/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import com.sonyericsson.ams.ApplicationManager;
import com.sonyericsson.homescreen.Homescreen;
import com.sonyericsson.homescreen.HomescreenMIDlet;
import com.sonyericsson.homescreen.KeyListener;
import com.sonyericsson.twitter.APIHandler;
import com.sonyericsson.twitter.APIListener;
import com.sonyericsson.twitter.IndirectionHS;
import com.sonyericsson.twitter.TextShrinker;
import com.sonyericsson.twitter.TimeStamp;
import com.sonyericsson.twitter.Tweet;
import com.sonyericsson.twitter.TweetMessage;
import com.sonyericsson.twitter.TwitterCanvas;
import com.sonyericsson.twitter.TwitterUpdater;
import com.sonyericsson.twitter.Utils;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;
import se.vitamin.ui.QuestionListener;
import se.vitamin.ui.UI;

public class TwitterClient
extends HomescreenMIDlet
implements KeyListener,
APIListener {
    public static final int TITEL_Y = 40;
    public static Image avatarFrame = null;
    private static Image[] _activeBorder;
    private static Image[] _inactiveBorder;
    private static String hashString;
    Image LSK = null;
    private TwitterUpdater updater;
    private byte[] recordarray = null;
    private static long recordTimeStamp;
    public static boolean useKilometers;
    public static int addLocation;
    public static int range;
    public static int updateRate;
    public static int standbyId;
    public static String trend;
    public static boolean autoUpdates;
    private static Hashtable avatars;
    private static Hashtable images;
    private static final int THUMB_HEIGHT = 48;
    private static final int THUMB_WIDTH = 48;
    static int[] roundalpha;
    private static Image defaultAvatar;
    static int rw;
    static int rh;
    private static final int TWITTER_SW_WIDTH = 11;
    private static final int TWITTER_SE_WIDTH = 13;
    private static final int TWITTER_SE_OFFSET = -11;
    private static final int TWITTER_S_WIDTH = 50;
    private static final int TWITTER_SW_OFFSET = 0;
    private static final int TWITTER_S_OFFSET = -3;
    private boolean closing_down = false;
    private static Hashtable gradients;
    public static String userName;
    private boolean hasUpdate = false;
    public static APIHandler apiHandler;
    private static Vector avatarCleaner;
    private int public_time_line;
    private static final String MAIN_APPLICATION = "Twitter";
    private static final String MIDLET_SUITE_VENDOR = "Sony Ericsson Mobile Communications AB";
    private boolean initiated;
    private boolean paused;
    private TwitterCanvas canvas;
    private Homescreen homescreen;
    private boolean standByMode;
    private ApplicationManager appManager;
    public static TextShrinker txtShrinker;
    private Display display;
    public static TwitterClient _instance;
    public static boolean refreshInSleepMode;
    private Runnable updateRunnable = new Runnable(){

        public void run() {
            TwitterClient.this.updater = new TwitterUpdater();
            TwitterClient.this.hasUpdate = TwitterClient.this.updater.update(TwitterClient.this);
            if (TwitterClient.this.hasUpdate && autoUpdates && ((TwitterClient)TwitterClient.this).canvas.activeMode && !((TwitterClient)TwitterClient.this).canvas.showBird) {
                TwitterClient.this.hasUpdate = false;
                TwitterClient.this.canvas.showQuestionPopup(95, TwitterClient.this.updateQuestionListener);
            }
        }
    };
    private QuestionListener updateQuestionListener = new QuestionListener(){

        public void response(boolean yes) {
            if (yes) {
                TwitterClient.this.updater.downloadUpdate();
                try {
                    TwitterClient.this.destroyApp(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                TwitterClient.this.notifyDestroyed();
            }
            TwitterClient.this.canvas.hidePopup();
        }
    };
    private Runnable textBoxFixer = new Runnable(){

        public void run() {
            try {
                Thread.sleep(100L);
                TwitterClient.this.homescreen.leaveStandby();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private boolean checkRoam = true;

    public TwitterClient() {
        if (_instance == null) {
            _instance = this;
        }
        try {
            this.LSK = Image.createImage((String)"/L_SK_Logo.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initiated = false;
        this.paused = false;
        this.standByMode = true;
        this.appManager = ApplicationManager.getApplicationManager();
        apiHandler = new APIHandler(this);
        UI.init();
        TimeStamp.init();
        txtShrinker = new TextShrinker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettings() {
        System.out.println("loading settings");
        String RMS_NAME = "TwitterSettings";
        String RMS_MIDLET = MAIN_APPLICATION;
        String RMS_VENDOR = MIDLET_SUITE_VENDOR;
        RecordStore r = null;
        try {
            r = RecordStore.openRecordStore((String)RMS_NAME, (String)RMS_VENDOR, (String)RMS_MIDLET);
            if (r.getNumRecords() == 0) {
                System.out.println("NULL");
                return;
            }
            recordTimeStamp = r.getLastModified();
            System.out.println("record time: " + recordTimeStamp);
            this.recordarray = r.getRecord(1);
            range = this.recordarray[0];
            standbyId = this.recordarray[5];
            updateRate = this.recordarray[6];
            autoUpdates = this.recordarray[4] == 1;
            useKilometers = this.recordarray[7] == 1;
            trend = new String(this.recordarray, 8, this.recordarray.length - 8, "UTF8");
        }
        catch (RecordStoreNotFoundException e) {
            this.closeDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (r != null) {
                try {
                    r.closeRecordStore();
                }
                catch (Exception e) {}
                r = null;
            }
        }
        if (this.canvas != null) {
            this.canvas.setPreference(standbyId, range, trend);
            this.canvas.setRefreshRate(updateRate);
            System.out.println("update_delay: " + updateRate * 60000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings(int view, int range, String trendterm) {
        String RMS_NAME = "TwitterSettings";
        String RMS_MIDLET = MAIN_APPLICATION;
        String RMS_VENDOR = MIDLET_SUITE_VENDOR;
        RecordStore r = null;
        TwitterClient.range = range;
        standbyId = view;
        trend = trendterm;
        try {
            r = RecordStore.openRecordStore((String)RMS_NAME, (String)RMS_VENDOR, (String)RMS_MIDLET);
            if (r.getNumRecords() == 0) {
                System.out.println("NULL");
                return;
            }
            byte[] t = trend.getBytes("UTF8");
            byte[] n = new byte[8 + t.length];
            n[0] = (byte)TwitterClient.range;
            n[5] = (byte)standbyId;
            n[1] = this.recordarray[1];
            n[2] = this.recordarray[2];
            n[3] = this.recordarray[3];
            n[4] = this.recordarray[4];
            n[6] = this.recordarray[6];
            n[7] = this.recordarray[7];
            for (int i = 0; i < t.length; ++i) {
                n[i + 8] = t[i];
            }
            this.recordarray = n;
            r.setRecord(1, this.recordarray, 0, this.recordarray.length);
            recordTimeStamp = System.currentTimeMillis();
        }
        catch (RecordStoreNotFoundException t) {
        }
        catch (Exception e) {
            System.out.println("RMS failure");
            e.printStackTrace();
        }
        finally {
            if (r != null) {
                try {
                    r.closeRecordStore();
                }
                catch (Exception e) {}
                r = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTimelineRMS(Vector in) {
        System.out.println("Saving data");
        String RMS_NAME = "TwitterData";
        String RMS_MIDLET = MAIN_APPLICATION;
        String RMS_VENDOR = MIDLET_SUITE_VENDOR;
        RecordStore r = null;
        try {
            r = RecordStore.openRecordStore((String)RMS_NAME, (String)RMS_VENDOR, (String)RMS_MIDLET);
            if (r.getNumRecords() == 0) {
                return;
            }
            int num = in.size();
            byte[][][] data = new byte[num][7][];
            byte[] data2 = new byte[num];
            int size = 0;
            for (int i = 0; i < num; ++i) {
                Tweet t = (Tweet)in.elementAt(i);
                data[i][0] = t.avatar.getBytes("UTF8");
                data[i][1] = t.createdAt.getBytes("UTF8");
                data[i][2] = t.location.getBytes("UTF8");
                data[i][3] = t.messageId.getBytes("UTF8");
                data[i][4] = t.screenname.getBytes("UTF8");
                data[i][5] = t.text.getBytes("UTF8");
                data[i][6] = t.username.getBytes("UTF8");
                size += data[i][0].length;
                size += data[i][1].length;
                size += data[i][2].length;
                size += data[i][3].length;
                size += data[i][4].length;
                size += data[i][5].length;
                size += data[i][6].length;
                data2[i] = (byte)(t.favorited ? 1 : 0);
            }
            byte[] b = new byte[size + num * 8];
            int c = 0;
            for (int i = 0; i < num; ++i) {
                for (int j = 0; j < 7; ++j) {
                    int len = data[i][j].length;
                    b[c] = (byte)len;
                    ++c;
                    for (int k = 0; k < len; ++k) {
                        b[c] = data[i][j][k];
                        ++c;
                    }
                }
                b[c] = data2[i];
                ++c;
            }
            data = null;
            data2 = null;
            r.setRecord(1, b, 0, b.length);
        }
        catch (RecordStoreNotFoundException num) {
        }
        catch (Exception e) {
            System.out.println("RMS failure");
            e.printStackTrace();
        }
        finally {
            if (r != null) {
                try {
                    r.closeRecordStore();
                }
                catch (Exception e) {}
                r = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getTimelineRMS() {
        String RMS_NAME = "TwitterData";
        String RMS_MIDLET = MAIN_APPLICATION;
        String RMS_VENDOR = MIDLET_SUITE_VENDOR;
        RecordStore r = null;
        try {
            r = RecordStore.openRecordStore((String)RMS_NAME, (String)RMS_VENDOR, (String)RMS_MIDLET);
            if (r.getNumRecords() == 0) {
                Vector vector = null;
                return vector;
            }
            if (r.getLastModified() < recordTimeStamp) {
                Vector vector = null;
                return vector;
            }
            byte[] data = r.getRecord(1);
            if (data.length == 4) {
                Vector vector = null;
                return vector;
            }
            Vector<Tweet> v = new Vector<Tweet>(20);
            int c = 0;
            int len = data.length;
            int element = 0;
            int strlen = 0;
            Tweet t = new Tweet();
            int i = 0;
            while (c < len) {
                System.out.println(i + "_" + c);
                while (element < 7) {
                    System.out.println(element + "_" + c);
                    strlen = data[c];
                    if (strlen < 0) {
                        strlen += 256;
                    }
                    String s = new String(data, ++c, strlen, "UTF8");
                    switch (element) {
                        case 0: {
                            t.avatar = s;
                            break;
                        }
                        case 1: {
                            t.createdAt = s;
                            break;
                        }
                        case 2: {
                            t.location = s;
                            break;
                        }
                        case 3: {
                            t.messageId = s;
                            break;
                        }
                        case 4: {
                            t.screenname = s;
                            break;
                        }
                        case 5: {
                            t.text = s;
                            break;
                        }
                        case 6: {
                            t.username = s;
                        }
                    }
                    c += strlen;
                    ++element;
                }
                element = 0;
                t.favorited = data[c] == 1;
                v.addElement(t);
                t = null;
                System.gc();
                if (++c < len) {
                    t = new Tweet();
                }
                ++i;
            }
            Vector<Tweet> vector = v;
            return vector;
        }
        catch (RecordStoreNotFoundException data) {
        }
        catch (Exception e) {
            System.out.println("RMS failure");
            e.printStackTrace();
        }
        finally {
            if (r != null) {
                try {
                    r.closeRecordStore();
                }
                catch (Exception e) {}
                r = null;
            }
        }
        return null;
    }

    public static void drawRoundBorder(Graphics g, int x, int y, int w, int h, boolean active) {
        int bottom = y + h;
        int right = x + w;
        int left = x + 11;
        int width = w - 11 - 13;
        int segments = width / 50;
        if (active) {
            int offset = width % 50;
            for (int i = 0; i < segments; ++i) {
                g.drawImage(_activeBorder[4], left, y, 0);
                g.drawImage(_activeBorder[0], left, bottom + -3, 0);
                left += 50;
            }
            if (left < x + width + 13) {
                g.drawRegion(_activeBorder[4], 0, 0, x + width + 13 - left, _activeBorder[4].getHeight(), 0, left, y, 0);
                g.drawRegion(_activeBorder[0], 0, 0, x + width + 13 - left, _activeBorder[0].getHeight(), 0, left, bottom + -3, 0);
            }
            g.drawImage(_activeBorder[1], x + 0, y + h - 10, 0);
            g.drawImage(_activeBorder[7], x + w + -11, y + h - 10, 0);
            g.drawImage(_activeBorder[3], x + 0, y, 0);
            g.drawImage(_activeBorder[5], x + w + -11, y, 0);
            int height = h - 20;
            segments = height / 10;
            int top = y + 10;
            offset = height % 10;
            for (int i = 0; i < segments; ++i) {
                g.drawImage(_activeBorder[6], right - 5, top, 0);
                g.drawImage(_activeBorder[2], x, top, 0);
                top += 10;
            }
            if (offset != 0) {
                g.drawRegion(_activeBorder[6], 0, 0, _activeBorder[6].getWidth(), offset, 0, right - 5, top, 0);
                g.drawRegion(_activeBorder[2], 0, 0, _activeBorder[2].getWidth(), offset, 0, x, top, 0);
            }
        } else {
            int offset = width % 50;
            for (int i = 0; i < segments; ++i) {
                g.drawImage(_inactiveBorder[4], left, y, 0);
                g.drawImage(_inactiveBorder[0], left, bottom - 1, 0);
                left += 50;
            }
            if (left < x + width + 13) {
                g.drawRegion(_inactiveBorder[4], 0, 0, x + width + 13 - left, _inactiveBorder[4].getHeight(), 0, left, y, 0);
                g.drawRegion(_inactiveBorder[0], 0, 0, x + width + 13 - left, _inactiveBorder[0].getHeight(), 0, left, bottom - 1, 0);
            }
            g.drawImage(_inactiveBorder[1], x + 0, y + h - 10, 0);
            g.drawImage(_inactiveBorder[7], x + w + -11, y + h - 10, 0);
            g.drawImage(_inactiveBorder[3], x + 0, y, 0);
            g.drawImage(_inactiveBorder[5], x + w + -11, y, 0);
            int height = h - 20;
            segments = height / 10;
            int top = y + 10;
            offset = height % 10;
            for (int i = 0; i < segments; ++i) {
                g.drawImage(_inactiveBorder[6], right - 2, top, 0);
                g.drawImage(_inactiveBorder[2], x, top, 0);
                top += 10;
            }
            if (offset != 0) {
                g.drawRegion(_inactiveBorder[6], 0, 0, _inactiveBorder[6].getWidth(), offset, 0, right - 2, top, 0);
                g.drawRegion(_inactiveBorder[2], 0, 0, _inactiveBorder[2].getWidth(), offset, 0, x, top, 0);
            }
        }
    }

    public static Image createGradient(int w, int h, int type) {
        return TwitterClient.createGradient(w, h, type, true, 255);
    }

    public static Image createGradient(int w, int h, int type, int alpha) {
        return TwitterClient.createGradient(w, h, type, true, alpha);
    }

    public static Image createGradient(int w, int h, int type, boolean rounded) {
        return TwitterClient.createGradient(w, h, type, rounded, 255);
    }

    public static Image createGradient(int w, int h, int type, boolean rounded, int alpha) {
        hashString = w + ":" + h + ":" + type + ":" + alpha;
        if (gradients.containsKey(hashString)) {
            return (Image)gradients.get(hashString);
        }
        Image img = null;
        switch (type) {
            case 0: {
                img = Utils.createGradient(w, h, 12906488, 8705257, 8309470, 4430513, alpha, rounded, 6);
                break;
            }
            case 4: {
                img = Utils.createGradient(w, h, 8705257, 4234422, 3380658, 1343649, alpha, rounded, 6);
                break;
            }
            case 1: {
                img = Utils.createGradient(w, h, 12973538, 6938798, 6938798, 2340481, alpha, rounded, 6);
                break;
            }
            case 5: {
                img = Utils.createGradient(w, h, 50320, 33889, 33889, 22079, alpha, rounded, 0);
                break;
            }
            case 8: {
                img = Utils.createGradient(w, h, 13103096, 8247020, 8247020, 2794950, alpha, rounded, 6);
                break;
            }
            case 11: {
                img = Utils.createGradient(w, h, 10280951, 3325166, 3325166, 1084859, alpha, rounded, 0);
                break;
            }
            case 9: {
                img = Utils.createGradient(w, h, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xCCCCCC, alpha, rounded, 0);
                break;
            }
            case 10: {
                img = Utils.createGradient(w, h, 0, 0, 0, 0x222222, alpha, rounded, 0);
                break;
            }
            default: {
                System.out.println("Unknown gradient");
            }
        }
        gradients.put(hashString, img);
        return img;
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        if (!this.standByMode && this.canvas.active) {
            this.enterStandByMode();
            throw new MIDletStateChangeException();
        }
        this.canvas.endRefresh();
        apiHandler.endData();
    }

    public void notifyCloseDown() {
        this.closing_down = true;
    }

    public void keyPressed(int key) {
        switch (key) {
            case 2: {
                if (this.closing_down) {
                    try {
                        this.destroyApp(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this.notifyDestroyed();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.enterActiveMode();
            }
        }
    }

    public void launchMainApplication() {
        this.appManager.startApplication(MAIN_APPLICATION, MIDLET_SUITE_VENDOR);
        this.enterStandByMode();
    }

    protected void init() {
        boolean hasUser;
        this.display = Display.getDisplay((MIDlet)this);
        this.loadSettings();
        this.homescreen = this.getHomescreen();
        if (UI.newPlatform) {
            new IndirectionHS(this.homescreen);
        }
        this.homescreen.addKeyListener((KeyListener)this);
        String key = this.getAppProperty("twitterSoftKey");
        if (key == null) {
            key = "0";
        }
        int softkey = 2;
        if (key.equals("1")) {
            softkey = 70;
        } else if (key.equals("2")) {
            softkey = 3;
        }
        System.out.println("Settings softkey " + softkey + " from jad " + key);
        if (this.LSK == null) {
            this.homescreen.setKey(softkey, MAIN_APPLICATION);
        } else {
            this.homescreen.setKey(softkey, this.LSK);
        }
        this.homescreen.setStandbyInformation(true);
        String r = this.getAppProperty("refreshInSleepMode");
        if (r != null && r.equalsIgnoreCase("Y")) {
            refreshInSleepMode = true;
        }
        if (roundalpha == null) {
            try {
                defaultAvatar = Image.createImage((String)"/default_profile_normal.png");
                avatarFrame = Image.createImage((String)"/avatarframe.png");
                Image roundCorner = Image.createImage((String)"/roundcorner.png");
                rw = roundCorner.getWidth();
                rh = roundCorner.getHeight();
                roundalpha = new int[rw * rh];
                roundCorner.getRGB(roundalpha, 0, rw, 0, 0, rw, rh);
                int i = 0;
                while (i < rw * rh) {
                    int n = i++;
                    roundalpha[n] = roundalpha[n] & 0xFF000000;
                }
                _activeBorder = new Image[8];
                _inactiveBorder = new Image[8];
                for (i = 0; i < 8; ++i) {
                    TwitterClient._activeBorder[i] = Image.createImage((String)("/border/active/" + i + ".png"));
                    TwitterClient._inactiveBorder[i] = Image.createImage((String)("/border/inactive/" + i + ".png"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!(hasUser = apiHandler.loadUserFromRMS())) {
            this.closeDown();
            return;
        }
        try {
            this.canvas = new TwitterCanvas(this);
        }
        catch (Exception e) {
            System.out.println("Shut down!");
            this.closeDown();
        }
        this.canvas.repaint();
        try {
            this.canvas.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error");
            this.closeDown();
        }
        this.enterStandByMode();
        this.display.setCurrent((Displayable)this.canvas);
        if (autoUpdates) {
            Thread t = new Thread(this.updateRunnable);
            t.start();
        }
        this.initiated = true;
    }

    protected void pauseApp() {
        if (this.paused) {
            this.paused = false;
        }
    }

    private void closeDown() {
        try {
            System.out.println("Error333");
            this.destroyApp(true);
        }
        catch (Exception ex) {
            System.out.println("Error4444");
            ex.printStackTrace();
        }
        try {
            this.notifyDestroyed();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    protected void startApp() throws MIDletStateChangeException {
        if (!this.initiated) {
            this.init();
        }
    }

    public void enterStandByMode() {
        if (!this.standByMode) {
            this.homescreen.enterStandby();
            this.canvas.setInActiveScreenMode();
            this.homescreen.setStandbyInformation(true);
            this.standByMode = true;
        }
    }

    public void enterActiveMode() {
        this.homescreen.leaveStandby();
        if (this.standByMode) {
            this.canvas.setStandardPositionsForBubbles();
            this.canvas.selectLatestMessage();
            this.canvas.setActiveScreenMode();
            this.homescreen.setStandbyInformation(false);
            this.standByMode = false;
        }
    }

    public void twitterEvent(int ID, String response) {
    }

    public void getLatestTweets() {
    }

    public static void loadAvatarImage(String user, String url, boolean save) {
        if (avatars.containsKey(user)) {
            return;
        }
        Image avatar = TwitterClient.loadImage(url);
        if (avatar != null) {
            int[] rgb = new int[2304];
            int w = 48;
            int h = 48;
            if (w > avatar.getWidth()) {
                w = avatar.getWidth();
            }
            if (h > avatar.getHeight()) {
                h = avatar.getHeight();
            }
            avatar.getRGB(rgb, 0, w, 0, 0, w, h);
            avatar = null;
            for (int y = 0; y < rh; ++y) {
                for (int x = 0; x < rw; ++x) {
                    int pos = y * 48 + x;
                    int maskpos = x + y * rw;
                    rgb[pos] = rgb[pos] & 0xFFFFFF | roundalpha[maskpos];
                    pos = (47 - y) * 48 + x;
                    rgb[pos] = rgb[pos] & 0xFFFFFF | roundalpha[maskpos];
                    pos = y * 48 + (47 - x);
                    rgb[pos] = rgb[pos] & 0xFFFFFF | roundalpha[maskpos];
                    pos = (47 - y) * 48 + (47 - x);
                    rgb[pos] = rgb[pos] & 0xFFFFFF | roundalpha[maskpos];
                }
            }
            avatar = Image.createRGBImage((int[])rgb, (int)48, (int)48, (boolean)true);
            images.put(url, avatar);
            avatars.put(user, url);
            if (!save) {
                avatarCleaner.addElement(user);
            }
        }
    }

    public static void clearAvatars() {
        Tweet t;
        Vector external;
        System.out.println("clearing avatars");
        Vector<String> v = new Vector<String>();
        v.addElement(userName);
        if (TwitterClient._instance.canvas.tweetsForCurrentView != null) {
            for (int i = 0; i < TwitterClient._instance.canvas.tweetsForCurrentView.size(); ++i) {
                Tweet t2 = ((TweetMessage)TwitterClient._instance.canvas.tweetsForCurrentView.elementAt(i)).getTweet();
                v.addElement(t2.screenname);
            }
        }
        if ((external = TwitterClient._instance.canvas.tweetQueue.getAll()) != null) {
            for (int i = 0; i < external.size(); ++i) {
                t = ((TweetMessage)external.elementAt(i)).getTweet();
                v.addElement(t.screenname);
            }
        }
        if ((external = TwitterClient._instance.canvas.areIn) != null) {
            for (int i = 0; i < external.size(); ++i) {
                t = ((TweetMessage)external.elementAt(i)).getTweet();
                v.addElement(t.screenname);
            }
        }
        if ((external = TwitterClient._instance.canvas.outGoing) != null) {
            for (int i = 0; i < external.size(); ++i) {
                t = ((TweetMessage)external.elementAt(i)).getTweet();
                v.addElement(t.screenname);
            }
        }
        if (TwitterClient._instance.canvas.incoming != null) {
            v.addElement(TwitterClient._instance.canvas.incoming.getTweet().screenname);
        }
        for (int i = 0; i < avatarCleaner.size(); ++i) {
            Object o = avatarCleaner.elementAt(i);
            if (v.contains(o)) continue;
            Object url = avatars.get(o);
            if (url != null) {
                images.remove(url);
                avatars.remove(o);
            }
            avatarCleaner.removeElementAt(i);
            --i;
        }
        System.gc();
    }

    public void updateCheck() {
        if (this.hasUpdate && autoUpdates) {
            this.hasUpdate = false;
            this.canvas.showQuestionPopup(95, this.updateQuestionListener);
        }
    }

    public static Image getAvatarImage(String user) {
        if (avatars.containsKey(user)) {
            String url = (String)avatars.get(user);
            Image img = (Image)images.get(url);
            if (img == null) {
                return defaultAvatar;
            }
            return img;
        }
        return defaultAvatar;
    }

    private static Image loadImage(String url) {
        try {
            if (images.containsKey(url)) {
                return (Image)images.get(url);
            }
            StreamConnection c = null;
            InputStream s = null;
            c = (StreamConnection)Connector.open((String)url);
            s = c.openInputStream();
            apiHandler.addToDataCounter(s.available());
            Image img = Image.createImage((InputStream)s);
            s.close();
            c.close();
            return img;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void languageUpdate() {
        TwitterClient._instance.canvas.languageUpdate();
    }

    public void openTextBox(Displayable d) {
        this.display.setCurrent(d);
        Thread t = new Thread(this.textBoxFixer);
        t.start();
    }

    public boolean checkRoaming() {
        if (!this.checkRoam) {
            return false;
        }
        int i = TwitterClient.getRoamSync();
        if (i == 0) {
            this.checkRoam = false;
            return false;
        }
        String cmcc = System.getProperty("com.sonyericsson.net.cmcc");
        String mcc = System.getProperty("com.sonyericsson.net.mcc");
        if (cmcc == null) {
            cmcc = "0";
        }
        if (mcc == null) {
            mcc = "0";
        }
        if (!mcc.equalsIgnoreCase(cmcc)) {
            this.checkRoam = false;
            return true;
        }
        if (i == 2) {
            String cmnc = System.getProperty("com.sonyericsson.net.cmnc");
            String mnc = System.getProperty("com.sonyericsson.net.mnc");
            if (cmnc == null) {
                cmnc = "0";
            }
            if (mnc == null) {
                mnc = "0";
            }
            if (!mnc.equalsIgnoreCase(cmnc)) {
                this.checkRoam = false;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getRoamSync() {
        String RMS_NAME = "TwitterRS";
        String RMS_MIDLET = MAIN_APPLICATION;
        String RMS_VENDOR = MIDLET_SUITE_VENDOR;
        RecordStore r = null;
        try {
            r = RecordStore.openRecordStore((String)RMS_NAME, (String)RMS_VENDOR, (String)RMS_MIDLET);
            if (r.getNumRecords() == 0) {
                int n = 0;
                return n;
            }
            byte[] b = r.getRecord(1);
            byte by = b[0];
            return by;
        }
        catch (RecordStoreNotFoundException b) {
        }
        catch (Exception e) {
            System.out.println("RMS failure");
            e.printStackTrace();
        }
        finally {
            if (r != null) {
                try {
                    r.closeRecordStore();
                }
                catch (Exception e) {}
                r = null;
            }
        }
        return 0;
    }

    static {
        useKilometers = true;
        addLocation = 0;
        range = 2;
        updateRate = 5;
        standbyId = 0;
        trend = "null";
        autoUpdates = true;
        avatars = new Hashtable();
        images = new Hashtable();
        roundalpha = null;
        gradients = new Hashtable();
        userName = "vitamintest";
        avatarCleaner = new Vector();
        _instance = null;
        refreshInSleepMode = false;
    }
}

