/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.sonyericsson.twitter.LinkedText;
import com.sonyericsson.twitter.TimeStamp;
import com.sonyericsson.twitter.Tweet;
import com.sonyericsson.twitter.TwitterCanvas;
import com.sonyericsson.twitter.TwitterClient;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import se.vitamin.ui.UI;
import se.vitamin.ui.Widget;
import se.vitamin.ui.Window;

public class TwitterCloud
extends Widget {
    private static Image[] _border = null;
    private static final int AVATAR_RIGHT_OFFSET = 172;
    public static int _backgroundW;
    public static int _backgroundH;
    private Tweet tweet;
    private LinkedText textImage;
    private static final int AVATAR_WIDTH = 48;
    private static final int AVATAR_SPACE = 5;
    private static final int MIN_HEIGHT = 26;
    protected boolean drawBig = false;
    protected boolean drawSmall = false;
    protected String header;
    protected TimeStamp how_long_ago = null;

    public TwitterCloud(Window parent, int id) {
        super(parent, id);
        this._w = 150;
        this._h = 80;
        this._x = 6;
        _backgroundW = 155;
        if (_border == null) {
            try {
                _border = new Image[15];
                TwitterCloud._border[0] = Image.createImage((String)"/cloud/b0.png");
                TwitterCloud._border[1] = Image.createImage((String)"/cloud/b1.png");
                TwitterCloud._border[2] = Image.createImage((String)"/cloud/b2.png");
                TwitterCloud._border[3] = Image.createImage((String)"/cloud/b3.png");
                TwitterCloud._border[4] = Image.createImage((String)"/cloud/b4.png");
                TwitterCloud._border[5] = Image.createImage((String)"/cloud/b5.png");
                TwitterCloud._border[6] = Image.createImage((String)"/cloud/b6.png");
                TwitterCloud._border[7] = Image.createImage((String)"/cloud/b7.png");
                TwitterCloud._border[8] = Image.createImage((String)"/cloud/b8.png");
                TwitterCloud._border[9] = Image.createImage((String)"/cloud/b9.png");
                TwitterCloud._border[10] = Image.createImage((String)"/cloud/b10.png");
                TwitterCloud._border[11] = Image.createImage((String)"/cloud/b11.png");
                TwitterCloud._border[12] = Image.createImage((String)"/cloud/b12.png");
                TwitterCloud._border[13] = Image.createImage((String)"/cloud/b13.png");
                TwitterCloud._border[14] = Image.createImage((String)"/cloud/b14.png");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setTimeStamp(TimeStamp timeStamp) {
        this.how_long_ago = timeStamp;
    }

    public void setTweet(Tweet t) {
        this.tweet = t;
        this.textImage = new LinkedText(this.tweet.text, 0, 0xFFFFFF, 0, 16, _backgroundW - 10, 10, false, false, false);
        this._h = this.textImage.getHeight() < 26 ? 65 : this.textImage.getHeight() + 39;
        this._w = _backgroundW;
        this.header = this.tweet.username;
        if (UI.smallFont.stringWidth(this.header) > _backgroundW - 10) {
            int index = 0;
            while (UI.smallFont.stringWidth(this.header.substring(0, index + 1) + "...") < _backgroundW - 10) {
                ++index;
            }
            this.header = this.header.substring(0, index) + "...";
        }
    }

    public void loadAvatar(boolean save) {
        TwitterClient.loadAvatarImage(this.tweet.screenname, this.tweet.avatar, save);
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public boolean handleKeyDown(int key) {
        return false;
    }

    public boolean handleKeyUp(int key) {
        return false;
    }

    public boolean handleLongPress(int key) {
        return false;
    }

    public void paint(Graphics g, int x, int y) {
        System.out.println("TwitterCloud.paint(g,x,y) shouldn't be called");
    }

    public void paint(Graphics g, int x, int y, boolean active, boolean activeMode) {
        if (this.tweet.screenname.compareTo(TwitterClient.userName) == 0) {
            this.paint(g, x, y, true, active, activeMode);
        } else {
            this.paint(g, x, y, false, active, activeMode);
        }
    }

    public void paint(Graphics g, int x, int y, boolean left, boolean active, boolean activeMode) {
        this._screenY = y;
        this._screenX = x + 14;
        if (this._screenY > UI.SCREEN_HEIGHT || this._screenY + this._h < 0) {
            return;
        }
        g.setFont(UI.smallFont);
        g.setColor(2072319);
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        int avatarX = 0;
        int avatarY = 0;
        int pipY = this._screenY + (this._h - _border[7].getHeight()) / 2;
        avatarY = this._screenY + (this._h - 48) / 2;
        if (left) {
            avatarX = this._screenX + 172 - 5;
            this._screenX -= 13;
            if (!activeMode) {
                int top = this._screenY;
                g.drawImage(TwitterClient.createGradient(this._w + 2, this._h, 8, 192), this._screenX + 10, this._screenY, 0);
                this._screenX += 6;
                dg.drawImage(_border[10], this._screenX, top, 0, 8192);
                top += _border[10].getHeight();
                while (top + _border[11].getHeight() < pipY) {
                    dg.drawImage(_border[11], this._screenX, top, 0, 8192);
                    top += _border[11].getHeight();
                }
                if (top < pipY) {
                    g.drawRegion(_border[11], 0, 0, _border[11].getWidth(), pipY - top, 2, this._screenX, top, 0);
                }
                dg.drawImage(_border[12], this._screenX, pipY, 0, 8192);
                top = pipY + _border[12].getHeight();
                int height = this._h - _border[14].getHeight() + 10;
                int bottom = this._screenY + height - 6;
                while (top + _border[13].getHeight() < bottom) {
                    dg.drawImage(_border[13], this._screenX, top, 0, 8192);
                    top += _border[13].getHeight();
                }
                if (top < bottom) {
                    g.drawRegion(_border[13], 0, 0, _border[13].getWidth(), bottom - top, 2, this._screenX, top, 0);
                }
                dg.drawImage(_border[14], this._screenX, bottom, 0, 8192);
                this._screenX -= 3;
                g.setColor(3039605);
            } else if (active) {
                int top = this._screenY - 2;
                g.drawImage(TwitterClient.createGradient(this._w + 1, this._h, 11), this._screenX + 10, this._screenY, 0);
                dg.drawImage(_border[0], this._screenX, top, 0, 8192);
                top += _border[0].getHeight();
                while (top + _border[1].getHeight() < pipY) {
                    dg.drawImage(_border[1], this._screenX, top, 0, 8192);
                    top += _border[1].getHeight();
                }
                if (top < pipY) {
                    g.drawRegion(_border[1], 0, 0, _border[1].getWidth(), pipY - top, 2, this._screenX, top, 0);
                }
                dg.drawImage(_border[2], this._screenX, pipY, 0, 8192);
                top = pipY + _border[2].getHeight();
                int height = this._h - _border[4].getHeight() + 10;
                int bottom = this._screenY + height - 3;
                while (top + _border[3].getHeight() < bottom) {
                    dg.drawImage(_border[3], this._screenX, top, 0, 8192);
                    top += _border[3].getHeight();
                }
                if (top < bottom) {
                    g.drawRegion(_border[3], 0, 0, _border[3].getWidth(), bottom - top, 2, this._screenX, top, 0);
                }
                dg.drawImage(_border[4], this._screenX, bottom, 0, 8192);
                g.setColor(0xFFFFFF);
            } else {
                int top = this._screenY;
                g.drawImage(TwitterClient.createGradient(this._w + 2, this._h, 8), this._screenX + 10, this._screenY, 0);
                this._screenX += 6;
                dg.drawImage(_border[5], this._screenX, top, 0, 8192);
                top += _border[5].getHeight();
                while (top + _border[6].getHeight() < pipY) {
                    dg.drawImage(_border[6], this._screenX, top, 0, 8192);
                    top += _border[1].getHeight();
                }
                if (top < pipY) {
                    g.drawRegion(_border[6], 0, 0, _border[6].getWidth(), pipY - top, 2, this._screenX, top, 0);
                }
                dg.drawImage(_border[7], this._screenX, pipY, 0, 8192);
                top = pipY + _border[7].getHeight();
                int height = this._h - _border[9].getHeight() + 10;
                int bottom = this._screenY + height - 6;
                while (top + _border[8].getHeight() < bottom) {
                    dg.drawImage(_border[8], this._screenX, top, 0, 8192);
                    top += _border[8].getHeight();
                }
                if (top < bottom) {
                    g.drawRegion(_border[8], 0, 0, _border[8].getWidth(), bottom - top, 2, this._screenX, top, 0);
                }
                dg.drawImage(_border[9], this._screenX, bottom, 0, 8192);
                this._screenX -= 3;
                g.setColor(3039605);
            }
            this._screenX -= 5;
            if (active) {
                this._screenX += 3;
            }
        } else {
            this._screenX += 45;
            avatarX = this._screenX - 53;
            if (!activeMode) {
                int top = this._screenY;
                this._screenX += 2;
                g.drawImage(TwitterClient.createGradient(this._w + 2, this._h, 8, 192), this._screenX + 13, top, 0);
                g.drawImage(_border[10], this._screenX, top, 0);
                top += _border[10].getHeight();
                while (top + _border[11].getHeight() < pipY) {
                    g.drawImage(_border[11], this._screenX, top, 0);
                    top += _border[11].getHeight();
                }
                if (top < pipY) {
                    g.drawRegion(_border[11], 0, 0, _border[11].getWidth(), pipY - top, 0, this._screenX, top, 0);
                }
                g.drawImage(_border[12], this._screenX, pipY, 0);
                top = pipY + _border[12].getHeight();
                int height = this._h - _border[14].getHeight() + 10;
                int bottom = this._screenY + height - 6;
                while (top + _border[13].getHeight() < bottom) {
                    g.drawImage(_border[13], this._screenX, top, 0);
                    top += _border[13].getHeight();
                }
                if (top < bottom) {
                    g.drawRegion(_border[13], 0, 0, _border[13].getWidth(), bottom - top, 0, this._screenX, top, 0);
                }
                g.drawImage(_border[14], this._screenX, bottom, 0);
                this._screenX -= 2;
                g.setColor(3039605);
            } else if (active) {
                int top = this._screenY - 2;
                g.drawImage(TwitterClient.createGradient(this._w + 2, this._h, 11), this._screenX + 15, this._screenY, 0);
                g.drawImage(_border[0], this._screenX, top, 0);
                top += _border[0].getHeight();
                while (top + _border[1].getHeight() < pipY) {
                    g.drawImage(_border[1], this._screenX, top, 0);
                    top += _border[1].getHeight();
                }
                if (top < pipY) {
                    g.drawRegion(_border[1], 0, 0, _border[1].getWidth(), pipY - top, 0, this._screenX, top, 0);
                }
                g.drawImage(_border[2], this._screenX, pipY, 0);
                top = pipY + _border[2].getHeight();
                int height = this._h - _border[4].getHeight() + 10;
                int bottom = this._screenY + height - 3;
                while (top + _border[3].getHeight() < bottom) {
                    g.drawImage(_border[3], this._screenX, top, 0);
                    top += _border[3].getHeight();
                }
                if (top < bottom) {
                    g.drawRegion(_border[3], 0, 0, _border[3].getWidth(), bottom - top, 0, this._screenX, top, 0);
                }
                g.drawImage(_border[4], this._screenX, bottom, 0);
                g.setColor(0xFFFFFF);
            } else {
                int top = this._screenY;
                this._screenX += 2;
                g.drawImage(TwitterClient.createGradient(this._w + 2, this._h, 8), this._screenX + 13, top, 0);
                g.drawImage(_border[5], this._screenX, top, 0);
                top += _border[5].getHeight();
                while (top + _border[6].getHeight() < pipY) {
                    g.drawImage(_border[6], this._screenX, top, 0);
                    top += _border[6].getHeight();
                }
                if (top < pipY) {
                    g.drawRegion(_border[6], 0, 0, _border[6].getWidth(), pipY - top, 0, this._screenX, top, 0);
                }
                g.drawImage(_border[7], this._screenX, pipY, 0);
                top = pipY + _border[7].getHeight();
                int height = this._h - _border[9].getHeight() + 10;
                int bottom = this._screenY + height - 6;
                while (top + _border[8].getHeight() < bottom) {
                    g.drawImage(_border[8], this._screenX, top, 0);
                    top += _border[8].getHeight();
                }
                if (top < bottom) {
                    g.drawRegion(_border[8], 0, 0, _border[8].getWidth(), bottom - top, 0, this._screenX, top, 0);
                }
                g.drawImage(_border[9], this._screenX, bottom, 0);
                this._screenX -= 2;
                g.setColor(3039605);
            }
        }
        this.textImage.drawText(g, this._screenX + 19, this._screenY + 22);
        g.drawString(this.header, this._screenX + 19, this._screenY + 5, 0);
        g.setColor(0xFFFFFF);
        g.drawImage(TwitterClient.getAvatarImage(this.tweet.screenname), avatarX + 3, avatarY + 1, 0);
        if (active) {
            g.drawImage(TwitterClient.avatarFrame, avatarX, avatarY, 0);
        }
        this.how_long_ago.paint(g, this._screenX + 164, this._screenY + this._h - 3 - this.how_long_ago.getHeight(), true, TwitterCanvas.frameTime);
    }

    public void select() {
    }

    public void setDimensions(int x, int y, int w, int h) {
    }

    public void setFont(Font f) {
    }

    public void update() {
    }

    public Tweet getTweet() {
        return this.tweet;
    }
}

