/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.utility;

import java.util.Hashtable;
import java.util.Vector;

public class StrUtility {
    public static String byteArrayToHexStr(byte[] b) {
        StringBuffer hexString = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(0xFF & b[i]);
            if (hex.length() == 1) {
                hexString.append("0" + hex);
            } else {
                hexString.append(hex);
            }
            ++i;
        }
        return hexString.toString().toUpperCase();
    }

    public static byte[] hexStrToByteArray(String hexStr) {
        byte[] bArray = new byte[hexStr.length() / 2];
        int i = 0;
        while (i < hexStr.length() / 2) {
            byte firstNibble = Byte.parseByte(hexStr.substring(2 * i, 2 * i + 1), 16);
            byte secondNibble = Byte.parseByte(hexStr.substring(2 * i + 1, 2 * i + 2), 16);
            int finalByte = secondNibble | firstNibble << 4;
            bArray[i] = (byte)finalByte;
            ++i;
        }
        return bArray;
    }

    public static String padZero(String original, int expectedLength) {
        StringBuffer out = new StringBuffer();
        int padCnt = expectedLength - original.length();
        int i = 0;
        while (i < padCnt) {
            out.append("0");
            ++i;
        }
        out.append(original);
        return out.toString();
    }

    public static String[] split(String original, String regex) {
        int startIndex = 0;
        Vector<String> v = new Vector<String>();
        String[] str = null;
        int index = 0;
        if (original == null || regex == null) {
            return str;
        }
        startIndex = original.indexOf(regex);
        while (startIndex < original.length() && startIndex != -1) {
            String temp = original.substring(index, startIndex);
            v.addElement(temp);
            index = startIndex + regex.length();
            startIndex = original.indexOf(regex, startIndex + regex.length());
        }
        v.addElement(original.substring(index + 1 - regex.length()));
        str = new String[v.size()];
        int i = 0;
        while (i < str.length) {
            str[i] = (String)v.elementAt(i);
            ++i;
        }
        return str;
    }

    public static String[] split(String original, String regex, int limit) {
        int startIndex = 0;
        Vector<String> v = new Vector<String>();
        String[] str = null;
        int index = 0;
        int splitCnt = 0;
        if (original == null || regex == null) {
            return str;
        }
        startIndex = original.indexOf(regex);
        while (startIndex < original.length() && startIndex != -1) {
            String temp = original.substring(index, startIndex);
            v.addElement(temp);
            index = startIndex + regex.length();
            startIndex = original.indexOf(regex, startIndex + regex.length());
            if (++splitCnt >= limit - 1) break;
        }
        v.addElement(original.substring(index + 1 - regex.length()));
        str = new String[v.size()];
        int i = 0;
        while (i < str.length) {
            str[i] = (String)v.elementAt(i);
            ++i;
        }
        return str;
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || with == null || repl.length() == 0 || max == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static Hashtable linesToHashtable(String data) {
        String[] lines = StrUtility.split(data, "\n");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        String[] keyVal = null;
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].indexOf("#") == -1 && (keyVal = StrUtility.split(lines[i], "=")).length == 2) {
                properties.put(keyVal[0].trim(), keyVal[1].trim());
            }
            ++i;
        }
        return properties;
    }

    public static Hashtable linesToHashtable(String data, int limit) {
        String[] lines = StrUtility.split(data, "\n");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        String[] keyVal = null;
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].indexOf("#") == -1 && (keyVal = StrUtility.split(lines[i], "=", limit)).length == 2) {
                properties.put(keyVal[0].trim(), keyVal[1].trim());
            }
            ++i;
        }
        return properties;
    }
}

