/*
 * Decompiled with CFR 0.152.
 */
package actions.mapActions;

import com.loboltd.javamap.bean.Building;
import com.loboltd.javamap.map.MapCanvas;
import com.loboltd.javamap.map.MapLV2.MapLV2Canvas;
import com.loboltd.javamap.map.NullAreaException;
import com.loboltd.javamap.util.DataPool;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Ticker;
import net.kbox.Action;
import net.kbox.ActionForward;
import net.kbox.common.MsgResource;
import net.kbox.component.KCommand;
import search.Address;
import search.HSBCSearcher;

public class MoveSlowly
implements Action {
    private static boolean isHMoveStop = false;
    private static boolean isVMoveStop = false;

    public void execute(KCommand cmd, Item item, Displayable dis, ActionForward forward, Hashtable parameters) throws Exception {
        int direct = Integer.valueOf((String)parameters.get("1"));
        final MapLV2Canvas mc = (MapLV2Canvas)dis;
        MsgResource msgRes = MsgResource.getInstance();
        String keyName = cmd.getUniqueID();
        MapCanvas.setCurrentBuilding(null);
        Vector buildings = mc.getShowOnMap();
        mc.setShowOnMap(null);
        mc.setShowOnMap(null);
        String wlcMsg = MsgResource.getInstance().getMsg("MAPTIPS");
        String oldMsg = mc.getTicker().getString();
        if (oldMsg != null && !oldMsg.equals(wlcMsg)) {
            mc.setTicker(null);
            mc.setTicker(new Ticker(wlcMsg));
        }
        mc.setSelectedBuildingIndex(null);
        if (keyName.equals("4") || keyName.equals("6")) {
            isHMoveStop = false;
            isVMoveStop = true;
            MoveSlowly.hMove(direct * 10, mc, 24);
        } else {
            isHMoveStop = true;
            isVMoveStop = false;
            MoveSlowly.vMove(direct * 10, mc, 24);
        }
        Object loadingObj = DataPool.getAttribute("LoadingBuildingThread");
        if (!(loadingObj != null && ((Thread)loadingObj).isAlive() || mc.getLV() == 1)) {
            Thread t = new Thread(){

                public void run() {
                    Address[] as = new HSBCSearcher().searchAddressByCoordinate(mc.getCurrentLn(), mc.getCurrentLat(), 0.0036);
                    if (as != null) {
                        Vector<Address> showOnMap = new Vector<Address>(as.length);
                        int i = 0;
                        while (i < as.length) {
                            showOnMap.addElement(as[i]);
                            ++i;
                        }
                        mc.setShowOnMap(showOnMap);
                        try {
                            mc.reflash();
                        }
                        catch (NullAreaException e) {
                            throw new RuntimeException(e.toString());
                        }
                    }
                }
            };
            DataPool.setAttribute("LoadingBuildingThread", t);
            t.setPriority(1);
            t.start();
        }
        if (mc.getShowOnMap() == null) {
            mc.setShowOnMap(buildings);
        }
        double currentLn = mc.getCurrentLn();
        double currentLat = mc.getCurrentLat();
        if (buildings != null) {
            Vector<Integer> selectedBuildingIndexs = new Vector<Integer>();
            int i = 0;
            while (i < buildings.size()) {
                Building building = (Building)buildings.elementAt(i);
                double addLn = Math.abs(building.getLn() - currentLn);
                double addLat = Math.abs(building.getLat() - currentLat);
                if (addLn < 4.5E-5 && addLat < 4.5E-5) {
                    selectedBuildingIndexs.addElement(new Integer(i));
                }
                ++i;
            }
            if (selectedBuildingIndexs.size() != 0) {
                KCommand kcmd = new KCommand(msgRes.getMsg("PRODETAILS"), 8, 15, "MapClick", null);
                mc.addCommand(kcmd);
            } else {
                mc.removeKCommand("MapClick");
            }
            mc.setSelectedBuildingIndex(selectedBuildingIndexs);
        }
        mc.reflash();
    }

    private static synchronized void hMove(int step, MapCanvas mc, int times) throws NullAreaException {
        int x = mc.getCurrentX();
        int y = mc.getCurrentY();
        int i = 0;
        while (i < times && !isHMoveStop) {
            mc.showMap(x += step, y);
            ++i;
        }
    }

    private static synchronized void vMove(int step, MapCanvas mc, int times) throws NullAreaException {
        int x = mc.getCurrentX();
        int y = mc.getCurrentY();
        int i = 0;
        while (i < times && !isVMoveStop) {
            mc.showMap(x, y += step);
            ++i;
        }
    }
}

