/*
 * Decompiled with CFR 0.152.
 */
package com.mgie.darkchess;

import com.mgie.darkchess.ChessUnit;
import com.mgie.darkchess.DarkChessConfig;
import com.mgie.darkchess.DarkChessRes;
import com.mgie.darkchess.GameFunction;
import java.util.Vector;

public class DarkChessAI
implements DarkChessConfig {
    private DarkChessRes res = null;
    public boolean running = false;

    public DarkChessAI(DarkChessRes darkChessRes) {
        this.res = darkChessRes;
    }

    public void initAI() {
        this.res.vt_chess_red.removeAllElements();
        this.res.vt_chess_black.removeAllElements();
    }

    public int chessTurn() {
        int n = -1;
        while (this.chessTurnAble()) {
            n = GameFunction.random(0, 32);
            byte by = this.res.display_chess_map[n];
            if (by != 10) continue;
            this.chessTurnSuccee(n);
            return n;
        }
        return n;
    }

    public int chessTurn_cheat() {
        int n = -1;
        while (this.chessTurnAble(this.res.running_chess_color)) {
            n = GameFunction.random(0, 32);
            byte by = this.res.display_chess_map[n];
            byte by2 = this.res.type_chess_map[n];
            if (by != 10 || !this.isMyColor(this.res.running_chess_color, by2)) continue;
            this.chessTurnSuccee(n);
            return n;
        }
        n = this.chessTurn();
        return n;
    }

    public boolean chessTurnAble() {
        return this.res.game_hide_total > 0;
    }

    public boolean chessTurnAble(int n) {
        return n > 0 ? this.res.game_hide_total_red > 0 : this.res.game_hide_total_black > 0;
    }

    public boolean chessAttackAble(int n) {
        if (this.getMyChessSize(n) > 0) {
            this.res.attack_get_value = -1;
            for (int i = 0; i < this.getMyChessVector(n).size(); ++i) {
                ChessUnit chessUnit = (ChessUnit)this.getMyChessVector(n).elementAt(i);
                this.ai_check_each_chess(chessUnit.row, chessUnit.col, chessUnit.type, 1);
                if (this.res.attack_get_value == -1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean chessMoveAble(int n) {
        if (this.getMyChessSize(n) > 0) {
            for (int i = 0; i < this.getMyChessVector(n).size(); ++i) {
                ChessUnit chessUnit = (ChessUnit)this.getMyChessVector(n).elementAt(i);
                if (!this.chessMoveAble(chessUnit.row, chessUnit.col)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean chessMoveAble(int n, int n2) {
        this.res.random_move_now_col = n2;
        this.res.random_move_now_row = n;
        if (this.moveUseable(n - 1, n2)) {
            return true;
        }
        if (this.moveUseable(n + 1, n2)) {
            return true;
        }
        if (this.moveUseable(n, n2 - 1)) {
            return true;
        }
        return this.moveUseable(n, n2 + 1);
    }

    public void chessTurnSuccee(int n) {
        byte by = this.res.type_chess_map[n];
        int n2 = n / 4;
        int n3 = n % 4;
        ChessUnit chessUnit = new ChessUnit(by, n2, n3, this.res.game_hide_total);
        if (by > 0) {
            this.res.vt_chess_red.addElement(chessUnit);
            --this.res.game_hide_total_red;
        } else {
            this.res.vt_chess_black.addElement(chessUnit);
            --this.res.game_hide_total_black;
        }
        this.resetLaseMoveChessCount(this.res.running_chess_color);
        this.res.display_chess_map[n] = by;
        --this.res.game_hide_total;
        this.res.lastChess = chessUnit;
    }

    public int getMyChessSize(int n) {
        if (n == 1) {
            return this.res.vt_chess_red.size();
        }
        return this.res.vt_chess_black.size();
    }

    private Vector getMyChessVector(int n) {
        if (n == 1) {
            return this.res.vt_chess_red;
        }
        return this.res.vt_chess_black;
    }

    public int getRivalChessSize() {
        return this.getMyChessSize(-this.res.running_chess_color);
    }

    public int getMyChessSize() {
        return this.getMyChessSize(this.res.running_chess_color);
    }

    public byte[] getChessDeleteTotal(int n) {
        if (n == 1) {
            return this.res.delete_chess_red;
        }
        return this.res.delete_chess_black;
    }

    public boolean checkStandoff() {
        return this.res.emptyStepCount > 100;
    }

    private int complexion() {
        if (this.getChessDeleteTotal(-this.res.running_chess_color)[1] == 0 && this.getChessDeleteTotal(this.res.running_chess_color)[7] < 5) {
            this.res.attack_get_value = -1;
            for (int i = 0; i < this.getMyChessVector(this.res.running_chess_color).size(); ++i) {
                ChessUnit chessUnit = (ChessUnit)this.getMyChessVector(this.res.running_chess_color).elementAt(i);
                if (Math.abs(chessUnit.type) != 7) continue;
                this.ai_check_each_chess(chessUnit.row, chessUnit.col, chessUnit.type, 1);
            }
            if (this.res.attack_get_value > 0) {
                return 20;
            }
        }
        if (this.getLaseMoveChessCount(-this.res.running_chess_color) > 3) {
            ChessUnit chessUnit;
            int n;
            int n2 = this.checking_attack();
            if (n2 != 24) {
                return n2;
            }
            Vector<ChessUnit> vector = new Vector<ChessUnit>();
            for (n = 0; n < this.getMyChessVector(this.res.running_chess_color).size(); ++n) {
                chessUnit = (ChessUnit)this.getMyChessVector(this.res.running_chess_color).elementAt(n);
                if (!this.eatUseable_by_side(chessUnit.type, this.res.lastChess.type)) continue;
                vector.addElement(chessUnit);
            }
            while (vector.size() > 0) {
                n = GameFunction.random(0, vector.size());
                chessUnit = (ChessUnit)vector.elementAt(n);
                if (this.moveApproachCheck(chessUnit, this.res.lastChess)) {
                    return 21;
                }
                vector.removeElementAt(n);
            }
            if (this.chessTurnAble(this.res.running_chess_color)) {
                return 23;
            }
        }
        if (this.getLaseMoveChessCount(this.res.running_chess_color) > 3) {
            int n = this.checking_attack();
            if (n != 24) {
                return n;
            }
            if (this.chessTurnAble(this.res.running_chess_color)) {
                return 23;
            }
        }
        return 24;
    }

    private boolean moveApproachCheck(ChessUnit chessUnit, ChessUnit chessUnit2) {
        int n = chessUnit.col;
        int n2 = chessUnit.row;
        this.res.random_move_now_col = n;
        this.res.random_move_now_row = n2;
        boolean bl = false;
        byte by = this.getChessType(n2, n);
        if (n > chessUnit2.col) {
            bl = this.moveUseable_byEat(n2, n - 1, by);
        } else if (n < chessUnit2.col) {
            bl = this.moveUseable_byEat(n2, n + 1, by);
        }
        if (bl) {
            return true;
        }
        bl = n2 > chessUnit2.row ? this.moveUseable_byEat(n2 - 1, n, by) : this.moveUseable_byEat(n2 + 1, n, by);
        return bl;
    }

    public int checking() {
        try {
            int n = this.getMyChessSize();
            if (n == 0) {
                if (this.chessTurnAble(this.res.running_chess_color)) {
                    return 23;
                }
                return 26;
            }
            int n2 = 24;
            n2 = this.complexion();
            if (n2 != 24) {
                return n2;
            }
            n2 = this.checking_common();
            if (n2 != 24) {
                return n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 24;
    }

    private int checking_common() {
        int n = 24;
        n = this.checking_defend();
        if (n != 24) {
            return n;
        }
        n = this.checking_attack();
        if (n != 24) {
            return n;
        }
        n = this.checking_move();
        if (n != 24) {
            return n;
        }
        n = this.checking_random();
        if (n != 24) {
            return n;
        }
        return 25;
    }

    private int checking_random() {
        int n = this.getMyChessSize();
        if (n == 0 && !this.chessTurnAble(this.res.running_chess_color)) {
            return 26;
        }
        if (n > 3) {
            for (int i = 0; i < 20; ++i) {
                int n2 = GameFunction.random(0, n);
                ChessUnit chessUnit = (ChessUnit)this.getMyChessVector(this.res.running_chess_color).elementAt(n2);
                if (!this.moveRandomCheck(chessUnit.row, chessUnit.col)) continue;
                return 21;
            }
        }
        if (this.chessTurnAble(this.res.running_chess_color)) {
            return 23;
        }
        if (this.chessMoveAble(this.res.running_chess_color)) {
            return 21;
        }
        if (this.chessTurnAble()) {
            return 23;
        }
        return 24;
    }

    private int checking_move() {
        this.res.move_get_value = -1;
        for (int i = 0; i < this.getMyChessVector(this.res.running_chess_color).size(); ++i) {
            ChessUnit chessUnit = (ChessUnit)this.getMyChessVector(this.res.running_chess_color).elementAt(i);
            this.moveChessCheck(chessUnit.row, chessUnit.col, 3);
        }
        if (this.res.move_get_value > 0) {
            return 22;
        }
        return 24;
    }

    private int checking_attack() {
        this.res.attack_get_value = -1;
        for (int i = 0; i < this.getMyChessVector(this.res.running_chess_color).size(); ++i) {
            ChessUnit chessUnit = (ChessUnit)this.getMyChessVector(this.res.running_chess_color).elementAt(i);
            this.ai_check_each_chess(chessUnit.row, chessUnit.col, chessUnit.type, 1);
        }
        if (this.res.attack_get_value != -1) {
            return 20;
        }
        return 24;
    }

    private int checking_defend() {
        if (this.isMyColor(this.res.running_chess_color, this.res.lastChess.type)) {
            if (this.eatChess_counterattack(this.res.lastChess.row, this.res.lastChess.col, this.res.lastChess.type)) {
                this.res.defend_damage = DarkChessConfig.CHESS_TYPE_VALUE[Math.abs(this.res.lastChess.type)];
                this.res.attack_get_value = -1;
                this.ai_check_each_chess(this.res.lastChess.row, this.res.lastChess.col, this.res.lastChess.type, 1);
                if (this.res.attack_get_value != -1) {
                    this.res.defend_score = this.res.attack_get_value;
                    this.res.defend_score_next_row = this.res.attack_next_row;
                    this.res.defend_score_next_col = this.res.attack_next_col;
                    this.res.defend_score_now_row = this.res.attack_now_row;
                    this.res.defend_score_now_col = this.res.attack_now_col;
                    return 20;
                }
                if (this.moveRandomCheck(this.res.lastChess.row, this.res.lastChess.col)) {
                    return 21;
                }
            }
        } else {
            this.res.defend_get_value = -1;
            this.ai_check_each_chess(this.res.lastChess.row, this.res.lastChess.col, this.res.lastChess.type, 2);
            if (this.res.defend_get_value != -1) {
                if (this.eatChess_counterattack(this.res.lastChess.row, this.res.lastChess.col, this.res.lastChess.type)) {
                    this.res.byeat_dmg_row = this.res.lastChess.row;
                    this.res.byeat_dmg_col = this.res.lastChess.col;
                    return 27;
                }
                this.res.attack_get_value = -1;
                this.ai_check_each_chess(this.res.defend_need_row, this.res.defend_need_col, this.getChessType(this.res.defend_need_row, this.res.defend_need_col), 1);
                if (this.res.attack_get_value != -1) {
                    return 20;
                }
                this.res.move_get_value = -1;
                this.moveChessCheck(this.res.defend_need_row, this.res.defend_need_col, 3);
                if (this.res.move_get_value > 0) {
                    return 22;
                }
                if (this.moveRandomCheck(this.res.defend_need_row, this.res.defend_need_col)) {
                    return 21;
                }
            }
        }
        return 24;
    }

    private void ai_check_each_chess(int n, int n2, byte by, int n3) {
        if (Math.abs(by) != 6) {
            this.eatChessCheck(n, n2, by, n3);
        } else {
            this.eatChessCheck_cannon(n, n2, n3);
        }
    }

    public void chessCounterattack() {
        this.chessAttackSuccee(this.res.byeat_atk_row, this.res.byeat_atk_col, this.res.byeat_dmg_row, this.res.byeat_dmg_col);
    }

    public void chessAttack() {
        this.chessAttackSuccee(this.res.attack_now_row, this.res.attack_now_col, this.res.attack_next_row, this.res.attack_next_col);
    }

    public void chessMoveAttack() {
        this.chessMoveSuccee(this.res.move_now_row, this.res.move_now_col, this.res.move_next_row, this.res.move_next_col);
    }

    public void chessRandomMove() {
        this.chessMoveSuccee(this.res.random_move_now_row, this.res.random_move_now_col, this.res.random_move_next_row, this.res.random_move_next_col);
    }

    private boolean moveRandomCheck(int n, int n2) {
        this.res.random_move_now_col = n2;
        this.res.random_move_now_row = n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        byte by = this.getChessType(n, n2);
        while (!bl5) {
            switch (GameFunction.random(0, 4)) {
                case 0: {
                    if (bl) break;
                    bl = true;
                    bl5 = this.moveUseable_byEat(n - 1, n2, by);
                    break;
                }
                case 1: {
                    if (bl2) break;
                    bl2 = true;
                    bl5 = this.moveUseable_byEat(n + 1, n2, by);
                    break;
                }
                case 2: {
                    if (bl3) break;
                    bl3 = true;
                    bl5 = this.moveUseable_byEat(n, n2 - 1, by);
                    break;
                }
                case 3: {
                    if (bl4) break;
                    bl4 = true;
                    bl5 = this.moveUseable_byEat(n, n2 + 1, by);
                }
            }
            if (!bl || !bl2 || !bl3 || !bl4) continue;
            return bl5;
        }
        return true;
    }

    private void moveChessCheck(int n, int n2, int n3) {
        this.res.move_now_col_tmp = n2;
        this.res.move_now_row_tmp = n;
        byte by = this.getChessType(n, n2);
        this.moveUseable(n, n2 - 1, by, n3);
        this.moveUseable(n, n2 + 1, by, n3);
        this.moveUseable(n - 1, n2, by, n3);
        this.moveUseable(n + 1, n2, by, n3);
    }

    private boolean moveUseable(int n, int n2) {
        if (n < 0 || n >= 8 || n2 < 0 || n2 >= 4) {
            return false;
        }
        if (this.isEmpty(n, n2)) {
            this.res.random_move_next_col = n2;
            this.res.random_move_next_row = n;
            return true;
        }
        return false;
    }

    private boolean moveUseable_byEat(int n, int n2, byte by) {
        if (n < 0 || n >= 8 || n2 < 0 || n2 >= 4) {
            return false;
        }
        if (this.isEmpty(n, n2) && !this.eatChess_counterattack(n, n2, by)) {
            this.res.random_move_next_col = n2;
            this.res.random_move_next_row = n;
            return true;
        }
        return false;
    }

    private void moveUseable(int n, int n2, byte by, int n3) {
        if (n < 0 || n >= 8 || n2 < 0 || n2 >= 4) {
            return;
        }
        if (this.eatChess_counterattack(n, n2, by)) {
            return;
        }
        if (this.isEmpty(n, n2)) {
            this.ai_check_each_chess(n, n2, by, n3);
        }
    }

    private void eatChessCheck(int n, int n2, byte by, int n3) {
        this.setWillStateChess(n, n2, n - 1, n2, by, n3);
        this.setWillStateChess(n, n2, n + 1, n2, by, n3);
        this.setWillStateChess(n, n2, n, n2 - 1, by, n3);
        this.setWillStateChess(n, n2, n, n2 + 1, by, n3);
    }

    private void eatChessCheck_cannon(int n, int n2, int n3) {
        int n4;
        byte by;
        int n5;
        byte by2 = this.getChessType(n, n2);
        if (n >= 2) {
            n5 = 0;
            by = 0;
            for (n4 = 1; n4 <= n; ++n4) {
                by = this.getChessDisplay(n - n4, n2);
                if (by == 0 || ++n5 != 2) continue;
                if (by == 10 || !this.isEmeny(n - n4, n2, by2)) break;
                this.setWillStateChess(n, n2, n - n4, n2, by2, n3);
                break;
            }
        }
        if (n < 6) {
            n5 = 0;
            by = 0;
            for (n4 = 1; n4 < 8 - n; ++n4) {
                by = this.getChessDisplay(n + n4, n2);
                if (by == 0 || ++n5 != 2) continue;
                if (by == 10 || !this.isEmeny(n + n4, n2, by2)) break;
                this.setWillStateChess(n, n2, n + n4, n2, by2, n3);
                break;
            }
        }
        if (n2 >= 2) {
            n5 = 0;
            by = 0;
            for (n4 = 1; n4 <= n2; ++n4) {
                by = this.getChessDisplay(n, n2 - n4);
                if (by == 0 || ++n5 != 2) continue;
                if (by == 10 || !this.isEmeny(n, n2 - n4, by2)) break;
                this.setWillStateChess(n, n2, n, n2 - n4, by2, n3);
                break;
            }
        }
        if (n2 < 2) {
            n5 = 0;
            by = 0;
            for (n4 = 1; n4 < 4 - n2; ++n4) {
                by = this.getChessDisplay(n, n2 + n4);
                if (by == 0 || ++n5 != 2) continue;
                if (by == 10 || !this.isEmeny(n, n2 + n4, by2)) break;
                this.setWillStateChess(n, n2, n, n2 + n4, by2, n3);
                break;
            }
        }
    }

    private void setWillStateChess(int n, int n2, int n3, int n4, byte by, int n5) {
        switch (n5) {
            case 1: {
                this.setWillAttackChess(n, n2, n3, n4, this.eatChess_attack(n3, n4, by));
                break;
            }
            case 2: {
                this.setWillDefendChess(n, n2, n3, n4, this.eatChess_attack(n3, n4, by));
                break;
            }
            case 3: {
                this.setWillMoveAttackChess(this.res.move_now_row_tmp, this.res.move_now_col_tmp, n, n2, this.eatChess_attack(n3, n4, by));
            }
        }
    }

    private void setWillMoveAttackChess(int n, int n2, int n3, int n4, int n5) {
        if (n5 > this.res.move_get_value) {
            this.res.move_get_value = n5;
            this.res.move_next_col = n4;
            this.res.move_next_row = n3;
            this.res.move_now_col = n2;
            this.res.move_now_row = n;
        }
    }

    private void setWillDefendChess(int n, int n2, int n3, int n4, int n5) {
        if (n5 > this.res.defend_get_value) {
            this.res.defend_get_value = n5;
            this.res.defend_atk_col = n2;
            this.res.defend_atk_row = n;
            this.res.defend_need_col = n4;
            this.res.defend_need_row = n3;
        }
    }

    private void setWillAttackChess(int n, int n2, int n3, int n4, int n5) {
        if (n5 > this.res.attack_get_value) {
            this.res.attack_get_value = n5;
            this.res.attack_next_row = n3;
            this.res.attack_next_col = n4;
            this.res.attack_now_row = n;
            this.res.attack_now_col = n2;
        }
    }

    private int eatChess_attack(int n, int n2, byte by) {
        if (Math.abs(by) != 6) {
            return this.eatChess_attack_side(n, n2, by);
        }
        return this.eatChess_attack_cannon(n, n2, by);
    }

    private int eatChess_attack_cannon(int n, int n2, byte by) {
        if (!this.isUseable(n, n2)) {
            return -1;
        }
        if (!this.isEmeny(n, n2, by)) {
            return -1;
        }
        int n3 = this.getChessValue(n, n2);
        if (this.eatChess_counterattack(n, n2, by)) {
            return n3 - DarkChessConfig.CHESS_TYPE_VALUE[Math.abs(by)];
        }
        return n3;
    }

    private int eatChess_attack_side(int n, int n2, byte by) {
        if (!this.isUseable(n, n2)) {
            return -1;
        }
        if (!this.isEmeny(n, n2, by)) {
            return -1;
        }
        if (!this.eatUseable_by_side(by, this.getChessType(n, n2))) {
            return -1;
        }
        int n3 = this.getChessValue(n, n2);
        if (this.eatChess_counterattack(n, n2, by)) {
            return n3 - DarkChessConfig.CHESS_TYPE_VALUE[Math.abs(by)];
        }
        return n3;
    }

    private boolean eatUseable_by_side(byte by, byte by2) {
        if (Math.abs(by) == 6) {
            return false;
        }
        return Math.abs(by) == 1 ? Math.abs(by2) != 7 : (Math.abs(by) == 7 ? Math.abs(by2) == 1 || Math.abs(by2) == 7 : Math.abs(by) <= Math.abs(by2));
    }

    private boolean eatChess_counterattack(int n, int n2, byte by) {
        try {
            if (this.checkByEat(n, n2, by)) {
                return true;
            }
            if (this.checkByEat_cannon(n, n2, by)) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private boolean checkByEat_cannon(int n, int n2, byte by) {
        int n3;
        byte by2;
        int n4;
        if (n >= 2) {
            n4 = 0;
            by2 = 0;
            for (n3 = 1; n3 <= n; ++n3) {
                by2 = this.getChessDisplay(n - n3, n2);
                if (by2 == 0 || ++n4 != 2) continue;
                if (!this.byEat_cannon(n - n3, n2, by, by2)) break;
                return true;
            }
        }
        if (n < 6) {
            n4 = 0;
            by2 = 0;
            for (n3 = 1; n3 < 8 - n; ++n3) {
                by2 = this.getChessDisplay(n + n3, n2);
                if (by2 == 0 || ++n4 != 2) continue;
                if (!this.byEat_cannon(n + n3, n2, by, by2)) break;
                return true;
            }
        }
        if (n2 >= 2) {
            n4 = 0;
            by2 = 0;
            for (n3 = 1; n3 <= n2; ++n3) {
                by2 = this.getChessDisplay(n, n2 - n3);
                if (by2 == 0 || ++n4 != 2) continue;
                if (!this.byEat_cannon(n, n2 - n3, by, by2)) break;
                return true;
            }
        }
        if (n2 < 2) {
            n4 = 0;
            by2 = 0;
            for (n3 = 1; n3 < 4 - n2; ++n3) {
                by2 = this.getChessDisplay(n, n2 + n3);
                if (by2 == 0 || ++n4 != 2) continue;
                if (!this.byEat_cannon(n, n2 + n3, by, by2)) break;
                return true;
            }
        }
        return false;
    }

    private boolean byEat_cannon(int n, int n2, byte by, byte by2) {
        if (Math.abs(by2) == 6 && this.isEmeny(n, n2, by)) {
            this.res.byeat_atk_col = n2;
            this.res.byeat_atk_row = n;
            return true;
        }
        return false;
    }

    private boolean checkByEat(int n, int n2, byte by) {
        if (this.byEat(n, n2 - 1, by)) {
            return true;
        }
        if (this.byEat(n, n2 + 1, by)) {
            return true;
        }
        if (this.byEat(n - 1, n2, by)) {
            return true;
        }
        return this.byEat(n + 1, n2, by);
    }

    private boolean byEat(int n, int n2, byte by) {
        byte by2;
        if (!this.isUseable(n, n2)) {
            return false;
        }
        if (this.isEmeny(n, n2, by) && this.eatUseable_by_side(by2 = this.getChessType(n, n2), by)) {
            this.res.byeat_atk_col = n2;
            this.res.byeat_atk_row = n;
            return true;
        }
        return false;
    }

    private boolean isEmeny(int n, int n2, byte by) {
        int n3 = n * 4 + n2;
        byte by2 = this.res.display_chess_map[n3];
        byte by3 = this.res.type_chess_map[n3];
        return by2 != 10 && (by > 0 && by3 < 0 || by < 0 && by3 > 0);
    }

    private byte getChessType(int n, int n2) {
        int n3 = n * 4 + n2;
        return this.res.type_chess_map[n3];
    }

    private byte getChessDisplay(int n, int n2) {
        int n3 = n * 4 + n2;
        return this.res.display_chess_map[n3];
    }

    private boolean isHide(int n, int n2) {
        int n3 = n * 4 + n2;
        return this.res.display_chess_map[n3] == 10;
    }

    private boolean isEmpty(int n, int n2) {
        int n3 = n * 4 + n2;
        return this.res.display_chess_map[n3] == 0;
    }

    private boolean isUseable(int n, int n2) {
        if (n < 0 || n >= 8 || n2 < 0 || n2 >= 4) {
            return false;
        }
        if (this.isEmpty(n, n2)) {
            return false;
        }
        return !this.isHide(n, n2);
    }

    private boolean isMyColor(int n, byte by) {
        return n < 0 && by < 0 || n > 0 && by > 0;
    }

    private int getChessValue(int n, int n2) {
        int n3 = n * 4 + n2;
        byte by = this.res.type_chess_map[n3];
        return DarkChessConfig.CHESS_TYPE_VALUE[Math.abs(by)];
    }

    public void chessMoveSuccee(int n, int n2, int n3, int n4) {
        byte by;
        ++this.res.emptyStepCount;
        int n5 = n3 * 4 + n4;
        int n6 = n * 4 + n2;
        this.res.display_chess_map[n5] = by = this.getChessType(n, n2);
        this.res.type_chess_map[n5] = by;
        this.res.display_chess_map[n6] = 0;
        this.res.type_chess_map[n6] = 0;
        this.moveChess(n, n2, n3, n4, this.res.running_chess_color);
    }

    public void chessAttackSuccee(int n, int n2, int n3, int n4) {
        this.chessMoveSuccee(n, n2, n3, n4);
        this.deleteChess(n3, n4, -this.res.running_chess_color);
    }

    private void deleteChess(int n, int n2, int n3) {
        this.res.emptyStepCount = 0;
        for (int i = 0; i < this.getMyChessVector(n3).size(); ++i) {
            ChessUnit chessUnit = (ChessUnit)this.getMyChessVector(n3).elementAt(i);
            if (n != chessUnit.row || n2 != chessUnit.col) continue;
            this.deleteChessTotal(chessUnit.type);
            this.getMyChessVector(n3).removeElementAt(i);
            return;
        }
    }

    private void deleteChessTotal(byte by) {
        if (by > 0) {
            byte by2 = by;
            this.res.delete_chess_red[by2] = (byte)(this.res.delete_chess_red[by2] + 1);
        } else {
            int n = Math.abs(by);
            this.res.delete_chess_black[n] = (byte)(this.res.delete_chess_black[n] + 1);
        }
        this.res.attack_ready = true;
    }

    private void moveChess(int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < this.getMyChessVector(n5).size(); ++i) {
            ChessUnit chessUnit = (ChessUnit)this.getMyChessVector(n5).elementAt(i);
            if (n != chessUnit.row || n2 != chessUnit.col) continue;
            chessUnit.row = n3;
            chessUnit.col = n4;
            this.res.lastChess = chessUnit;
            this.setLaseMoveChess(chessUnit);
            return;
        }
    }

    private void setLaseMoveChess(ChessUnit chessUnit) {
        int n = chessUnit.id;
        if (chessUnit.type > 0) {
            if (this.res.lastChessRed != null) {
                this.res.lastChessRedCount = this.res.lastChessRed.id == n ? ++this.res.lastChessRedCount : 0;
            }
            this.res.lastChessRed = chessUnit;
        } else {
            if (this.res.lastChessBlack != null) {
                this.res.lastChessBlackCount = this.res.lastChessBlack.id == n ? ++this.res.lastChessBlackCount : 0;
            }
            this.res.lastChessBlack = chessUnit;
        }
    }

    private int getLaseMoveChessCount(int n) {
        if (n == 1) {
            return this.res.lastChessRedCount;
        }
        return this.res.lastChessBlackCount;
    }

    private void resetLaseMoveChessCount(int n) {
        if (n == 1) {
            this.res.lastChessRedCount = 0;
        } else {
            this.res.lastChessBlackCount = 0;
        }
    }
}

