/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class TextHandler {
    static final int FONT_SPACE_WIDTH = 4;
    static final int Width = 240;
    Image[] i_font = new Image[2];
    byte[][] char_widths = new byte[2][255];
    short[][] char_offsets = new short[2][255];
    public short[] font_heights = new short[2];
    public static final int offset_smalleng = 36;
    public static final int offset_special_sym = 61;
    public static final int offset_digit = 10;

    TextHandler() {
    }

    public static final int CenterX(String str, Font font) {
        int strWidth = font.stringWidth(str);
        return (240 - strWidth) / 2;
    }

    public final void loadFonts() {
        String path = "";
        path = "/res/";
        try {
            this.i_font[0] = Image.createImage((String)"/res/800.png");
            this.i_font[1] = Image.createImage((String)"/res/801.png");
            InputStream is = this.getClass().getResourceAsStream(path + "800");
            is.read();
            this.font_heights[0] = (short)is.read();
            is.read(this.char_widths[0]);
            for (int j = 1; j < 255; ++j) {
                this.char_offsets[0][j] = (short)(this.char_offsets[0][j - 1] + this.char_widths[0][j - 1]);
            }
            is.close();
            this.char_widths[0][101] = 4;
            InputStream is1 = this.getClass().getResourceAsStream(path + "801");
            is1.read();
            this.font_heights[1] = (short)is1.read();
            is1.read(this.char_widths[1]);
            for (int j = 1; j < 255; ++j) {
                this.char_offsets[1][j] = (short)(this.char_offsets[1][j - 1] + this.char_widths[1][j - 1]);
            }
            is1.close();
            this.char_widths[1][101] = 4;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static final int char_index(char sym) {
        if (sym >= '0' && sym <= '9') {
            return sym - 48;
        }
        if (sym >= 'A' && sym <= 'Z') {
            return sym - 65 + 10;
        }
        if (sym >= 'a' && sym <= 'z') {
            return sym - 97 + 36;
        }
        if (sym >= '\u05d0' && sym <= '\u05ea') {
            return 154 - (sym - 1488);
        }
        switch (sym) {
            case '.': {
                return 62;
            }
            case ',': {
                return 63;
            }
            case '-': {
                return 64;
            }
            case ':': {
                return 65;
            }
            case ';': {
                return 66;
            }
            case '\u001c': 
            case '\u001d': 
            case '\"': {
                return 67;
            }
            case '!': {
                return 68;
            }
            case '?': {
                return 69;
            }
            case '\\': {
                return 70;
            }
            case '/': {
                return 71;
            }
            case '(': {
                return 72;
            }
            case ')': {
                return 73;
            }
            case '[': {
                return 74;
            }
            case ']': {
                return 75;
            }
            case '`': 
            case '~': {
                return 76;
            }
            case '\u0019': 
            case '\'': 
            case '\u2019': {
                return 77;
            }
            case '&': {
                return 78;
            }
            case ' ': {
                return 101;
            }
            case '\n': {
                return 100;
            }
        }
        return sym;
    }

    public byte[] convert(String s) {
        if (s == null) {
            return new byte[0];
        }
        byte[] res = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            res[i] = s.charAt(i) >= 'A' && s.charAt(i) <= 'Z' || s.charAt(i) >= 'a' && s.charAt(i) <= 'z' ? (byte)TextHandler.char_index(s.charAt(s.length() - i - 1)) : (byte)TextHandler.char_index(s.charAt(i));
        }
        return res;
    }

    public final void paintText(Graphics g, int font, byte[] text, int x, int y, int width, int height) {
        byte sym_width = 0;
        if (text == null) {
            return;
        }
        int strLen = text.length;
        for (int i = 0; i < strLen; ++i) {
            if (text[i] == 101) {
                x -= 4;
                continue;
            }
            int c = text[i];
            if (c < 0) {
                c += 256;
            }
            sym_width = this.char_widths[font][c];
            g.setClip(x - sym_width, y, (int)sym_width, (int)this.font_heights[font]);
            g.drawImage(this.i_font[font], x - this.char_offsets[font][c] - sym_width, y, 0);
            x -= sym_width;
        }
        g.setClip(0, 0, width, height);
    }

    public final void paintTextNormal(Graphics g, int font, byte[] text, int x, int y, int width, int height) {
        byte sym_width = 0;
        if (text == null) {
            return;
        }
        int strLen = text.length;
        for (int i = 0; i < strLen; ++i) {
            if (text[i] == 101) {
                x += 4;
                continue;
            }
            int c = text[i];
            if (c < 0) {
                c += 256;
            }
            sym_width = this.char_widths[font][c];
            g.setClip(x, y, (int)sym_width, (int)this.font_heights[font]);
            g.drawImage(this.i_font[font], x - this.char_offsets[font][c], y, 0);
            x += sym_width;
        }
        g.setClip(0, 0, width, height);
    }

    public final int getTextWidth(int font, byte[] text) {
        int str_width = 0;
        if (text == null) {
            return 0;
        }
        int strLen = text.length;
        for (int i = 0; i < strLen; ++i) {
            int c = text[i];
            if (c < 0) {
                c += 256;
            }
            str_width += this.char_widths[font][c];
        }
        return str_width;
    }

    public final byte[] text_getNextLine(int font, byte[] text, int start, int max_width) {
        int i;
        if (text == null) {
            return null;
        }
        int last_ptr = start;
        if (start >= text.length) {
            return null;
        }
        for (i = start; i < text.length; ++i) {
            if (text[i] == 100) {
                if (this.text_sub_string_width(font, text, start, i) >= max_width) {
                    return TextHandler.text_sub_string(text, start, last_ptr + 1);
                }
                return TextHandler.text_sub_string(text, start, i + 1);
            }
            if (text[i] != 101) continue;
            if (this.text_sub_string_width(font, text, start, i) >= max_width) {
                return TextHandler.text_sub_string(text, start, last_ptr + 1);
            }
            last_ptr = i;
        }
        if (this.text_sub_string_width(font, text, start, i) >= max_width) {
            if (last_ptr == start) {
                for (int k = start; k < i; ++k) {
                    if (this.text_sub_string_width(font, text, start, k) < max_width) continue;
                    return TextHandler.text_sub_string(text, start, k - 1);
                }
                return null;
            }
            return TextHandler.text_sub_string(text, start, last_ptr + 1);
        }
        return TextHandler.text_sub_string(text, start, i);
    }

    public static final byte[] text_sub_string(byte[] array, int start, int end) {
        int count = end - start;
        if (count <= 0) {
            return new byte[0];
        }
        byte[] res = new byte[count];
        System.arraycopy(array, start, res, 0, count);
        return res;
    }

    final int text_sub_string_width(int font, byte[] array, int start, int end) {
        int res = 0;
        for (int i = start; i < end; ++i) {
            int c = array[i];
            if (c < 0) {
                c += 256;
            }
            res += this.char_widths[font][c];
        }
        return res;
    }
}

