/*
 * Decompiled with CFR 0.152.
 */
package com.bpi.encryption;

public class GenerationLibrary {
    public static final boolean DEBUG = false;
    public static final int TOTAL_VALUE_BASE32 = 32;
    public static final int TOTAL_INT_BIT = 32;
    public static final int TOTAL_BPC = 5;
    public static final int TOTAL_CODE = 13;
    public static final int TOTAL_CODE_WITH_CHECKBITS = 15;
    public static final int MAX_RANGE = 1000000000;
    public static final int TOTAL_NUMBER_DIGIT = 10;
    public static final int TOTAL_DIGIT = 9;
    public static final int[] DIGIT_TABLE = new int[]{10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    public static final int UID = 0;
    public static final int SCORE = 1;
    public static final int MASK1 = -1431655766;
    public static final int MASK2 = 0x55555555;
    public static final int SINGLE_BIT_MARK = 1;
    public static final int[][] UID_TABLE = new int[][]{{5, 2, 4, 1, 7, 0, 3, 9, 6, 8}, {2, 4, 1, 7, 0, 3, 9, 6, 8, 5}, {4, 1, 7, 0, 3, 9, 6, 8, 5, 2}, {1, 7, 0, 3, 9, 6, 8, 5, 2, 4}, {7, 0, 3, 9, 6, 8, 5, 2, 4, 1}, {0, 3, 9, 6, 8, 5, 2, 4, 1, 7}, {3, 9, 6, 8, 5, 2, 4, 1, 7, 0}, {9, 6, 8, 5, 2, 4, 1, 7, 0, 3}, {6, 8, 5, 2, 4, 1, 7, 0, 3, 9}, {8, 5, 2, 4, 1, 7, 0, 3, 9, 6}};
    public static final int[][] SOURCE_TABLE = new int[][]{{7, 4, 5, 2, 3, 6, 1, 8, 9, 0}, {4, 5, 2, 3, 6, 1, 8, 9, 0, 7}, {5, 2, 3, 6, 1, 8, 9, 0, 7, 4}, {2, 3, 6, 1, 8, 9, 0, 7, 4, 5}, {3, 6, 1, 8, 9, 0, 7, 4, 5, 2}, {6, 1, 8, 9, 0, 7, 4, 5, 2, 3}, {1, 8, 9, 0, 7, 4, 5, 2, 3, 6}, {8, 9, 0, 7, 4, 5, 2, 3, 6, 1}, {9, 0, 7, 4, 5, 2, 3, 6, 1, 8}, {0, 7, 4, 5, 2, 3, 6, 1, 8, 9}};
    public static long seed1 = 1010002406L;
    public static long seed2 = 501L;
    public static int seed3 = 23;
    public static char[] BASE32 = new char[]{'4', 'H', 'J', 'K', '9', 'R', 'S', '8', 'X', 'U', '6', 'E', '7', 'D', 'G', 'W', '2', 'N', 'A', '3', 'Z', 'B', 'C', 'L', 'F', 'P', 'V', '5', 'Y', 'T', 'Q', 'M'};
    public static String BASE32_STR;

    public static int[] decryption(String string) {
        int[] nArray = new int[]{-1, -1};
        try {
            if (string.length() == 13) {
                nArray = GenerationLibrary.base32DecodingData32(string, BASE32_STR);
                int n = nArray[0] & 0xAAAAAAAA | nArray[1] & 0x55555555;
                int n2 = nArray[0] & 0x55555555 | nArray[1] & 0xAAAAAAAA;
                nArray[0] = GenerationLibrary.decodeNumber(n, UID_TABLE);
                nArray[1] = GenerationLibrary.decodeNumber(n2, SOURCE_TABLE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nArray;
    }

    public static String encryption(int n, int n2) {
        String string = null;
        n = GenerationLibrary.encodeNumber(n, UID_TABLE);
        n2 = GenerationLibrary.encodeNumber(n2, SOURCE_TABLE);
        int n3 = n & 0xAAAAAAAA | n2 & 0x55555555;
        int n4 = n & 0x55555555 | n2 & 0xAAAAAAAA;
        int[] nArray = new int[]{n3, n4};
        try {
            string = GenerationLibrary.base32Encoding(nArray, BASE32_STR);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static int encodeNumber(int n, int[][] nArray) {
        int n2 = 0;
        if (n >= 0 && n < 1000000000) {
            for (int i = 8; i >= 0; --i) {
                int n3 = DIGIT_TABLE[i];
                int n4 = n3 / 10;
                int n5 = n % n3;
                int n6 = n5 / n4;
                int n7 = nArray[i][n6];
                n2 += n7 * n4;
            }
        }
        return n2;
    }

    public static int decodeNumber(int n, int[][] nArray) {
        int n2 = 0;
        if (n >= 0 && n < 1000000000) {
            for (int i = 8; i >= 0; --i) {
                int n3 = DIGIT_TABLE[i];
                int n4 = n3 / 10;
                int n5 = n % n3;
                int n6 = n5 / n4;
                int n7 = 0;
                for (int j = 0; j < 10; ++j) {
                    if (nArray[i][j] != n6) continue;
                    n7 = j;
                }
                n2 += n7 * n4;
            }
        }
        return n2;
    }

    public static String base32Encoding(int[] nArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 5;
        int n2 = 0;
        int n3 = 0;
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 31; j >= 0; --j) {
                    if (n == 0) {
                        stringBuffer.append(string.charAt(n2));
                        n2 = 0;
                        n = 5;
                    }
                    n3 = nArray[i] & 1 << j;
                    n2 |= (n3 >>= j) << --n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append(BASE32[n2]);
        return stringBuffer.toString();
    }

    public static int[] base32DecodingData32(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 32;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length() * 5 / 32;
        int n5 = 0;
        char[] cArray = string.toCharArray();
        int[] nArray = new int[n4];
        for (int i = 0; i < cArray.length; ++i) {
            int n6;
            n2 = string2.indexOf(cArray[i]);
            if (n > 5) {
                nArray[n5] = nArray[n5] | n2 << (n -= 5);
                continue;
            }
            int n7 = 0;
            while (0 < n) {
                n6 = 5 - n7 - 1;
                n3 = n2 & 1 << n6;
                nArray[n5] = nArray[n5] | (n3 >>= n6) << n - 1;
                --n;
                ++n7;
            }
            if (++n5 >= n4) continue;
            n = 32;
            while (n7 < 5) {
                n6 = 5 - n7 - 1;
                n3 = n2 & 1 << n6;
                nArray[n5] = nArray[n5] | (n3 >>= n6) << --n;
                ++n7;
            }
        }
        stringBuffer.append(BASE32[n2]);
        return nArray;
    }

    static {
        for (int i = 0; i < BASE32.length; ++i) {
            int n = (int)((seed1 -= seed2 * (long)i) % (long)BASE32.length);
            char c = BASE32[n];
            GenerationLibrary.BASE32[n] = BASE32[i];
            GenerationLibrary.BASE32[i] = c;
            BASE32_STR = new String(BASE32);
        }
    }
}

