/*
 * Decompiled with CFR 0.152.
 */
package NamesPKG;

import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class RSHandler {
    private RecordStore rs = null;
    static final String LANG_RS = "Names_Lang_db";
    static final int ARABIC = 0;
    static final int ENGLISH = 1;
    static final int GRID = 0;
    static final int LIST = 1;
    private int Language = 0;
    private int View = 0;

    public RSHandler() {
        try {
            this.getCurrentSetting();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void getCurrentSetting() throws RecordStoreException {
        try {
            this.rs = RecordStore.openRecordStore((String)LANG_RS, (boolean)false);
        }
        catch (RecordStoreNotFoundException e) {
            try {
                this.rs = RecordStore.openRecordStore((String)LANG_RS, (boolean)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.rs.getNumRecords() != 0) {
            this.Language = this.readRecords(1).equals("AR") ? 0 : 1;
            this.View = this.readRecords(2).equals("GRID") ? 0 : 1;
        }
        this.rs.closeRecordStore();
        this.rs = null;
    }

    public void saveLastStatus() throws RecordStoreException {
        try {
            this.rs = RecordStore.openRecordStore((String)LANG_RS, (boolean)false);
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        String str = this.Language == 0 ? "AR" : "EN";
        String view = this.View == 0 ? "GRID" : "LIST";
        if (this.rs.getNumRecords() != 0) {
            byte[] rec = str.getBytes();
            this.rs.setRecord(1, rec, 0, rec.length);
            rec = null;
            rec = view.getBytes();
            this.rs.setRecord(2, rec, 0, rec.length);
        } else {
            this.writeRecord(str.trim());
            this.writeRecord(view.trim());
        }
        this.rs.closeRecordStore();
        this.rs = null;
    }

    public int getLanguage() {
        return this.Language;
    }

    public void setLanguage(int lang) {
        this.Language = lang;
    }

    public int getCurrView() {
        return this.View;
    }

    public void setCurrView(int V) {
        this.View = V;
    }

    public void writeRecord(String str) {
        byte[] rec = str.getBytes();
        try {
            this.rs.addRecord(rec, 0, rec.length);
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
        }
    }

    public String readRecords(int index) {
        try {
            byte[] recData = new byte[this.rs.getRecordSize(index)];
            int len = this.rs.getRecord(index, recData, 0);
            return new String(recData, 0, len);
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
            return null;
        }
    }

    public void closeRecStore() {
        try {
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
        }
    }

    public void deleteRecStore() {
        if (RecordStore.listRecordStores() == null) {
            // empty if block
        }
    }
}

