/*
 * Decompiled with CFR 0.152.
 */
package GPackage;

import GPackage.Shapper;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class ArabicUtils {
    private static Shapper s_ShapperObj = new Shapper();
    static char[] cp1256_to_unicode_tab = new char[]{'\u20ac', '\u067e', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0679', '\u2039', '\u0152', '\u0686', '\u0698', '\u0688', '\u06af', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u06a9', '\u2122', '\u0691', '\u203a', '\u0153', '\u200c', '\u200d', '\u06ba', '\u00a0', '\u060c', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u06be', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u061b', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u061f', '\u06c1', '\u0621', '\u0622', '\u0623', '\u0624', '\u0625', '\u0626', '\u0627', '\u0628', '\u0629', '\u062a', '\u062b', '\u062c', '\u062d', '\u062e', '\u062f', '\u0630', '\u0631', '\u0632', '\u0633', '\u0634', '\u0635', '\u0636', '\u00d7', '\u0637', '\u0638', '\u0639', '\u063a', '\u0640', '\u0641', '\u0642', '\u0643', '\u00e0', '\u0644', '\u00e2', '\u0645', '\u0646', '\u0647', '\u0648', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u0649', '\u064a', '\u00ee', '\u00ef', '\u064b', '\u064c', '\u064d', '\u064e', '\u00f4', '\u064f', '\u0650', '\u00f7', '\u0651', '\u00f9', '\u0652', '\u00fb', '\u00fc', '\u200e', '\u200f', '\u00ff'};
    static int ISO_ALEF = 224;
    static int ISO_TAV = 250;
    static int ISO_HAMZA = 193;
    static int CP1256_DAD = 214;
    static int UNI_HAMZA = 1569;
    static int UNI_DAD = 1590;
    public static int[] m_intFontWidths;
    public static CustomBmpFont g_ControlsArabicFont;

    public static String ArabicAscii2Unicode(byte[] b) {
        String out = "";
        for (int i = 0; i < b.length; ++i) {
            int ch = b[i];
            if ((ch &= 0xFF) == 0) break;
            out = ch >= 128 && ch <= 255 ? out + cp1256_to_unicode_tab[ch - 128] : out + (char)ch;
        }
        return out;
    }

    public static byte unicode_to_cp1256(char uch) {
        int bRet;
        if (uch < '\u0100') {
            return (byte)uch;
        }
        if (uch >= UNI_HAMZA && uch <= UNI_DAD) {
            return (byte)(uch - UNI_HAMZA + ISO_HAMZA);
        }
        switch (uch) {
            case '\u0152': {
                bRet = 140;
                break;
            }
            case '\u0153': {
                bRet = 156;
                break;
            }
            case '\u0192': {
                bRet = 131;
                break;
            }
            case '\u02c6': {
                bRet = 136;
                break;
            }
            case '\u060c': {
                bRet = 161;
                break;
            }
            case '\u061b': {
                bRet = 186;
                break;
            }
            case '\u061f': {
                bRet = 191;
                break;
            }
            case '\u0637': {
                bRet = 216;
                break;
            }
            case '\u0638': {
                bRet = 217;
                break;
            }
            case '\u0639': {
                bRet = 218;
                break;
            }
            case '\u063a': {
                bRet = 219;
                break;
            }
            case '\u0640': {
                bRet = 220;
                break;
            }
            case '\u0641': {
                bRet = 221;
                break;
            }
            case '\u0642': {
                bRet = 222;
                break;
            }
            case '\u0643': {
                bRet = 223;
                break;
            }
            case '\u0644': {
                bRet = 225;
                break;
            }
            case '\u0645': {
                bRet = 227;
                break;
            }
            case '\u0646': {
                bRet = 228;
                break;
            }
            case '\u0647': {
                bRet = 229;
                break;
            }
            case '\u0648': {
                bRet = 230;
                break;
            }
            case '\u0649': {
                bRet = 236;
                break;
            }
            case '\u064a': {
                bRet = 237;
                break;
            }
            case '\u064b': {
                bRet = 240;
                break;
            }
            case '\u064c': {
                bRet = 241;
                break;
            }
            case '\u064d': {
                bRet = 242;
                break;
            }
            case '\u064e': {
                bRet = 243;
                break;
            }
            case '\u064f': {
                bRet = 245;
                break;
            }
            case '\u0650': {
                bRet = 246;
                break;
            }
            case '\u0651': {
                bRet = 248;
                break;
            }
            case '\u0652': {
                bRet = 250;
                break;
            }
            case '\u0679': {
                bRet = 138;
                break;
            }
            case '\u067e': {
                bRet = 129;
                break;
            }
            case '\u0686': {
                bRet = 141;
                break;
            }
            case '\u0688': {
                bRet = 143;
                break;
            }
            case '\u0691': {
                bRet = 154;
                break;
            }
            case '\u0698': {
                bRet = 142;
                break;
            }
            case '\u06a9': {
                bRet = 152;
                break;
            }
            case '\u06af': {
                bRet = 144;
                break;
            }
            case '\u06ba': {
                bRet = 159;
                break;
            }
            case '\u06be': {
                bRet = 170;
                break;
            }
            case '\u06c1': {
                bRet = 192;
                break;
            }
            case '\u200c': {
                bRet = 157;
                break;
            }
            case '\u200d': {
                bRet = 158;
                break;
            }
            case '\u200e': {
                bRet = 253;
                break;
            }
            case '\u200f': {
                bRet = 254;
                break;
            }
            case '\u2013': {
                bRet = 150;
                break;
            }
            case '\u2014': {
                bRet = 151;
                break;
            }
            case '\u2018': {
                bRet = 145;
                break;
            }
            case '\u2019': {
                bRet = 146;
                break;
            }
            case '\u201a': {
                bRet = 130;
                break;
            }
            case '\u201c': {
                bRet = 147;
                break;
            }
            case '\u201d': {
                bRet = 148;
                break;
            }
            case '\u201e': {
                bRet = 132;
                break;
            }
            case '\u2020': {
                bRet = 134;
                break;
            }
            case '\u2021': {
                bRet = 135;
                break;
            }
            case '\u2022': {
                bRet = 149;
                break;
            }
            case '\u2026': {
                bRet = 133;
                break;
            }
            case '\u2030': {
                bRet = 137;
                break;
            }
            case '\u2039': {
                bRet = 139;
                break;
            }
            case '\u203a': {
                bRet = 155;
                break;
            }
            case '\u20ac': {
                bRet = 128;
                break;
            }
            case '\u2122': {
                bRet = 153;
                break;
            }
            default: {
                bRet = 63;
            }
        }
        return (byte)bRet;
    }

    public static int unicode_to_cp1256(String us, byte[] s) {
        int length = us.length();
        for (int i = 0; i < length; ++i) {
            s[i] = ArabicUtils.unicode_to_cp1256(us.charAt(i));
        }
        s[i] = 0;
        return length;
    }

    public static String ArabicString(String strIn) {
        if (strIn == null) {
            return null;
        }
        String strOut = new String(strIn);
        strOut = ArabicUtils.ArabicString_RemoveDiacs(strOut);
        strOut = ArabicUtils.ArabicString_Shape(strOut);
        if (ArabicUtils.IsArabicStringNoShape(strOut = ArabicUtils.ArabicString_ShapeDiacs(strOut, strIn))) {
            strOut = ArabicUtils.ArabicString_Reversal(strOut);
        }
        return strOut;
    }

    public static int stringWidth(String s, Font fe) {
        if (s == null) {
            return 0;
        }
        int count = 2;
        boolean iXStart = false;
        boolean iXTranslate = false;
        String str = ArabicUtils.ArabicString(s);
        boolean iIsHasArabic = false;
        int iStrWidth = 0;
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i) & 0xFFFF;
            int c0 = c - 65136;
            if (c >= 65136 && c < 65279) {
                iStrWidth += 8;
                iIsHasArabic = true;
                continue;
            }
            String strC = "" + (char)c;
            iStrWidth += fe.charWidth((char)c);
        }
        return iStrWidth;
    }

    public static String reverseString(String strIn) {
        char[] inChars = strIn.toCharArray();
        char[] outChars = new char[inChars.length];
        for (int i = 0; i < outChars.length; ++i) {
            outChars[i] = inChars[inChars.length - 1 - i];
        }
        return new String(outChars);
    }

    public static String ArabicStringNoReversal(String strIn) {
        if (strIn == null) {
            return null;
        }
        String strOut = strIn;
        strOut = ArabicUtils.ArabicString_RemoveDiacs(strOut);
        strOut = ArabicUtils.ArabicString_Shape(strOut);
        strOut = ArabicUtils.ArabicString_ShapeDiacs(strOut, strIn);
        return strOut;
    }

    public static String StringReversal(String strIn) {
        if (strIn == null) {
            return null;
        }
        String strOut = strIn;
        strOut = ArabicUtils.ArabicString_Reversal(strOut);
        return strOut;
    }

    private static String ArabicString_Reversal(String strIn) {
        char c;
        int i;
        if (strIn == null) {
            return null;
        }
        String strOut = "";
        String strOutPart = "";
        String strNum = "";
        String strEngChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String strCtxChars = "()[]{}\\\"<>`~!@#$%^&*-_+=|/?';:., \t\n\r";
        int iCtxDirRTL = -1;
        boolean bIsNum = false;
        boolean bIsEng = false;
        int iLastInsertPos = 0;
        for (i = 0; i < strIn.length(); ++i) {
            c = strIn.charAt(i);
            if (strCtxChars.indexOf(c) != -1 || c >= '0' && c <= '9') continue;
            if (strEngChars.indexOf(c) != -1) {
                iCtxDirRTL = 0;
                break;
            }
            iCtxDirRTL = 1;
            break;
        }
        if (iCtxDirRTL == -1) {
            return strIn;
        }
        for (i = 0; i < strIn.length(); ++i) {
            c = strIn.charAt(i);
            if (c >= '0' && c <= '9') {
                if (strOutPart.compareTo("") != 0) {
                    strOut = iCtxDirRTL == 1 ? strOutPart + strOut : strOut + strOutPart;
                    strOutPart = "";
                }
                bIsNum = true;
                strNum = strNum + c;
                continue;
            }
            if (bIsNum) {
                strOutPart = strNum;
                strOut = iCtxDirRTL == 1 ? strOutPart + strOut : strOut + strOutPart;
                strNum = "";
                strOutPart = "";
                bIsNum = false;
            }
            if (strEngChars.indexOf(c) != -1 || iCtxDirRTL == 0 && strCtxChars.indexOf(c) != -1) {
                if (!bIsEng) {
                    bIsEng = true;
                    if (iCtxDirRTL == 1) {
                        strOut = strOut.substring(0, iLastInsertPos) + strOutPart + strOut.substring(iLastInsertPos);
                    } else {
                        strOut = strOut + strOutPart;
                        iLastInsertPos = strOut.length();
                    }
                    strOutPart = "";
                    strOutPart = strOutPart + c;
                    iCtxDirRTL = 0;
                    continue;
                }
                strOutPart = strOutPart + c;
                continue;
            }
            if (bIsEng) {
                if (iCtxDirRTL == 1) {
                    strOut = strOut.substring(0, iLastInsertPos) + strOutPart + strOut.substring(iLastInsertPos);
                } else {
                    strOut = strOut + strOutPart;
                    iLastInsertPos = strOut.length();
                }
                strOutPart = "";
                bIsEng = false;
            }
            strOutPart = "" + c + strOutPart;
            iCtxDirRTL = 1;
        }
        if (bIsNum) {
            strOutPart = strNum;
            strOut = iCtxDirRTL == 1 ? strOutPart + strOut : strOut + strOutPart;
            strNum = "";
            strOutPart = "";
            bIsNum = false;
        }
        if (strOutPart.compareTo("") != 0) {
            if (iCtxDirRTL == 1) {
                strOut = strOut.substring(0, iLastInsertPos) + strOutPart + strOut.substring(iLastInsertPos);
            } else {
                strOut = strOut + strOutPart;
                iLastInsertPos = strOut.length();
            }
            strOutPart = "";
        }
        return strOut;
    }

    private static String ArabicString_Shape(String strIn) {
        String strOut = "";
        Shapper shp = s_ShapperObj;
        strOut = shp.ShapeString(strIn);
        return strOut;
    }

    private static String ArabicString_RemoveDiacs(String strIn) {
        String strOut = "";
        Shapper shp = s_ShapperObj;
        for (int i = 0; i < strIn.length(); ++i) {
            char c = strIn.charAt(i);
            if (shp.is_Diac(c)) continue;
            strOut = strOut + c;
        }
        return strOut;
    }

    private static String ArabicString_AddDiacs(String strIn, String strWDiacs) {
        String strOut = "";
        Shapper shp = s_ShapperObj;
        int j = 0;
        for (int i = 0; i < strWDiacs.length(); ++i) {
            char c = strWDiacs.charAt(i);
            if (!shp.is_Diac(c)) {
                c = strIn.charAt(j);
                ++j;
                strOut = strOut + c;
                continue;
            }
            strOut = strOut + c;
        }
        return strOut;
    }

    private static String ArabicString_ShapeDiacs(String strIn, String OrgnStr) {
        String strOut = "";
        Shapper shp = s_ShapperObj;
        strOut = shp.ShapeStringDiacs(strIn, OrgnStr);
        return strOut;
    }

    public static void drawStringControl(Graphics g, String s, int x, int y, int anchor) {
        ArabicUtils.drawString(g, g_ControlsArabicFont, s, x, y, anchor);
    }

    public static void drawString(Graphics g, CustomBmpFont f, String s, int x, int y, int anchor) {
        String strC;
        int c0;
        int c;
        int i;
        if (g == null || s == null) {
            return;
        }
        if (f == null || f.m_imgFont == null || f.m_intFontWidths == null) {
            if ((anchor & 2) == 2) {
                anchor &= 0xFFFFFFFD;
                anchor |= 0x40;
            }
            g.drawString(s, x, y, anchor);
            return;
        }
        Font fe = g.getFont();
        int iFontHeight = f.m_iFontHeight;
        int iMaxGlyphWidth = f.m_iMaxGlyphWidth;
        int iXStart = 0;
        int iXTranslate = 0;
        String str = s;
        int iOldC = g.getColor();
        if (ArabicUtils.IsArabicString(str)) {
            str = ArabicUtils.ArabicString(s);
            g.setColor(0);
        }
        int ye = y;
        if ((anchor & 0x20) == 32) {
            y -= iFontHeight;
            ye -= fe.getHeight();
        }
        if ((anchor & 2) == 2) {
            y -= iFontHeight / 2;
            ye -= fe.getHeight() / 2;
        }
        if ((anchor & 4) == 4) {
            for (i = 0; i < str.length(); ++i) {
                c = str.charAt(i) & 0xFFFF;
                c0 = c - 65136;
                if (c >= 65136 && c < 65279) {
                    g.drawRegion(f.m_imgFont, c0 * iMaxGlyphWidth, 0, f.m_intFontWidths[c0], iFontHeight, 0, x + iXStart + iXTranslate, y, 20);
                    iXTranslate += f.m_intFontWidths[c0];
                    continue;
                }
                strC = "" + (char)c;
                g.drawString(strC, x + iXStart + iXTranslate, ye, 20);
                iXTranslate += fe.charWidth((char)c);
            }
        }
        if ((anchor & 8) == 8) {
            for (i = str.length() - 1; i >= 0; --i) {
                c = str.charAt(i) & 0xFFFF;
                c0 = c - 65136;
                if (c >= 65136 && c < 65279) {
                    g.drawRegion(f.m_imgFont, c0 * iMaxGlyphWidth, 0, f.m_intFontWidths[c0], iFontHeight, 0, x + iXStart + iXTranslate, y, 24);
                    iXTranslate -= f.m_intFontWidths[c0];
                    continue;
                }
                strC = "" + (char)c;
                g.drawString(strC, x + iXStart + iXTranslate, ye, 24);
                iXTranslate -= fe.charWidth((char)c);
            }
        }
        if ((anchor & 1) == 1) {
            boolean iIsHasArabic = false;
            int iStrWidth = 0;
            for (i = 0; i < str.length(); ++i) {
                c = str.charAt(i) & 0xFFFF;
                c0 = c - 65136;
                if (c >= 65136 && c < 65279) {
                    iStrWidth += f.m_intFontWidths[c0];
                    iIsHasArabic = true;
                    continue;
                }
                strC = "" + (char)c;
                iStrWidth += fe.charWidth((char)c);
            }
            x -= iStrWidth / 2;
            for (i = 0; i < str.length(); ++i) {
                c = str.charAt(i) & 0xFFFF;
                c0 = c - 65136;
                if (c >= 65136 && c < 65279) {
                    g.drawRegion(f.m_imgFont, c0 * iMaxGlyphWidth, 0, f.m_intFontWidths[c0], iFontHeight, 0, x + iXStart + iXTranslate, y, 20);
                    iXTranslate += f.m_intFontWidths[c0];
                    continue;
                }
                strC = "" + (char)c;
                g.drawString(strC, x + iXStart + iXTranslate, ye, 20);
                iXTranslate += fe.charWidth((char)c);
            }
        }
        g.setColor(iOldC);
    }

    public static int stringWidth(Graphics g, CustomBmpFont f, String s) {
        if (g == null || s == null) {
            return 0;
        }
        Font fe = g.getFont();
        if (f == null || f.m_imgFont == null || f.m_intFontWidths == null) {
            return fe.stringWidth(s);
        }
        int iFontHeight = f.m_iFontHeight;
        int iMaxGlyphWidth = f.m_iMaxGlyphWidth;
        boolean iXStart = false;
        boolean iXTranslate = false;
        String str = ArabicUtils.ArabicString(s);
        boolean iIsHasArabic = false;
        int iStrWidth = 0;
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i) & 0xFFFF;
            int c0 = c - 65136;
            if (c >= 65136 && c < 65279) {
                iStrWidth += f.m_intFontWidths[c0];
                iIsHasArabic = true;
                continue;
            }
            String strC = "" + (char)c;
            iStrWidth += fe.charWidth((char)c);
        }
        return iStrWidth;
    }

    public static void drawStringControlNoShape(Graphics g, String s, int x, int y, int anchor) {
        ArabicUtils.drawStringNoShape(g, g_ControlsArabicFont, s, x, y, anchor);
    }

    public static void drawStringNoShape(Graphics g, CustomBmpFont f, String s, int x, int y, int anchor) {
        String strC;
        int c0;
        int c;
        int i;
        if (g == null || s == null) {
            return;
        }
        if (f == null || f.m_imgFont == null || f.m_intFontWidths == null) {
            if ((anchor & 2) == 2) {
                anchor &= 0xFFFFFFFD;
                anchor |= 0x40;
            }
            g.drawString(s, x, y, anchor);
            return;
        }
        Font fe = g.getFont();
        int iFontHeight = f.m_iFontHeight;
        int iMaxGlyphWidth = f.m_iMaxGlyphWidth;
        int iXStart = 0;
        int iXTranslate = 0;
        String str = s;
        int iOldC = g.getColor();
        if (ArabicUtils.IsArabicStringNoShape(str)) {
            g.setColor(0);
        }
        int ye = y;
        if ((anchor & 0x20) == 32) {
            y -= iFontHeight;
            ye -= fe.getHeight();
        }
        if ((anchor & 2) == 2) {
            y -= iFontHeight / 2;
            ye -= fe.getHeight() / 2;
        }
        if ((anchor & 4) == 4) {
            for (i = 0; i < str.length(); ++i) {
                c = str.charAt(i) & 0xFFFF;
                c0 = c - 65136;
                if (c >= 65136 && c < 65279) {
                    g.drawRegion(f.m_imgFont, c0 * iMaxGlyphWidth, 0, f.m_intFontWidths[c0], iFontHeight, 0, x + iXStart + iXTranslate, y, 20);
                    iXTranslate += f.m_intFontWidths[c0];
                    continue;
                }
                strC = "" + (char)c;
                g.drawString(strC, x + iXStart + iXTranslate, ye, 20);
                iXTranslate += fe.charWidth((char)c);
            }
        }
        if ((anchor & 8) == 8) {
            for (i = str.length() - 1; i >= 0; --i) {
                c = str.charAt(i) & 0xFFFF;
                c0 = c - 65136;
                if (c >= 65136 && c < 65279) {
                    g.drawRegion(f.m_imgFont, c0 * iMaxGlyphWidth, 0, f.m_intFontWidths[c0], iFontHeight, 0, x + iXStart + iXTranslate, y, 24);
                    iXTranslate -= f.m_intFontWidths[c0];
                    continue;
                }
                strC = "" + (char)c;
                g.drawString(strC, x + iXStart + iXTranslate, ye, 24);
                iXTranslate -= fe.charWidth((char)c);
            }
        }
        if ((anchor & 1) == 1) {
            boolean iIsHasArabic = false;
            int iStrWidth = 0;
            for (i = 0; i < str.length(); ++i) {
                c = str.charAt(i) & 0xFFFF;
                c0 = c - 65136;
                if (c >= 65136 && c < 65279) {
                    iStrWidth += f.m_intFontWidths[c0];
                    iIsHasArabic = true;
                    continue;
                }
                strC = "" + (char)c;
                iStrWidth += fe.charWidth((char)c);
            }
            x -= iStrWidth / 2;
            for (i = 0; i < str.length(); ++i) {
                c = str.charAt(i) & 0xFFFF;
                c0 = c - 65136;
                if (c >= 65136 && c < 65279) {
                    g.drawRegion(f.m_imgFont, c0 * iMaxGlyphWidth, 0, f.m_intFontWidths[c0], iFontHeight, 0, x + iXStart + iXTranslate, y, 20);
                    iXTranslate += f.m_intFontWidths[c0];
                    continue;
                }
                strC = "" + (char)c;
                g.drawString(strC, x + iXStart + iXTranslate, ye, 20);
                iXTranslate += fe.charWidth((char)c);
            }
        }
        g.setColor(iOldC);
    }

    public static int stringWidthNoShape(Graphics g, CustomBmpFont f, String s) {
        if (g == null || s == null) {
            return 0;
        }
        Font fe = g.getFont();
        if (f == null || f.m_imgFont == null || f.m_intFontWidths == null) {
            return fe.stringWidth(s);
        }
        int iFontHeight = f.m_iFontHeight;
        int iMaxGlyphWidth = f.m_iMaxGlyphWidth;
        boolean iXStart = false;
        boolean iXTranslate = false;
        String str = s;
        boolean iIsHasArabic = false;
        int iStrWidth = 0;
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i) & 0xFFFF;
            int c0 = c - 65136;
            if (c >= 65136 && c < 65279) {
                iStrWidth += f.m_intFontWidths[c0];
                iIsHasArabic = true;
                continue;
            }
            String strC = "" + (char)c;
            iStrWidth += fe.charWidth((char)c);
        }
        return iStrWidth;
    }

    public static boolean IsArabicStringNoShape(String s) {
        if (s == null) {
            return false;
        }
        boolean iIsHasArabic = false;
        String str = s;
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i) & 0xFFFF;
            if (c < 65136 || c >= 65279) continue;
            iIsHasArabic = true;
        }
        return iIsHasArabic;
    }

    public static boolean IsArabicString(String s) {
        if (s == null) {
            return false;
        }
        boolean iIsHasArabic = false;
        String str = ArabicUtils.ArabicString(s);
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i) & 0xFFFF;
            if (c < 65136 || c >= 65279) continue;
            iIsHasArabic = true;
        }
        return iIsHasArabic;
    }

    public static void SetControlsArabicFont(CustomBmpFont ControlsArabicFont) {
        g_ControlsArabicFont = ControlsArabicFont;
    }

    public static CustomBmpFont GetControlsArabicFont() {
        return g_ControlsArabicFont;
    }

    static {
        g_ControlsArabicFont = null;
    }

    public static class CustomBmpFont {
        Image m_imgFont = null;
        int[] m_intFontWidths = null;
        int m_iFontHeight;
        int m_iMaxGlyphWidth;

        private CustomBmpFont() {
        }

        public int GetFontHeight() {
            return this.m_iFontHeight;
        }

        public static CustomBmpFont LoadFont(String string) throws IOException {
            CustomBmpFont NewFont = new CustomBmpFont();
            NewFont.m_imgFont = Image.createImage((String)("/MobmeControls/" + string + ".png"));
            DataInputStream ds = new DataInputStream(NewFont.m_imgFont.getClass().getResourceAsStream("/MobmeControls/" + string + ".jfw"));
            int iNoAraGlyphs = ds.readInt();
            NewFont.m_intFontWidths = new int[iNoAraGlyphs];
            for (int i = 0; i < iNoAraGlyphs; ++i) {
                NewFont.m_intFontWidths[i] = ds.readInt();
            }
            ds.close();
            ds = null;
            NewFont.m_iFontHeight = NewFont.m_imgFont.getHeight();
            NewFont.m_iMaxGlyphWidth = NewFont.m_imgFont.getWidth() / NewFont.m_intFontWidths.length;
            return NewFont;
        }

        int getHeight() {
            return this.m_iFontHeight;
        }

        int stringWidth(Graphics g, String s) {
            if (g == null || s == null) {
                return 0;
            }
            Font fe = null;
            fe = g != null ? g.getFont() : Font.getDefaultFont();
            if (this.m_imgFont == null || this.m_intFontWidths == null) {
                return fe.stringWidth(s);
            }
            int iFontHeight = this.m_iFontHeight;
            int iMaxGlyphWidth = this.m_iMaxGlyphWidth;
            boolean iXStart = false;
            boolean iXTranslate = false;
            String str = ArabicUtils.ArabicString(s);
            boolean iIsHasArabic = false;
            int iStrWidth = 0;
            for (int i = 0; i < str.length(); ++i) {
                int c = str.charAt(i) & 0xFFFF;
                int c0 = c - 65136;
                if (c >= 65136 && c < 65279) {
                    iStrWidth += this.m_intFontWidths[c0];
                    iIsHasArabic = true;
                    continue;
                }
                String strC = "" + (char)c;
                iStrWidth += fe.charWidth((char)c);
            }
            return iStrWidth;
        }

        int stringWidthNoShape(Graphics g, String s) {
            if (g == null || s == null) {
                return 0;
            }
            Font fe = null;
            if (g != null) {
                g.getFont();
            } else {
                fe = Font.getDefaultFont();
            }
            if (this.m_imgFont == null || this.m_intFontWidths == null) {
                return fe.stringWidth(s);
            }
            int iFontHeight = this.m_iFontHeight;
            int iMaxGlyphWidth = this.m_iMaxGlyphWidth;
            boolean iXStart = false;
            boolean iXTranslate = false;
            String str = s;
            boolean iIsHasArabic = false;
            int iStrWidth = 0;
            for (int i = 0; i < str.length(); ++i) {
                int c = str.charAt(i) & 0xFFFF;
                int c0 = c - 65136;
                if (c >= 65136 && c < 65279) {
                    iStrWidth += this.m_intFontWidths[c0];
                    iIsHasArabic = true;
                    continue;
                }
                String strC = "" + (char)c;
                iStrWidth += fe.charWidth((char)c);
            }
            return iStrWidth;
        }
    }
}

