/*
 * Decompiled with CFR 0.152.
 */
package GPackage;

import ImanPKG.ArabicUtils;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class LineEnumeration
implements Enumeration {
    private Font font;
    private String text;
    public static boolean WITH_DIAC = true;
    public static boolean WITHOUT_DIAC = false;
    private boolean DiacStatus;
    private int width;
    private int position;
    private int length;
    private int start = 0;

    public LineEnumeration(Font font, String text, int width) {
        this.font = font;
        this.text = text;
        this.width = width;
        if (text != null) {
            this.length = text.length();
        }
    }

    public boolean hasMoreElements() {
        return this.position < this.length - 1;
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            int next = this.next();
            String s = this.text.substring(this.start, next);
            this.start = next;
            if (this.text.length() - 1 > this.start && (this.text.charAt(this.start) == ' ' || this.text.charAt(this.start) == '\n')) {
                ++this.position;
                ++this.start;
            }
            return s;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException(e.getMessage());
        }
        catch (Exception e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    private int next() {
        int i;
        int lastBreak = -1;
        int discarded = 0;
        for (i = this.position; i < this.length && this.font.stringWidth(this.text.substring(this.position, i)) <= this.width + discarded; ++i) {
            if (ArabicUtils.isDiacs(this.text.charAt(i))) {
                discarded = 0;
                continue;
            }
            if (this.text.charAt(i) == ' ') {
                lastBreak = i;
                continue;
            }
            if (this.text.charAt(i) != '\n') continue;
            lastBreak = i;
            break;
        }
        this.position = i == this.length ? i : (lastBreak == this.position ? ++this.position : (lastBreak < this.position ? i : lastBreak));
        return this.position;
    }

    public int writeTo(Graphics g, int startx, int starty, Font font) {
        int fontHeight = font.getHeight() + 1;
        while (this.hasMoreElements()) {
            g.drawString(String.valueOf(this.nextElement()), startx, starty, 20);
            starty += fontHeight;
        }
        return starty;
    }

    public void reset() {
        this.start = 0;
        this.position = 0;
    }
}

