/*
 * Decompiled with CFR 0.152.
 */
package CalendarPKG;

import CalendarPKG.CalCanvas;
import CalendarPKG.EventRegister;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pim.Event;
import javax.microedition.pim.PIMException;

public class AnniversaryForm
implements CommandListener {
    Form aForm;
    TextField subject;
    ChoiceGroup alarm;
    DateField alarmTime;
    DateField date;
    CalCanvas Parent;
    Command Done;
    Command Back;
    List alarmList;
    Event ev = null;
    Date d;
    boolean editEvent = false;
    int itemIndex = 2;
    private final int[] TIMES = new int[]{5, 10, 30, 60, 720};

    public AnniversaryForm(CalCanvas Owner) {
        this.Parent = Owner;
    }

    public void Create() {
        this.date = new DateField("Date", 3);
        this.date.setLayout(3);
        this.date.setDate(null);
        this.subject = new TextField("Subject", "", 30, 0);
        this.subject.setLayout(3);
        this.alarm = new ChoiceGroup("Set Alarm", 1, new String[]{"On", "Off"}, null);
        this.alarm.setLayout(3);
        this.alarmTime = new DateField("Alarm Time", 2);
        this.alarmTime.setLayout(3);
        this.alarmTime.setDate(null);
        this.alarmList = new List("Select Alarm Time", 3, new String[]{"5 Minutes Before", "10 Minutes Before", "30 Minutes Before ", "1 Hour Before", "12 Hours Before"}, null);
        this.aForm = new Form("Create Anniversary", new Item[]{this.subject, this.date, this.alarm});
        this.Done = new Command("Done", 4, 1);
        this.Back = new Command("Back", 7, 2);
        this.aForm.addCommand(this.Done);
        this.aForm.addCommand(this.Back);
        this.aForm.setCommandListener((CommandListener)this);
        this.alarmList.addCommand(this.Done);
        this.alarmList.addCommand(this.Back);
        this.alarmList.setCommandListener((CommandListener)this);
        if (CalCanvas.Arabic) {
            this.toggleLang(CalCanvas.Arabic);
        }
    }

    public void toggleLang(boolean Arabic) {
        this.aForm.removeCommand(this.Done);
        this.aForm.removeCommand(this.Back);
        this.alarmList.removeCommand(this.Done);
        this.alarmList.removeCommand(this.Back);
        if (Arabic) {
            this.date.setLabel("\u0627\u0644\u062a\u0627\u0631\u064a\u062e");
            this.subject.setLabel("\u0627\u0644\u0645\u0648\u0636\u0648\u0639");
            this.alarm.setLabel("\u0627\u0644\u062a\u0646\u0628\u064a\u0647");
            this.alarm.set(0, "\u062a\u0634\u063a\u064a\u0644", null);
            this.alarm.set(1, "\u0625\u064a\u0642\u0627\u0641 ", null);
            this.alarmTime.setLabel("\u0648\u0642\u062a \u0627\u0644\u062a\u0646\u0628\u064a\u0647");
            this.aForm.setTitle("\u0623\u0636\u0627\u0641\u0629 \u0630\u0643\u0631\u0649 \u0633\u0646\u0648\u064a\u0629");
            this.Done = new Command("\u062a\u0645", 4, 1);
            this.Back = new Command("\u0625\u0644\u063a\u0627\u0621", 7, 2);
            this.alarmList.set(0, "\u0642\u0628\u0644 5 \u062f\u0642\u0627\u0626\u0642", null);
            this.alarmList.set(1, "\u0642\u0628\u0644 10 \u062f\u0642\u0627\u0626\u0642", null);
            this.alarmList.set(2, "\u0642\u0628\u0644 30 \u062f\u0642\u064a\u0642\u0629", null);
            this.alarmList.set(3, "\u0642\u0628\u0644 \u0633\u0627\u0639\u0629", null);
            this.alarmList.set(4, "\u0642\u0628\u0644 12 \u0633\u0627\u0639\u0629", null);
            this.alarmList.setTitle("\u0648\u0642\u062a \u0627\u0644\u062a\u0646\u0628\u064a\u0647");
        } else {
            this.date.setLabel("Date");
            this.subject.setLabel("Subject");
            this.alarm.setLabel("Set Alarm");
            this.alarm.set(0, "On", null);
            this.alarm.set(1, "Off", null);
            this.alarmTime.setLabel("Alarm Time");
            this.aForm.setTitle("Create Anniversary");
            this.Done = new Command("Done", 4, 1);
            this.Back = new Command("Back", 7, 2);
            this.alarmList.set(0, "5 Minutes Before", null);
            this.alarmList.set(1, "10 Minutes Before", null);
            this.alarmList.set(2, "30 Minutes Before", null);
            this.alarmList.set(3, "1 Hour Before", null);
            this.alarmList.set(4, "12 Hours Before", null);
            this.alarmList.setTitle("Select Alarm Time");
        }
        this.alarmList.addCommand(this.Done);
        this.alarmList.addCommand(this.Back);
        this.alarmList.setCommandListener((CommandListener)this);
        this.aForm.addCommand(this.Done);
        this.aForm.addCommand(this.Back);
        this.aForm.setCommandListener((CommandListener)this);
    }

    public void Show(boolean edit) {
        this.editEvent = edit;
        if (CalCanvas.Arabic) {
            this.aForm.setTitle("\u0625\u0636\u0627\u0641\u0629 \u0630\u0643\u0631\u0649 \u0633\u0646\u0648\u064a\u0629");
        } else {
            this.aForm.setTitle("Create Anniversary");
        }
        this.editEvent = false;
        Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.aForm);
    }

    public void Show(boolean edit, Event e) {
        if (!CalCanvas.Arabic) {
            this.aForm.setTitle("Edit Anniversary");
        } else {
            this.aForm.setTitle("\u062a\u0639\u062f\u064a\u0644 \u0630\u0643\u0631\u0649 \u0633\u0646\u0648\u064a\u0629");
        }
        this.date.setDate(new Date(e.getDate(106, 0)));
        long l = this.date.getDate().getTime();
        Calendar.getInstance().getTimeZone();
        this.date.setDate(new Date(l + (long)TimeZone.getDefault().getRawOffset()));
        this.subject.setString(e.getString(107, 0));
        this.editEvent = edit;
        this.ev = e;
        try {
            int alarmTm = e.getInt(100, 0) * 1000;
            this.alarm.setSelectedIndex(0, true);
            this.alarmTime.setDate(new Date(alarmTm));
        }
        catch (Exception ex) {
            this.alarm.setSelectedIndex(1, true);
        }
        Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.aForm);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.aForm) {
            if (command.getPriority() == 1) {
                if (this.subject.getString().length() == 0) {
                    return;
                }
                Calendar cal = Calendar.getInstance();
                cal.set(5, this.Parent.curGregDay);
                cal.set(2, this.Parent.curGregMon);
                cal.set(1, this.Parent.curGregYear);
                cal.set(11, 12);
                cal.set(12, 0);
                if (this.date.getDate() == null) {
                    return;
                }
                cal.setTime(this.date.getDate());
                long l = cal.getTime().getTime();
                cal.getTimeZone();
                cal.setTime(new Date(l - (long)TimeZone.getDefault().getRawOffset()));
                this.d = cal.getTime();
                int alarmm = 0;
                if (this.alarm.getSelectedIndex() == 0) {
                    Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.alarmList);
                    return;
                }
                new Thread(new EventRegister(this.subject.getString(), this.d, new Date(this.d.getTime() + 60000L), alarmm, 1, this.alarm.getSelectedIndex() == 0, true, this.Parent)).start();
                if (this.editEvent) {
                    try {
                        this.Parent.eventList.events.removeEvent(this.ev);
                    }
                    catch (PIMException ex) {
                        ex.printStackTrace();
                    }
                }
                if (CalCanvas.CALLER == 1) {
                    CalCanvas.NeedFullRepaint = true;
                    Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.Parent);
                    this.Parent.repaint();
                } else {
                    Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.Parent.weeks);
                    this.Parent.weeks.repaint();
                }
                this.subject.setString("");
                this.alarm.setSelectedIndex(0, true);
                this.alarmTime.setDate(null);
            } else if (CalCanvas.CALLER == 1) {
                Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.Parent);
            } else {
                Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.Parent.weeks);
            }
        } else if (displayable == this.alarmList) {
            if (command.getPriority() == 1) {
                new Thread(new EventRegister(this.subject.getString(), this.d, new Date(this.d.getTime() + 60000L), this.TIMES[this.alarmList.getSelectedIndex()] * 60, 2, true, true, this.Parent)).start();
                if (this.editEvent) {
                    try {
                        this.Parent.eventList.events.removeEvent(this.ev);
                    }
                    catch (PIMException ex) {
                        ex.printStackTrace();
                    }
                }
                if (CalCanvas.CALLER == 1) {
                    CalCanvas.NeedFullRepaint = true;
                    Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.Parent);
                    this.Parent.repaint();
                } else {
                    Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.Parent.weeks);
                    this.Parent.weeks.repaint();
                }
            } else if (command.getPriority() == 2) {
                Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.aForm);
            } else if (command.getPriority() == 0) {
                this.commandAction(this.Done, (Displayable)this.alarmList);
            }
        }
    }
}

