/*
 * Decompiled with CFR 0.152.
 */
package CalendarPKG;

import CalendarPKG.CalCanvas;
import CalendarPKG.CalData;
import CalendarPKG.ConvertDate;
import CalendarPKG.SDATE;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class ConvertDateSingle
implements CommandListener {
    DateField date = new DateField("Input", 1);
    TextField day = new TextField("day", "", 2, 2);
    TextField month = new TextField("Month", "", 2, 2);
    TextField year = new TextField("year", "", 4, 2);
    StringItem result = new StringItem(" ", " ");
    Form form = new Form("Convert", new Item[]{this.day, this.month, this.year, this.result});
    Command exit;
    Command G2H;
    Command H2G;
    CalCanvas Owner;
    ConvertDate conversion;
    String res = "Result: ";

    public ConvertDateSingle(CalCanvas Parent) {
        this.Owner = Parent;
        this.result.setFont(Font.getFont((int)0, (int)0, (int)8));
        this.switchLang(CalCanvas.Arabic);
        this.Owner.dateConvert = new ConvertDate(this.Owner);
    }

    public void switchLang(boolean Arabic) {
        this.form.removeCommand(this.exit);
        this.form.removeCommand(this.G2H);
        this.form.removeCommand(this.H2G);
        this.result.setText("");
        if (Arabic) {
            this.result.setLayout(2);
            this.form.setTitle("\u062a\u062d\u0648\u064a\u0644 \u062a\u0627\u0631\u064a\u062e");
            this.day.setLabel("\u0627\u0644\u064a\u0648\u0645");
            this.month.setLabel("\u0627\u0644\u0634\u0647\u0631");
            this.year.setLabel("\u0627\u0644\u0633\u0646\u0647");
            this.res = " \u0627\u0644\u0646\u062a\u064a\u062c\u0629: ";
            this.exit = new Command("\u0631\u062c\u0648\u0639", 7, 1);
            this.G2H = new Command("\u0645\u064a\u0644\u0627\u062f\u064a \u0625\u0644\u064a \u0647\u062c\u0631\u064a", 4, 2);
            this.H2G = new Command("\u0647\u062c\u0631\u064a \u0625\u0644\u064a \u0645\u064a\u0644\u0627\u062f\u064a", 4, 3);
        } else {
            this.result.setLayout(1);
            this.form.setTitle("Convert Date");
            this.day.setLabel("Day");
            this.month.setLabel("Month");
            this.year.setLabel("Year");
            this.res = "Result:";
            this.exit = new Command("Back", 7, 1);
            this.G2H = new Command("Greg. To Hijri", 4, 2);
            this.H2G = new Command("Hijri To Greg.", 4, 3);
        }
        this.form.addCommand(this.exit);
        this.form.addCommand(this.G2H);
        this.form.addCommand(this.H2G);
        this.form.setCommandListener((CommandListener)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getPriority() == 1) {
            this.day.setString("");
            this.month.setString("");
            this.year.setString("");
            this.result.setText("");
            Display.getDisplay((MIDlet)this.Owner.OwnerMidlet).setCurrent((Displayable)this.Owner);
            return;
        }
        if (command.getPriority() == 2) {
            if (!this.isValidGregDate()) {
                if (CalCanvas.Arabic) {
                    this.result.setText("\u062a\u0627\u0631\u064a\u062e \u063a\u064a\u0631 \u0635\u062d\u064a\u062d");
                } else {
                    this.result.setText("Invalid Date");
                }
                return;
            }
            SDATE outDate = this.Owner.dateConvert.GregorianToHijriDate(this.getSDate(this.day.getString(), this.month.getString(), this.year.getString()), this.Owner.HijryAdjustVal != 0);
            if (outDate.year < 0) {
                if (CalCanvas.Arabic) {
                    this.result.setText("\u062a\u0627\u0631\u064a\u062e \u063a\u064a\u0631 \u0635\u062d\u064a\u062d");
                } else {
                    this.result.setText("Invalid Date");
                }
                return;
            }
            if (CalCanvas.Arabic) {
                this.result.setText(this.res + outDate.day + " " + CalData.arMonths[outDate.mon - 1] + " " + outDate.year);
            } else {
                this.result.setText(this.res + outDate.day + " " + CalData.arMonthsEn[outDate.mon - 1] + " " + outDate.year);
            }
        } else if (command.getPriority() == 3) {
            if (!this.isValidHijryDate()) {
                if (CalCanvas.Arabic) {
                    this.result.setText("\u062a\u0627\u0631\u064a\u062e \u063a\u064a\u0631 \u0635\u062d\u064a\u062d");
                } else {
                    this.result.setText("Invalid Date");
                }
                return;
            }
            SDATE outDate = this.Owner.dateConvert.HijriToGregorianDate(this.getSDate(this.day.getString(), this.month.getString(), this.year.getString()), false);
            if (outDate.year < 0) {
                return;
            }
            if (CalCanvas.Arabic) {
                this.result.setText(this.res + outDate.year + " " + CalData.grMonths[outDate.mon - 1] + " " + outDate.day);
            } else {
                this.result.setText(this.res + outDate.day + " " + CalData.grMonthsEn[outDate.mon - 1] + " " + outDate.year);
            }
        }
    }

    SDATE getSDate(String day, String mon, String year) {
        return new SDATE(Integer.parseInt(day), Integer.parseInt(mon), Integer.parseInt(year), 0, 0.0f);
    }

    boolean isValidGregDate() {
        Calendar c = Calendar.getInstance();
        try {
            c.set(5, Integer.parseInt(this.day.getString()));
            c.set(2, Integer.parseInt(this.month.getString()) - 1);
            c.set(1, Integer.parseInt(this.year.getString()));
            c.setTime(c.getTime());
        }
        catch (Exception ex) {
            return false;
        }
        return c.get(2) == Integer.parseInt(this.month.getString()) - 1;
    }

    boolean isValidHijryDate() {
        int Hday = Integer.parseInt(this.day.getString());
        int Hmonth = Integer.parseInt(this.month.getString());
        int Hyear = Integer.parseInt(this.year.getString());
        if (Hday < 1 || Hday > 30) {
            return false;
        }
        if (Hmonth < 1 || Hmonth > 12) {
            return false;
        }
        if (Hyear < 0) {
            return false;
        }
        if (Hday == 30) {
            SDATE date = this.Owner.dateConvert.HijriToGregorianDate(new SDATE(Hday - 1, Hmonth, Hyear, 0, 0.0f), false);
            Calendar c = Calendar.getInstance();
            c.set(5, date.day);
            c.set(2, date.mon - 1);
            c.set(1, date.year);
            c.setTime(new Date(c.getTime().getTime() + 86400000L));
            date = this.Owner.dateConvert.GregorianToHijriDate(new SDATE(c.get(5), c.get(2) + 1, c.get(1), 0, 0.0f), false);
            return date.day == 30;
        }
        return true;
    }
}

