/*
 * Decompiled with CFR 0.152.
 */
package MobmeControls;

import CalendarPKG.CalCanvas;
import CalendarPKG.HolidayCanvas;
import MobmeControls.ArabicUtils;
import MobmeControls.CustomComponent;
import MobmeControls.IMobeListListener;
import MobmeControls.MobmeChoiceLoader;
import MobmeControls.MobmeForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MobmeListCtrl
extends CustomComponent
implements CommandListener {
    String m_strTitle = "";
    String m_strEdit = "";
    Displayable m_Parent = null;
    CalCanvas canvas = null;
    Display m_Display = null;
    boolean m_bIsArabic = false;
    Font m_F;
    int m_iPos;
    String[] m_arrHistory;
    long m_iLastWriteTime = -1L;
    boolean m_bIsDrawBackRect = false;
    boolean m_bIsHasCopy = false;
    boolean m_bNeedToScrollRight = false;
    boolean m_bNeedToScrollLeft = false;
    boolean m_IWasScrolling = false;
    boolean m_INeedScrolling = false;
    int m_iListWidth = 0;
    String[] m_arrShappedData = null;
    TextHScroller TextHScrollerObj;
    Alert report;
    int iWidth;
    int iHeight;
    int m_iFocusID = 0;
    int m_ListLen = 0;
    int m_StartIndex = 0;
    int m_BGColor = 0xFFFFFF;
    int m_HLColor = 49151;
    boolean m_DrawBullet = false;
    boolean m_DrawScroll = false;
    boolean m_ScrollDirection = false;
    String[] m_strArrayCpy = null;
    String strItemOfLargeWidth = "";
    int iWidthOfLargeItem = 0;
    int m_iXScrollStep = 5;
    int m_ElementsPerListNum = 0;
    int m_VScrollCounter = 0;
    int m_VSHeight = 0;
    int m_VSStep = 0;
    int m_ipad = 5;
    int m_iBulletWidth = 3;
    int m_iVScrollWidth = 10;
    int m_VSStepSize = 0;
    IMobeListListener m_IMobeListListener;
    int m_VSY_Up = 0;
    int m_VSY_DOWN = 0;
    int m_StartIndexBKP = 0;
    int m_VScrollSteps = 0;
    int m_VSAppoxmator = 0;
    int m_VSAppoxmatorCounter = 0;
    int m_VSMaxShare;
    int m_VSMaxShareBKP = this.m_VSMaxShare = 1;
    int m_VSMaxShareCounter = 1;
    int m_VSShareAppoxmator = 0;
    int m_VSShareAppoxmatorCounter = 0;
    Command keyCommand = new Command("", 4, 2);
    MobmeChoiceLoader m_ChoiceLoader = null;

    public MobmeListCtrl(String Title, Displayable parent, Display display, Font f, boolean bIsArabic, String[] arrHistory) {
        this.m_strTitle = Title;
        this.m_Parent = parent;
        this.canvas = (CalCanvas)parent;
        this.m_Display = display;
        this.m_bIsArabic = bIsArabic;
        this.m_F = f;
        this.m_arrHistory = arrHistory;
        this.m_iPos = -1;
        this.m_ListLen = arrHistory != null ? arrHistory.length : 0;
        this.m_iListWidth = this.m_Parent.getWidth() - 3;
        this.TextHScrollerObj = new TextHScroller(this);
        this.SetDimension(this.m_Parent.getWidth(), this.m_Parent.getHeight());
    }

    public void SetItemChangeListener(IMobeListListener MyListener) {
        this.m_IMobeListListener = MyListener;
    }

    public void setArabic(boolean isArabic) {
        this.m_bIsArabic = isArabic;
    }

    void DisplayAlert(String strMSG) {
        this.report = new Alert("Sorry", null, null, null);
        this.report.setTimeout(-2);
        this.report.setType(AlertType.ERROR);
        this.report.setString(strMSG);
        this.m_Display.setCurrent((Displayable)this.report);
    }

    public void SetDimension(int w, int h) {
        this.iWidth = w;
        this.iHeight = h;
    }

    protected int getMinContentWidth() {
        return this.m_Parent.getWidth();
    }

    protected int getMinContentHeight() {
        return this.iHeight;
    }

    protected int getPrefContentWidth(int i) {
        return this.m_Parent.getWidth();
    }

    protected int getPrefContentHeight(int i) {
        return this.iHeight;
    }

    protected void paint(Graphics graphics, int w, int h) {
        try {
            Font OldF = graphics.getFont();
            int oldC = graphics.getColor();
            boolean bIneedToScroll = false;
            graphics.setColor(this.m_BGColor);
            graphics.fillRect(0, 0, w - 3, h - 2);
            graphics.setColor(0);
            graphics.drawRect(0, 0, w - 3, h - 2);
            if (!this.m_bIsArabic) {
                int i;
                for (int i2 = 0; i2 < this.m_ListLen && this.m_DrawBullet; ++i2) {
                    int iStartWrite = i2 * (this.m_F.getHeight() + 3);
                    graphics.fillRect(this.m_ipad, (iStartWrite += (this.m_F.getHeight() + 3) / 2) - 1, this.m_iBulletWidth, this.m_iBulletWidth);
                    graphics.drawRect(this.m_ipad, iStartWrite - 1, this.m_iBulletWidth, this.m_iBulletWidth);
                }
                if (this.m_DrawScroll) {
                    this.DrawVScroll(graphics, w, h);
                }
                int iRightOffset = this.m_ipad;
                int iLeftOffset = this.m_ipad;
                if (this.m_DrawScroll) {
                    iRightOffset = iRightOffset + this.m_iVScrollWidth + this.m_ipad;
                }
                if (this.m_DrawBullet) {
                    iLeftOffset = iLeftOffset + this.m_iBulletWidth + this.m_ipad;
                }
                for (i = 0; i < this.m_ListLen; ++i) {
                    if (i != this.m_iFocusID) continue;
                    int iDist = this.m_F.getHeight() + 3;
                    graphics.setColor(this.m_HLColor);
                    if (this.m_DrawScroll) {
                        graphics.fillRect(1, i * iDist + 1, w - 4 - this.m_iVScrollWidth, iDist + 1);
                    } else {
                        graphics.fillRect(1, i * iDist + 1, w - 4, iDist + 1);
                    }
                    graphics.setColor(0);
                    break;
                }
                for (i = 0; i < this.m_ListLen; ++i) {
                    graphics.setClip(iLeftOffset, i * (this.m_F.getHeight() + 3), w - iLeftOffset - iRightOffset, this.m_F.getHeight() + 3);
                    graphics.setFont(null);
                    if (this.m_ChoiceLoader == null) {
                        graphics.drawString(this.m_arrHistory[this.m_StartIndex + i], iLeftOffset - this.m_iXScrollStep * this.TextHScrollerObj.m_HScrollCounter, i * (this.m_F.getHeight() + 3), 20);
                        continue;
                    }
                    graphics.drawString(this.m_ChoiceLoader.GetItemStrAt(this.m_StartIndex + i), iLeftOffset - this.m_iXScrollStep * this.TextHScrollerObj.m_HScrollCounter, i * (this.m_F.getHeight() + 3) + 4, 20);
                }
            } else {
                int i;
                int iRightOffset = 3 + this.m_ipad;
                int iLeftOffset = this.m_ipad;
                for (i = 0; i < this.m_ListLen && this.m_DrawBullet; ++i) {
                    int iStartWrite = i * (this.m_F.getHeight() + 3);
                    graphics.fillRect(w - iRightOffset - this.m_iBulletWidth, iStartWrite += (this.m_F.getHeight() + 3) / 2, this.m_iBulletWidth, this.m_iBulletWidth);
                    graphics.drawRect(w - iRightOffset - this.m_iBulletWidth, iStartWrite, this.m_iBulletWidth, this.m_iBulletWidth);
                }
                if (this.m_DrawScroll) {
                    this.DrawVScroll(graphics, w, h);
                }
                if (this.m_DrawScroll) {
                    iLeftOffset += this.m_iVScrollWidth + this.m_ipad;
                }
                if (this.m_DrawBullet) {
                    iRightOffset += this.m_iBulletWidth + this.m_ipad;
                }
                for (i = 0; i < this.m_ListLen; ++i) {
                    if (i != this.m_iFocusID) continue;
                    int iDist = this.m_F.getHeight() + 3;
                    graphics.setColor(this.m_HLColor);
                    if (this.m_DrawScroll) {
                        graphics.fillRect(2 + this.m_iVScrollWidth, i * iDist + 1, w - 5 - this.m_iVScrollWidth, iDist + 1);
                    } else {
                        graphics.fillRect(1, i * iDist + 1, w - 4, iDist + 1);
                    }
                    graphics.setColor(0);
                    break;
                }
                for (i = 0; i < this.m_ListLen; ++i) {
                    try {
                        bIneedToScroll = true;
                        graphics.setClip(iLeftOffset, i * (this.m_F.getHeight() + 3), w - iRightOffset - iLeftOffset, this.m_F.getHeight() + 3);
                        graphics.setFont(null);
                        if (this.m_ChoiceLoader == null) {
                            graphics.drawString(ArabicUtils.ArabicString(this.m_arrHistory[this.m_StartIndex + i]), w - iRightOffset + this.m_iXScrollStep * this.TextHScrollerObj.m_HScrollCounter, i * (this.m_F.getHeight() + 3) + 2, 24);
                            continue;
                        }
                        graphics.drawString(ArabicUtils.ArabicString(this.m_ChoiceLoader.GetItemStrAt(this.m_StartIndex + i)), w - iRightOffset + this.m_iXScrollStep * this.TextHScrollerObj.m_HScrollCounter, i * (this.m_F.getHeight() + 3) + 2, 24);
                        continue;
                    }
                    catch (Exception Err) {
                        String strErr = "Error in List Paint\t Lang:" + String.valueOf(this.m_bIsArabic) + Err.getMessage();
                        Err.printStackTrace();
                    }
                }
            }
            graphics.setColor(oldC);
            graphics.setFont(OldF);
            return;
        }
        catch (Exception Ex) {
            String strErr = "Error in List Paint\t" + String.valueOf(this.m_bIsArabic) + Ex.getMessage();
            Ex.printStackTrace();
            return;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getPriority() == 0) {
            CalCanvas.HighlightToday = true;
            this.m_Display.setCurrent(this.m_Parent);
        } else if (command.getPriority() == 1 || command.getPriority() == 2) {
            HolidayCanvas.HolidaysLoaded = false;
            CalCanvas.HighlightToday = true;
            CalCanvas.CountryIndex = this.GetSelectedIndex();
            this.canvas.setHolidays();
            this.m_Display.setCurrent(this.m_Parent);
        }
    }

    public void UpdateList(String[] strList, int iStart) {
        this.m_INeedScrolling = false;
        this.m_arrHistory = strList;
        this.m_StartIndex = iStart;
        this.m_StartIndexBKP = iStart;
        this.m_ListLen = strList != null ? strList.length : 0;
        this.m_bNeedToScrollRight = false;
        this.m_strArrayCpy = null;
        this.m_bIsHasCopy = false;
        this.m_IWasScrolling = false;
        this.strItemOfLargeWidth = "";
        this.TextHScrollerObj.m_HScrollCounter = 0;
        this.iWidthOfLargeItem = 0;
        this.FormatData();
        this.SetVScrollInfo();
        this.SetHScrollInfo();
        if (this.m_ContainerForm != null) {
            this.m_bIsNeedtorepaint = true;
            this.m_ContainerForm.repaint();
        }
    }

    void SetHScrollInfo() {
        this.m_INeedScrolling = false;
        this.TextHScrollerObj.m_IsRun = false;
        this.TextHScrollerObj = new TextHScroller(this);
        if (this.TextHScrollerObj != null) {
            int iRealWidth = this.m_iListWidth - this.m_ipad;
            if (this.m_DrawBullet) {
                iRealWidth = iRealWidth - this.m_iBulletWidth - this.m_ipad;
            }
            if (this.m_DrawScroll) {
                iRealWidth = iRealWidth - this.m_iVScrollWidth - this.m_ipad;
            }
            if (this.m_bIsArabic) {
                if (this.m_ChoiceLoader == null) {
                    for (int i = this.m_StartIndex; i < this.m_ListLen + this.m_StartIndex; ++i) {
                        if (this.m_F.stringWidth(this.m_arrShappedData[i]) > iRealWidth) {
                            this.m_INeedScrolling = true;
                        }
                        if (this.m_F.stringWidth(this.strItemOfLargeWidth) >= this.m_F.stringWidth(this.m_arrShappedData[i])) continue;
                        this.strItemOfLargeWidth = this.m_arrShappedData[i];
                    }
                } else {
                    for (int i = this.m_StartIndex; i < this.m_ListLen + this.m_StartIndex; ++i) {
                        String str = this.m_ChoiceLoader.GetItemStrAt(i);
                        if (this.m_F.stringWidth(str) > iRealWidth) {
                            this.m_INeedScrolling = true;
                        }
                        if (this.m_F.stringWidth(this.strItemOfLargeWidth) >= this.m_F.stringWidth(str)) continue;
                        this.strItemOfLargeWidth = str;
                    }
                }
            } else if (this.m_ChoiceLoader == null) {
                for (int i = this.m_StartIndex; i < this.m_ListLen + this.m_StartIndex; ++i) {
                    if (this.m_F.stringWidth(this.m_arrHistory[i]) > iRealWidth) {
                        this.m_INeedScrolling = true;
                    }
                    if (this.m_F.stringWidth(this.strItemOfLargeWidth) >= this.m_F.stringWidth(this.m_arrHistory[i])) continue;
                    this.strItemOfLargeWidth = this.m_arrHistory[i];
                }
            } else {
                for (int i = this.m_StartIndex; i < this.m_ListLen + this.m_StartIndex; ++i) {
                    String str = this.m_ChoiceLoader.GetItemStrAt(i);
                    if (this.m_F.stringWidth(str) > iRealWidth) {
                        this.m_INeedScrolling = true;
                    }
                    if (this.m_F.stringWidth(this.strItemOfLargeWidth) >= this.m_F.stringWidth(str)) continue;
                    this.strItemOfLargeWidth = str;
                }
            }
            if (this.strItemOfLargeWidth.length() > 0) {
                this.iWidthOfLargeItem = this.m_F.stringWidth(this.strItemOfLargeWidth);
                this.TextHScrollerObj.m_iMaxScrollCount = (this.iWidthOfLargeItem - iRealWidth) / this.m_iXScrollStep + 2;
                if (this.m_INeedScrolling) {
                    this.TextHScrollerObj.m_IsRun = true;
                    new Thread(this.TextHScrollerObj).start();
                } else {
                    this.TextHScrollerObj.m_IsRun = false;
                }
            }
        }
    }

    void SetVScrollInfo() {
        int nItems = this.m_arrHistory.length;
        if (this.m_ChoiceLoader != null) {
            nItems = this.m_ChoiceLoader.GetListCount();
        }
        if (this.iHeight > 0) {
            this.m_ElementsPerListNum = this.iHeight / (this.m_F.getHeight() + 3);
            if (this.m_ElementsPerListNum < this.m_ListLen) {
                this.m_ListLen = this.m_ElementsPerListNum;
            }
            if (this.m_ElementsPerListNum < nItems) {
                int m_dVSHeight;
                int iScrollBarHeight = this.iHeight - 4 - 20;
                this.m_DrawScroll = true;
                int StepsSizeInPixels = this.m_VScrollSteps = nItems - this.m_ListLen;
                int d1 = this.m_ElementsPerListNum;
                int d2 = nItems;
                this.m_VSHeight = m_dVSHeight = d1 * iScrollBarHeight / d2;
                this.m_VSStepSize = (iScrollBarHeight - this.m_VSHeight) * 1000 / this.m_VScrollSteps;
                this.m_VSAppoxmator = iScrollBarHeight - this.m_VSHeight - this.m_VSStepSize * (d2 - d1);
                int iVSStepSize = this.m_VSStepSize;
                if (iVSStepSize < 1000) {
                    this.m_VSHeight = 5;
                    this.m_VSStepSize = (iScrollBarHeight - this.m_VSHeight) * 1000 / this.m_VScrollSteps;
                }
            } else {
                this.m_ElementsPerListNum = nItems;
                this.m_DrawScroll = false;
                this.m_VSHeight = 0;
                this.m_VScrollCounter = 0;
            }
        }
    }

    void FormatData() {
        if (this.m_ChoiceLoader != null) {
            return;
        }
        int nItems = this.m_arrHistory.length;
        if (this.m_ChoiceLoader != null) {
            nItems = this.m_ChoiceLoader.GetListCount();
        }
        if (this.m_bIsArabic) {
            this.m_ElementsPerListNum = this.iHeight / (this.m_F.getHeight() + 3);
            this.m_arrShappedData = nItems <= this.m_ElementsPerListNum ? new String[this.m_ListLen] : new String[nItems];
            for (int i = 0; i < this.m_arrShappedData.length; ++i) {
                String strShapeString;
                String strMyData = this.m_arrHistory[i];
                if (strMyData.indexOf(")") != -1 || strMyData.indexOf("(") != -1) {
                    String strPart1 = strMyData = strMyData.replace('(', '*');
                    strMyData = strMyData.replace(')', '#');
                    strMyData = strMyData.replace('*', ')');
                    strMyData = strMyData.replace('#', '(');
                }
                this.m_arrShappedData[i] = strShapeString = ArabicUtils.ArabicString(strMyData);
            }
        }
    }

    public void SetFocusItem(int iID) {
        int nItems = this.m_arrHistory.length;
        if (this.m_ChoiceLoader != null) {
            nItems = this.m_ChoiceLoader.GetListCount();
        }
        if (iID >= 0 && iID < nItems) {
            this.m_iFocusID = iID;
            if (this.m_ContainerForm != null) {
                this.m_bIsNeedtorepaint = true;
                this.m_ContainerForm.repaint();
            } else {
                this.repaint();
            }
        }
        if (iID < 0) {
            this.m_iFocusID = iID;
        }
    }

    public void SetBGColor(int RBG) {
        this.m_BGColor = RBG;
    }

    public void SetHLColor(int RBG) {
        this.m_HLColor = RBG;
    }

    public void SetDrawBullets(boolean bDrawBullets) {
        this.m_DrawBullet = bDrawBullets;
    }

    public void SetScrollSymbol(boolean bScrollDirection) {
    }

    public void ResetScrollSymbol() {
    }

    void DrawVScroll(Graphics graphics, int w, int h) {
        int nItems = this.m_arrHistory.length;
        if (this.m_ChoiceLoader != null) {
            nItems = this.m_ChoiceLoader.GetListCount();
        }
        if (this.m_StartIndex == this.m_StartIndexBKP) {
            this.m_VScrollCounter = 0;
            this.m_VSStep = 0;
        }
        if (this.m_bIsArabic) {
            int ihScrollHeight = h - 3;
            graphics.setColor(0);
            graphics.drawRect(1, 0, this.m_iVScrollWidth, ihScrollHeight);
            graphics.setColor(0xDCDCDC);
            graphics.fillRect(1, 0, this.m_iVScrollWidth, ihScrollHeight);
            graphics.setColor(0);
            graphics.drawRect(1, 0, 10, 10);
            graphics.setColor(4734347);
            graphics.fillRect(1, 0, 10, 10);
            graphics.setColor(0);
            graphics.drawRect(1, ihScrollHeight - 10, 10, 10);
            graphics.setColor(4734347);
            graphics.fillRect(1, ihScrollHeight - 10, 10, 10);
            graphics.setColor(0xF0F8FF);
            graphics.drawLine(5, 3, 3, 7);
            graphics.drawLine(5, 3, 7, 7);
            graphics.drawLine(5, 2, 2, 7);
            graphics.drawLine(5, 2, 7, 7);
            graphics.drawLine(3, ihScrollHeight - 7, 5, ihScrollHeight - 2);
            graphics.drawLine(5, ihScrollHeight - 2, 7, ihScrollHeight - 7);
            graphics.drawLine(2, ihScrollHeight - 7, 5, ihScrollHeight - 2);
            graphics.drawLine(5, ihScrollHeight - 2, 7, ihScrollHeight - 7);
            graphics.setColor(0);
            if (this.m_VScrollCounter == nItems - this.m_ListLen || this.m_VScrollCounter == this.m_VScrollSteps) {
                graphics.drawRect(2, ihScrollHeight - 10 - this.m_VSHeight - 1, 8, this.m_VSHeight);
                graphics.setColor(131, 139, 139);
                graphics.fillRect(2, ihScrollHeight - 10 - this.m_VSHeight - 1, 8, this.m_VSHeight);
                this.m_VSY_Up = ihScrollHeight - 10 - this.m_VSHeight - 1;
                this.m_VSY_DOWN = ihScrollHeight - 10 - this.m_VSHeight - 1 + this.m_VSHeight;
                graphics.setColor(0);
                return;
            }
            int VSY = this.m_VScrollCounter * this.m_VSStepSize / 1000;
            graphics.drawRect(2, VSY + 11, 8, this.m_VSHeight);
            graphics.setColor(131, 139, 139);
            graphics.fillRect(2, VSY + 11, 8, this.m_VSHeight);
            this.m_VSY_Up = VSY + 11;
            this.m_VSY_DOWN = VSY + 11 + this.m_VSHeight;
            graphics.setColor(0);
        } else {
            int ihScrollHeight = h - 3;
            graphics.setColor(0);
            graphics.drawRect(w - 13, 0, this.m_iVScrollWidth, ihScrollHeight);
            graphics.setColor(0xDCDCDC);
            graphics.fillRect(w - 13, 0, this.m_iVScrollWidth, ihScrollHeight);
            graphics.setColor(0);
            graphics.drawRect(w - 13, 0, 10, 10);
            graphics.setColor(4734347);
            graphics.fillRect(w - 13, 0, 10, 10);
            graphics.setColor(0);
            graphics.drawRect(w - 13, ihScrollHeight - 10, 10, 10);
            graphics.setColor(4734347);
            graphics.fillRect(w - 13, ihScrollHeight - 10, 10, 10);
            graphics.setColor(0xF0F8FF);
            graphics.drawLine(w - 5 - 4, 3, w - 3 - 4, 7);
            graphics.drawLine(w - 5 - 4, 3, w - 7 - 4, 7);
            graphics.drawLine(w - 5 - 4, 2, w - 2 - 4, 7);
            graphics.drawLine(w - 5 - 4, 2, w - 7 - 4, 7);
            graphics.drawLine(w - 4 - 3, ihScrollHeight - 7, w - 4 - 5, ihScrollHeight - 2);
            graphics.drawLine(w - 4 - 5, ihScrollHeight - 2, w - 4 - 7, ihScrollHeight - 7);
            graphics.drawLine(w - 4 - 2, ihScrollHeight - 7, w - 4 - 5, ihScrollHeight - 2);
            graphics.drawLine(w - 4 - 5, ihScrollHeight - 2, w - 4 - 7, ihScrollHeight - 7);
            graphics.setColor(0);
            if (this.m_VScrollCounter == nItems - this.m_ListLen) {
                graphics.drawRect(w - 12, ihScrollHeight - 10 - this.m_VSHeight - 1, 8, this.m_VSHeight);
                graphics.setColor(131, 139, 139);
                graphics.fillRect(w - 12, ihScrollHeight - 10 - this.m_VSHeight - 1, 8, this.m_VSHeight);
                this.m_VSY_Up = ihScrollHeight - 10 - this.m_VSHeight - 1;
                this.m_VSY_DOWN = ihScrollHeight - 10 - this.m_VSHeight - 1 + this.m_VSHeight;
                graphics.setColor(0);
                return;
            }
            int VSY = this.m_VScrollCounter * this.m_VSStepSize / 1000;
            graphics.drawRect(w - 12, VSY + 11, 8, this.m_VSHeight);
            graphics.setColor(131, 139, 139);
            graphics.fillRect(w - 12, VSY + 11, 8, this.m_VSHeight);
            this.m_VSY_Up = VSY + 11;
            this.m_VSY_DOWN = VSY + 11 + this.m_VSHeight;
            graphics.setColor(0);
        }
    }

    public void DoHScrollRight() {
    }

    public void DoHScrollLeft() {
    }

    public boolean SetTraverser(int iDir) {
        return this.traverse(iDir, 0, 0, null);
    }

    public void SetKeyAction(MobmeForm ContainerForm) {
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        if (this.m_StartIndex == this.m_StartIndexBKP) {
            this.m_VScrollCounter = 0;
            this.m_VSAppoxmatorCounter = 0;
            this.m_VSStep = 0;
            this.SetHScrollInfo();
        }
        switch (dir) {
            case 6: {
                ++this.m_iFocusID;
                if (this.m_iFocusID >= this.m_ElementsPerListNum) {
                    ++this.m_StartIndex;
                    ++this.m_VSAppoxmatorCounter;
                    ++this.m_VScrollCounter;
                    ++this.m_VSStep;
                    this.m_VSMaxShareCounter = 1;
                }
                if (this.m_iFocusID == this.m_ElementsPerListNum) {
                    this.m_iFocusID = this.m_ElementsPerListNum - 1;
                }
                if (this.m_VSAppoxmatorCounter >= this.m_VSAppoxmator) {
                    this.m_VSAppoxmatorCounter = this.m_VSAppoxmator;
                }
                if (this.m_VScrollCounter > this.m_VScrollSteps) {
                    --this.m_StartIndex;
                    this.m_VScrollCounter = this.m_VScrollSteps;
                    this.m_VSStep = this.m_VScrollSteps;
                    this.m_VSMaxShareCounter = 1;
                    this.m_VSMaxShare = this.m_VSMaxShare;
                    this.m_VSMaxShare = this.m_VSMaxShareBKP;
                }
                this.SetHScrollInfo();
                if (this.m_IMobeListListener != null) {
                    this.m_IMobeListListener.OnChangeItem(this.m_iFocusID, this.m_bIsArabic);
                }
                if (this.m_ContainerForm != null) {
                    this.m_bIsNeedtorepaint = true;
                    this.m_ContainerForm.repaint();
                } else {
                    this.repaint();
                }
                return false;
            }
            case 1: {
                --this.m_iFocusID;
                if (this.m_iFocusID < 0) {
                    --this.m_StartIndex;
                    --this.m_VScrollCounter;
                    --this.m_VSAppoxmatorCounter;
                    --this.m_VSStep;
                    this.m_iFocusID = 0;
                    this.m_VSMaxShareCounter = 1;
                }
                if (this.m_VSAppoxmatorCounter <= 0) {
                    this.m_VSAppoxmatorCounter = 0;
                }
                if (this.m_iFocusID < 0) {
                    this.m_iFocusID = 0;
                }
                if (this.m_VSStep < 0) {
                    ++this.m_StartIndex;
                    this.m_VScrollCounter = 0;
                    this.m_VSStep = 0;
                    this.m_VSMaxShare = this.m_VSMaxShareBKP;
                }
                this.SetHScrollInfo();
                if (this.m_IMobeListListener != null) {
                    this.m_IMobeListListener.OnChangeItem(this.m_iFocusID, this.m_bIsArabic);
                }
                if (this.m_ContainerForm != null) {
                    this.m_bIsNeedtorepaint = true;
                    this.m_ContainerForm.repaint();
                } else {
                    this.repaint();
                }
                return false;
            }
        }
        return false;
    }

    public void ScrollList(int iDir) {
        this.traverse(iDir, 0, 0, null);
    }

    protected void traverseOut() {
        boolean TraverseOut = false;
    }

    protected void keyPressed(int keyCode) {
        int keyAction = this.getGameAction(keyCode);
        if (keyAction == 8) {
            this.commandAction(this.keyCommand, this.m_Parent);
        }
    }

    public void FocusIsGained() {
    }

    protected void pointerReleased(int x, int y) {
        int iXLcomp = 0;
        int iXRcomp = this.m_iListWidth;
        if (this.m_DrawScroll) {
            if (this.m_bIsArabic) {
                iXRcomp = this.m_iListWidth;
                iXLcomp = this.m_iVScrollWidth + 1;
            } else {
                iXLcomp = 0;
                iXRcomp -= this.m_iVScrollWidth;
            }
        }
        int iHeight = this.getMinContentHeight() - 3;
        if (x >= iXLcomp && x <= iXRcomp && y >= 0 && y <= iHeight) {
            int iAccHeight = this.m_F.getHeight();
            int iPreviousHeight = 0;
            int iItemIndex = 0;
            while (iAccHeight < iHeight) {
                if (y > iPreviousHeight && y < iAccHeight) {
                    if (this.m_IMobeListListener != null) {
                        this.m_IMobeListListener.OnChangeItem(iItemIndex, this.m_bIsArabic);
                    }
                    this.SetFocusItem(iItemIndex);
                    return;
                }
                iPreviousHeight = iAccHeight + 3;
                iAccHeight = iAccHeight + this.m_F.getHeight() + 3;
                ++iItemIndex;
            }
        } else if (this.m_DrawScroll) {
            if (this.m_bIsArabic) {
                if (x >= 0 && x <= iXLcomp && y >= this.m_VSY_DOWN && y <= this.getMinContentHeight()) {
                    if (this.m_IMobeListListener != null) {
                        this.m_IMobeListListener.OnVScroll(6, this.m_bIsArabic);
                    }
                    this.ApplyVScroll(6);
                    return;
                }
                if (x >= 0 && x <= iXLcomp && y <= this.m_VSY_Up && y >= 0) {
                    if (this.m_IMobeListListener != null) {
                        this.m_IMobeListListener.OnVScroll(1, this.m_bIsArabic);
                    }
                    this.ApplyVScroll(1);
                    return;
                }
            } else {
                if (x >= iXRcomp && x <= this.m_iListWidth && y >= this.m_VSY_DOWN && y <= this.getMinContentHeight()) {
                    if (this.m_IMobeListListener != null) {
                        this.m_IMobeListListener.OnVScroll(6, this.m_bIsArabic);
                    }
                    this.ApplyVScroll(6);
                    return;
                }
                if (x >= iXRcomp && x <= this.m_iListWidth && y > 0 && y <= this.m_VSY_Up) {
                    if (this.m_IMobeListListener != null) {
                        this.m_IMobeListListener.OnVScroll(1, this.m_bIsArabic);
                    }
                    this.ApplyVScroll(1);
                    return;
                }
            }
        }
    }

    protected void pointerPressed(int x, int y) {
    }

    void ApplyVScroll(int iDirection) {
        if (iDirection == 6) {
            ++this.m_VScrollCounter;
            ++this.m_VSAppoxmatorCounter;
            ++this.m_VSStep;
            ++this.m_StartIndex;
            if (this.m_VSAppoxmatorCounter >= this.m_VSAppoxmator) {
                this.m_VSAppoxmatorCounter = this.m_VSAppoxmator;
            }
            if (this.m_VScrollCounter > this.m_VScrollSteps) {
                --this.m_StartIndex;
                this.m_VScrollCounter = this.m_VScrollSteps;
                this.m_VSStep = this.m_VScrollSteps;
            }
            this.SetHScrollInfo();
            if (this.m_ContainerForm != null) {
                this.m_bIsNeedtorepaint = true;
                this.m_ContainerForm.repaint();
            } else {
                this.repaint();
            }
        } else if (iDirection == 1) {
            --this.m_VScrollCounter;
            --this.m_VSStep;
            --this.m_StartIndex;
            --this.m_VSAppoxmatorCounter;
            if (this.m_VSAppoxmatorCounter <= 0) {
                this.m_VSAppoxmatorCounter = 0;
            }
            if (this.m_VSStep < 0) {
                ++this.m_StartIndex;
                this.m_VScrollCounter = 0;
                this.m_VSStep = 0;
            }
            this.SetHScrollInfo();
            if (this.m_ContainerForm != null) {
                this.m_bIsNeedtorepaint = true;
                this.m_ContainerForm.repaint();
            } else {
                this.repaint();
            }
        }
    }

    public int GetSelectedIndex() {
        return this.m_StartIndex + this.m_iFocusID;
    }

    public void SetSelectedIndex(int iSelIndex) {
        int nItems = this.m_arrHistory.length;
        if (this.m_ChoiceLoader != null) {
            nItems = this.m_ChoiceLoader.GetListCount();
        }
        int iMidofList = this.m_ElementsPerListNum / 2;
        if (iSelIndex >= this.m_ElementsPerListNum) {
            if (iSelIndex + this.m_ElementsPerListNum <= nItems) {
                this.m_iFocusID = this.m_ElementsPerListNum - iMidofList;
                this.m_StartIndex = iSelIndex - this.m_ElementsPerListNum + iMidofList;
                this.m_VScrollCounter = iSelIndex - this.m_ElementsPerListNum + iMidofList;
                this.m_VSStep = iSelIndex - this.m_ElementsPerListNum + iMidofList;
                this.m_VSAppoxmatorCounter = iSelIndex - this.m_ElementsPerListNum + iMidofList;
                if (this.m_VSAppoxmatorCounter >= this.m_VSAppoxmator) {
                    this.m_VSAppoxmatorCounter = this.m_VSAppoxmator;
                }
                this.SetHScrollInfo();
            } else {
                this.m_iFocusID = this.m_ElementsPerListNum - (nItems - iSelIndex);
                this.m_StartIndex = nItems - this.m_ElementsPerListNum;
                this.m_VScrollCounter = this.m_VScrollSteps;
                this.m_VSStep = this.m_VScrollSteps;
                this.m_VSAppoxmatorCounter = this.m_VSAppoxmator;
                this.SetHScrollInfo();
            }
        } else if (iSelIndex < this.m_ElementsPerListNum) {
            this.m_iFocusID = iSelIndex;
            this.SetHScrollInfo();
        }
    }

    void UpdateList(MobmeChoiceLoader ChoiceLoader, int iStart) {
        this.m_INeedScrolling = false;
        this.m_ChoiceLoader = ChoiceLoader;
        this.m_StartIndex = iStart;
        this.m_StartIndexBKP = iStart;
        this.m_ListLen = this.m_ChoiceLoader != null ? this.m_ChoiceLoader.GetListCount() : 0;
        this.m_bNeedToScrollRight = false;
        this.m_strArrayCpy = null;
        this.m_bIsHasCopy = false;
        this.m_IWasScrolling = false;
        this.strItemOfLargeWidth = "";
        this.TextHScrollerObj.m_HScrollCounter = 0;
        this.iWidthOfLargeItem = 0;
        this.FormatData();
        this.SetVScrollInfo();
        this.SetHScrollInfo();
        if (this.m_ContainerForm != null) {
            this.m_bIsNeedtorepaint = true;
            this.m_ContainerForm.repaint();
        }
    }

    public static class TextHScroller
    implements Runnable {
        MobmeListCtrl m_Parent;
        int iStep = 0;
        public int m_HScrollCounter = 0;
        public boolean m_IsRun;
        int m_iMaxScrollCount;

        TextHScroller(MobmeListCtrl Parent) {
            this.m_Parent = Parent;
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            try {
                int iStepR = 0;
                boolean iStepL = false;
                boolean bSwicth = false;
                while (this.m_IsRun) {
                    if (iStepR < this.m_iMaxScrollCount) {
                        Thread.sleep(500L);
                        ++this.m_HScrollCounter;
                        ++iStepR;
                    } else {
                        if (iStepR == this.m_iMaxScrollCount) {
                            iStepR = 2 * this.m_iMaxScrollCount;
                        }
                        Thread.sleep(500L);
                        --this.m_HScrollCounter;
                        if (--iStepR == this.m_iMaxScrollCount) {
                            Thread.sleep(500L);
                            iStepR = 0;
                        }
                    }
                    if (this.m_Parent.m_ContainerForm != null) {
                        this.m_Parent.m_bIsNeedtorepaint = true;
                        this.m_Parent.m_ContainerForm.repaint();
                        continue;
                    }
                    this.m_Parent.repaint();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

