/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher.storage;

import com.beeweeb.globallauncher.model.Commons;
import com.beeweeb.globallauncher.model.InstantLauncherData;
import com.beeweeb.globallauncher.model.LauncherDataDocumentHandler;
import com.beeweeb.globallauncher.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Storage {
    private static final String MAIN_STORE_NAME = "ILlive";
    private static final String IMAGE_STORE_NAME = "ILimages";
    private static final String IMAGE_STORE_NAME2 = "ILimages2";
    private static final String SWITCH_STORE_NAME = "ILswitch";
    private static final String TIMER_STORE_NAME = "ILtimer";
    private static final String COUNT_STORE_NAME = "ILcount";
    private static final String STORE_NAME_VERSION = "ILversion";
    private static Object obj = new Object();
    private static InstantLauncherData _live;
    private static ImageURLFilter _filter;
    private static Storage _delegate;
    private static boolean useMain;
    private static boolean firstExecution;

    private Storage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveImage(String string, byte[] byArray) throws RecordStoreException, IOException {
        RecordStore recordStore = null;
        try {
            Log.log("RS open1");
            recordStore = RecordStore.openRecordStore((String)Storage.getMainRecordStore(), (boolean)true);
            Storage._filter.url = string;
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords((RecordFilter)_filter, null, false);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(byArray.length);
            ((OutputStream)dataOutputStream).write(byArray);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            if (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                recordStore.setRecord(n, byArray2, 0, byArray2.length);
            } else {
                recordStore.addRecord(byArray2, 0, byArray2.length);
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    Log.log("RS close1");
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadImage(String string) throws RecordStoreException, IOException {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)Storage.getMainRecordStore(), (boolean)true);
            Log.log("RS open2");
            Storage._filter.url = string;
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords((RecordFilter)_filter, null, false);
            if (recordEnumeration.hasNextElement()) {
                byte[] byArray = recordEnumeration.nextRecord();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                dataInputStream.readUTF();
                int n = dataInputStream.readInt();
                byte[] byArray2 = new byte[n];
                dataInputStream.readFully(byArray2);
                byte[] byArray3 = byArray2;
                return byArray3;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                    Log.log("RS close2");
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsImage(String string) throws RecordStoreException, IOException {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)Storage.getMainRecordStore(), (boolean)true);
            Log.log("RS open3");
            Storage._filter.url = string;
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords((RecordFilter)_filter, null, false);
            if (recordEnumeration.hasNextElement()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                    Log.log("RS close3");
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Image loadAndCreateImage(String string) {
        Image image = null;
        try {
            Log.log("Load and create");
            byte[] byArray = Storage.loadImage(string);
            image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        catch (Exception exception) {
            Log.log(exception);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteImage(String string) throws RecordStoreNotOpenException, RecordStoreException {
        RecordStore recordStore = null;
        try {
            if (string != null) {
                recordStore = RecordStore.openRecordStore((String)Storage.getMainRecordStore(), (boolean)true);
                Storage._filter.url = string;
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords((RecordFilter)_filter, null, false);
                if (recordEnumeration.hasNextElement()) {
                    int n = recordEnumeration.nextRecordId();
                    recordStore.deleteRecord(n);
                }
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static InstantLauncherData getStaticData() throws ParserConfigurationException, SAXException, IOException {
        Log.log("getStaticData():IN");
        InputStream inputStream = obj.getClass().getResourceAsStream("/config.xml");
        SAXParser sAXParser = Commons.getParser();
        LauncherDataDocumentHandler launcherDataDocumentHandler = new LauncherDataDocumentHandler();
        sAXParser.parse(inputStream, (DefaultHandler)launcherDataDocumentHandler);
        byte[] byArray = launcherDataDocumentHandler.getData().toXML().getBytes("utf-8");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SAXParser sAXParser2 = Commons.getParser();
        LauncherDataDocumentHandler launcherDataDocumentHandler2 = new LauncherDataDocumentHandler();
        sAXParser2.parse((InputStream)byteArrayInputStream, (DefaultHandler)launcherDataDocumentHandler2);
        Runtime.getRuntime().gc();
        Log.log("getStaticData():OUT");
        return launcherDataDocumentHandler.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstantLauncherData loadInstantLauncherData() throws RecordStoreException, ParserConfigurationException, SAXException, IOException {
        RecordStore recordStore = null;
        try {
            Object object;
            recordStore = RecordStore.openRecordStore((String)MAIN_STORE_NAME, (boolean)true);
            InstantLauncherData instantLauncherData = null;
            if (recordStore.getNumRecords() == 0) {
                instantLauncherData = Storage.getStaticData();
                firstExecution = true;
            } else {
                object = recordStore.getRecord(1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                SAXParser sAXParser = Commons.getParser();
                LauncherDataDocumentHandler launcherDataDocumentHandler = new LauncherDataDocumentHandler();
                sAXParser.parse((InputStream)byteArrayInputStream, (DefaultHandler)launcherDataDocumentHandler);
                instantLauncherData = launcherDataDocumentHandler.getData();
                Runtime.getRuntime().gc();
            }
            object = instantLauncherData;
            return object;
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveInstantLauncherData(InstantLauncherData instantLauncherData) throws RecordStoreException {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)MAIN_STORE_NAME, (boolean)true);
            byte[] byArray = null;
            try {
                byArray = instantLauncherData.toXML().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = instantLauncherData.toXML().getBytes();
            }
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTimers(long[] lArray) throws RecordStoreException, IOException {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)TIMER_STORE_NAME, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                dataOutputStream.writeLong(lArray[i]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] loadTimers() throws RecordStoreException, IOException {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)TIMER_STORE_NAME, (boolean)true);
            if (recordStore.getNumRecords() != 0) {
                byte[] byArray = recordStore.getRecord(1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                int n = dataInputStream.readInt();
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = dataInputStream.readLong();
                }
                long[] lArray2 = lArray;
                return lArray2;
            }
            long[] lArray = null;
            return lArray;
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCounters(int[] nArray) throws RecordStoreException, IOException {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)COUNT_STORE_NAME, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                dataOutputStream.writeInt(nArray[i]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] loadCounters() throws RecordStoreException, IOException {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)COUNT_STORE_NAME, (boolean)true);
            if (recordStore.getNumRecords() != 0) {
                byte[] byArray = recordStore.getRecord(1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                int n = dataInputStream.readInt();
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = dataInputStream.readInt();
                }
                int[] nArray2 = nArray;
                return nArray2;
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canStore(byte[] byArray) throws RecordStoreException {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)IMAGE_STORE_NAME, (boolean)true);
            if (recordStore.getSizeAvailable() > byArray.length) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Image getAndCreateLocalImage(String string) throws IOException {
        return Image.createImage((String)("/images/" + string));
    }

    public static byte[] copyFromJARToRMS(String string, String string2) {
        try {
            int n;
            InputStream inputStream = obj.getClass().getResourceAsStream("/images/" + string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, byArray.length);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            Storage.saveImage(string2, byArray2);
            return byArray2;
        }
        catch (Exception exception) {
            Log.log("Exception on: copyFromJARToRMS() " + string + " " + string2);
            Log.log(exception);
            return null;
        }
    }

    public static void clearImages() {
        try {
            RecordStore.deleteRecordStore((String)Storage.getMainRecordStore());
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public static void clearAll() {
        try {
            RecordStore.deleteRecordStore((String)MAIN_STORE_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecordStore.deleteRecordStore((String)IMAGE_STORE_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecordStore.deleteRecordStore((String)IMAGE_STORE_NAME2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecordStore.deleteRecordStore((String)COUNT_STORE_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecordStore.deleteRecordStore((String)TIMER_STORE_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecordStore.deleteRecordStore((String)SWITCH_STORE_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecordStore.deleteRecordStore((String)STORE_NAME_VERSION);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listImages() {
        Object[] objectArray = null;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)IMAGE_STORE_NAME, (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            Vector<String> vector = new Vector<String>();
            String string = null;
            ByteArrayInputStream byteArrayInputStream = null;
            DataInputStream dataInputStream = null;
            byte[] byArray = null;
            while (recordEnumeration.hasNextElement()) {
                byArray = recordEnumeration.nextRecord();
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                string = dataInputStream.readUTF();
                vector.addElement(string);
                byArray = null;
                byteArrayInputStream = null;
                dataInputStream = null;
                string = null;
            }
            if (vector.size() > 0) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
            }
        }
        catch (Exception exception) {
            Log.log(exception);
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                    recordStoreNotOpenException.printStackTrace();
                }
                catch (RecordStoreException recordStoreException) {
                    recordStoreException.printStackTrace();
                }
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveVersion(String string) throws RecordStoreException, IOException {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)STORE_NAME_VERSION, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(string);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadVersion() {
        RecordStore recordStore = null;
        String string = null;
        try {
            recordStore = RecordStore.openRecordStore((String)STORE_NAME_VERSION, (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                byte[] byArray = recordStore.getRecord(1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                string = dataInputStream.readUTF();
            }
        }
        catch (Exception exception) {
            Log.log(exception);
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                    recordStoreNotOpenException.printStackTrace();
                }
                catch (RecordStoreException recordStoreException) {
                    recordStoreException.printStackTrace();
                }
            }
        }
        return string;
    }

    public static byte[] loadLocalResource(String string) {
        byte[] byArray = null;
        Log.log("Loading: " + string);
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = obj.getClass().getResourceAsStream(string);
            byte[] byArray2 = new byte[1024];
            while ((n = inputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            Log.log("Error loading local resource");
            Log.log(exception);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void switchRecordStore() {
        Log.log("Switching record store " + firstExecution);
        if (!firstExecution) {
            useMain = !useMain;
            RecordStore recordStore = null;
            try {
                recordStore = RecordStore.openRecordStore((String)SWITCH_STORE_NAME, (boolean)true);
                byte[] byArray = new byte[]{(byte)(useMain ? 1 : 0)};
                if (recordStore.getNumRecords() == 0) {
                    recordStore.addRecord(byArray, 0, 1);
                } else {
                    recordStore.setRecord(1, byArray, 0, 1);
                }
                Storage.deleteSecondaryRecordStore();
            }
            catch (Throwable throwable) {
                Log.log(throwable);
            }
            finally {
                if (recordStore != null) {
                    try {
                        recordStore.closeRecordStore();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            firstExecution = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSwitchRecordStore() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)SWITCH_STORE_NAME, (boolean)false);
            if (recordStore.getNumRecords() == 0) {
                useMain = true;
                Log.log("Using main RS as default");
            } else {
                byte[] byArray = recordStore.getRecord(1);
                if (byArray[0] == 1) {
                    useMain = true;
                    Log.log("Using main RS (from store)");
                } else {
                    useMain = false;
                    Log.log("Using secondary RS");
                }
            }
        }
        catch (Throwable throwable) {
            Log.log(throwable);
            useMain = true;
            Log.log("Using main RS (from exception)");
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {
                }
                finally {
                    recordStore = null;
                }
            }
        }
    }

    private static String getMainRecordStore() {
        if (useMain) {
            return IMAGE_STORE_NAME;
        }
        return IMAGE_STORE_NAME2;
    }

    private static String getSecondaryRecordStore() {
        if (useMain) {
            return IMAGE_STORE_NAME2;
        }
        return IMAGE_STORE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveImageOnSecondaryRecordStore(String string, byte[] byArray) throws RecordStoreException, IOException {
        RecordStore recordStore = null;
        try {
            Log.log("2a: Saving on secondary storage");
            recordStore = RecordStore.openRecordStore((String)Storage.getSecondaryRecordStore(), (boolean)true);
            Storage._filter.url = string;
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords((RecordFilter)_filter, null, false);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(byArray.length);
            ((OutputStream)dataOutputStream).write(byArray);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            if (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                recordStore.setRecord(n, byArray2, 0, byArray2.length);
            } else {
                recordStore.addRecord(byArray2, 0, byArray2.length);
            }
            Log.log("2b: Saved on secondary storage");
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void deleteSecondaryRecordStore() {
        try {
            Log.log("#1a: Deleting secondary recordstore");
            RecordStore.deleteRecordStore((String)Storage.getSecondaryRecordStore());
            Log.log("#1b: Secondary recordstore deleted");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Log.log("#1c: Can't delete secondary record store");
        }
    }

    static {
        _filter = new ImageURLFilter();
        useMain = true;
        firstExecution = false;
    }

    private static class ImageURLFilter
    implements RecordFilter {
        public String url;

        private ImageURLFilter() {
        }

        public boolean matches(byte[] byArray) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            String string = null;
            try {
                string = dataInputStream.readUTF();
            }
            catch (IOException iOException) {
                Log.log(iOException);
                return false;
            }
            return string.equals(this.url);
        }
    }
}

