/*
 * Decompiled with CFR 0.152.
 */
public abstract class mp
extends gv {
    private static final long FP_FLUCTUATION_TOLERANCE = mx.a(13L) / 1000L;
    private long lastFixOrReset;
    private final hu currentGpsData = new hu();
    private final hu previousGpsData = new hu();
    private final hu currentBuffer = new hu();
    private final hu previousBuffer = new hu();
    private final kd positionBuffer = new kd();
    private final kd directionBuffer = new kd();
    private long fpCurrentDistance;
    private volatile boolean connected;
    private volatile boolean positionFixed;
    protected volatile String lastDiagnosticLineReceived;
    private long lastUpdateTime;
    private long lastChangeTime;
    private final cn notifier;
    private final Object lock = new Object();
    private final Object connectLock = new Object();

    protected mp(g g2) {
        super("GPS facade", g2);
        this.notifier = new cn(this, g2);
        this.notifier.start();
        this.setPriority(10);
        this.pauseWorker();
        this.start();
    }

    protected mp() {
        this(hc.d().g());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isPositionFixed() {
        Object object = this.lock;
        synchronized (object) {
            return this.connected && this.positionFixed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentSpeed() {
        Object object = this.lock;
        synchronized (object) {
            return this.connected && this.positionFixed ? this.currentGpsData.d : -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentDistance() {
        Object object = this.lock;
        synchronized (object) {
            if (this.connected && this.positionFixed && this.previousGpsData.i && this.currentGpsData.i) {
                return this.fpCurrentDistance;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getCurrentCoordinate(kd kd2) {
        Object object = this.lock;
        synchronized (object) {
            kd2.a = this.currentGpsData.b;
            kd2.b = this.currentGpsData.a;
            if (!this.connected) {
                return 4;
            }
            if (!this.positionFixed) {
                return 2;
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getDirection(kd kd2) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected) {
                return 4;
            }
            if (!this.positionFixed) {
                return 2;
            }
            if (!this.currentGpsData.i || !this.previousGpsData.i) {
                return 2;
            }
            if (this.currentGpsData.a == this.previousGpsData.a && this.currentGpsData.b == this.previousGpsData.b) {
                return 2;
            }
            long l2 = this.currentGpsData.a - this.previousGpsData.a;
            long l3 = this.currentGpsData.b - this.previousGpsData.b;
            kd2.b = this.currentGpsData.a + l2;
            kd2.a = this.currentGpsData.b + l3;
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getVisibleSatellitesNr() {
        Object object = this.lock;
        synchronized (object) {
            if (this.connected && this.positionFixed) {
                return this.currentGpsData.h;
            }
            return -1;
        }
    }

    public final void ensureRunningUI() {
        try {
            this.ensureRunning();
        }
        catch (be be2) {
            be2.a();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureRunning() {
        Object object = this.connectLock;
        synchronized (object) {
            if (!this.connected) {
                this.reset();
            }
        }
    }

    public void pause() {
        this.pauseWorker();
        this.doDisconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        this.pauseWorker();
        Object object = this.connectLock;
        synchronized (object) {
            String string = this.getErrorMessage();
            if (string != null) {
                throw be.a(string);
            }
            this.doDisconnect();
            this.notifier.a();
            this.onReset();
        }
        this.resumeWorker();
    }

    protected abstract void onReset();

    protected abstract void connect();

    protected abstract void disconnect();

    protected abstract byte pullGpsData(hu var1, hu var2);

    protected boolean isFluctuationDetected(long l2, long l3, long l4, long l5) {
        long l6 = an.a(l2, l3, l4, l5);
        return l6 < FP_FLUCTUATION_TOLERANCE;
    }

    public void addListener(mr mr2) {
        this.notifier.a(mr2);
    }

    public void removeListener(mr mr2) {
        this.notifier.b(mr2);
    }

    protected void fireEvent(int n2, Object[] objectArray) {
        long l2 = System.currentTimeMillis();
        switch (n2) {
            case 0x20000001: 
            case 0x20000005: 
            case 0x20000006: {
                this.notifier.a(n2, objectArray, false, l2);
                break;
            }
            default: {
                this.notifier.a(n2, objectArray, true, l2);
            }
        }
    }

    public String formatLastDiagnosticLine() {
        String string = this.lastDiagnosticLineReceived;
        if (string == null || string.length() == 0) {
            return '<' + fg.a(151) + '>';
        }
        if (string.length() > 15) {
            return string.substring(0, 15);
        }
        return string;
    }

    protected String getErrorMessage() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getGpsData() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connected || !this.positionFixed) {
                return null;
            }
            kd kd2 = new kd();
            kd kd3 = new kd();
            kd2.a = this.currentGpsData.b;
            kd2.b = this.currentGpsData.a;
            if (!this.currentGpsData.i || !this.previousGpsData.i || this.currentGpsData.a == this.previousGpsData.a && this.currentGpsData.b == this.previousGpsData.b) {
                return new Object[]{kd2, kd3, new Integer(0)};
            }
            long l2 = this.currentGpsData.a - this.previousGpsData.a;
            long l3 = this.currentGpsData.b - this.previousGpsData.b;
            kd3.b = this.currentGpsData.a + l2;
            kd3.a = this.currentGpsData.b + l3;
            int n2 = (int)mx.b(this.getCurrentSpeed());
            return new Object[]{kd2, kd3, new Integer(n2)};
        }
    }

    public boolean isGPSReady() {
        String string = this.getErrorMessage();
        if (string == null) {
            return true;
        }
        ay.a(string);
        return false;
    }

    public hu getCurrentGpsData() {
        return this.currentGpsData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performTask() {
        this.setDelay(0);
        if (this.connected) {
            int n2 = 4;
            try {
                while ((n2 = (int)this.pullGpsData(this.previousBuffer, this.currentBuffer)) == 5) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            long l2 = System.currentTimeMillis();
            switch (n2) {
                case 4: {
                    this.lastFixOrReset = l2;
                    this.doDisconnect();
                    break;
                }
                case 3: {
                    this.lastUpdateTime = l2;
                    Object object = this.lock;
                    synchronized (object) {
                        this.positionFixed = false;
                        this.fpCurrentDistance = 0L;
                    }
                    this.fireEvent(0x20000006, null);
                    break;
                }
                case 2: {
                    this.lastFixOrReset = l2;
                    this.lastUpdateTime = l2;
                    this.lastChangeTime = l2;
                    this.positionFixed = true;
                    this.currentGpsData.a(this.previousGpsData);
                    this.currentBuffer.a(this.currentGpsData);
                    this.positionBuffer.b = this.currentBuffer.a;
                    this.positionBuffer.a = this.currentBuffer.b;
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.previousGpsData.i) {
                            long l3 = this.currentGpsData.f - this.previousGpsData.f;
                            if (l3 < 3000L) {
                                long l4 = (this.currentGpsData.d + this.previousGpsData.d) / 2L;
                                this.fpCurrentDistance = l4 * l3 / 3600L;
                            } else {
                                this.fpCurrentDistance = an.a(this.currentGpsData.b, this.currentGpsData.a, this.previousGpsData.b, this.previousGpsData.a) * 1000L;
                            }
                        } else {
                            this.fpCurrentDistance = 0L;
                        }
                    }
                    if (this.getDirection(this.directionBuffer) != 1) {
                        this.fireEvent(0x20000001, new kd[]{this.positionBuffer, null});
                        break;
                    }
                    this.fireEvent(0x20000001, new kd[]{this.positionBuffer, this.directionBuffer});
                    break;
                }
                case 1: {
                    this.lastFixOrReset = l2;
                    this.lastUpdateTime = l2;
                    Object object = this.lock;
                    synchronized (object) {
                        this.positionFixed = true;
                        this.fpCurrentDistance = 0L;
                    }
                    if (this.lastUpdateTime - this.lastChangeTime > 3000L) {
                        this.currentGpsData.d = 0L;
                    }
                    this.positionBuffer.b = this.currentGpsData.a;
                    this.positionBuffer.a = this.currentGpsData.b;
                    this.getDirection(this.directionBuffer);
                    this.fireEvent(0x20000005, new kd[]{this.positionBuffer, this.directionBuffer});
                    break;
                }
                case 5: {
                    this.lastFixOrReset = l2;
                    break;
                }
            }
        } else {
            this.fireEvent(0x20000003, null);
            try {
                this.doConnect();
            }
            catch (Throwable throwable) {
                this.fireEvent(-2147483647, new String[]{"Connection error: " + throwable.getMessage()});
                this.setDelay(5000);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect() {
        Object object = this.connectLock;
        synchronized (object) {
            if (!this.connected) {
                this.connect();
                this.connected = true;
                this.positionFixed = false;
                this.notifier.b();
                this.fireEvent(0x20000004, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDisconnect() {
        Object object = this.connectLock;
        synchronized (object) {
            if (this.connected) {
                this.disconnect();
                this.connected = false;
                this.positionFixed = false;
                this.lastDiagnosticLineReceived = null;
                this.notifier.c();
                this.fireEvent(0x20000002, null);
            }
        }
    }

    public void dispose() {
        this.notifier.killWorker();
        this.killWorker();
    }

    void notifyTimeout() {
        this.doDisconnect();
    }

    public boolean isLastPositionKnown() {
        kd kd2 = this.getLastPosition();
        return kd2.b != 0L || kd2.a != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public kd getLastPosition() {
        kd kd2 = new kd();
        Object object = this.lock;
        synchronized (object) {
            if (this.connected && this.positionFixed) {
                this.getCurrentCoordinate(kd2);
            } else {
                kl kl2 = hc.d().k().g();
                kd2.b = kl2.a("gps.LastKnownLon", 0L);
                kd2.a = kl2.a("gps.LastKnownLat", 0L);
            }
        }
        return kd2;
    }

    public boolean isKillable() {
        return false;
    }
}

