/*
 * Decompiled with CFR 0.152.
 */
package at.calista.framework.gui.core;

import at.calista.framework.debug.Debug;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.imageeffect.ImageTransformControl;
import javax.microedition.lcdui.Image;

public class Calculation {
    public static Image scale2(Image image, int n, int n2) {
        try {
            int[] nArray = new int[image.getWidth()];
            int[] nArray2 = new int[n * n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = image.getHeight() * ((i2 << 1) + 1) / (n2 * 2);
                if (-1 != n3) {
                    image.getRGB(nArray, 0, image.getWidth(), 0, n3, image.getWidth(), 1);
                }
                for (n3 = 0; n3 < n; ++n3) {
                    int n4 = image.getWidth() * ((n3 << 1) + 1) / (n * 2);
                    nArray2[i2 * n + n3] = nArray[n4];
                }
            }
            return Image.createRGBImage((int[])nArray2, (int)n, (int)n2, (boolean)false);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static Image scale2alt(Image image, int n, int n2) {
        int[] nArray = new int[image.getHeight() * image.getWidth()];
        image.getRGB(nArray, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        int[] nArray2 = new int[n * n2];
        int n3 = image.getHeight() / n2 * image.getWidth() - image.getWidth();
        int n4 = image.getHeight() % n2;
        int n5 = image.getWidth() / n;
        int n6 = image.getWidth() % n;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (int i2 = n2; i2 > 0; --i2) {
            int n10 = 0;
            for (int i3 = n; i3 > 0; --i3) {
                nArray2[n7++] = nArray[n8];
                n8 += n5;
                if ((n10 += n6) < n) continue;
                n10 -= n;
                ++n8;
            }
            n8 += n3;
            if ((n9 += n4) < n2) continue;
            n9 -= n2;
            n8 += image.getWidth();
        }
        return Image.createRGBImage((int[])nArray2, (int)n, (int)n2, (boolean)false);
    }

    public static Image scale(Image object, int n, int n2) {
        int n3 = object.getWidth();
        int n4 = object.getWidth();
        int n5 = object.getHeight();
        int[] nArray = new int[n4 * n5];
        object.getRGB(nArray, 0, n3, 0, 0, n4, n5);
        object = new int[n * n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n6 = i2 * n;
            int n7 = i2 * n5 / n2 * n3;
            for (int i3 = 0; i3 < n; ++i3) {
                object[n6 + i3] = (Image)nArray[n7 + i3 * n4 / n];
            }
        }
        Image image = Image.createRGBImage((int[])object, (int)n, (int)n2, (boolean)true);
        return image;
    }

    public static Image rotateImage(Image image, int n) {
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2 * n3];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            image.getRGB(nArray, 0, n2, 0, i2, n2, 1);
            for (int i3 = 0; i3 < n2; ++i3) {
                n4 = n == 90 ? n3 - i2 - 1 + i3 * n3 : (n == 270 ? i2 + n3 * (n2 - i3 - 1) : n2 * n3 - (i2 * n2 + i3) - 1);
                nArray2[n4] = nArray[i3];
            }
        }
        if (n == 90 || n == 270) {
            return Image.createRGBImage((int[])nArray2, (int)n3, (int)n2, (boolean)true);
        }
        return Image.createRGBImage((int[])nArray2, (int)n2, (int)n3, (boolean)true);
    }

    public static final String getCaptureSupport(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = System.getProperty("supports." + string + ".capture");
        if (string2 != null && !string2.trim().equals("")) {
            stringBuffer.append(" capture supported");
            string2 = System.getProperty("supports.recording");
            if (string2 != null && !string2.trim().equals("")) {
                string2 = System.getProperty(string + ".encodings");
                if (string2 != null && !string2.trim().equals("")) {
                    stringBuffer.append(", recording supported to ");
                    stringBuffer.append(string2);
                } else {
                    stringBuffer.append(", recording not supported for this media format");
                }
            } else {
                stringBuffer.append(", recording not supported");
            }
            string2 = System.getProperty(string + ".snapshot.encodings");
            if (string2 != null) {
                stringBuffer.append(", snapshots supported to ");
                stringBuffer.append(string2);
            }
        } else {
            stringBuffer.append(" capture not supported");
        }
        return stringBuffer.toString();
    }

    public static final Image getThumbFromFile(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        Object object = new byte[25600];
        byte[] byArray = new byte[]{0};
        byte by = 0;
        int n = 0;
        try {
            inputStream.read(byArray);
            byte by2 = byArray[0];
            inputStream.read(byArray);
            by = byArray[0];
            int n2 = 0;
            if (Calculation.isJPEG(by2, by)) {
                by2 = 0;
                while (true) {
                    if (by2 != -1) {
                        inputStream.read(byArray);
                        by2 = byArray[0];
                        if (++n2 <= 25600) continue;
                        inputStream.close();
                        return null;
                    }
                    inputStream.read(byArray);
                    by2 = byArray[0];
                    if ((by2 & 0xFF) == 216) break;
                }
                ++n;
                object[0] = -1;
                ++n;
                object[1] = by2;
                by2 = 0;
                while (true) {
                    if (by2 != -1) {
                        inputStream.read(byArray);
                        by2 = byArray[0];
                        object[n++] = by2;
                        continue;
                    }
                    inputStream.read(byArray);
                    by2 = byArray[0];
                    object[n++] = by2;
                    if ((by2 & 0xFF) == 217) break;
                }
                byArray = new byte[n];
                object[n] = -1;
                System.arraycopy(object, 0, byArray, 0, n);
                object = null;
                try {
                    object = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                }
                catch (Exception exception) {
                    Debug.appenderror(" createImg " + exception.toString());
                }
                inputStream.close();
                return object;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            Debug.appenderror(" getThumbFromFile " + exception.toString());
        }
        return null;
    }

    public static Image resizeImage(InputStream inputStream, int n, int n2) {
        if (Calculation.hasAMMS()) {
            try {
                MediaProcessor mediaProcessor = GlobalManager.getSupportedMediaProcessorInputTypes();
                if (mediaProcessor != null) {
                    for (int i2 = 0; i2 < ((MediaProcessor)mediaProcessor).length; ++i2) {
                        Debug.appenddebug((String)mediaProcessor[i2]);
                    }
                }
                mediaProcessor = GlobalManager.createMediaProcessor((String)"image/jpeg");
                mediaProcessor.setInput(inputStream, -1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                mediaProcessor.setOutput((OutputStream)byteArrayOutputStream);
                ImageTransformControl imageTransformControl = (ImageTransformControl)mediaProcessor.getControl("javax.microedition.amms.control.imageeffect.ImageTransformControl");
                imageTransformControl.setTargetSize(n, n2, 0);
                imageTransformControl.setEnforced(true);
                imageTransformControl.setEnabled(true);
                mediaProcessor.complete();
                inputStream.close();
                return Image.createImage((byte[])byteArrayOutputStream.toByteArray(), (int)0, (int)byteArrayOutputStream.size());
            }
            catch (Exception exception) {
                Debug.appenderror("resImg:" + exception.getMessage() + " no mediaprocessor");
            }
        } else {
            Debug.appenddebug("no amms!");
        }
        return null;
    }

    public static final boolean isJPEG(byte by, byte by2) {
        return (by & 0xFF) == 255 && (by2 & 0xFF) == 216;
    }

    public static final Image colorGradiant(int n, int n2, int n3) {
        int[] nArray = new int[n2 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = n * i2 / (n3 - 1);
            n4 = n4 | n4 << 8 | n4 << 16;
            for (int i3 = 0; i3 < n2; ++i3) {
                nArray[i2 * n2 + i3] = n4;
            }
        }
        Image image = Image.createRGBImage((int[])nArray, (int)n2, (int)n3, (boolean)false);
        return image;
    }

    public static final boolean hasAMMS() {
        return System.getProperty("microedition.amms.version") != null && System.getProperty("microedition.amms.version").equals("1.0");
    }
}

