/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.font;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class FontRenderer {
    private static final Font SYSTEM_FONT_SMALL = Font.getFont((int)0, (int)1, (int)8);
    private static final Font SYSTEM_FONT_MEDIUM = Font.getFont((int)0, (int)1, (int)0);
    private static final Font SYSTEM_FONT_LARGE = Font.getFont((int)0, (int)1, (int)16);
    public static final int FONT_SMALL = 0;
    public static final int FONT_MEDIUM = 1;
    public static final int FONT_LARGE = 2;

    public static final int getTextHeight(int font, String text) {
        int y = 0;
        int pos = 0;
        int yDistance = 0;
        switch (font) {
            case 0: {
                yDistance = (int)((double)SYSTEM_FONT_SMALL.getHeight() * 1.5);
                break;
            }
            case 1: {
                yDistance = (int)((double)SYSTEM_FONT_MEDIUM.getHeight() * 1.5);
                break;
            }
            case 2: {
                yDistance = (int)((double)SYSTEM_FONT_LARGE.getHeight() * 1.5);
                break;
            }
            default: {
                yDistance = (int)((double)SYSTEM_FONT_MEDIUM.getHeight() * 1.5);
                break;
            }
        }
        while (pos < text.length()) {
            int index = text.indexOf("\\n", pos);
            if (index != -1) {
                pos = index + 2;
                y += yDistance;
                continue;
            }
            y += yDistance;
            break;
        }
        return y;
    }

    public static final void drawTextMultiple(Graphics g, int x, int y, int alignment, int font, int color, String text) {
        int pos = 0;
        int yDistance = 0;
        switch (font) {
            case 0: {
                yDistance = (int)((double)SYSTEM_FONT_SMALL.getHeight() * 1.5);
                break;
            }
            case 1: {
                yDistance = (int)((double)SYSTEM_FONT_MEDIUM.getHeight() * 1.5);
                break;
            }
            case 2: {
                yDistance = (int)((double)SYSTEM_FONT_LARGE.getHeight() * 1.5);
                break;
            }
            default: {
                yDistance = (int)((double)SYSTEM_FONT_MEDIUM.getHeight() * 1.5);
                break;
            }
        }
        while (pos < text.length()) {
            int index = text.indexOf("\\n", pos);
            if (index != -1) {
                FontRenderer.drawText(g, x, y, alignment, font, color, text.substring(pos, index));
                pos = index + 2;
                y += yDistance;
                continue;
            }
            FontRenderer.drawText(g, x, y, alignment, font, color, text.substring(pos));
            break;
        }
    }

    public static final int drawText(Graphics g, int x, int y, int alignment, int font, int color, String text) {
        Font textFont;
        int textWidth = 0;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int oldColor = g.getColor();
        int adjustment = 0;
        switch (font) {
            case 0: {
                textFont = SYSTEM_FONT_SMALL;
                adjustment = -3;
                break;
            }
            case 1: {
                textFont = SYSTEM_FONT_MEDIUM;
                adjustment = -3;
                break;
            }
            case 2: {
                textFont = SYSTEM_FONT_LARGE;
                adjustment = -5;
                break;
            }
            default: {
                textFont = SYSTEM_FONT_MEDIUM;
            }
        }
        g.setColor(color);
        g.setFont(textFont);
        textWidth = g.getFont().stringWidth(text);
        g.drawString(text, x, y + adjustment, 0x40 | alignment);
        g.setColor(oldColor);
        g.setClip(clipX, clipY, clipW, clipH);
        return textWidth;
    }
}

