/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.language;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class Translator {
    private static final String _MESSAGES_BUNDLE = "/com/sonyericsson/walkmate/language/messages.properties";
    private static final String _INIT_LOCALIZATION_ERROR_MSG = "Error when initializing localization support, reason: {0}";
    private static final String _DEFAULT_STRING = "???";
    private static String currentLocale = "";
    private static final String _KEY_VALUE_SEPARATORS = "=: \t\r\n\f";
    private static final String _STRICT_KEY_VALUE_SEPARTORS = "=:";
    private static final String _WHITESPACE_CHARS = " \t\r\n\f";
    private static Hashtable _messageTable;
    private static String _localizationErrorMessage;

    static {
        _localizationErrorMessage = null;
    }

    public static boolean localeHasChanged() {
        return !currentLocale.equals(System.getProperty("microedition.locale"));
    }

    public static synchronized boolean initLocalizationSupport() {
        currentLocale = System.getProperty("microedition.locale");
        return Translator.initLocalizationSupport(System.getProperty("microedition.locale"));
    }

    public static boolean initLocalizationSupport(String locale) {
        block6: {
            InputStream in = null;
            Class<?> clazz = Runtime.getRuntime().getClass();
            try {
                if (locale != null && locale.length() > 1) {
                    int lastIndex = _MESSAGES_BUNDLE.lastIndexOf(46);
                    String prefix = _MESSAGES_BUNDLE.substring(0, lastIndex);
                    String suffix = _MESSAGES_BUNDLE.substring(lastIndex);
                    locale = locale.replace('-', '_');
                    in = clazz.getResourceAsStream(String.valueOf(prefix) + "_" + locale + suffix);
                    if (in == null) {
                        in = clazz.getResourceAsStream(String.valueOf(prefix) + "_" + locale.substring(0, 2) + suffix);
                    }
                }
                if (in == null) {
                    in = clazz.getResourceAsStream(_MESSAGES_BUNDLE);
                }
                if (in == null) {
                    _localizationErrorMessage = Translator._processPattern(_INIT_LOCALIZATION_ERROR_MSG, new Object[]{"No messages found"});
                    break block6;
                }
                _messageTable = new Hashtable();
                Translator._loadMessages(in);
                return true;
            }
            catch (Exception e) {
                _localizationErrorMessage = Translator._processPattern(_INIT_LOCALIZATION_ERROR_MSG, new Object[]{e.getMessage()});
            }
        }
        return false;
    }

    public static String getErrorMessage() {
        return _localizationErrorMessage;
    }

    public static final String getMessage(String key) {
        return Translator.getMessage(key, null);
    }

    public static final String getMessage(String key, Object[] args) {
        if (_messageTable == null && !Translator.initLocalizationSupport()) {
            return _DEFAULT_STRING;
        }
        StringBuffer toAppendTo = new StringBuffer();
        String s = (String)_messageTable.get(key);
        if (s == null) {
            return _DEFAULT_STRING;
        }
        int l = s.length();
        int n = 0;
        int lidx = -1;
        int lastidx = 0;
        int i = 0;
        while (i < l) {
            if (s.charAt(i) == '{' && ++n == 1) {
                lidx = i;
                toAppendTo.append(s.substring(lastidx, i));
                lastidx = i;
            }
            if (s.charAt(i) == '}') {
                if (n == 1) {
                    toAppendTo.append(Translator._processPattern(s.substring(lidx + 1, i), args));
                    lidx = -1;
                    lastidx = i + 1;
                }
                --n;
            }
            ++i;
        }
        if (n > 0) {
            toAppendTo.append(Translator._processPattern(s.substring(lidx + 1), args));
        } else {
            toAppendTo.append(s.substring(lastidx));
        }
        return toAppendTo.toString();
    }

    private static synchronized void _loadMessages(InputStream inStream) throws IOException {
        InputStreamReader in = new InputStreamReader(inStream);
        String line;
        while ((line = Translator._readLine(in)) != null) {
            char firstChar;
            if (line.length() <= 0) continue;
            int len = line.length();
            int keyStart = 0;
            while (keyStart < len) {
                if (_WHITESPACE_CHARS.indexOf(line.charAt(keyStart)) == -1) break;
                ++keyStart;
            }
            if (keyStart == len || (firstChar = line.charAt(keyStart)) == '#' || firstChar == '!') continue;
            while (Translator._continueLine(line)) {
                String nextLine = Translator._readLine(in);
                if (nextLine == null) {
                    nextLine = "";
                }
                String loppedLine = line.substring(0, len - 1);
                int startIndex = 0;
                while (startIndex < nextLine.length()) {
                    if (_WHITESPACE_CHARS.indexOf(nextLine.charAt(startIndex)) == -1) break;
                    ++startIndex;
                }
                nextLine = nextLine.substring(startIndex, nextLine.length());
                line = String.valueOf(loppedLine) + nextLine;
                len = line.length();
            }
            int separatorIndex = keyStart;
            while (separatorIndex < len) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                } else if (_KEY_VALUE_SEPARATORS.indexOf(currentChar) != -1) break;
                ++separatorIndex;
            }
            int valueIndex = separatorIndex;
            while (valueIndex < len) {
                if (_WHITESPACE_CHARS.indexOf(line.charAt(valueIndex)) == -1) break;
                ++valueIndex;
            }
            if (valueIndex < len && _STRICT_KEY_VALUE_SEPARTORS.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len) {
                if (_WHITESPACE_CHARS.indexOf(line.charAt(valueIndex)) == -1) break;
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            key = Translator._convertString(key);
            value = Translator._convertString(value);
            _messageTable.put(key, value);
        }
        return;
    }

    private static String _readLine(InputStreamReader in) throws IOException {
        int i;
        StringBuffer strBuf = new StringBuffer("");
        while ((i = in.read()) != -1) {
            if ((char)i == '\r' || (char)i == '\n') {
                return strBuf.toString();
            }
            strBuf.append((char)i);
        }
        return strBuf.length() > 0 ? strBuf.toString() : null;
    }

    private static boolean _continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 != 0;
    }

    private static String _convertString(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                return _DEFAULT_STRING;
                            }
                        }
                        ++i;
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    private static String _processPattern(String indexString, Object[] args) {
        try {
            int index = Integer.parseInt(indexString);
            if (args != null && index >= 0 && index < args.length && args[index] != null) {
                return args[index].toString();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return _DEFAULT_STRING;
    }
}

