/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.pedometer;

import com.sonyericsson.walkmate.mvc.AObservable;
import com.sonyericsson.walkmate.pedometer.ST_PedometerAlgorithm;
import javax.microedition.io.Connector;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class ST_Pedometer
extends AObservable
implements DataListener,
Runnable {
    static final String channelNames0 = "axis_x";
    static final String channelNames1 = "axis_y";
    static final String channelNames2 = "axis_z";
    static final int SENSITIVITY = 46;
    private ST_PedometerAlgorithm pedometer;
    private int steps;
    private int oldSteps;
    private String URL;
    private SensorConnection sensor;
    private int[] channels = new int[3];
    private Thread powerSavingThread;
    private int movementX = 0;
    private int movementY = 0;
    private int movementZ = 0;
    private int movementOldX = 0;
    private int movementOldY = 0;
    private int movementOldZ = 0;
    private int movementDeltaX = 0;
    private int movementDeltaY = 0;
    private int movementDeltaZ = 0;
    private int movementCounter = 0;
    private volatile boolean allowPowerSaving = true;

    public int getSteps() {
        return this.steps;
    }

    public boolean start() {
        this.pedometer = new ST_PedometerAlgorithm();
        this.pedometer.sensitivity = 2;
        this.pedometer.Init();
        this.oldSteps = 0;
        try {
            SensorInfo[] si = SensorManager.findSensors((String)"acceleration", (String)"user");
            int i = 0;
            while (i != si.length) {
                SensorInfo s = si[i];
                this.URL = s.getUrl();
                ++i;
            }
            this.sensor = (SensorConnection)Connector.open((String)this.URL);
            this.sensor.setDataListener((DataListener)this, 1, 0L, true, false, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public void reset() {
        this.pedometer.Init();
        this.oldSteps = 0;
    }

    public void stop() {
        try {
            if (this.sensor != null && this.sensor.getState() != 4) {
                this.sensor.removeDataListener();
                this.sensor.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void dataReceived(SensorConnection sensor, Data[] data, boolean isDataLost) {
        this.movementOldX = this.movementX;
        this.movementOldY = this.movementY;
        this.movementOldZ = this.movementZ;
        int i = 0;
        while (i != data.length) {
            if (data[i].getChannelInfo().getName().compareTo(channelNames0) == 0) {
                this.channels[0] = data[i].getIntValues()[0] / 46;
                this.movementX = Math.abs(data[i].getIntValues()[0]);
            } else if (data[i].getChannelInfo().getName().compareTo(channelNames1) == 0) {
                this.channels[1] = data[i].getIntValues()[0] / 46;
                this.movementY = Math.abs(data[i].getIntValues()[0]);
            } else if (data[i].getChannelInfo().getName().compareTo(channelNames2) == 0) {
                this.channels[2] = data[i].getIntValues()[0] / 46;
                this.movementZ = Math.abs(data[i].getIntValues()[0]);
            }
            ++i;
        }
        this.movementDeltaX = Math.abs(this.movementX - this.movementOldX);
        this.movementDeltaY = Math.abs(this.movementY - this.movementOldY);
        this.movementDeltaZ = Math.abs(this.movementZ - this.movementOldZ);
        this.pedometer.CalAcc(this.channels[0], this.channels[1], this.channels[2]);
        this.pedometer.PedoAlgo();
        this.steps = this.pedometer.GetSteps();
        if (this.oldSteps != this.steps) {
            this.notifySteps(this.steps - this.oldSteps);
            this.oldSteps = this.steps;
        }
        if (this.movementDeltaX + this.movementDeltaY + this.movementDeltaZ > 60) {
            ++this.movementCounter;
            if (this.movementCounter == 5) {
                this.notifyMovement(true);
            } else if (this.movementCounter == 21) {
                this.movementCounter = 20;
            }
        } else {
            --this.movementCounter;
            if (this.movementCounter == 4) {
                this.notifyMovement(false);
            } else if (this.movementCounter == -1) {
                this.movementCounter = 0;
            }
        }
        if (this.allowPowerSaving && this.pedometer.memsPowerState == 2) {
            this.stop();
            this.powerSavingThread = new Thread(this);
            this.powerSavingThread.start();
        }
    }

    public void run() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.sensor = (SensorConnection)Connector.open((String)this.URL);
            this.sensor.setDataListener((DataListener)this, 1, 0L, true, false, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private final void notifySteps(int steps) {
        this.setChanged();
        this.notifyObservers(steps);
    }

    private final synchronized void notifyMovement(boolean movement) {
        this.setChanged();
        this.notifyObservers(movement);
    }

    public final void allowPowerSaving(boolean allowPowerSaving) {
        this.allowPowerSaving = allowPowerSaving;
        if (!allowPowerSaving && this.powerSavingThread != null && this.powerSavingThread.isAlive()) {
            this.powerSavingThread.interrupt();
        }
    }
}

