/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.pedometer;

public class ST_PedometerAlgorithm {
    static final int AXIS_X = 1;
    static final int AXIS_Y = 2;
    static final int AXIS_Z = 3;
    static final int LSENSIT = 1;
    static final int MSENSIT = 2;
    static final int HSENSIT = 3;
    static final int MEMS_IS_UP = 1;
    static final int MEMS_IS_DOWN = 2;
    static final float thresholdLevelPercentRun = 0.4f;
    static final float thresholdLevelPercentWalk = 0.68f;
    static final float minDurationChange = 0.55f;
    static final float maxDurationChange = 1.8f;
    static final short validationStep = 8;
    static final short maxBadStep = 4;
    static final float lowSensitivityWalking = 3.5f;
    static final float mediumSensitivityWalking = 3.0f;
    static final float highSensitivityWalking = 2.0f;
    static final float envelopeMeanWeight = 0.9f;
    static final float envelopePosWeight = 0.1f;
    static final float envelopeMeanWeightStepValidation = 0.7f;
    static final float envelopePosWeightStepValidation = 0.3f;
    static final short noStepDetectionValidationTiming = 60;
    static final short envelopeMeanTimeDecay = 40;
    static final short autoDetectAxisTiming = 40;
    static final short envelopeMeanTimeDecayLimit = 920;
    static final short powerUpTiming = 40;
    public int sensitivity;
    private int steps;
    private short maskStep;
    private float thresholdLevelPercent;
    private int badStep;
    private boolean validationReachedStep;
    private boolean incrementStepAllowed;
    private float walking;
    private float envelopePos;
    private float prevEnvelopePos;
    private float envelopeNeg;
    private float envelopeMean;
    private boolean envelopeMeanStart;
    private float maxPos;
    private boolean posState;
    private int mask;
    private boolean Xover;
    private boolean stepProcessed;
    private int tmpStepCount;
    private int PrevSampleCount;
    private float cutoffp;
    private float cutoffm;
    private float calAcc;
    private float calAccX;
    private float calAccY;
    private float calAccZ;
    private int acc;
    private int sampleCountSinceLastStep;
    private int sampleCountSinceLast2Step;
    private int sampleCountSinceLast3Step;
    private int sampleCountSinceLast4Step;
    private float meanX;
    private float meanY;
    private float meanZ;
    private boolean meanPosX;
    private boolean meanPosY;
    private boolean meanPosZ;
    private boolean checkDominant;
    private boolean start;
    private int dominantAxis;
    private boolean autoDetect;
    private boolean powerDown;
    private boolean sampleBeforePowerDownTaken;
    private int prevAccX;
    private int prevAccY;
    private int prevAccZ;
    public int memsPowerState;
    private int sampleNbrAfterMemsIsUp;
    private boolean activityDetected;
    private boolean powerUp;
    private boolean normalOperation;
    private int deltamX;
    private int deltamY;
    private int deltamZ;
    private int powerOnThreshold;
    private int powerUpTimingCounter;
    private boolean powerUpExpired;
    private int powerUpTimingCounterInitVal;
    private boolean autoPowerOff;

    public void Init() {
        this.maskStep = (short)8;
        this.thresholdLevelPercent = 0.68f;
        this.badStep = 0;
        this.validationReachedStep = false;
        this.incrementStepAllowed = false;
        switch (this.sensitivity) {
            case 1: {
                this.walking = 3.5f;
                break;
            }
            case 2: {
                this.walking = 3.0f;
                break;
            }
            case 3: {
                this.walking = 2.0f;
                break;
            }
        }
        this.envelopePos = this.walking;
        this.prevEnvelopePos = 0.0f;
        this.envelopeNeg = -this.walking;
        this.envelopeMean = 0.0f;
        this.envelopeMeanStart = true;
        this.maxPos = 0.0f;
        this.posState = true;
        this.mask = 0;
        this.Xover = true;
        this.stepProcessed = true;
        this.tmpStepCount = 0;
        this.PrevSampleCount = 0;
        this.cutoffp = this.walking;
        this.cutoffm = -this.walking;
        this.calAcc = 0.0f;
        this.calAccX = 0.0f;
        this.calAccY = 0.0f;
        this.calAccZ = 0.0f;
        this.acc = 0;
        this.sampleCountSinceLastStep = 0;
        this.sampleCountSinceLast2Step = 0;
        this.sampleCountSinceLast3Step = 0;
        this.sampleCountSinceLast4Step = 0;
        this.meanX = 0.0f;
        this.meanY = 0.0f;
        this.meanZ = 0.0f;
        this.meanPosX = true;
        this.meanPosY = true;
        this.meanPosZ = true;
        this.checkDominant = true;
        this.start = true;
        this.dominantAxis = 1;
        this.autoDetect = true;
        this.steps = 0;
        this.powerDown = false;
        this.sampleBeforePowerDownTaken = false;
        this.prevAccX = 0;
        this.prevAccY = 0;
        this.prevAccZ = 0;
        this.memsPowerState = 1;
        this.sampleNbrAfterMemsIsUp = 0;
        this.activityDetected = true;
        this.powerUp = false;
        this.normalOperation = true;
        this.deltamX = 0;
        this.deltamY = 0;
        this.deltamZ = 0;
        this.powerOnThreshold = 2;
        this.powerUpTimingCounter = this.powerUpTimingCounterInitVal = 40;
        this.powerUpExpired = true;
        this.autoPowerOff = true;
    }

    public void DominantAxis(int X, int Y, int Z) {
        if (this.start) {
            this.meanX = X;
            this.meanY = Y;
            this.meanZ = Z;
            this.start = false;
        } else {
            this.meanX = (this.meanX * 795.0f + (float)X * 5.0f) / 800.0f;
            this.meanY = (this.meanY * 795.0f + (float)Y * 5.0f) / 800.0f;
            this.meanZ = (this.meanZ * 795.0f + (float)Z * 5.0f) / 800.0f;
            if (this.checkDominant) {
                this.dominantAxis = Math.abs(this.meanX) > Math.abs(this.meanY) ? (Math.abs(this.meanX) > Math.abs(this.meanZ) ? 1 : 3) : (Math.abs(this.meanY) > Math.abs(this.meanZ) ? 2 : 3);
            }
        }
    }

    public void CalAcc(int X, int Y, int Z) {
        this.DominantAxis(X, Y, Z);
        this.checkDominant = false;
        if (this.powerDown) {
            if (!this.sampleBeforePowerDownTaken) {
                this.prevAccX = X;
                this.prevAccY = Y;
                this.prevAccZ = Z;
                this.sampleBeforePowerDownTaken = true;
                this.memsPowerState = 2;
            } else {
                ++this.sampleNbrAfterMemsIsUp;
                if (this.sampleNbrAfterMemsIsUp == 1) {
                    this.memsPowerState = 1;
                }
                if (this.sampleNbrAfterMemsIsUp < 2) {
                    this.activityDetected = false;
                    this.powerUp = false;
                    this.normalOperation = false;
                    this.powerDown = true;
                } else {
                    this.sampleNbrAfterMemsIsUp = 0;
                    this.deltamX = Math.abs(X - this.prevAccX);
                    this.deltamY = Math.abs(Y - this.prevAccY);
                    this.deltamZ = Math.abs(Z - this.prevAccZ);
                    this.prevAccX = X;
                    this.prevAccY = Y;
                    this.prevAccZ = Z;
                    if (this.deltamX >= this.powerOnThreshold || this.deltamY >= this.powerOnThreshold || this.deltamZ >= this.powerOnThreshold) {
                        this.activityDetected = true;
                        this.powerDown = false;
                        this.powerUp = true;
                    } else {
                        this.activityDetected = false;
                        this.normalOperation = false;
                        this.memsPowerState = 2;
                        this.powerDown = true;
                        this.powerUp = false;
                    }
                }
            }
        }
        if (this.activityDetected) {
            this.calAccX = 0.2f * this.calAccX + 0.8f * ((float)X - this.meanX);
            this.calAccY = 0.2f * this.calAccY + 0.8f * ((float)Y - this.meanY);
            this.calAccZ = 0.2f * this.calAccZ + 0.8f * ((float)Z - this.meanZ);
            if (this.meanX > 4.0f) {
                this.meanPosX = true;
            } else if (this.meanX < -4.0f) {
                this.meanPosX = false;
            }
            if (!this.meanPosX) {
                this.calAccX = -this.calAccX;
            }
            if (this.meanY > 4.0f) {
                this.meanPosY = true;
            } else if (this.meanY < -4.0f) {
                this.meanPosY = false;
            }
            if (!this.meanPosY) {
                this.calAccY = -this.calAccY;
            }
            if (this.meanZ > 4.0f) {
                this.meanPosZ = true;
            } else if (this.meanZ < -4.0f) {
                this.meanPosZ = false;
            }
            if (!this.meanPosZ) {
                this.calAccZ = -this.calAccZ;
            }
            if (this.dominantAxis == 1) {
                this.calAcc = this.calAccX;
                this.acc = X;
            } else if (this.dominantAxis == 2) {
                this.calAcc = this.calAccY;
                this.acc = Y;
            } else if (this.dominantAxis == 3) {
                this.calAcc = this.calAccZ;
                this.acc = Z;
            }
        }
    }

    public int GetSteps() {
        return this.steps;
    }

    public void PedoAlgo() {
        if (this.powerUp) {
            if (this.powerUpTimingCounter > 0) {
                --this.powerUpTimingCounter;
                this.normalOperation = true;
                this.activityDetected = true;
                this.powerDown = false;
                this.powerUpExpired = false;
            } else {
                this.normalOperation = false;
                this.powerUp = false;
                this.powerDown = true;
                this.powerUpTimingCounter = this.powerUpTimingCounterInitVal;
                this.activityDetected = false;
                this.powerUpExpired = true;
                this.sampleBeforePowerDownTaken = false;
            }
        }
        if (this.normalOperation) {
            if (this.calAcc > this.envelopePos) {
                this.maxPos = Math.max(this.calAcc, this.maxPos);
                this.envelopePos = this.calAcc;
            } else {
                this.envelopePos *= 0.8766f;
            }
            this.envelopeNeg = this.calAcc < this.envelopeNeg ? this.calAcc : (this.envelopeNeg *= 0.8888f);
            this.cutoffp = this.thresholdLevelPercent * this.envelopePos;
            if (this.cutoffp < this.walking) {
                this.cutoffp = this.walking;
            }
            this.cutoffm = this.thresholdLevelPercent * this.envelopeNeg;
            if (this.cutoffm > -this.walking) {
                this.cutoffm = -this.walking;
            }
            if (this.calAcc < this.cutoffm && this.posState) {
                this.Xover = true;
                if (this.envelopeMeanStart) {
                    this.envelopeMean = this.envelopePos;
                    this.envelopeMeanStart = false;
                } else {
                    this.envelopeMean = this.envelopeMean * 0.9f + Math.max(this.envelopePos, this.prevEnvelopePos) * 0.1f;
                }
                this.posState = false;
            } else if (this.calAcc > this.cutoffp && !this.posState && this.mask >= this.maskStep) {
                this.posState = true;
                this.mask = 0;
                this.thresholdLevelPercent = this.envelopeMean >= 32.0f ? 0.4f : 0.68f;
                this.maskStep = this.envelopeMean > 25.0f ? (short)2 : (this.envelopeMean < 4.0f ? (short)8 : (short)5);
            }
            if (this.mask < this.maskStep && this.calAcc < this.envelopePos) {
                ++this.mask;
            }
            if (this.Xover && this.mask >= this.maskStep) {
                this.Xover = false;
                this.stepProcessed = false;
            }
            if (!this.Xover && !this.stepProcessed) {
                this.stepProcessed = true;
                this.ValidateWalking();
                this.sampleCountSinceLastStep = 0;
                if (this.powerUp) {
                    this.powerDown = false;
                    this.powerUp = false;
                    this.powerUpTimingCounter = this.powerUpTimingCounterInitVal;
                    this.powerUpExpired = true;
                }
            }
        }
        ++this.sampleCountSinceLastStep;
        if (this.sampleCountSinceLastStep >= 40) {
            this.envelopeMean *= 0.9f;
        }
        if (this.sampleCountSinceLastStep >= 920) {
            this.sampleCountSinceLastStep = 880;
            if (this.autoPowerOff && !this.powerDown && this.powerUpExpired) {
                this.powerDown = true;
                this.activityDetected = false;
                this.normalOperation = false;
                this.sampleBeforePowerDownTaken = false;
                this.powerUpTimingCounter = this.powerUpTimingCounterInitVal;
            }
        }
        this.CheckDominantAxis();
    }

    public void CheckDominantAxis() {
        if (this.autoDetect) {
            this.checkDominant = true;
            if (this.sampleCountSinceLastStep % 40 == 0) {
                this.start = true;
            }
        }
    }

    public boolean ValidateWalking() {
        boolean retVal = false;
        this.prevEnvelopePos = this.maxPos;
        this.maxPos = 0.0f;
        if (this.tmpStepCount > 2) {
            if ((float)(this.sampleCountSinceLastStep + this.sampleCountSinceLast2Step) > (float)this.PrevSampleCount * 0.55f && (float)(this.sampleCountSinceLastStep + this.sampleCountSinceLast2Step) < (float)this.PrevSampleCount * 1.8f) {
                ++this.tmpStepCount;
            } else {
                if (this.badStep <= 0) {
                    --this.tmpStepCount;
                    ++this.badStep;
                } else {
                    this.tmpStepCount -= 2;
                    ++this.badStep;
                }
                if (this.tmpStepCount == 0) {
                    this.badStep = 0;
                }
            }
        } else {
            ++this.tmpStepCount;
        }
        if (this.badStep >= 4 || this.sampleCountSinceLastStep > 60) {
            this.incrementStepAllowed = false;
            this.validationReachedStep = false;
            this.tmpStepCount = 0;
            this.badStep = 0;
        }
        if (this.tmpStepCount >= 8 || this.incrementStepAllowed) {
            this.incrementStepAllowed = true;
            if (!this.validationReachedStep) {
                this.validationReachedStep = true;
                this.steps += 8;
            } else {
                ++this.steps;
            }
            retVal = true;
        } else {
            this.validationReachedStep = false;
            this.envelopeMean = this.envelopeMean * 0.7f + Math.max(this.envelopePos, this.prevEnvelopePos) * 0.3f;
        }
        if (this.tmpStepCount >= 8) {
            this.badStep = 0;
            this.tmpStepCount = 0;
        }
        this.sampleCountSinceLast4Step = this.sampleCountSinceLast3Step;
        this.sampleCountSinceLast3Step = this.sampleCountSinceLast2Step;
        this.sampleCountSinceLast2Step = this.sampleCountSinceLastStep;
        this.PrevSampleCount = this.sampleCountSinceLast4Step + this.sampleCountSinceLast3Step;
        return retVal;
    }
}

