/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate;

import com.sonyericsson.walkmate.datastore.Datastore;
import com.sonyericsson.walkmate.gui.GUI;
import com.sonyericsson.walkmate.mvc.AObservable;
import com.sonyericsson.walkmate.mvc.IEventListener;
import com.sonyericsson.walkmate.mvc.IObservable;
import com.sonyericsson.walkmate.mvc.IObserver;
import com.sonyericsson.walkmate.pedometer.ST_Pedometer;
import com.sonyericsson.walkmate.utils.DateUtils;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStoreException;

public class Main
extends MIDlet
implements IObservable,
IObserver,
IEventListener {
    private boolean appIsRunning = false;
    private AObservable observable;
    private GUI gui;
    private boolean isActiveSet;
    private boolean isActive;
    private ST_Pedometer pedometer;
    private int stepsToday;
    private int[] stepsLastWeek;
    private int daysWithStepsLastWeek;
    private long millisToday;
    private long millisLastSave;
    private int stepsLastSave;
    private final long SAVE_INTERVAL;

    public Main() {
        this.SAVE_INTERVAL = 60000L;
    }

    public final void startApp() {
        if (this.appIsRunning) {
            return;
        }
        this.appIsRunning = true;
        this.isActiveSet = false;
        this.observable = new AObservable(){};
        this.initializeSteps();
        this.pedometer = new ST_Pedometer();
        if (!this.pedometer.start()) {
            this.notifyDestroyed();
            return;
        }
        this.gui = new GUI(this);
        if (!this.gui.start()) {
            this.destroyApp(true);
            this.notifyDestroyed();
        }
        this.gui.initializeGUI(this.stepsLastWeek, this.daysWithStepsLastWeek, DateUtils.getDayOfWeekToday());
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.gui);
        this.pedometer.addObserver(this);
        this.addObserver(this.gui);
        this.millisToday = DateUtils.getMillisToday();
        this.millisLastSave = DateUtils.getMillisNow();
    }

    public final void pauseApp() {
        this.notifyPaused();
    }

    public final void destroyApp(boolean unconditional) {
        if (this.pedometer == null) {
            return;
        }
        this.pedometer.stop();
        this.pedometer = null;
        this.gui.stop();
        this.gui = null;
        if (DateUtils.getMillisToday() != this.millisToday) {
            this.saveSteps(this.millisToday);
            this.initializeSteps();
        }
        try {
            Datastore.setStepsForToday(this.stepsToday);
        }
        catch (RecordStoreException ignored) {
            ignored.printStackTrace();
        }
    }

    public void screenIsOn() {
        if (!this.isActiveSet) {
            this.isActiveSet = true;
            this.isActive = this.isActive();
            this.gui.setRightSoftKey(this.isActive);
        }
        this.pedometer.allowPowerSaving(false);
    }

    public void screenIsOff() {
        this.pedometer.allowPowerSaving(true);
        if (this.stepsLastSave != this.stepsToday) {
            this.saveSteps(this.millisToday);
            this.stepsLastSave = this.stepsToday;
        }
        this.millisLastSave = DateUtils.getMillisNow();
    }

    private final void saveSteps(long millis) {
        try {
            int[] date = DateUtils.convertMillisToDate(millis);
            Datastore.setSteps(this.stepsToday, date[0], date[1], date[2]);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private final void initializeSteps() {
        this.stepsLastSave = -1;
        try {
            this.stepsToday = Datastore.getStepsForToday();
            this.stepsLastWeek = Datastore.getStepsForLastWeek();
            this.daysWithStepsLastWeek = Datastore.getDaysWithStepsLastWeek();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    private final boolean isActive() {
        return Display.getDisplay((MIDlet)this).flashBacklight(0);
    }

    private final void checkTimeAndDate() {
        if (DateUtils.getMillisToday() != this.millisToday) {
            this.saveSteps(this.millisToday);
            this.millisToday = DateUtils.getMillisToday();
            this.millisLastSave = DateUtils.getMillisNow();
            this.initializeSteps();
            this.gui.initializeGUI(this.stepsLastWeek, this.daysWithStepsLastWeek, DateUtils.getDayOfWeekToday());
        } else if (Math.abs(DateUtils.getMillisNow() - this.millisLastSave) > 60000L) {
            if (this.stepsLastSave != this.stepsToday) {
                this.saveSteps(this.millisToday);
                this.stepsLastSave = this.stepsToday;
            }
            this.millisLastSave = DateUtils.getMillisNow();
        }
    }

    public final void update(IObservable observable, Object argument) {
    }

    public final void update(IObservable observable, int argument) {
        this.checkTimeAndDate();
        this.stepsToday += argument;
        this.setChanged();
        this.notifyObservers(this.stepsToday);
    }

    public final void update(IObservable observable, String argument) {
    }

    public final void update(IObservable observable, boolean argument) {
        this.setChanged();
        this.notifyObservers(argument);
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -7) {
            if (this.isActive) {
                this.destroyApp(true);
                this.notifyDestroyed();
            } else {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.gui);
                Display.getDisplay((MIDlet)this).setCurrent(null);
                Display.getDisplay((MIDlet)this).setCurrent(null);
            }
        }
    }

    public final void requestUpdate(IObserver observer) {
        this.checkTimeAndDate();
    }

    public final void addObserver(IObserver observer) {
        this.observable.addObserver(observer);
    }

    public final void removeObserver(IObserver observer) {
        this.observable.removeObserver(observer);
    }

    public final void notifyObservers(Object argument) {
        this.observable.notifyObservers(argument);
    }

    public final void notifyObservers(int argument) {
        this.observable.notifyObservers(argument);
    }

    public final void notifyObservers(String argument) {
        this.observable.notifyObservers(argument);
    }

    public final void notifyObservers(boolean argument) {
        this.observable.notifyObservers(argument);
    }

    public final void setChanged() {
        this.observable.setChanged();
    }
}

