/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.font.FontRenderer;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.mvc.IEventListener;
import com.sonyericsson.walkmate.mvc.IObservable;
import com.sonyericsson.walkmate.mvc.IObserver;
import com.sonyericsson.walkmate.utils.DateUtils;
import com.sonyericsson.walkmate.utils.MathUtils;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class GUI
extends GameCanvas
implements IObserver,
Runnable,
CommandListener {
    private IEventListener eventListener;
    private Command rskCommand;
    private boolean isActive;
    private boolean manIsMoving;
    private Thread paintThread;
    private volatile boolean run;
    private boolean showPopup;
    private long nextSwitchTimestamp;
    private Object mutex;
    private int stepsToday;
    private double co2;
    private int co2Saved;
    private int dailyAverage;
    private int biggestNumberOfSteps;
    private int[] stepsLastWeek = new int[7];
    private int daysWithStepsLastWeek;
    private int dayOfWeek;
    private long millisToday;
    private final String[] WEEKDAYS = new String[]{"JAVAAPPS_WM_MONDAY_TXT", "JAVAAPPS_WM_TUESDAY_TXT", "JAVAAPPS_WM_WEDNESDAY_TXT", "JAVAAPPS_WM_THURSDAY_TXT", "JAVAAPPS_WM_FRIDAY_TXT", "JAVAAPPS_WM_SATURDAY_TXT", "JAVAAPPS_WM_SUNDAY_TXT"};
    private final int HEALTH_GOAL;
    private final int COLOR_LINE_HEALTH;
    private final int COLOR_LINE_AVERAGE;
    private final int COLOR_LINE_SCALE;
    private final int COLOR_LINE_SCALE_DARK;
    private final int COLOR_TEXT_SCALE;
    private final int COLOR_TEXT_STEPS;
    private final int COLOR_TEXT_HEALTH;
    private final int COLOR_TEXT_HEALTH_AFTER;
    private final int COLOR_TEXT_AVERAGE;
    private final int COLOR_TEXT_HEADLINES;
    private final int COLOR_TEXT_THISWEEK;
    private final int COLOR_TEXT_PASTWEEK;
    private final int COLOR_TEXT_SHADOW;
    private final int COLOR_BAR_BEFORE_TOP;
    private final int COLOR_BAR_BEFORE_FRONT;
    private final int COLOR_BAR_BEFORE_SIDE;
    private final int COLOR_BAR_TODAY_TOP;
    private final int COLOR_BAR_TODAY_FRONT;
    private final int COLOR_BAR_TODAY_SIDE;
    private final int COLOR_BAR_AFTER_TOP;
    private final int COLOR_BAR_AFTER_FRONT;
    private final int COLOR_BAR_AFTER_SIDE;
    private final int COLOR_BAR_HEALTH_TOP;
    private final int COLOR_BAR_HEALTH_FRONT;
    private final int COLOR_BAR_HEALTH_SIDE;
    private final int COLOR_BAR_HEALTH_AFTER_TOP;
    private final int COLOR_BAR_HEALTH_AFTER_FRONT;
    private final int COLOR_BAR_HEALTH_AFTER_SIDE;
    private final int CLIPX;
    private final int CLIPY;
    private final int CLIPW;
    private final int CLIPH;
    private Image imageBackground;
    private Image imageResultsBackground;
    private Image imageBarReflection;
    private Image imageWalkingPersonWhite;
    private Image imageWalkingPersonHealth;
    private Image imageBarShadow;
    private Image imageEcoIcon;
    private String[] textWeekdays = new String[7];
    private String textStepsToday = "";
    private String textHealthGoal = "";
    private String textDailyAverage = "";
    private String textKilo = "";
    private int walkingPersonAnimationCounter;
    private final int WALKING_PERSON_ANIM_FRAMES;
    private final int SWITCH_COUNTER_MAXIMUM;
    private final int SWITCH_LINE_STEP;
    private final int SWITCH_TEXT_STEP;
    private int switchStage = 0;
    private int switchLine = 240;
    private int switchText = 240;
    private int switchCurrentTextWidth = 240;
    private final int SWITCH_INTERVAL;
    private final int UPDATE_CHECK_INTERVAL;
    private final int ANIMATION_INTERVAL_ANIMATE;
    private volatile boolean doAnimate = false;
    private volatile int animationInterval = 50;
    private final int SCREEN_WIDTH;
    private final int SCREEN_HEIGHT;
    private int coordsBackgroundY;
    private int coordsScaleZero;
    private int coordsScaleHeight;
    private int coordsScaleDistance;
    private int coordsBarStartX;
    private int coordsBarStartY;
    private int coordsBarTextY;
    private int coordsBarWidth;
    private int coordsBarDistance;
    private int coordsShadowDisplacementX;
    private int coordsShadowDisplacementY;
    private int coordsTextBackgroundY;
    private int coordsLeftTextSmallX;
    private int coordsLeftTextSmallY;
    private int coordsLeftTextBigX;
    private int coordsLeftTextBigY;
    private int coordsRightTextSmallX;
    private int coordsRightTextSmallY;
    private int coordsRightTextBigX;
    private int coordsRightTextBigY;
    private int coordsRightEcoIconX;
    private int coordsRightEcoIconY;
    private static final int SHOW_HEALTH = 1;
    private static final int DAILY_AVERAGE = 2;
    private static final int CO2_SAVED = 3;
    private static int LoopState = 1;
    private static double GramsPerMeterCo2 = 0.20365;
    private static double StepSize = 0.7;

    public GUI(IEventListener eventListener) {
        super(false);
        this.HEALTH_GOAL = 10000;
        this.COLOR_LINE_HEALTH = 5612828;
        this.COLOR_LINE_AVERAGE = 0xA0A0A0;
        this.COLOR_LINE_SCALE = 0x4D4D4D;
        this.COLOR_LINE_SCALE_DARK = 0x202020;
        this.COLOR_TEXT_SCALE = 0x838383;
        this.COLOR_TEXT_STEPS = 0xFFFFFF;
        this.COLOR_TEXT_HEALTH = 5612828;
        this.COLOR_TEXT_HEALTH_AFTER = 3170317;
        this.COLOR_TEXT_AVERAGE = 0x909090;
        this.COLOR_TEXT_HEADLINES = 0;
        this.COLOR_TEXT_THISWEEK = 0xFFFFFF;
        this.COLOR_TEXT_PASTWEEK = 0x767777;
        this.COLOR_TEXT_SHADOW = 0;
        this.COLOR_BAR_BEFORE_TOP = 10857648;
        this.COLOR_BAR_BEFORE_FRONT = 8555151;
        this.COLOR_BAR_BEFORE_SIDE = 6187634;
        this.COLOR_BAR_TODAY_TOP = 0xFFFFFF;
        this.COLOR_BAR_TODAY_FRONT = 10857648;
        this.COLOR_BAR_TODAY_SIDE = 8555151;
        this.COLOR_BAR_AFTER_TOP = 6187634;
        this.COLOR_BAR_AFTER_FRONT = 3555914;
        this.COLOR_BAR_AFTER_SIDE = 1778474;
        this.COLOR_BAR_HEALTH_TOP = 6732841;
        this.COLOR_BAR_HEALTH_FRONT = 5612828;
        this.COLOR_BAR_HEALTH_SIDE = 5934626;
        this.COLOR_BAR_HEALTH_AFTER_TOP = 6652741;
        this.COLOR_BAR_HEALTH_AFTER_FRONT = 3170317;
        this.COLOR_BAR_HEALTH_AFTER_SIDE = 1919488;
        this.CLIPX = 0;
        this.CLIPY = 0;
        this.CLIPW = 240;
        this.CLIPH = 320;
        this.WALKING_PERSON_ANIM_FRAMES = 28;
        this.SWITCH_COUNTER_MAXIMUM = 240;
        this.SWITCH_LINE_STEP = 20;
        this.SWITCH_TEXT_STEP = 10;
        this.SWITCH_INTERVAL = 8000;
        this.UPDATE_CHECK_INTERVAL = 1000;
        this.ANIMATION_INTERVAL_ANIMATE = 50;
        this.SCREEN_WIDTH = 240;
        this.SCREEN_HEIGHT = 320;
        this.eventListener = eventListener;
        this.setFullScreenMode(false);
        this.setCommandListener(this);
        this.updateLanguage();
    }

    public final boolean start() {
        this.initializeCoords();
        if (!this.initializeImages()) {
            return false;
        }
        this.manIsMoving = false;
        this.walkingPersonAnimationCounter = 15;
        this.showPopup = false;
        this.mutex = this;
        this.paintThread = new Thread(this);
        this.paintThread.start();
        this.setNextSwitchTimestamp();
        return true;
    }

    public final void stop() {
        if (this.paintThread != null) {
            this.run = false;
            this.paintThread = null;
        }
    }

    private void updateLanguage() {
        int i = 0;
        while (i != this.textWeekdays.length) {
            this.textWeekdays[i] = Translator.getMessage(this.WEEKDAYS[i]);
            ++i;
        }
        this.textStepsToday = Translator.getMessage("JAVAAPPS_WM_STEPS_TODAY_TXT");
        this.textHealthGoal = Translator.getMessage("JAVAAPPS_WM_HEALTH_GOAL_TXT");
        this.textDailyAverage = Translator.getMessage("JAVAAPPS_WM_DAILY_AVERAGE_TXT");
        this.textKilo = Translator.getMessage("JAVAAPPS_WM_KILO_TXT");
        this.setRightSoftKey(this.isActive);
    }

    protected final void showNotify() {
        super.showNotify();
        if (Translator.localeHasChanged()) {
            Translator.initLocalizationSupport();
        }
        this.updateLanguage();
        if (DateUtils.getMillisToday() != this.millisToday) {
            this.eventListener.requestUpdate(this);
        }
        this.animationInterval = 50;
        this.doAnimate = true;
        if (this.paintThread == null) {
            this.paintThread = new Thread(this);
            this.paintThread.start();
        }
        this.eventListener.screenIsOn();
    }

    protected final void hideNotify() {
        super.hideNotify();
        this.doAnimate = false;
        this.run = false;
        this.paintThread = null;
        this.eventListener.screenIsOff();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.rskCommand) {
            this.eventListener.keyPressed(-7);
        }
    }

    private final void setNextSwitchTimestamp() {
        this.nextSwitchTimestamp = System.currentTimeMillis() + 8000L;
    }

    private final boolean isPastNextSwitchTimestamp() {
        return System.currentTimeMillis() >= this.nextSwitchTimestamp || this.nextSwitchTimestamp - System.currentTimeMillis() > 16000L;
    }

    private final void initializeCoords() {
        this.coordsBackgroundY = -28;
        this.coordsScaleZero = 182;
        this.coordsScaleHeight = 70;
        this.coordsScaleDistance = 14;
        this.coordsBarStartX = 30;
        this.coordsBarStartY = this.coordsScaleZero + 8;
        this.coordsBarTextY = this.coordsBarStartY + 17;
        this.coordsBarWidth = 19;
        this.coordsBarDistance = 11;
        this.coordsShadowDisplacementX = -10;
        this.coordsShadowDisplacementY = -18;
        this.coordsTextBackgroundY = 49;
        this.coordsLeftTextSmallX = 6;
        this.coordsLeftTextSmallY = this.coordsTextBackgroundY + 25;
        this.coordsLeftTextBigX = 6;
        this.coordsLeftTextBigY = this.coordsTextBackgroundY + 48;
        this.coordsRightTextSmallX = 234;
        this.coordsRightTextSmallY = this.coordsTextBackgroundY + 25;
        this.coordsRightTextBigX = 234;
        this.coordsRightTextBigY = this.coordsTextBackgroundY + 48;
        this.coordsRightEcoIconX = this.coordsRightTextSmallX - 71;
        this.coordsRightEcoIconY = this.coordsRightTextSmallY - 18;
    }

    private final boolean initializeImages() {
        try {
            this.imageBackground = Image.createImage((String)"/images/background.png");
            this.imageResultsBackground = Image.createImage((String)"/images/resultsBackground.png");
            this.imageBarReflection = Image.createImage((String)"/images/barReflection.png");
            this.imageWalkingPersonWhite = Image.createImage((String)"/images/walkingPersonWhite.png");
            this.imageWalkingPersonHealth = Image.createImage((String)"/images/walkingPersonGreen.png");
            this.imageBarShadow = Image.createImage((String)"/images/barShadow.png");
            this.imageEcoIcon = Image.createImage((String)"/images/green_co2.png");
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public final void initializeGUI(int[] stepsLastWeek, int daysWithStepsLastWeek, int dayOfWeek) {
        System.arraycopy(stepsLastWeek, 0, this.stepsLastWeek, 0, this.stepsLastWeek.length);
        this.stepsToday = this.stepsLastWeek[dayOfWeek];
        this.daysWithStepsLastWeek = daysWithStepsLastWeek;
        this.dayOfWeek = dayOfWeek;
        this.millisToday = DateUtils.getMillisToday();
        this.dailyAverage = this.getDailyAverage();
        this.biggestNumberOfSteps = this.getBiggestNumberOfSteps();
        this.co2 = this.convertStepsToCO2(this.stepsToday);
        this.refresh();
    }

    public final void resetSteps() {
        this.stepsToday = 0;
        this.refresh();
    }

    public final void update(IObservable observable, Object argument) {
    }

    public final void update(IObservable observable, int argument) {
        this.stepsLastWeek[this.dayOfWeek] = this.stepsToday = argument;
        this.biggestNumberOfSteps = this.getBiggestNumberOfSteps();
        this.co2 = this.convertStepsToCO2(this.stepsToday);
        this.refresh();
    }

    private double convertStepsToCO2(int stepsToday) {
        this.co2Saved = (int)((double)stepsToday * StepSize * GramsPerMeterCo2);
        return this.co2Saved;
    }

    public final void update(IObservable observable, String argument) {
    }

    public final void update(IObservable observable, boolean argument) {
        this.manIsMoving = argument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.run = true;
        int updateCounter = 0;
        int animationWaitingTime = 0;
        long timer = 0L;
        while (this.run) {
            timer = System.currentTimeMillis() - timer;
            animationWaitingTime = timer >= (long)this.animationInterval ? this.animationInterval : this.animationInterval - (int)timer;
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Thread.sleep(animationWaitingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            timer = System.currentTimeMillis();
            if (!this.doAnimate) continue;
            if ((updateCounter += this.animationInterval) >= 1000) {
                updateCounter = 0;
                if (DateUtils.getMillisToday() != this.millisToday) {
                    this.eventListener.requestUpdate(this);
                }
            }
            if (this.isPastNextSwitchTimestamp()) {
                this.switchLine -= 20;
                if (this.switchLine <= 0) {
                    this.switchLine = 0;
                }
                this.switchText -= 10;
                if (this.switchText <= 0 || this.switchText <= 240 - this.switchCurrentTextWidth) {
                    this.switchText = 0;
                }
                if (this.switchLine == 0 && this.switchText == 0) {
                    ++this.switchStage;
                    if (this.switchStage == 2) {
                        this.switchStage = 0;
                        this.setNextSwitchTimestamp();
                    } else {
                        switch (LoopState) {
                            case 1: {
                                LoopState = 2;
                                break;
                            }
                            case 2: {
                                LoopState = 3;
                                break;
                            }
                            case 3: {
                                LoopState = 1;
                            }
                        }
                    }
                    this.switchLine = 240;
                    this.switchText = 240;
                }
            }
            this.repaint();
        }
    }

    public final void paint(Graphics g) {
        int i;
        g.setClip(0, 0, 240, 320);
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        g.drawImage(this.imageBackground, 0, this.coordsBackgroundY, 20);
        int scaleMax = 10000;
        while (scaleMax < this.biggestNumberOfSteps) {
            scaleMax += 5000;
        }
        double scaleFactor = (double)this.coordsScaleHeight / (double)scaleMax;
        int scaleStep = scaleMax / 5;
        int walkingPersonX = 0;
        int walkingPersonY = 0;
        g.setColor(0x4D4D4D);
        int[] yCoordsScale = new int[6];
        int i2 = 1;
        while (i2 != 6) {
            int y;
            yCoordsScale[i2] = y = this.coordsScaleZero - i2 * this.coordsScaleDistance - 1;
            g.drawLine(0, y, 240, y);
            FontRenderer.drawText(g, 1, y + 2, 4, 0, 0x838383, String.valueOf(scaleStep / 1000 * i2) + this.textKilo);
            ++i2;
        }
        if (this.switchStage == 0) {
            g.setClip(0, 0, this.switchLine, 320);
        } else {
            g.setClip(this.switchLine, 0, 240 - this.switchLine, 320);
        }
        if (LoopState == 1) {
            int healthY = this.coordsScaleZero - (int)(10000.0 * scaleFactor) - 1;
            boolean healthOverScaleLine = false;
            i = 1;
            while (i != 6) {
                if (healthY == yCoordsScale[i]) {
                    healthOverScaleLine = true;
                }
                ++i;
            }
            if (healthOverScaleLine) {
                g.setColor(0x202020);
                g.drawLine(0, healthY, 240, healthY);
            }
            g.setColor(5612828);
            i = 2;
            while (i < 240) {
                g.drawLine(i, healthY, i + 4, healthY);
                i += 10;
            }
        } else {
            int averageY = this.coordsScaleZero - (int)((double)this.dailyAverage * scaleFactor) - 1;
            if (averageY == this.coordsScaleZero - 1) {
                --averageY;
            }
            boolean averageOverScaleLine = false;
            i = 1;
            while (i != 6) {
                if (averageY == yCoordsScale[i]) {
                    averageOverScaleLine = true;
                }
                ++i;
            }
            if (averageOverScaleLine) {
                g.setColor(0x202020);
                g.drawLine(0, averageY, 240, averageY);
            }
            g.setColor(0xA0A0A0);
            i = 2;
            while (i < 240) {
                g.drawLine(i, averageY, i + 4, averageY);
                i += 10;
            }
        }
        g.setClip(0, 0, 240, 320);
        i2 = 0;
        while (i2 != this.stepsLastWeek.length) {
            int reflectionAdjustment;
            int angle = (int)MathUtils.round((double)Math.abs(i2 - 3) * 1.2);
            if (i2 - 3 < 0) {
                angle *= -1;
            }
            int barHeight = (int)((double)this.stepsLastWeek[i2] * scaleFactor) + 1;
            int barThisX = this.coordsBarStartX + (this.coordsBarWidth + this.coordsBarDistance) * i2;
            int n = reflectionAdjustment = barHeight < this.imageBarReflection.getHeight() ? (int)MathUtils.round((double)(this.imageBarReflection.getHeight() - barHeight) / 1.75) : 0;
            if (this.stepsLastWeek[i2] != 0) {
                if (angle > 0) {
                    g.setClip(barThisX - 2 - angle, this.coordsBarStartY - 4 - Math.abs(angle), angle + 2, this.imageBarReflection.getHeight());
                    g.drawImage(this.imageBarReflection, barThisX - 2 - angle, this.coordsBarStartY - 4 - Math.abs(angle) - reflectionAdjustment, 20);
                } else if (angle < 0) {
                    g.setClip(barThisX - 2 + this.coordsBarWidth, this.coordsBarStartY - 4 - Math.abs(angle), Math.abs(2 - angle), this.imageBarReflection.getHeight());
                    g.drawImage(this.imageBarReflection, barThisX - 2 + this.coordsBarWidth, this.coordsBarStartY - 4 - Math.abs(angle) - reflectionAdjustment, 20);
                }
                g.setClip(barThisX - 2, this.coordsBarStartY - 2, this.imageBarReflection.getWidth(), this.imageBarReflection.getHeight());
                g.drawImage(this.imageBarReflection, barThisX - 2, this.coordsBarStartY - 2 - reflectionAdjustment, 20);
                g.setClip(0, 0, 240, 320);
                g.drawImage(this.imageBarShadow, barThisX + this.coordsShadowDisplacementX - angle / 2 + 1, this.coordsBarStartY + this.coordsShadowDisplacementY, 20);
            }
            int perspectiveHeightCorrection = (int)MathUtils.round((double)(8 * barHeight) / (double)this.coordsScaleHeight);
            int perspective = 8 - perspectiveHeightCorrection;
            barHeight += perspectiveHeightCorrection;
            if (i2 == this.dayOfWeek) {
                walkingPersonX = this.coordsBarStartX + (this.coordsBarWidth + this.coordsBarDistance - 1) * this.dayOfWeek - 1 - (6 - this.dayOfWeek) / 2;
                walkingPersonY = this.coordsBarStartY - barHeight + 2 - (int)MathUtils.round((double)perspective / 2.0);
            }
            int xAdjustment = angle;
            while (xAdjustment != 0) {
                int p = (int)MathUtils.round((double)(Math.abs(xAdjustment) * perspective) / (double)Math.abs(angle) - (double)Math.abs(xAdjustment));
                int a = Math.abs(xAdjustment);
                if (this.stepsLastWeek[i2] != 0) {
                    if (this.stepsLastWeek[i2] >= 10000) {
                        if (i2 > this.dayOfWeek) {
                            g.setColor(1919488);
                        } else {
                            g.setColor(5934626);
                        }
                    } else if (i2 < this.dayOfWeek) {
                        g.setColor(6187634);
                    } else if (i2 > this.dayOfWeek) {
                        g.setColor(1778474);
                    } else {
                        g.setColor(8555151);
                    }
                    g.fillRect(barThisX - xAdjustment, this.coordsBarStartY - barHeight - a - p, this.coordsBarWidth, barHeight - a + p);
                    if (this.stepsLastWeek[i2] >= 10000) {
                        if (i2 > this.dayOfWeek) {
                            g.setColor(6652741);
                        } else {
                            g.setColor(6732841);
                        }
                    } else if (i2 < this.dayOfWeek) {
                        g.setColor(10857648);
                    } else if (i2 > this.dayOfWeek) {
                        g.setColor(6187634);
                    } else {
                        g.setColor(0xFFFFFF);
                    }
                    g.fillRect(barThisX - xAdjustment + (angle > 0 ? 1 : 0), this.coordsBarStartY - barHeight - a - p, this.coordsBarWidth - 1, p + 1);
                    g.drawLine(barThisX - xAdjustment, this.coordsBarStartY - barHeight - Math.abs(xAdjustment) - p, barThisX - xAdjustment + this.coordsBarWidth - 1, this.coordsBarStartY - barHeight - Math.abs(xAdjustment) - p);
                }
                if (angle < 0) {
                    ++xAdjustment;
                    continue;
                }
                --xAdjustment;
            }
            if (this.stepsLastWeek[i2] != 0) {
                if (angle == 0) {
                    if (this.stepsLastWeek[i2] >= 10000) {
                        if (i2 > this.dayOfWeek) {
                            g.setColor(6652741);
                        } else {
                            g.setColor(6732841);
                        }
                    } else if (i2 < this.dayOfWeek) {
                        g.setColor(10857648);
                    } else if (i2 > this.dayOfWeek) {
                        g.setColor(6187634);
                    } else {
                        g.setColor(0xFFFFFF);
                    }
                    g.fillRect(barThisX, this.coordsBarStartY - barHeight - perspective, this.coordsBarWidth, barHeight + perspective);
                }
                if (this.stepsLastWeek[i2] >= 10000) {
                    if (i2 > this.dayOfWeek) {
                        g.setColor(3170317);
                    } else {
                        g.setColor(5612828);
                    }
                } else if (i2 < this.dayOfWeek) {
                    g.setColor(8555151);
                } else if (i2 > this.dayOfWeek) {
                    g.setColor(3555914);
                } else {
                    g.setColor(10857648);
                }
                g.fillRect(barThisX, this.coordsBarStartY - barHeight, this.coordsBarWidth, barHeight);
                if (this.stepsLastWeek[i2] >= 10000) {
                    if (i2 > this.dayOfWeek) {
                        g.setColor(6652741);
                    } else {
                        g.setColor(6732841);
                    }
                } else if (i2 < this.dayOfWeek) {
                    g.setColor(10857648);
                } else if (i2 > this.dayOfWeek) {
                    g.setColor(6187634);
                } else {
                    g.setColor(0xFFFFFF);
                }
                g.drawLine(barThisX, this.coordsBarStartY - barHeight - 1, barThisX + this.coordsBarWidth - 1, this.coordsBarStartY - barHeight - 1);
            }
            FontRenderer.drawText(g, barThisX + this.coordsBarWidth / 2 + 2, this.coordsBarTextY + 1, 1, 0, 0, this.textWeekdays[i2]);
            int weekdayColor = i2 > this.dayOfWeek ? (this.stepsLastWeek[i2] >= 10000 ? 3170317 : 0x767777) : (this.stepsLastWeek[i2] >= 10000 ? 5612828 : 0xFFFFFF);
            FontRenderer.drawText(g, barThisX + this.coordsBarWidth / 2 + 1, this.coordsBarTextY, 1, 0, weekdayColor, this.textWeekdays[i2]);
            ++i2;
        }
        g.setClip(walkingPersonX, walkingPersonY - this.imageWalkingPersonWhite.getHeight(), 30, this.imageWalkingPersonWhite.getHeight() - 2);
        g.drawImage(this.stepsToday >= 10000 ? this.imageWalkingPersonHealth : this.imageWalkingPersonWhite, walkingPersonX - this.walkingPersonAnimationCounter * 30, walkingPersonY, 36);
        g.setClip(0, 0, 240, 320);
        if (this.manIsMoving || !this.manIsMoving && this.walkingPersonAnimationCounter != 15) {
            this.walkingPersonAnimationCounter = (this.walkingPersonAnimationCounter + 1) % 28;
        }
        g.setClip(0, 0, 240, 320);
        g.drawImage(this.imageResultsBackground, 0, this.coordsTextBackgroundY, 20);
        String steps = "" + this.stepsToday;
        String healthGoal = "10000";
        String average = "" + this.dailyAverage;
        String co2SavedToday = String.valueOf(this.co2Saved) + "g";
        FontRenderer.drawText(g, this.coordsLeftTextSmallX, this.coordsLeftTextSmallY, 4, 0, 0, this.textStepsToday);
        FontRenderer.drawText(g, this.coordsLeftTextBigX + 1, this.coordsLeftTextBigY + 1, 4, 2, 0, steps);
        FontRenderer.drawText(g, this.coordsLeftTextBigX, this.coordsLeftTextBigY, 4, 2, this.stepsToday >= 10000 ? 5612828 : 0xFFFFFF, steps);
        if (this.switchStage == 0) {
            g.setClip(0, 0, this.switchText, 320);
        } else {
            g.setClip(this.switchText, 0, 240 - this.switchText, 320);
        }
        if (LoopState == 1) {
            FontRenderer.drawText(g, this.coordsRightTextSmallX, this.coordsRightTextSmallY, 8, 0, 0, this.textHealthGoal);
            FontRenderer.drawText(g, this.coordsRightTextBigX + 1, this.coordsRightTextBigY + 1, 8, 1, 0, "10000");
            FontRenderer.drawText(g, this.coordsRightTextBigX, this.coordsRightTextBigY, 8, 1, 5612828, "10000");
        } else if (LoopState == 2) {
            FontRenderer.drawText(g, this.coordsRightTextSmallX, this.coordsRightTextSmallY, 8, 0, 0, this.textDailyAverage);
            FontRenderer.drawText(g, this.coordsRightTextBigX + 1, this.coordsRightTextBigY + 1, 8, 1, 0, average);
            FontRenderer.drawText(g, this.coordsRightTextBigX, this.coordsRightTextBigY, 8, 1, 0x909090, average);
        } else if (LoopState == 3) {
            g.drawImage(this.imageEcoIcon, this.coordsRightEcoIconX + 70, this.coordsRightEcoIconY + 3, 24);
            FontRenderer.drawText(g, this.coordsRightTextBigX + 1, this.coordsRightTextBigY + 1, 8, 1, 0, co2SavedToday);
            FontRenderer.drawText(g, this.coordsRightTextBigX, this.coordsRightTextBigY, 8, 1, 0x909090, co2SavedToday);
        }
        g.setClip(0, 0, 240, 320);
    }

    private final int getBiggestNumberOfSteps() {
        int steps = 0;
        int i = 0;
        while (i != this.stepsLastWeek.length) {
            if (this.stepsLastWeek[i] > steps) {
                steps = this.stepsLastWeek[i];
            }
            ++i;
        }
        return steps;
    }

    private final int getDailyAverage() {
        if (this.daysWithStepsLastWeek == 0) {
            return 0;
        }
        int average = 0;
        int i = 0;
        while (i != this.stepsLastWeek.length) {
            if (i != this.dayOfWeek) {
                average += this.stepsLastWeek[i];
            }
            ++i;
        }
        return (int)MathUtils.round((double)average / (double)this.daysWithStepsLastWeek);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refresh() {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    public final void showPopup() {
        this.showPopup = true;
        this.refresh();
    }

    public final void hidePopup() {
        this.showPopup = false;
        this.refresh();
    }

    public final boolean isPopupShowing() {
        return this.showPopup;
    }

    public final void setRightSoftKey(boolean isActive) {
        this.isActive = isActive;
        this.removeCommand(this.rskCommand);
        this.rskCommand = new Command(Translator.getMessage(isActive ? "JAVAAPPS_WM_EXIT_SK" : "JAVAAPPS_WM_BACK_SK"), 7, 1);
        this.addCommand(this.rskCommand);
    }
}

