/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.datastore;

import com.sonyericsson.walkmate.utils.DateUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Datastore {
    private static final String RECORDSTORE_NAME = "PEDWPMIDLET";

    public static final void resetStepsForToday() throws RecordStoreException {
        Datastore.setStepsForToday(0);
    }

    public static final void setStepsForToday(int steps) throws RecordStoreException {
        int[] date = DateUtils.convertMillisToDate(System.currentTimeMillis());
        Datastore.setSteps(steps, date[0], date[1], date[2]);
    }

    public static final void setSteps(int steps, int year, int month, int day) throws RecordStoreException {
        RecordStore recordStore = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
        int id = Datastore.getRecordId(recordStore, year, month, day);
        byte[] record = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeShort((short)year);
            dataOutputStream.writeByte((byte)month);
            dataOutputStream.writeByte((byte)day);
            dataOutputStream.writeInt(steps);
            dataOutputStream.flush();
            record = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
        if (id != -1 && record != null) {
            recordStore.setRecord(id, record, 0, record.length);
        } else if (record != null) {
            if (recordStore.getNumRecords() == 7) {
                int[] obsoleteIds = Datastore.getObsoleteRecordIds(recordStore, (short)year, (byte)month, (byte)day);
                int i = 0;
                while (i != obsoleteIds.length) {
                    recordStore.deleteRecord(obsoleteIds[i]);
                    ++i;
                }
            }
            recordStore.addRecord(record, 0, record.length);
        }
        recordStore.closeRecordStore();
    }

    public static final int getStepsForToday() throws RecordStoreException {
        int[] date = DateUtils.convertMillisToDate(System.currentTimeMillis());
        int steps = Datastore.getSteps(date[0], date[1], date[2]);
        if (steps == -1) {
            steps = 0;
        }
        return steps;
    }

    private static final int getSteps(int year, int month, int day) throws RecordStoreException {
        RecordStore recordStore = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
        int steps = -1;
        int id = Datastore.getRecordId(recordStore, year, month, day);
        if (id != -1) {
            byte[] record = recordStore.getRecord(id);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(record));
            try {
                dataInputStream.readShort();
                dataInputStream.readByte();
                dataInputStream.readByte();
                steps = dataInputStream.readInt();
                dataInputStream.close();
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
            }
        }
        recordStore.closeRecordStore();
        return steps;
    }

    public static final int[] getStepsForLastWeek() throws RecordStoreException {
        int[] stepsForLastWeek = new int[7];
        int[] date = DateUtils.convertMillisToDate(System.currentTimeMillis());
        long millisToday = DateUtils.convertDateToMillis((short)date[0], (byte)date[1], (byte)date[2]);
        int dayOfWeek = DateUtils.convertMillisToDayOfWeek(millisToday);
        long oneDayInMillis = 86400000L;
        int i = 0;
        while (i != 7) {
            date = DateUtils.convertMillisToDate(millisToday - (long)i * 86400000L);
            int steps = Datastore.getSteps(date[0], date[1], date[2]);
            if (steps == -1) {
                steps = 0;
            }
            stepsForLastWeek[(7 - i + dayOfWeek) % 7] = steps;
            ++i;
        }
        return stepsForLastWeek;
    }

    public static final int getDaysWithStepsLastWeek() throws RecordStoreException {
        int daysWithStepsLastWeek = 0;
        int[] date = DateUtils.convertMillisToDate(System.currentTimeMillis());
        long millisToday = DateUtils.convertDateToMillis((short)date[0], (byte)date[1], (byte)date[2]);
        int dayOfWeek = DateUtils.convertMillisToDayOfWeek(millisToday);
        long oneDayInMillis = 86400000L;
        int i = 1;
        while (i != 7) {
            date = DateUtils.convertMillisToDate(millisToday - (long)i * 86400000L);
            if (Datastore.getSteps(date[0], date[1], date[2]) != -1) {
                ++daysWithStepsLastWeek;
            }
            ++i;
        }
        return daysWithStepsLastWeek;
    }

    private static final int getRecordId(RecordStore recordStore, final int year, final int month, final int day) {
        RecordFilter recordFilter = new RecordFilter(){

            public boolean matches(byte[] candidate) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(candidate));
                try {
                    short matchYear = dataInputStream.readShort();
                    byte matchMonth = dataInputStream.readByte();
                    byte matchDay = dataInputStream.readByte();
                    dataInputStream.close();
                    if (year == matchYear && month == matchMonth && day == matchDay) {
                        return true;
                    }
                }
                catch (IOException ignored) {
                    ignored.printStackTrace();
                }
                return false;
            }
        };
        int id = -1;
        try {
            RecordEnumeration records = recordStore.enumerateRecords(recordFilter, null, false);
            if (records.hasNextElement()) {
                id = records.nextRecordId();
                records.destroy();
            }
        }
        catch (RecordStoreException ignored) {
            ignored.printStackTrace();
        }
        return id;
    }

    private static final int[] getObsoleteRecordIds(RecordStore recordStore, short year, byte month, byte day) {
        final long currentMillis = DateUtils.convertDateToMillis(year, month, day);
        final long oneWeekBackMillis = currentMillis - 604800000L;
        RecordFilter recordFilter = new RecordFilter(){

            public boolean matches(byte[] candidate) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(candidate));
                try {
                    short matchYear = dataInputStream.readShort();
                    byte matchMonth = dataInputStream.readByte();
                    byte matchDay = dataInputStream.readByte();
                    dataInputStream.close();
                    long matchMillis = DateUtils.convertDateToMillis(matchYear, matchMonth, matchDay);
                    if (matchMillis > currentMillis || matchMillis <= oneWeekBackMillis) {
                        return true;
                    }
                }
                catch (IOException ignored) {
                    ignored.printStackTrace();
                }
                return false;
            }
        };
        int[] obsoleteRecords = null;
        try {
            RecordEnumeration records = recordStore.enumerateRecords(recordFilter, null, false);
            obsoleteRecords = new int[records.numRecords()];
            int pos = 0;
            while (records.hasNextElement()) {
                int n = pos;
                pos = (byte)(n + 1);
                obsoleteRecords[n] = records.nextRecordId();
            }
            records.destroy();
        }
        catch (RecordStoreException ignored) {
            ignored.printStackTrace();
        }
        return obsoleteRecords;
    }
}

