/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class MenuTextImage {
    private BImage primaryImage;
    private BImage secondaryImage;
    private Image soloImage;
    private int yOffset;
    private int xOffset;
    private int xHalfSize;
    private int yHalfSize;
    private int width;
    private int height;
    private int primaryCount = 1;
    private int secondaryCount = 0;
    private int xSpacing = 0;
    private Sprite primarySprite = null;
    private Sprite secondarySprite = null;

    MenuTextImage(BImage img, int xOff, int yOff) {
        this.primaryImage = img;
        this.xOffset = xOff;
        this.yOffset = yOff;
        this.init();
    }

    MenuTextImage(Image img, int xOff, int yOff) {
        this.soloImage = img;
        this.xOffset = xOff;
        this.yOffset = yOff;
        this.init();
    }

    MenuTextImage(BImage priImg, BImage secImg, int priCount, int secCount, int space, int xOff, int yOff) {
        this.primaryImage = priImg;
        this.secondaryImage = secImg;
        this.primaryCount = priCount;
        this.secondaryCount = secCount;
        this.xSpacing = space;
        this.xOffset = xOff;
        this.yOffset = yOff;
        this.init();
    }

    MenuTextImage(Sprite spr, int xOff, int yOff) {
        this.primarySprite = spr;
        this.xOffset = xOff;
        this.yOffset = yOff;
        this.init();
    }

    MenuTextImage(Sprite spr, Sprite altSprite, int xOff, int yOff) {
        this.primarySprite = spr;
        this.secondarySprite = altSprite;
        this.xOffset = xOff;
        this.yOffset = yOff;
        this.init();
    }

    private void init() {
        if (this.primarySprite != null) {
            this.width = this.primarySprite.image.getWidth(0, this.primarySprite.frame);
            this.height = this.primarySprite.image.getHeight(0, this.primarySprite.frame);
        } else if (this.primaryImage != null) {
            this.width = this.primaryImage.getImageWidth();
            this.height = this.primaryImage.getImageHeight();
        } else if (this.soloImage != null) {
            this.width = this.soloImage.getWidth();
            this.height = this.soloImage.getHeight();
        }
        this.xHalfSize = this.width / 2;
        this.yHalfSize = this.height / 2;
    }

    public int getXSpacing() {
        return this.xSpacing;
    }

    public void drawTextImage(GraphicsHelper gh, int xPos, int yPos) {
        int i;
        boolean verbose = false;
        int currentX = xPos + this.xOffset;
        if (this.primaryImage != null) {
            for (i = 0; i < this.primaryCount; ++i) {
                this.primaryImage.paint(gh, currentX, yPos + this.yOffset, 0, 0);
                currentX += this.primaryImage.getImageWidth() + this.xSpacing;
            }
        }
        if (this.secondaryImage != null) {
            for (i = 0; i < this.secondaryCount; ++i) {
                this.secondaryImage.paint(gh, currentX, yPos + this.yOffset, 0, 0);
                currentX += this.secondaryImage.getImageWidth() + this.xSpacing;
            }
        }
    }

    private void drawSprite(GraphicsHelper gh, int xPos, int yPos, boolean useAltSprite) {
        if (this.primarySprite != null && !useAltSprite) {
            this.primarySprite.paint(gh, xPos + this.xOffset, yPos + this.yOffset);
        } else if (this.secondarySprite != null) {
            this.secondarySprite.paint(gh, xPos + this.xOffset, yPos + this.yOffset);
        }
    }

    public boolean isSprite() {
        return null == this.primarySprite;
    }

    void drawTextImage(GraphicsHelper gh, int xPos, int yPos, boolean useAlternateImage, boolean useOffsetAsAbsolute) {
        boolean verbose = false;
        if (this.primarySprite != null) {
            this.drawSprite(gh, xPos, yPos, useAlternateImage);
        } else {
            if (this.soloImage == null) {
                if (useAlternateImage && this.secondaryImage == null) {
                    return;
                }
                if (!useAlternateImage && this.primaryImage == null) {
                    return;
                }
            }
            int currentX = this.xOffset;
            int currentY = this.yOffset;
            if (!useOffsetAsAbsolute) {
                currentX += xPos;
                currentY += yPos;
            }
            if (this.soloImage != null) {
                if (!useOffsetAsAbsolute) {
                    gh.drawImage(this.soloImage, currentX, yPos + this.yOffset);
                } else {
                    gh.drawImage(this.soloImage, currentX, currentY);
                }
            } else {
                for (int i = 0; i < (useAlternateImage ? this.secondaryCount : this.primaryCount); ++i) {
                    if (useAlternateImage) {
                        this.secondaryImage.paint(gh, currentX, currentY, 0, 0);
                    } else {
                        this.primaryImage.paint(gh, currentX, currentY, 0, 0);
                    }
                    currentX += this.primaryImage.getImageWidth() + this.xSpacing;
                }
            }
        }
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public int getHalfSizeX() {
        return this.xHalfSize;
    }

    public int getHalfSizeY() {
        return this.yHalfSize;
    }

    public int getWidth() {
        return this.width;
    }

    public int getPrimaryWidth() {
        return this.width * this.primaryCount;
    }

    public int getSecondaryWidth() {
        return this.width * this.secondaryCount;
    }

    public int getHeight() {
        return this.height;
    }
}

