/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class SoundManager_MMAPI_MIDP20_RunnableBufferEOM
implements ISoundManager,
Runnable {
    private static String[] musicFiles = new String[0];
    private static boolean isSoundActivated = false;
    public static int playerState = 3;
    public static int playerActiveState = 0;
    private static boolean playerBlocked = false;
    private static int threadHashCode = -1;
    private static Player soundPlayer = null;
    private static int lastSoundIndex = -1;
    private static boolean lastLoopMusicIsLoop = false;
    private static int lastIndexLoopMusicNeedResume = -1;
    private static boolean lastSoundLoop = false;
    private static boolean repeatLastSound = false;
    private static int volumeLevel = 100;
    private InputStream _soundIS = null;
    private static int mainCount = 0;
    private static int nextSoundIndex = 0;
    private static boolean nextSoundLoop = false;
    private boolean needStopMusic = false;
    private static byte[][] StreamBuffer_music_tune = null;
    private static Thread workThread = null;
    private PlayerListener playerListener = new PlayerListener(){

        public void playerUpdate(Player player, String event, Object object) {
            if (event.equals("deviceAvailable")) {
                playerState = 0;
                if (playerBlocked) {
                    playerBlocked = false;
                    repeatLastSound = true;
                }
            } else if (event.equals("deviceUnavailable")) {
                playerState = 1;
                playerBlocked = true;
            } else if (event.equals("endOfMedia")) {
                playerState = 0;
                repeatLastSound = true;
            } else if (event.equals("stopped") || event.equals("error")) {
                if (playerState != 1) {
                    playerState = 0;
                    repeatLastSound = false;
                }
            } else if (event.equals("started")) {
                playerState = 2;
            }
        }
    };

    public boolean setMusicFiles(String[] files) {
        int i;
        musicFiles = files;
        StreamBuffer_music_tune = new byte[musicFiles.length][];
        for (i = 0; i < musicFiles.length; ++i) {
            int size = 0;
            InputStream is = this.getClass().getResourceAsStream(musicFiles[i]);
            try {
                while (is.read() != -1) {
                    ++size;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                is.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                is = null;
            }
            is = null;
            SoundManager_MMAPI_MIDP20_RunnableBufferEOM.StreamBuffer_music_tune[i] = new byte[size];
        }
        for (i = 0; i < musicFiles.length; ++i) {
            FilterInputStream dis = null;
            try {
                dis = new DataInputStream(this.getClass().getResourceAsStream(musicFiles[i]));
                for (int read_bytes = 0; read_bytes < StreamBuffer_music_tune[i].length; read_bytes += ((DataInputStream)dis).read(StreamBuffer_music_tune[i], read_bytes, StreamBuffer_music_tune[i].length - read_bytes)) {
                }
                try {
                    dis.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    dis = null;
                }
                dis = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    dis.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    dis = null;
                }
                --i;
            }
            Object var3_5 = null;
        }
        return true;
    }

    public void setSoundEnable(boolean isSoundOn) {
        isSoundActivated = isSoundOn;
        lastSoundIndex = -1;
        this.stopSound();
        if (isSoundOn) {
            playerActiveState = 0;
            playerState = 3;
        }
        if (isSoundActivated) {
            if (workThread == null) {
                workThread = new Thread(this);
                workThread.start();
            }
            new Thread(){

                public void run() {
                    while (isSoundActivated) {
                        try {
                            if (isSoundActivated && repeatLastSound && playerState == 0 && playerActiveState == 0) {
                                if (isSoundActivated && lastSoundIndex != -1 && lastSoundLoop) {
                                    Thread.sleep(200L);
                                    nextSoundIndex = lastSoundIndex;
                                    nextSoundLoop = false;
                                    repeatLastSound = !SoundManager_MMAPI_MIDP20_RunnableBufferEOM.this.playSound();
                                    lastSoundLoop = true;
                                    continue;
                                }
                                repeatLastSound = false;
                                continue;
                            }
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException ex) {
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }.start();
        } else {
            workThread = null;
        }
    }

    public boolean getSoundEnable() {
        return isSoundActivated;
    }

    public boolean setMusicDurations(long[] durations) {
        return true;
    }

    public boolean getUseMusicDurations() {
        return false;
    }

    public void pause() {
        if (playerActiveState == 1) {
            return;
        }
        playerActiveState = 1;
        if (!isSoundActivated) {
            return;
        }
        lastIndexLoopMusicNeedResume = lastLoopMusicIsLoop ? lastSoundIndex : -1;
        this.stopSound();
        lastSoundIndex = -1;
        playerState = 1;
    }

    public void resume(boolean isResumeMusic) {
        if (playerActiveState == 0) {
            return;
        }
        playerActiveState = 0;
        playerState = 3;
        if (!isSoundActivated) {
            return;
        }
        if (lastIndexLoopMusicNeedResume > -1 && !playerBlocked && !repeatLastSound && isResumeMusic) {
            while (!this.playSound(lastIndexLoopMusicNeedResume, false)) {
            }
        }
    }

    public int getPlayerState() {
        return playerState;
    }

    public boolean isPlayerStateBlocked() {
        return playerBlocked;
    }

    public int getLastSoundIndex() {
        return lastSoundIndex;
    }

    public int getVolume() {
        return volumeLevel;
    }

    public boolean setVolume(int value) {
        volumeLevel = value;
        try {
            ((VolumeControl)soundPlayer.getControl("VolumeControl")).setLevel(value);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean playSound(int index, boolean loop) {
        if (repeatLastSound) {
            return true;
        }
        if (playerState == 0) {
            return true;
        }
        if (!isSoundActivated || index < 0 || index >= musicFiles.length || playerState == 1 || playerActiveState == 1) {
            return false;
        }
        if (loop && lastLoopMusicIsLoop && index == lastSoundIndex) {
            return true;
        }
        this.needStopMusic = false;
        nextSoundIndex = index;
        nextSoundLoop = loop;
        lastSoundLoop = loop;
        ++mainCount;
        return true;
    }

    public void run() {
        threadHashCode = Thread.currentThread().getClass().hashCode();
        while (isSoundActivated && threadHashCode == Thread.currentThread().getClass().hashCode()) {
            if (!this.needStopMusic && isSoundActivated && mainCount > 0) {
                this.playSound();
                lastLoopMusicIsLoop = nextSoundLoop;
            }
            if (isSoundActivated && this.needStopMusic) {
                lastLoopMusicIsLoop = false;
                this.stopSound();
                this.needStopMusic = false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        lastLoopMusicIsLoop = false;
        this.stopSound();
        this.needStopMusic = false;
    }

    private boolean playSound() {
        this.stopSound();
        if (this.prefetch(nextSoundIndex)) {
            try {
                soundPlayer.realize();
                soundPlayer.addPlayerListener(this.playerListener);
                if (playerState == 1 || playerActiveState == 1) {
                    lastSoundIndex = nextSoundIndex;
                    mainCount = 0;
                    playerActiveState = 0;
                    this.pause();
                    return false;
                }
                soundPlayer.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            lastSoundIndex = nextSoundIndex;
            mainCount = 0;
            return true;
        }
        nextSoundIndex = -1;
        mainCount = 0;
        return false;
    }

    private boolean prefetch(int index) {
        this._soundIS = new DataInputStream(new ByteArrayInputStream(StreamBuffer_music_tune[index]));
        try {
            block8: {
                String mime = "audio/midi";
                String mime2 = null;
                if (musicFiles[index].toLowerCase().endsWith(".wav")) {
                    mime = "audio/x-wav";
                } else if (musicFiles[index].toLowerCase().endsWith(".mp3")) {
                    mime = "audio/mpeg";
                    mime2 = "audio/mp3";
                } else {
                    mime = musicFiles[index].toLowerCase().endsWith(".amr") ? "audio/amr" : "audio/midi";
                }
                try {
                    soundPlayer = Manager.createPlayer((InputStream)this._soundIS, (String)mime);
                }
                catch (MediaException mex) {
                    if (mime2 == null) break block8;
                    soundPlayer = Manager.createPlayer((InputStream)this._soundIS, (String)mime2);
                }
            }
            soundPlayer.prefetch();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public void stopSound(int index) {
        this.needStopMusic = true;
    }

    private void stopSound() {
        try {
            if (soundPlayer != null) {
                soundPlayer.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.closeSoundStream();
        soundPlayer = null;
        if (playerState == 2) {
            playerState = 3;
        }
    }

    private void closeSoundStream() {
        if (this._soundIS == null) {
            return;
        }
        try {
            this._soundIS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._soundIS = null;
    }
}

