/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Stat {
    static final String[] babble_languages = new String[]{"en-US", "fr-FR", "de-DE", "it-IT", "es-ES"};
    public static final int ENGLISH = 0;
    public static final int FRENCH = 1;
    public static final int GERMAN = 2;
    public static final int ITALIAN = 3;
    public static final int SPANISH = 4;
    static final String[][] babble_szSource = new String[][]{{"ENGLISH", "FRAN\u00c7AIS", "DEUTSCH", "ITALIANO", "ESPA\u00d1OL"}};
    public static final String[] pauseLabel = new String[]{"PAUSE", "PAUSE", "PAUSE", "PAUSE", "PAUSE"};
    public static final String[] backLabel = new String[]{"BACK", "RET.", "ZUR.", "IND.", "VOL."};
    public static int currentlySetLanguage = -1;
    static byte[] babdata;
    static byte babdialect;

    public static int getLanguage() {
        return currentlySetLanguage;
    }

    public static String my_bab(int w) {
        for (int i = 0; i < 4; ++i) {
            String s = Stat.bab(w);
            if (Stat.getLanguage() == 2 && OptionsViscount.SCREEN_SIZE_CATEGORY == 3 && w == 108) {
                s = s.substring(0, 713) + "\n" + s.substring(714);
            }
            if (null == s) continue;
            return s;
        }
        return null;
    }

    public static int bab_locale(String szLocale) {
        int idxDialect = -1;
        try {
            if (szLocale == null) {
                szLocale = System.getProperty("microedition.locale");
            }
        }
        catch (Exception ex) {
            szLocale = null;
        }
        if (babble_languages.length <= 1) {
            return 0;
        }
        if (szLocale != null) {
            int i;
            for (i = 0; i < babble_languages.length; ++i) {
                if (babble_languages[i].toLowerCase().compareTo(szLocale.toLowerCase()) != 0) continue;
                idxDialect = i;
                break;
            }
            if (idxDialect == -1) {
                for (i = 0; i < babble_languages.length; ++i) {
                    if (babble_languages[i].toLowerCase().substring(0, 2).compareTo(szLocale.toLowerCase().substring(0, 2)) != 0) continue;
                    idxDialect = i | 0x8000;
                    break;
                }
            }
        }
        return idxDialect;
    }

    public static void bab_init(String szBin, String szLocale, int idxDialect) {
        InputStream is = null;
        DataInputStream dis = null;
        try {
            int bytes;
            if (idxDialect < 0 && (idxDialect = Stat.bab_locale(szLocale)) == -1) {
                idxDialect = 0;
            }
            babdialect = (byte)(idxDialect & Short.MAX_VALUE);
            String resName = szBin + "." + babble_languages[babdialect];
            is = Runtime.getRuntime().getClass().getResourceAsStream(resName);
            dis = new DataInputStream(is);
            int size = dis.readInt();
            babdata = new byte[size];
            int offset = 0;
            while ((offset += (bytes = dis.read(babdata, offset, size - offset))) < size) {
            }
            dis.close();
            dis = null;
            is.close();
        }
        catch (IOException ex) {
            Util.out("ERROR: Couldn't load babble file." + ex);
        }
    }

    public static String bab(int w) {
        DataInputStream babdis = null;
        try {
            babdis = new DataInputStream(new ByteArrayInputStream(babdata));
            int offset = 1;
            if (w <= 0) {
                return babble_szSource[w - offset][babdialect];
            }
            babdis.reset();
            int skip0 = (w -= offset) << 2;
            babdis.skip(skip0);
            int skip1 = babdis.readInt();
            babdis.skip(skip1);
            int skip2 = 2;
            babdis.skip(2L);
            String sz = babdis.readUTF();
            babdis.close();
            babdis = null;
            if (sz == null) {
                sz = "null";
            }
            return sz;
        }
        catch (IOException ex) {
            Util.out("Couldn't find word " + w + " " + ex);
            return null;
        }
    }

    static {
        babdialect = 0;
    }
}

