/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class SoundManager_MMAPI_MIDP20_RunnableBuffer
implements ISoundManager,
Runnable {
    private static String[] musicFiles = new String[0];
    private static long[] musicDurations = null;
    private static long curDuration = 0L;
    private static int curDurationIndex = 0;
    private static Thread musicDurationThread = null;
    private static boolean isSoundActivated = false;
    private static int playerState = 3;
    private static int playerActiveState = 0;
    private static int threadHashCode = -1;
    private static Player soundPlayer = null;
    private static int lastSoundIndex = -1;
    private static boolean lastLoopMusicIsLoop = false;
    private static boolean lastLoopMusicNeedResume = false;
    private static int volumeLevel = 100;
    private static int mainCount = 0;
    private static int nextSoundIndex = 0;
    private static boolean nextSoundLoop = false;
    private boolean needStopMusic = false;
    private static byte[][] StreamBuffer_music_tune = null;
    private static Thread workThread = null;
    private VolumeControl vControl;
    private boolean waitPlay = false;
    private static boolean blockedRun = false;
    public static Vector info = new Vector();
    private PlayerListener playerListener = new PlayerListener(){

        public void playerUpdate(Player player, String event, Object object) {
            info.addElement(event);
            if (event.equals("deviceAvailable")) {
                playerState = 0;
            } else if (event.equals("deviceUnavailable")) {
                playerState = 1;
            } else if (event.equals("endOfMedia")) {
                playerState = 0;
            } else if (event.equals("stopped") || event.equals("error")) {
                if (playerState != 1) {
                    playerState = 0;
                }
            } else if (event.equals("started")) {
                Scene.instace.songStart();
                playerState = 2;
            }
        }
    };

    public boolean setMusicFiles(String[] files) {
        int i;
        musicFiles = files;
        StreamBuffer_music_tune = new byte[musicFiles.length][];
        for (i = 0; i < musicFiles.length; ++i) {
            int size = 0;
            InputStream is = this.getClass().getResourceAsStream(musicFiles[i]);
            try {
                while (is.read() != -1) {
                    ++size;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                is.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                is = null;
            }
            is = null;
            SoundManager_MMAPI_MIDP20_RunnableBuffer.StreamBuffer_music_tune[i] = new byte[size];
        }
        for (i = 0; i < musicFiles.length; ++i) {
            FilterInputStream dis = null;
            try {
                dis = new DataInputStream(this.getClass().getResourceAsStream(musicFiles[i]));
                for (int read_bytes = 0; read_bytes < StreamBuffer_music_tune[i].length; read_bytes += ((DataInputStream)dis).read(StreamBuffer_music_tune[i], read_bytes, StreamBuffer_music_tune[i].length - read_bytes)) {
                }
                try {
                    dis.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    dis = null;
                }
                dis = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    dis.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    dis = null;
                }
                --i;
            }
            Object var3_5 = null;
        }
        musicDurations = null;
        return true;
    }

    public void setSoundEnable(boolean isSoundOn) {
        this.stopSound(0);
        lastSoundIndex = -1;
        if (isSoundOn) {
            playerActiveState = 0;
            playerState = 3;
        }
        isSoundActivated = isSoundOn;
        if (isSoundOn) {
            if (workThread == null) {
                workThread = new Thread(this);
                workThread.start();
            }
        } else {
            workThread = null;
        }
    }

    public boolean getSoundEnable() {
        return isSoundActivated;
    }

    public boolean setMusicDurations(long[] durations) {
        if (durations == null || musicFiles == null) {
            return false;
        }
        if (durations.length != musicFiles.length) {
            return false;
        }
        musicDurations = new long[durations.length];
        for (int i = 0; i < durations.length; ++i) {
            SoundManager_MMAPI_MIDP20_RunnableBuffer.musicDurations[i] = Math.abs(durations[i]);
        }
        return true;
    }

    public boolean getUseMusicDurations() {
        return musicDurations != null;
    }

    public void pause() {
        if (playerActiveState == 1) {
            return;
        }
        playerActiveState = 1;
        if (!isSoundActivated) {
            return;
        }
        if (lastLoopMusicIsLoop && !this.needStopMusic) {
            lastLoopMusicNeedResume = true;
        }
        this.stopSound();
    }

    public void resume(boolean isResumeMusic) {
        if (playerActiveState == 0) {
            return;
        }
        playerActiveState = 0;
        playerState = 3;
        if (!isSoundActivated) {
            return;
        }
        if (lastLoopMusicNeedResume) {
            lastLoopMusicNeedResume = false;
            if (isResumeMusic) {
                this.playSound(lastSoundIndex, true);
            }
        }
    }

    public int getPlayerState() {
        return playerState;
    }

    public boolean isPlayerStateBlocked() {
        return playerState == 1;
    }

    public int getLastSoundIndex() {
        return lastSoundIndex;
    }

    public int getVolume() {
        return volumeLevel;
    }

    public boolean setVolume(int value) {
        volumeLevel = value;
        try {
            this.vControl = (VolumeControl)soundPlayer.getControl("VolumeControl");
            if (this.vControl != null) {
                this.vControl.setLevel(100);
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean playSound(int index, boolean loop) {
        if (!isSoundActivated || index < 0 || index >= musicFiles.length || playerState == 1 || playerActiveState == 1) {
            return false;
        }
        if (loop && lastLoopMusicIsLoop && index == lastSoundIndex && this.getPlayerState() == 2) {
            return true;
        }
        this.needStopMusic = false;
        nextSoundIndex = index;
        nextSoundLoop = loop;
        ++mainCount;
        return true;
    }

    public void run() {
        threadHashCode = Thread.currentThread().getClass().hashCode();
        while (isSoundActivated && threadHashCode == Thread.currentThread().getClass().hashCode()) {
            if (!this.needStopMusic) {
                if (mainCount > 0) {
                    lastLoopMusicIsLoop = false;
                    this.stopSound();
                    this.closePlayer();
                    soundPlayer = null;
                    if (playerState == 2) {
                        playerState = 3;
                    }
                    if (this.prefetch(nextSoundIndex)) {
                        lastLoopMusicIsLoop = nextSoundLoop;
                        try {
                            soundPlayer.realize();
                            soundPlayer.addPlayerListener(this.playerListener);
                            if (nextSoundLoop) {
                                soundPlayer.setLoopCount(-1);
                            } else {
                                soundPlayer.setLoopCount(1);
                            }
                            while (playerState == 1 && playerActiveState == 1) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                lastSoundIndex = nextSoundIndex;
                                mainCount = 0;
                            }
                            soundPlayer.start();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        lastSoundIndex = nextSoundIndex;
                        mainCount = 0;
                    } else {
                        nextSoundIndex = -1;
                        mainCount = 0;
                    }
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            if (this.needStopMusic) {
                lastLoopMusicIsLoop = false;
                this.stopSound();
                this.closePlayer();
                soundPlayer = null;
                if (playerState == 2) {
                    playerState = 3;
                }
                this.needStopMusic = false;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.stopSound();
        this.closePlayer();
        soundPlayer = null;
        this.needStopMusic = false;
    }

    private boolean prefetch(int index) {
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(StreamBuffer_music_tune[index]));
        try {
            block8: {
                String mime = "audio/midi";
                String mime2 = null;
                if (musicFiles[index].toLowerCase().endsWith(".wav")) {
                    mime = "audio/x-wav";
                } else if (musicFiles[index].toLowerCase().endsWith(".mp3")) {
                    mime = "audio/mpeg";
                    mime2 = "audio/mp3";
                } else {
                    mime = musicFiles[index].toLowerCase().endsWith(".amr") ? "audio/amr" : "audio/midi";
                }
                try {
                    soundPlayer = Manager.createPlayer((InputStream)is, (String)mime);
                }
                catch (MediaException mex) {
                    if (mime2 == null) break block8;
                    soundPlayer = Manager.createPlayer((InputStream)is, mime2);
                }
            }
            soundPlayer.prefetch();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        is = null;
        return true;
    }

    public void stopSound(int index) {
        this.needStopMusic = true;
    }

    private void stopSound() {
        try {
            if (soundPlayer != null) {
                soundPlayer.stop();
                soundPlayer.deallocate();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void closePlayer() {
        try {
            if (soundPlayer != null) {
                soundPlayer.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

