/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher.model;

import com.beeweeb.globallauncher.model.LauncherDataDocumentHandler;
import com.beeweeb.globallauncher.model.Network;
import com.beeweeb.globallauncher.util.Log;
import java.util.Vector;

public class Configuration {
    private int homeNetworkMCC;
    private int homeNetworkMNC;
    private int heartbeatInterval;
    private int LOCAL_previousHBinterval;
    private String heartbeatURL = "";
    private String disableURL;
    private String trustedContentHost = "";
    private Boolean disable;
    private int numRetries;
    private int retryInterval;
    private String handsetType = "";
    private Boolean roamingGPRSTeasers;
    private Boolean roamingGPRSHeartbeat;
    private Boolean roaming3GTeasers;
    private Boolean roaming3GHeartbeat;
    private long lastHeartbeatSentAt;
    private Vector networks = new Vector();

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(int n) {
        this.heartbeatInterval = n;
    }

    public String getHeartbeatURL() {
        return this.heartbeatURL;
    }

    public void setHeartbeatURL(String string) {
        this.heartbeatURL = string;
    }

    public String getDisableURL() {
        return this.disableURL;
    }

    public void setDisableURL(String string) {
        this.disableURL = string;
    }

    public String getTrustedContentHost() {
        return this.trustedContentHost;
    }

    public void setTrustedContentHost(String string) {
        this.trustedContentHost = string;
    }

    public Boolean getDisable() {
        return this.disable;
    }

    public void setDisable(Boolean bl) {
        this.disable = bl;
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public void setNumRetries(int n) {
        this.numRetries = n;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int n) {
        this.retryInterval = n;
    }

    public String getHandsetType() {
        return this.handsetType;
    }

    public void setHandsetType(String string) {
        this.handsetType = string;
    }

    public Boolean getRoamingGPRSTeasers() {
        return this.roamingGPRSTeasers;
    }

    public void setRoamingGPRSTeasers(Boolean bl) {
        this.roamingGPRSTeasers = bl;
    }

    public Boolean getRoaming3GTeasers() {
        return this.roaming3GTeasers;
    }

    public void setRoaming3GTeasers(Boolean bl) {
        this.roaming3GTeasers = bl;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<configuration ");
        if (this.heartbeatURL != null) {
            stringBuffer.append("heartbeaturl=\"" + LauncherDataDocumentHandler.escape(this.heartbeatURL) + "\" ");
        }
        stringBuffer.append("heartbeatinterval=\"" + this.heartbeatInterval + "\" ");
        if (this.LOCAL_previousHBinterval > 0) {
            stringBuffer.append("LOCAL_previousHBinterval=\"" + this.LOCAL_previousHBinterval + "\" ");
        }
        if (this.disableURL != null) {
            stringBuffer.append("disableurl=\"" + this.disableURL + "\" ");
        }
        stringBuffer.append("home_network_mcc=\"" + this.homeNetworkMCC + "\" ");
        stringBuffer.append("home_network_mnc=\"" + this.homeNetworkMNC + "\" ");
        stringBuffer.append("disable=\"" + this.disable + "\" ");
        stringBuffer.append("numretries=\"" + this.numRetries + "\" ");
        stringBuffer.append("retryinterval=\"" + this.retryInterval + "\" ");
        stringBuffer.append("handset_type=\"" + this.handsetType + "\" ");
        if (this.roamingGPRSTeasers != null) {
            stringBuffer.append("roaming_gprs_teasers=\"" + this.roamingGPRSTeasers + "\" ");
        }
        if (this.roamingGPRSHeartbeat != null) {
            stringBuffer.append("roaming_gprs_heartbeat=\"" + this.roamingGPRSHeartbeat + "\" ");
        }
        if (this.roaming3GTeasers != null) {
            stringBuffer.append("roaming_3g_teasers=\"" + this.roaming3GTeasers + "\"");
        }
        if (this.roaming3GHeartbeat != null) {
            stringBuffer.append("roaming_3g_heartbeat=\"" + this.roaming3GHeartbeat + "\" ");
        }
        stringBuffer.append("LOCAL_last_heartbeat_sent_at=\"" + this.lastHeartbeatSentAt + "\" ");
        stringBuffer.append(">");
        for (int i = 0; i < this.networks.size(); ++i) {
            Network network = (Network)this.networks.elementAt(i);
            stringBuffer.append("<roamingnetworkwhitelist mnc=\"" + network.getMnc() + "\" mcc=\"" + network.getMcc() + "\"/>");
        }
        stringBuffer.append("</configuration>");
        return stringBuffer.toString();
    }

    public Vector getNetworks() {
        return this.networks;
    }

    public void setNetworks(Vector vector) {
        this.networks = vector;
    }

    public Network getNetwork(int n) {
        return (Network)this.networks.elementAt(n);
    }

    public void addNetwork(Network network) {
        this.networks.addElement(network);
    }

    public int getHomeNetworkMCC() {
        return this.homeNetworkMCC;
    }

    public void setHomeNetworkMCC(int n) {
        this.homeNetworkMCC = n;
    }

    public int getHomeNetworkMNC() {
        return this.homeNetworkMNC;
    }

    public void setHomeNetworkMNC(int n) {
        this.homeNetworkMNC = n;
    }

    public Boolean getRoamingGPRSHeartbeat() {
        return this.roamingGPRSHeartbeat;
    }

    public void setRoamingGPRSHeartbeat(Boolean bl) {
        this.roamingGPRSHeartbeat = bl;
    }

    public Boolean getRoaming3GHeartbeat() {
        return this.roaming3GHeartbeat;
    }

    public void setRoaming3GHeartbeat(Boolean bl) {
        this.roaming3GHeartbeat = bl;
    }

    public int getLOCAL_previousHBinterval() {
        return this.LOCAL_previousHBinterval;
    }

    public void setLOCAL_previousHBinterval(int n) {
        Log.log("Saving previous heartbeat interval");
        this.LOCAL_previousHBinterval = n;
    }
}

