/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher.model;

import com.beeweeb.globallauncher.model.Access;
import com.beeweeb.globallauncher.model.Application;
import com.beeweeb.globallauncher.model.Item;
import com.beeweeb.globallauncher.model.Midlet;

public class Shortcut
extends Item {
    public static final int DEFAULT_BG_COLOR = 0xFFFFFF;
    public static final int POSITION_UP = 0;
    public static final int POSITION_DOWN = 1;
    public static final int TYPE_LINK_IMAGE = 0;
    public static final int TYPE_LINK_IMAGE_TEXT = 1;
    public static final int TYPE_LINK_TEXT = 2;
    private int position = -1;
    private int type = -1;
    private int bgColor = 0xFFFFFF;
    private boolean deletable = true;
    private boolean alwaysDisplay = false;
    private Application application;
    private String webURL;
    private Access access;
    private String LOCAL_ID;
    private int LOCAL_click_count;
    private boolean LOCAL_fromTeaser;
    private boolean LOCAL_flexed;

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int n) {
        this.bgColor = n;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean bl) {
        this.deletable = bl;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public boolean getAlwaysDisplay() {
        return this.alwaysDisplay;
    }

    public void setAlwaysDisplay(boolean bl) {
        this.alwaysDisplay = bl;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<shortcut ");
        switch (this.type) {
            case 0: {
                stringBuffer.append("type=\"link_image\" ");
                break;
            }
            case 1: {
                stringBuffer.append("type=\"link_image_text\" ");
                break;
            }
            case 2: {
                stringBuffer.append("type=\"link_text\" ");
            }
        }
        stringBuffer.append("alwaysdisplay=\"" + this.alwaysDisplay + "\" ");
        stringBuffer.append("deletable=\"" + this.deletable + "\" ");
        stringBuffer.append("LOCAL_fromteaser=\"" + this.LOCAL_fromTeaser + "\" ");
        stringBuffer.append("bgcolor=\"0x" + Integer.toHexString(this.bgColor) + "\" ");
        if (this.position != -1) {
            stringBuffer.append("position=\"" + (this.position == 0 ? "up" : "down") + "\" ");
        }
        if (this.LOCAL_click_count != 0) {
            stringBuffer.append("LOCAL_click_count=\"" + Integer.toString(this.LOCAL_click_count) + "\" ");
        }
        stringBuffer.append("LOCAL_flexed=\"" + this.LOCAL_flexed + "\" ");
        stringBuffer.append("> \n");
        if (this.imgSrc != null) {
            stringBuffer.append("<img src=\"" + this.imgSrc + "\" ");
            if (this.imgSrcDwl != null) {
                stringBuffer.append("srcdwl=\"" + this.imgSrcDwl + "\" ");
            }
            switch (this.align) {
                case 1: {
                    stringBuffer.append("align=\"right\" ");
                    break;
                }
                case 0: {
                    stringBuffer.append("align=\"left\" ");
                }
            }
            stringBuffer.append("/> \n");
        }
        if (this.title != null) {
            stringBuffer.append("<title text=\"" + this.title + "\"");
            if (this.titleColor != -1) {
                stringBuffer.append(" color=\"" + Integer.toHexString(this.titleColor) + "\"");
            }
            stringBuffer.append("/> \n");
        }
        if (this.body != null) {
            stringBuffer.append("<body text=\"" + this.body + "\"");
            if (this.titleColor != -1) {
                stringBuffer.append(" color=\"" + Integer.toHexString(this.bodyColor) + "\"");
            }
            stringBuffer.append("/> \n");
        }
        if (this.roamingText != null) {
            stringBuffer.append("<roamingnotification disable=\"" + this.roamingNotificationDisable + "\" > \n");
            stringBuffer.append("<roamingtext><![CDATA[" + this.roamingText + "]]></" + "roamingtext" + "> \n");
            stringBuffer.append("</roamingnotification> \n");
        } else {
            stringBuffer.append("<roamingnotification disable=\"" + this.roamingNotificationDisable + "\" /> \n");
        }
        if (this.webURL != null) {
            stringBuffer.append("<web href=\"" + this.webURL + "\"/> \n");
        } else if (this.application != null) {
            Midlet midlet = (Midlet)this.application;
            stringBuffer.append("<application> \n");
            stringBuffer.append("<midlet ");
            stringBuffer.append("MIDlet-Vendor=\"" + midlet.getVendor() + "\" ");
            stringBuffer.append("MIDlet-Name=\"" + midlet.getName() + "\" ");
            stringBuffer.append("MIDlet-X=\"" + midlet.getRealName() + "\" ");
            if (midlet.getSubstituteURL() != null) {
                stringBuffer.append("substituteURL=\"" + midlet.getSubstituteURL() + "\" ");
            }
            stringBuffer.append("/> \n");
            stringBuffer.append("</application> \n");
        }
        stringBuffer.append("</shortcut> \n");
        return stringBuffer.toString();
    }

    public String getLOCAL_ID() {
        return this.LOCAL_ID;
    }

    public void setLOCAL_ID(String string) {
        this.LOCAL_ID = string;
    }

    public String getWebURL() {
        return this.webURL;
    }

    public void setWebURL(String string) {
        this.webURL = string;
    }

    public int getLOCAL_click_count() {
        return this.LOCAL_click_count;
    }

    public void updateLOCAL_click_count() {
        ++this.LOCAL_click_count;
    }

    public boolean equals(Object object) {
        if (object instanceof Shortcut) {
            Shortcut shortcut = (Shortcut)object;
            if (shortcut.getWebURL() != null && this.getWebURL() != null && this.getWebURL().equals(shortcut.getWebURL())) {
                return true;
            }
            if (shortcut.getApplication() != null && this.getApplication() != null) {
                Midlet midlet = (Midlet)shortcut.getApplication();
                Midlet midlet2 = (Midlet)this.getApplication();
                return midlet.equals(midlet2);
            }
        } else {
            return super.equals(object);
        }
        return false;
    }

    public boolean isFromTeaser() {
        return this.LOCAL_fromTeaser;
    }

    public void setFromTeaser(boolean bl) {
        this.LOCAL_fromTeaser = bl;
    }

    public void setLOCAL_click_count(int n) {
        this.LOCAL_click_count = n;
    }

    public boolean isLOCAL_flexed() {
        return this.LOCAL_flexed;
    }

    public void setLOCAL_flexed(boolean bl) {
        this.LOCAL_flexed = bl;
    }
}

