/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher.net;

import com.beeweeb.globallauncher.Launcher;
import com.beeweeb.globallauncher.model.InstantLauncherData;
import com.beeweeb.globallauncher.model.Item;
import com.beeweeb.globallauncher.net.LauncherService;
import com.beeweeb.globallauncher.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class TaskLoadImage
implements Runnable {
    private LauncherService service;
    private HttpConnection connection;
    private InputStream input;
    private String url;
    private Item item;
    private InstantLauncherData instantLauncherData;
    private int attempt;

    public TaskLoadImage(LauncherService launcherService, InstantLauncherData instantLauncherData, Item item, String string) {
        this.service = launcherService;
        this.url = string;
        this.item = item;
        this.instantLauncherData = instantLauncherData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            this.connection = (HttpConnection)Connector.open((String)this.url);
            Log.log("Loading image: " + this.url);
            try {
                this.connection.setRequestProperty("User-Agent", "bwb/IL/" + this.instantLauncherData.getConfiguration().getHandsetType() + "/" + Launcher.VERSION);
            }
            catch (Exception exception) {
                Log.log(exception);
            }
            int n = this.connection.getResponseCode();
            if (n == 200) {
                int n2;
                this.input = this.connection.openInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[4096];
                while ((n2 = this.input.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                this.closeAll();
                this.service.fireImageDownloaded(this.item, this.url, byteArrayOutputStream.toByteArray());
                return;
            } else if (n == 301 || n == 302 || n == 303 || n == 307) {
                String string = this.connection.getHeaderField("Location");
                if (string == null) throw new Exception("Error in redirect");
                TaskLoadImage taskLoadImage = new TaskLoadImage(this.service, this.instantLauncherData, this.item, string);
                this.service.enqueueTask(taskLoadImage);
                return;
            } else if (n == 404) {
                return;
            } else {
                if (this.retry()) return;
                throw new Exception("Server error");
            }
        }
        catch (Exception exception) {
            Log.log(exception);
            if (this.retry()) return;
            this.service.fireDownloadImageFailed(this.item, this.url, exception);
            return;
        }
        finally {
            this.closeAll();
        }
    }

    private void closeAll() {
        if (this.input != null) {
            try {
                this.input.close();
                this.input = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Runtime.getRuntime().gc();
    }

    private boolean retry() {
        if (this.instantLauncherData.getConfiguration() != null && this.attempt < this.instantLauncherData.getConfiguration().getNumRetries()) {
            Log.log("Retrying download image " + this.url);
            TaskLoadImage taskLoadImage = new TaskLoadImage(this.service, this.instantLauncherData, this.item, this.url);
            taskLoadImage.attempt = this.attempt + 1;
            this.service.enqueueTaskAfter(taskLoadImage, this.instantLauncherData.getConfiguration().getRetryInterval() * 1000);
            return true;
        }
        return false;
    }
}

