/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher.ui;

import com.beeweeb.globallauncher.Controller;
import com.beeweeb.globallauncher.model.InstantLauncherData;
import com.beeweeb.globallauncher.model.Strip;
import com.beeweeb.globallauncher.util.Log;
import com.beeweeb.globallauncher.util.StringTokenizer;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class MainView
extends Canvas {
    public static final int MODE_LIST = 0;
    public static final int MODE_ALERT = 1;
    public static final int MODE_DELETE = 2;
    public static final int MODE_LOADING = 3;
    public static final int TYPE_ALERT_ROAMING = 0;
    public static final int TYPE_ALERT_MAX_SIZE = 1;
    public static final int TYPE_ALERT_RESET_CONFIRM = 2;
    public static final Command COMMAND_RUN = new Command("Run!", 1, 1);
    private static final String ESCAPE_SEQUENCE = "><<>><";
    private static final String RESET_SEQUENCE = "71739";
    private static final int HIGHLIGHT_COLOR = 255;
    private StringBuffer buffer = new StringBuffer();
    private static int ITEM_COUNT;
    private static final int CELL_SIZE = 25;
    private static final int BAR_WIDTH = 8;
    private static final int CURSOR_WIDTH = 6;
    private static int BAR_CURSOR_HEIGHT;
    private static int MARGIN;
    private int selectedItem;
    private int topItem;
    private int viewSize;
    private boolean full;
    private int topOffset = 0;
    private int lastKey;
    private Font font;
    private Font fontBold;
    private Font fontBig;
    private String alertMessage;
    private Vector alertMessageRows;
    private Image fade;
    private Image cancelIcon;
    private Image background;
    private int mode = 0;
    private int alertType = 0;
    private Controller controller;
    private Sprite loadingSprite;
    private Animator animator;

    public MainView(Controller controller) {
        this.controller = controller;
        this.init();
    }

    private void init() {
        this.setFullScreenMode(false);
        this.font = Font.getFont((int)64, (int)0, (int)8);
        this.fontBold = Font.getFont((int)64, (int)1, (int)8);
        this.fontBig = Font.getFont((int)64, (int)0, (int)0);
        if (this.fade == null) {
            try {
                this.fade = Image.createImage((String)"/fade.png");
            }
            catch (IOException iOException) {
                Log.log(iOException);
            }
        }
        if (this.cancelIcon == null) {
            try {
                this.cancelIcon = Image.createImage((String)"/cancel.png");
            }
            catch (Exception exception) {
                Log.log(exception);
            }
        }
        if (this.background == null) {
            try {
                this.background = Image.createImage((String)"/images/background.png");
            }
            catch (Exception exception) {
                Log.log(exception);
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.mode == 3) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.loadingSprite != null) {
                this.loadingSprite.paint(graphics);
            }
        } else {
            int n;
            graphics.setFont(this.font);
            int n2 = 20;
            int n3 = 20;
            if (this.background != null) {
                graphics.drawImage(this.background, 0, 0, 20);
            } else {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            InstantLauncherData instantLauncherData = this.controller.getLiveData();
            if (instantLauncherData.getTeaser() != null) {
                if (this.selectedItem == -1 && instantLauncherData.getTeaser().getStrip().getImgDwl() != null) {
                    graphics.drawImage(instantLauncherData.getTeaser().getStrip().getImgDwl(), 0, this.topOffset - 50, 20);
                } else if (instantLauncherData.getTeaser().getStrip().getImg() != null) {
                    graphics.drawImage(instantLauncherData.getTeaser().getStrip().getImg(), 0, this.topOffset - 50, 20);
                }
                if (instantLauncherData.getTeaser().getStrip().getType() == 1 || instantLauncherData.getTeaser().getStrip().getType() == 2) {
                    Strip strip = instantLauncherData.getTeaser().getStrip();
                    if (strip.getTitle() != null) {
                        graphics.setColor(strip.getTitleColor());
                        graphics.setFont(this.fontBig);
                        switch (strip.getAlign()) {
                            case 1: {
                                graphics.drawString(strip.getTitle(), 5, 3 + this.topOffset - 50, 20);
                                break;
                            }
                            case 0: {
                                if (ITEM_COUNT > this.viewSize) {
                                    graphics.drawString(strip.getTitle(), this.getWidth() - 8 - 5, 3 + this.topOffset - 50, 24);
                                    break;
                                }
                                graphics.drawString(strip.getTitle(), this.getWidth() - 5, 3 + this.topOffset - 50, 24);
                            }
                        }
                    }
                    if (strip.getBody() != null) {
                        graphics.setColor(strip.getBodyColor());
                        graphics.setFont(this.font);
                        switch (strip.getAlign()) {
                            case 1: {
                                graphics.drawString(strip.getBody(), 5, 24 + this.topOffset - 50, 20);
                                break;
                            }
                            case 0: {
                                if (ITEM_COUNT > this.viewSize) {
                                    graphics.drawString(strip.getBody(), this.getWidth() - 8 - 5, 24 + this.topOffset - 50, 24);
                                    break;
                                }
                                graphics.drawString(strip.getBody(), this.getWidth() - 5, 24 + this.topOffset - 50, 24);
                            }
                        }
                    }
                }
            }
            block12: for (n = 0; n < instantLauncherData.getShortcutCount(); ++n) {
                if ((instantLauncherData.getShortcut(n).getType() == 0 || instantLauncherData.getShortcut(n).getType() == 1) && instantLauncherData.getShortcut(n).getImg() != null) {
                    if (n == this.selectedItem) {
                        if (instantLauncherData.getShortcut(n).getImgDwl() != null) {
                            graphics.drawImage(instantLauncherData.getShortcut(n).getImgDwl(), 0, this.topOffset + 25 * n, 20);
                        } else {
                            graphics.drawImage(instantLauncherData.getShortcut(n).getImg(), 0, this.topOffset + 25 * n, 20);
                        }
                        if (this.mode == 2 && !instantLauncherData.getShortcut(n).isLOCAL_flexed()) {
                            graphics.drawImage(this.cancelIcon, 112, this.topOffset + 25 * n + 4, 20);
                        }
                    } else {
                        graphics.drawImage(instantLauncherData.getShortcut(n).getImg(), 0, this.topOffset + 25 * n, 20);
                    }
                }
                if (instantLauncherData.getShortcut(n).getType() == 2) {
                    int n4 = instantLauncherData.getShortcut(n).getBgColor();
                    graphics.setColor(n4);
                    graphics.fillRect(0, this.topOffset + 25 * n, 240, 25);
                }
                if (instantLauncherData.getShortcut(n).getType() != 2 && instantLauncherData.getShortcut(n).getType() != 1 || instantLauncherData.getShortcut(n).getTitle() == null) continue;
                if (n == this.selectedItem && instantLauncherData.getShortcut(n).getImgDwl() == null) {
                    graphics.setColor(255);
                } else {
                    graphics.setColor(instantLauncherData.getShortcut(n).getTitleColor());
                }
                switch (instantLauncherData.getShortcut(n).getAlign()) {
                    case 1: {
                        graphics.drawString(instantLauncherData.getShortcut(n).getTitle(), 5, 3 + this.topOffset + 25 * n, 20);
                        continue block12;
                    }
                    case 0: {
                        if (ITEM_COUNT > this.viewSize) {
                            graphics.drawString(instantLauncherData.getShortcut(n).getTitle(), this.getWidth() - 8 - 5, 3 + this.topOffset + 25 * n, 24);
                            continue block12;
                        }
                        graphics.drawString(instantLauncherData.getShortcut(n).getTitle(), this.getWidth() - 5, 3 + this.topOffset + 25 * n, 24);
                    }
                }
            }
            if (ITEM_COUNT > this.viewSize) {
                graphics.setColor(0xDDDDDD);
                graphics.fillRect(this.getWidth() - 8, 0, 7, this.getHeight() - 1);
                graphics.setColor(0);
                graphics.drawRect(this.getWidth() - 8, 0, 7, this.getHeight() - 1);
                graphics.setColor(0x777777);
                if (this.selectedItem == ITEM_COUNT - 1) {
                    graphics.fillRect(this.getWidth() - 8 + 1, this.getHeight() - 1 - BAR_CURSOR_HEIGHT, 6, BAR_CURSOR_HEIGHT);
                } else if (this.controller.isTeaserPresent()) {
                    graphics.fillRect(this.getWidth() - 8 + 1, BAR_CURSOR_HEIGHT * (this.selectedItem + 1) + 1, 6, BAR_CURSOR_HEIGHT);
                } else {
                    graphics.fillRect(this.getWidth() - 8 + 1, BAR_CURSOR_HEIGHT * this.selectedItem + 1, 6, BAR_CURSOR_HEIGHT);
                }
                graphics.setColor(0x555555);
                graphics.fillRect(0, this.topOffset + 25 * instantLauncherData.getShortcutCount(), this.getWidth() - 8, 4);
            }
            if (this.mode == 1) {
                if (this.fade != null) {
                    graphics.drawImage(this.fade, 0, 0, 20);
                }
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(10, 40, 220, this.getHeight() - 70);
                graphics.setColor(0);
                graphics.drawRect(10, 40, 220, this.getHeight() - 70);
                for (n = 0; n < this.alertMessageRows.size(); ++n) {
                    graphics.drawString(this.alertMessageRows.elementAt(n).toString(), 120, 50 + n * (this.font.getHeight() + 10), 17);
                }
                graphics.setFont(this.fontBold);
                graphics.setColor(255);
                graphics.drawString("OK", 120, this.getHeight() - 50, 17);
            }
        }
    }

    protected void keyPressed(int n) {
        this.lastKey = n;
        int n2 = this.getGameAction(n);
        if (this.mode == 0 || this.mode == 2 || this.mode == 3) {
            switch (n) {
                case 55: {
                    this.buffer.append("7");
                    this.checkEscapeSequence();
                    break;
                }
                case 49: {
                    this.buffer.append("1");
                    this.checkEscapeSequence();
                    break;
                }
                case 51: {
                    this.buffer.append("3");
                    this.checkEscapeSequence();
                    break;
                }
                case 57: {
                    this.buffer.append("9");
                    this.checkEscapeSequence();
                }
            }
            if (n2 != 0) {
                switch (n2) {
                    case 1: {
                        if (this.mode == 3) break;
                        if (this.controller.isTeaserPresent()) {
                            if (this.selectedItem == -1 && this.controller.getLiveData().getShortcutCount() != 0) {
                                this.selectedItem = this.controller.getLiveData().getShortcutCount() - 1;
                                this.topItem = this.selectedItem - this.viewSize + 3;
                                if (this.topItem >= 0) {
                                    this.topOffset = 50 - MARGIN - this.topItem * 25;
                                } else {
                                    this.topItem = 0;
                                    this.topOffset = 50;
                                }
                            } else if (this.selectedItem == 0) {
                                this.selectedItem = -1;
                                this.topItem = 0;
                                this.topOffset = 50;
                            } else if (this.selectedItem > 0) {
                                --this.selectedItem;
                                if (this.topItem >= this.selectedItem) {
                                    this.topOffset = 50 - this.topItem * 25;
                                    if (this.topItem > this.selectedItem) {
                                        --this.topItem;
                                        this.topOffset = 50 - this.topItem * 25;
                                    }
                                }
                            } else {
                                this.selectedItem = this.controller.getLiveData().getShortcutCount() - 1;
                                this.topItem = this.selectedItem - this.viewSize + 1;
                                if (this.topItem >= 0) {
                                    this.topOffset = 50 - MARGIN - this.topItem * 25;
                                } else {
                                    this.topItem = 0;
                                    this.topOffset = 50;
                                }
                            }
                        } else if (this.selectedItem > 0) {
                            --this.selectedItem;
                            if (this.topItem >= this.selectedItem) {
                                this.topOffset = this.controller.isTeaserPresent() ? 50 : 0;
                                this.topOffset = -(this.topItem * 25);
                                if (this.topItem > this.selectedItem) {
                                    --this.topItem;
                                    this.topOffset = -(this.topItem * 25);
                                }
                            }
                        } else {
                            this.selectedItem = this.controller.getLiveData().getShortcutCount() - 1;
                            this.topItem = this.selectedItem - this.viewSize;
                            if (this.topItem >= 0) {
                                this.topOffset = -MARGIN - this.topItem * 25;
                            } else {
                                this.topItem = 0;
                                this.topOffset = 0;
                            }
                        }
                        this.repaint();
                        break;
                    }
                    case 6: {
                        if (this.mode == 3) break;
                        if (this.selectedItem < ITEM_COUNT - 1) {
                            ++this.selectedItem;
                            if (this.controller.isTeaserPresent()) {
                                if (ITEM_COUNT + 2 > this.viewSize && this.selectedItem >= this.viewSize - 3) {
                                    this.topOffset = 50 - MARGIN - this.topItem * 25;
                                    if (-this.topItem + this.selectedItem > this.viewSize - 3) {
                                        ++this.topItem;
                                        this.topOffset = 50 - MARGIN - this.topItem * 25;
                                    }
                                }
                            } else if (this.selectedItem >= this.viewSize - 1) {
                                this.topOffset = -MARGIN - this.topItem * 25;
                                if (-this.topItem + this.selectedItem > this.viewSize - 1 && this.selectedItem != ITEM_COUNT - 1) {
                                    ++this.topItem;
                                    this.topOffset = -MARGIN - this.topItem * 25;
                                }
                            }
                            this.repaint();
                            break;
                        }
                        if (this.controller.isTeaserPresent()) {
                            this.selectedItem = -1;
                            this.topItem = 0;
                            this.topOffset = 50;
                        } else {
                            this.selectedItem = 0;
                            this.topItem = 0;
                            this.topOffset = 0;
                        }
                        this.repaint();
                        break;
                    }
                    case 2: {
                        this.buffer.append("<");
                        this.checkEscapeSequence();
                        break;
                    }
                    case 5: {
                        this.buffer.append(">");
                        this.checkEscapeSequence();
                        break;
                    }
                    case 8: {
                        if (this.mode != 0 && this.mode != 2) break;
                        try {
                            this.controller.selectApplication(this.selectedItem);
                            break;
                        }
                        catch (Exception exception) {
                            Log.log(exception);
                        }
                    }
                }
            } else if (this.mode != 3) {
                switch (n) {
                    case 53: {
                        try {
                            this.controller.selectApplication(this.selectedItem);
                            break;
                        }
                        catch (Exception exception) {
                            Log.log(exception);
                        }
                    }
                }
            }
        } else if (this.mode == 1 && n2 != 0) {
            switch (n2) {
                case 8: {
                    if (this.mode != 1) break;
                    this.controller.fireOnAlert();
                }
            }
        }
    }

    public void update() {
        if (this.controller.getLiveData() != null && (ITEM_COUNT = this.controller.getLiveData().getShortcutCount()) != 0) {
            this.viewSize = this.getHeight() / 25;
            MARGIN = 2 + this.getHeight() % 25;
            boolean bl = this.full = MARGIN == 0;
            if (!this.full) {
                // empty if block
            }
            BAR_CURSOR_HEIGHT = this.controller.getLiveData().getTeaser() != null ? 1 + this.getHeight() / (ITEM_COUNT + 2) : 1 + this.getHeight() / ITEM_COUNT;
        }
        if (this.controller.isTeaserPresent()) {
            this.topOffset = 50;
            this.selectedItem = -1;
        } else {
            this.topOffset = 0;
            this.selectedItem = 0;
        }
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    protected void showNotify() {
        this.controller.mainViewShowNotify();
    }

    private void checkEscapeSequence() {
        if (this.buffer.length() > 0 && this.buffer.toString().startsWith("7")) {
            if (RESET_SEQUENCE.length() == this.buffer.length()) {
                if (this.buffer.toString().equals(RESET_SEQUENCE)) {
                    this.controller.performMasterReset();
                }
                this.buffer = new StringBuffer();
            } else if (!RESET_SEQUENCE.substring(0, this.buffer.length()).equals(this.buffer.toString())) {
                this.buffer = new StringBuffer();
            }
        }
    }

    public void showAlert(String string, int n) {
        this.alertMessage = string;
        this.mode = 1;
        this.alertType = n;
        this.alertMessageRows = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        StringBuffer stringBuffer = new StringBuffer();
        this.alertMessageRows.addElement(stringBuffer);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringBuffer.toString() + " " + string2;
            if (this.font.stringWidth(string3) < 200) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" " + string2);
                    continue;
                }
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer = new StringBuffer();
            this.alertMessageRows.addElement(stringBuffer);
            stringBuffer.append(string2);
        }
        this.removeCommand(Controller.COMMAND_BACK);
        this.repaint();
    }

    public void closeAlert() {
        this.mode = 0;
        this.alertMessage = null;
        this.alertMessageRows.removeAllElements();
        this.addCommand(Controller.COMMAND_BACK);
        this.repaint();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
        if (n == 3) {
            if (this.animator == null) {
                this.animator = new Animator();
                this.animator.start();
            }
        } else {
            if (this.animator != null) {
                this.animator.halt();
                this.animator = null;
            }
            if (n == 0) {
                this.update();
            }
        }
        this.repaint();
    }

    public int getAlertType() {
        return this.alertType;
    }

    private void initLoaderSprite() {
        if (this.loadingSprite == null) {
            try {
                Image image = Image.createImage((String)"/loader.png");
                this.loadingSprite = new Sprite(image, 31, 31);
                this.loadingSprite.setPosition(105, this.getHeight() / 2 - 15);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void dispose() {
        if (this.animator != null) {
            this.animator.halt();
            this.animator = null;
        }
    }

    static {
        MARGIN = 0;
    }

    private class Animator
    extends Thread {
        private boolean halt;

        public Animator() {
            MainView.this.initLoaderSprite();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.halt) {
                if (MainView.this.loadingSprite != null) {
                    MainView.this.loadingSprite.nextFrame();
                }
                MainView.this.repaint();
                Animator animator = this;
                synchronized (animator) {
                    try {
                        this.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }

        public synchronized void halt() {
            this.halt = true;
            this.notify();
        }
    }
}

