/*
 * Decompiled with CFR 0.152.
 */
package actions;

import com.loboltd.javamap.action.cmd.GotoMapAction;
import com.loboltd.javamap.bean.Building;
import com.loboltd.javamap.location.Point;
import com.loboltd.javamap.map.MapCanvas;
import com.loboltd.javamap.map.MapLV1Canvas;
import com.loboltd.javamap.map.MapLV2.MapLV2Canvas;
import com.loboltd.javamap.map.NullAreaException;
import com.loboltd.javamap.util.CoordinateTool;
import com.loboltd.javamap.util.DataPool;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Ticker;
import net.kbox.Action;
import net.kbox.ActionForward;
import net.kbox.common.MsgResource;
import net.kbox.component.KCommand;
import search.Address;
import search.HSBCSearcher;

public class Zoom
implements Action {
    public void execute(KCommand cmd, Item item, Displayable dis, ActionForward forward, Hashtable parameters) throws Exception {
        int y;
        int x;
        MapCanvas mc = (MapCanvas)dis;
        MapCanvas nextMc = null;
        try {
            nextMc = mc.getNextMapCanvas();
        }
        catch (Exception exception) {
            // empty catch block
        }
        MsgResource msgRes = MsgResource.getInstance();
        if (mc instanceof MapLV1Canvas) {
            x = ((MapLV1Canvas)mc).getCusorX();
            y = ((MapLV1Canvas)mc).getCusorY();
        } else {
            x = mc.getCurrentX();
            y = mc.getCurrentY();
        }
        double ln = CoordinateTool.getLn(x, 0.0, 0.0, 0.0) + mc.getFixLn();
        double lat = mc.getFixLat() - CoordinateTool.getLat(0.0, y, 0.0, 0.0);
        Point p = new Point(ln, lat);
        parameters = new Hashtable<String, Object>();
        parameters.put("point", p);
        parameters.put("mapCanvas", nextMc);
        cmd.setParameters(parameters);
        DataPool.removeAttribute("filename");
        new GotoMapAction().execute(cmd, null, (Displayable)nextMc, forward, parameters);
        Object loadingObj = DataPool.getAttribute("LoadingBuildingThread");
        if (nextMc.getLV() != 1) {
            nextMc.setSelectedBuildingIndex(null);
            KCommand kcmd = new KCommand(msgRes.getMsg("PRODETAILS"), 8, 40, "MapClick", null);
            nextMc.addCommand(kcmd);
        }
        if (nextMc.getLV() != 1) {
            nextMc.setTicker(null);
            nextMc.setTicker(new Ticker(msgRes.getMsg("MAPTIPS")));
            double currentLn = nextMc.getCurrentLn();
            double currentLat = nextMc.getCurrentLat();
            DataPool.setAttribute("firstPoint", p);
            Vector buildings = nextMc.getShowOnMap();
            if (buildings != null) {
                Vector<Integer> selectedBuildingIndexs = new Vector<Integer>();
                int i = 0;
                while (i < buildings.size()) {
                    Building building = (Building)buildings.elementAt(i);
                    double addLn = Math.abs(building.getLn() - currentLn);
                    double addLat = Math.abs(building.getLat() - currentLat);
                    if (addLn < 4.0E-5 && addLat < 4.0E-5) {
                        selectedBuildingIndexs.addElement(new Integer(i));
                    }
                    ++i;
                }
                nextMc.setSelectedBuildingIndex(selectedBuildingIndexs);
            }
        }
        if (!(loadingObj != null && ((Thread)loadingObj).isAlive() || nextMc.getLV() == 1)) {
            final MapLV2Canvas mcl2 = (MapLV2Canvas)nextMc;
            Thread t = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1.toString());
                    }
                    Address[] as = new HSBCSearcher().searchAddressByCoordinate(mcl2.getCurrentLn(), mcl2.getCurrentLat(), 0.0036);
                    Vector<Address> showOnMap = new Vector<Address>();
                    if (as != null) {
                        int i = 0;
                        while (i < as.length) {
                            Address building = new Address();
                            building.setName(as[i].getName());
                            building.setAddress(as[i].getAddress());
                            building.setLat(as[i].getLat());
                            building.setLn(as[i].getLn());
                            building.setAddressId(as[i].getAddressId());
                            showOnMap.addElement(building);
                            ++i;
                        }
                    }
                    mcl2.setShowOnMap(showOnMap);
                    double currentLn = mcl2.getCurrentLn();
                    double currentLat = mcl2.getCurrentLat();
                    Vector buildings = mcl2.getShowOnMap();
                    if (buildings != null) {
                        Vector<Integer> selectedBuildingIndexs = new Vector<Integer>();
                        int i = 0;
                        while (i < buildings.size()) {
                            Building building = (Building)buildings.elementAt(i);
                            double addLn = Math.abs(building.getLn() - currentLn);
                            double addLat = Math.abs(building.getLat() - currentLat);
                            if (addLn < 4.5E-5 && addLat < 4.5E-5) {
                                selectedBuildingIndexs.addElement(new Integer(i));
                            }
                            ++i;
                        }
                        mcl2.setSelectedBuildingIndex(selectedBuildingIndexs);
                    }
                    try {
                        mcl2.reflash();
                    }
                    catch (NullAreaException e) {
                        throw new RuntimeException(e.toString());
                    }
                }
            };
            DataPool.setAttribute("LoadingBuildingThread", t);
            t.setPriority(1);
            t.start();
        }
    }
}

