/*
 * Decompiled with CFR 0.152.
 */
package com.mgie.lib.cam;

import com.mgie.lib.cam.ImageOp;
import com.mgie.lib.cam.MGIECamera;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CapturedImage {
    public String format;
    public int w;
    public int h;
    public byte[] data;
    public int[] intData;

    public CapturedImage(String string, int n, int n2, byte[] byArray) {
        this.format = string;
        this.w = n;
        this.h = n2;
        this.data = byArray;
    }

    public CapturedImage(String string, int n, int n2, int[] nArray) {
        this.format = string;
        this.w = n;
        this.h = n2;
        this.intData = nArray;
    }

    public int getRawTypeID() {
        for (int i = 0; i < MGIECamera.RGB_FORMAT.length; ++i) {
            if (!this.format.equals(MGIECamera.RGB_FORMAT[i])) continue;
            return i;
        }
        return -1;
    }

    public Image toImage(int[] nArray, Image image) {
        boolean bl;
        Image image2 = null;
        boolean bl2 = bl = image != null && image.getWidth() >= this.w && image.getHeight() >= this.h;
        if (this.isFullIntFormat()) {
            if (bl) {
                Graphics graphics = image.getGraphics();
                graphics.drawRGB(this.intData, 0, this.w, 0, 0, this.w, this.h, false);
                return image;
            }
            image2 = Image.createImage((int)this.w, (int)this.h);
            image2.getGraphics().drawRGB(this.intData, 0, this.w, 0, 0, this.w, this.h, false);
        } else {
            int n = this.getRawTypeID();
            try {
                if (n >= 0) {
                    int[] nArray2 = ImageOp.toRGBFormat(this.data, MGIECamera.RGB_FORMAT_BIT[n], nArray);
                    if (bl) {
                        Graphics graphics = image.getGraphics();
                        graphics.drawRGB(nArray2, 0, this.w, 0, 0, this.w, this.h, false);
                        return image;
                    }
                    image2 = Image.createImage((int)this.w, (int)this.h);
                    image2.getGraphics().drawRGB(nArray2, 0, this.w, 0, 0, this.w, this.h, false);
                } else {
                    image2 = Image.createImage((byte[])this.data, (int)0, (int)this.data.length);
                    if (bl) {
                        image.getGraphics().drawImage(image2, 0, 0, 20);
                        image2 = image;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return image2;
    }

    public boolean isFullIntFormat() {
        return "ARGB".equals(this.format);
    }

    public byte[] getByteData(int n) {
        if (this.isFullIntFormat()) {
            return ImageOp.toByteFormat(this.intData, n, null);
        }
        int n2 = this.getRawTypeID();
        if (n2 >= 0) {
            if (MGIECamera.RGB_FORMAT_BIT[n2] == n) {
                return this.data;
            }
            int[] nArray = ImageOp.toRGBFormat(this.data, MGIECamera.RGB_FORMAT_BIT[n2], null);
            return ImageOp.toByteFormat(nArray, n, null);
        }
        Image image = Image.createImage((byte[])this.data, (int)0, (int)this.data.length);
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        int[] nArray = new int[n3 * n4];
        image.getRGB(nArray, 0, n3, 0, 0, n3, n4);
        return ImageOp.toByteFormat(nArray, n, null);
    }
}

