/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene;

import com.pacmobile.yp.mypcard.midlet.MYPCardMIDlet;
import com.pacmobile.yp.mypcard.rms.LanguageRMS;
import com.pacmobile.yp.mypcard.scene.Scene;
import com.pacmobile.yp.mypcard.scene.SceneController;
import com.pacmobile.yp.mypcard.scene.canvas.BaseCanvas;
import com.pacmobile.yp.mypcard.scene.canvas.MainMenuCanvas;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItem;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItemStyle;
import com.pacmobile.yp.mypcard.scene.canvas.item.SpacerCanvasItem;
import com.pacmobile.yp.mypcard.scene.canvas.item.StringCanvasItem;
import com.pacmobile.yp.mypcard.utility.Locale;
import com.pacmobile.yp.mypcard.utility.MsgUtility;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public class PreferencesScene
extends Scene {
    Image preferencesIconImage = null;
    MainMenuCanvas canvas = null;
    boolean isDefaultFocus = true;
    int selectedItemIndex = 3;
    boolean isPersonalDetailUpdated = false;
    private Command cmdExit = null;
    private Command cmdBack = null;
    private Command cmdSelect = null;
    StringCanvasItem languageSwapStringItem = null;
    StringCanvasItem perferencesStringItem = null;
    StringCanvasItem internetSettingStringItem = null;
    StringCanvasItem personalDetailUpdateStringItem = null;
    StringCanvasItem actNowToWinPrizesStringItem = null;
    StringCanvasItem informationUpdatedStringItem = null;
    SpacerCanvasItem spacerCanvasItem = null;
    StringCanvasItem backToMainMenuStringItem = null;

    public PreferencesScene() {
        this.prevSceneName = "MainMenuScene";
        try {
            this.preferencesIconImage = Image.createImage((String)"/images/icon_preferences.png");
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        this.canvas = new MainMenuCanvas();
        this.spacerCanvasItem = new SpacerCanvasItem(this.canvas, this.canvas.getWidth() - this.canvas.getScrollBarWidth());
        this.loadPage();
    }

    public void loadPage() {
        this.canvas.setContentRelativeY(0);
        if (this.canvas != null) {
            this.canvas.clearAllItems();
            this.canvas.removeAllCommands();
            this.canvas.removeSelectCommand();
            this.cmdSelect = new Command(MsgUtility.getMessage("label.select"), 8, 1);
            this.canvas.setSelectCommand(this.cmdSelect);
            this.canvas.addCommand(this.cmdSelect, BaseCanvas.COMMAND_SOFTKEY_SIDE_LEFT);
            this.cmdExit = new Command(MsgUtility.getMessage("label.exit"), 7, 1);
            this.cmdBack = new Command(MsgUtility.getMessage("label.back"), 2, 1);
            this.canvas.addCommand(this.cmdExit, BaseCanvas.COMMAND_SOFTKEY_SIDE_RIGHT);
            this.canvas.setBackCommand(this.cmdBack);
            this.languageSwapStringItem = new StringCanvasItem(this.canvas, MsgUtility.getMessage("language.swapTo"), null, CanvasItemStyle.languageButtonStyle.getFont().stringWidth(MsgUtility.getMessage("language.swapTo")), true, CanvasItemStyle.languageButtonStyle);
            this.perferencesStringItem = new StringCanvasItem(this.canvas, MsgUtility.getMessage("mainMenu.function.preferences"), this.preferencesIconImage, this.canvas.getWidth() - this.canvas.getScrollBarWidth(), false, CanvasItemStyle.titleStyle);
            this.internetSettingStringItem = new StringCanvasItem(this.canvas, MsgUtility.getMessage("preferences.internet.setting.title"), null, this.canvas.getWidth() - this.canvas.getScrollBarWidth(), true, CanvasItemStyle.underlineBulletedDefaultStyle);
            this.personalDetailUpdateStringItem = new StringCanvasItem(this.canvas, MsgUtility.getMessage("preferences.personal.details.update.title"), null, this.canvas.getWidth() - this.canvas.getScrollBarWidth(), true, CanvasItemStyle.underlineBulletedDefaultStyle);
            this.actNowToWinPrizesStringItem = new StringCanvasItem(this.canvas, MsgUtility.getMessage("preferences.personal.details.update.act.now.to.win.prizes"), null, this.canvas.getWidth() - this.canvas.getScrollBarWidth(), false, CanvasItemStyle.flashingDefaultStyle);
            this.actNowToWinPrizesStringItem.setIsFlash(true);
            this.canvas.addItem(this.languageSwapStringItem);
            this.canvas.addItem(this.spacerCanvasItem);
            this.canvas.addItem(this.perferencesStringItem);
            this.canvas.addItem(this.personalDetailUpdateStringItem);
            this.canvas.addItem(this.internetSettingStringItem);
            if (this.isPersonalDetailUpdated) {
                this.informationUpdatedStringItem = new StringCanvasItem(this.canvas, MsgUtility.getMessage("personal.information.updated"), null, this.canvas.getWidth() - this.canvas.getScrollBarWidth(), false, CanvasItemStyle.defaultStyle);
                this.informationUpdatedStringItem.setIsWarning(true);
                this.canvas.addItem(this.informationUpdatedStringItem);
            }
            this.canvas.addItem(this.spacerCanvasItem);
            this.canvas.addItem(this.actNowToWinPrizesStringItem);
            this.canvas.addItem(this.spacerCanvasItem);
            this.backToMainMenuStringItem = new StringCanvasItem(this.canvas, MsgUtility.getMessage("label.back"), null, CanvasItemStyle.buttonUnderlineDefaultStyle.getFont().stringWidth(MsgUtility.getMessage("label.back")), true, CanvasItemStyle.buttonUnderlineDefaultStyle);
            this.canvas.addItem(this.backToMainMenuStringItem);
            if (this.isDefaultFocus) {
                this.canvas.setSelectedItemIndex(this.personalDetailUpdateStringItem);
                this.isDefaultFocus = false;
            } else {
                this.canvas.selectItem(this.selectedItemIndex);
            }
        }
    }

    public void disableCancelButton() {
    }

    public void display() {
        if (this.canvas != null) {
            this.canvas.setCommandListener(this);
        }
    }

    public Displayable getDisplayable() {
        return this.canvas;
    }

    public void commandAction(Command cmd, Displayable arg1) {
        if (this.canvas != null) {
            CanvasItem canvasItem = this.canvas.getSelectedItem();
            if (cmd == this.cmdBack) {
                if (this.prevSceneName != null) {
                    SceneController.getInstance().forward(this.prevSceneName, this);
                }
            } else if (cmd == this.cmdExit) {
                if (this.midlet instanceof MYPCardMIDlet) {
                    ((MYPCardMIDlet)this.midlet).quit(false);
                }
            } else if (cmd == this.cmdSelect) {
                this.selectedItemIndex = this.canvas.getSelectedItemIndex();
                if (canvasItem != null) {
                    if (canvasItem == this.internetSettingStringItem) {
                        SceneController.getInstance().forward("InternetSettingScene", this);
                    } else if (canvasItem == this.personalDetailUpdateStringItem) {
                        SceneController.getInstance().forward("PersonalDetailUpdateScene", this);
                    } else if (canvasItem == this.languageSwapStringItem) {
                        if (Locale.getDefaultLocale().equals(Locale.localeEN)) {
                            Locale.setDefaultLocale(Locale.localeZH);
                        } else {
                            Locale.setDefaultLocale(Locale.localeEN);
                        }
                        LanguageRMS.saveLanguage();
                        MsgUtility.reloadMessage();
                        this.loadPage();
                    }
                }
                if (canvasItem == this.backToMainMenuStringItem && this.prevSceneName != null) {
                    SceneController.getInstance().forward(this.prevSceneName, this);
                }
            }
        }
    }

    public void draw() {
        try {
            if (this.canvas != null) {
                this.canvas.draw();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isPersonalDetailUpdated() {
        return this.isPersonalDetailUpdated;
    }

    public void setIsPersonalDetailUpdated(boolean isPersonalDetailUpdated) {
        this.isPersonalDetailUpdated = isPersonalDetailUpdated;
    }

    public void unload() {
        if (this.canvas != null) {
            this.canvas.unload();
            this.canvas = null;
        }
        this.cmdExit = null;
        this.cmdBack = null;
        this.cmdSelect = null;
        this.spacerCanvasItem = null;
        this.languageSwapStringItem = null;
        this.perferencesStringItem = null;
        this.internetSettingStringItem = null;
        this.personalDetailUpdateStringItem = null;
        this.actNowToWinPrizesStringItem = null;
        this.informationUpdatedStringItem = null;
        this.backToMainMenuStringItem = null;
        this.preferencesIconImage = null;
        System.gc();
        super.unload();
    }
}

