/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene.canvas.item;

import com.pacmobile.yp.mypcard.scene.canvas.BaseCanvas;
import com.pacmobile.yp.mypcard.scene.canvas.Color;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItem;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItemStyle;
import com.pacmobile.yp.mypcard.utility.LineEnumeration;
import com.pacmobile.yp.mypcard.utility.MsgUtility;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class StringCanvasItem
extends CanvasItem {
    long flashTime = System.currentTimeMillis();
    long flashTimePeriod = 750L;
    boolean flashFlag = false;
    boolean isFlash = false;
    boolean isSmallFont = false;
    boolean isWarning = false;
    Vector stringList = new Vector();
    Font font = Font.getFont((int)0);
    int fontHeight = this.font.getHeight();
    Image iconImage = null;
    LineEnumeration lineEnumeration = null;
    String bulletString = "";

    public StringCanvasItem(BaseCanvas canvas, String string, int itemWidth) {
        this(canvas, string, itemWidth, false);
    }

    public StringCanvasItem(BaseCanvas canvas, int itemWidth, boolean isSelectable) {
        this(canvas);
        this.setItemWidth(itemWidth);
        this.setSelectable(isSelectable);
        this.canvasItemStyle = new CanvasItemStyle();
        this.font = this.canvasItemStyle.getFont();
        this.bulletString = String.valueOf(MsgUtility.getMessage("bullet.sign")) + " ";
    }

    public StringCanvasItem(BaseCanvas canvas, String string, Image iconImage, int itemWidth) {
        this(canvas, string, iconImage, itemWidth, false);
    }

    public StringCanvasItem(BaseCanvas canvas, String string, Image iconImage, int itemWidth, boolean isSelectable) {
        this(canvas, string, iconImage, itemWidth, isSelectable, new CanvasItemStyle());
    }

    public StringCanvasItem(BaseCanvas canvas, String string, Image iconImage, int itemWidth, boolean isSelectable, CanvasItemStyle canvasItemStyle) {
        this(canvas, itemWidth, isSelectable);
        this.canvasItemStyle = canvasItemStyle;
        this.font = this.canvasItemStyle.getFont();
        this.iconImage = iconImage;
        this.addString(string);
    }

    public StringCanvasItem(BaseCanvas canvas, String string, int itemWidth, boolean isSelectable) {
        this(canvas, string, null, itemWidth, isSelectable, new CanvasItemStyle());
    }

    public StringCanvasItem(BaseCanvas canvas) {
        super(canvas);
        this.setSelectable(false);
        this.lineEnumeration = new LineEnumeration(this.font, "", 0);
    }

    public void setIsFlash(boolean isFlash) {
        this.isFlash = isFlash;
    }

    public boolean isFlash() {
        return this.isFlash;
    }

    public void setIsSmallFont(boolean isSmallFont) {
        this.isSmallFont = isSmallFont;
    }

    public boolean isSmallFont() {
        return this.isSmallFont;
    }

    public void setIsWarning(boolean isWarning) {
        this.isWarning = isWarning;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public void addString(String string) {
        int stringWidth = this.getItemWidth();
        if (this.iconImage != null) {
            stringWidth -= this.iconImage.getWidth();
        }
        if (this.iconImage != null) {
            stringWidth -= this.iconImage.getWidth();
            stringWidth -= this.font.stringWidth("  ");
        }
        String newString = string;
        if (this.canvasItemStyle.isBulleted()) {
            newString = String.valueOf(this.bulletString) + string;
        }
        this.lineEnumeration.reset(this.font, newString, stringWidth);
        String[] stringArray = this.lineEnumeration.getStringArray();
        if (stringArray != null && stringArray.length > 0) {
            int i = 0;
            while (i < stringArray.length) {
                if (i == 0 && this.canvasItemStyle.isBulleted() && stringArray[i] != null && stringArray[i].length() > 2) {
                    stringArray[i] = stringArray[i].substring(2);
                }
                this.stringList.addElement(stringArray[i]);
                ++i;
            }
        }
        stringArray = null;
        System.gc();
    }

    public int getItemHeight() {
        int height = 0;
        if (this.stringList != null && this.stringList.size() > 0) {
            height = this.fontHeight * this.stringList.size();
        }
        if (this.iconImage != null && this.iconImage.getHeight() > height) {
            height = this.iconImage.getHeight();
        }
        return height;
    }

    public int draw(Graphics g, int x, int y) {
        int initY = y;
        if (this.stringList != null && this.stringList.size() > 0) {
            if (this.canvasItemStyle.getItemAlign() == CanvasItemStyle.ITEM_ALIGN_CENTER) {
                if (this.canvas != null) {
                    x = (this.canvas.getWidth() - this.canvas.getScrollBarWidth() - this.getItemWidth()) / 2;
                }
            } else if (this.canvasItemStyle.getItemAlign() == CanvasItemStyle.ITEM_ALIGN_RIGHT && this.canvas != null) {
                x = this.canvas.getWidth() - this.canvas.getScrollBarWidth() - this.getItemWidth();
            }
            this.isFlash = this.canvasItemStyle.isFlashing();
            boolean isButton = false;
            if (this.canvasItemStyle.isButton()) {
                isButton = true;
            }
            if (isButton) {
                g.setColor(Color.BUTTON_COLOR);
                g.fillRect(x, y, this.getItemWidth() - 1, this.getItemHeight() - 1);
            }
            if (this.isHightlighted()) {
                if (isButton) {
                    g.setColor(Color.BUTTON_HIGHTLIGHTED_COLOR);
                } else {
                    g.setColor(Color.DEFAULT_ITEM_CONTENT_BG_COLOR);
                }
                g.fillRect(x, y, this.getItemWidth(), this.getItemHeight());
            } else if (this.canvasItemStyle.isFlashing && this.flashFlag) {
                g.setColor(0xFFFFFF);
                g.fillRect(x, y, this.getItemWidth(), this.getItemHeight());
            }
            if (isButton) {
                g.setColor(Color.BUTTON_BORDER_COLOR);
                g.drawRect(x, y, this.getItemWidth() - 1, this.getItemHeight() - 1);
            }
            Font itemFont = null;
            try {
                itemFont = Font.getFont((int)this.canvasItemStyle.getItemFontFace(), (int)this.canvasItemStyle.getItemFontStyle(), (int)this.canvasItemStyle.getItemFontSize());
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
                itemFont = Font.getDefaultFont();
            }
            g.setFont(itemFont);
            if (this.canvasItemStyle.getItemContentAlign() == CanvasItemStyle.ITEM_CONTENT_ALIGN_CENTER) {
                x += (this.getItemWidth() - this.getItemContentWidthWithoutLogo()) / 2;
                if (this.iconImage != null) {
                    x -= this.iconImage.getWidth();
                }
            }
            if (this.iconImage != null) {
                int iconPosY = initY + this.getItemHeight() / 2 - this.iconImage.getHeight() / 2;
                g.drawImage(this.iconImage, x, iconPosY, 20);
                x += this.iconImage.getWidth();
            }
            int i = 0;
            while (i < this.stringList.size()) {
                int itemFontHeight = itemFont.getHeight();
                int stringPosY = initY + (this.getItemHeight() / this.stringList.size() * i + (this.getItemHeight() / this.stringList.size() - itemFontHeight) / 2);
                g.setColor(Color.DEFAULT_ITEM_FONT_COLOR);
                if (!this.isHightlighted() && this.isFlash) {
                    if (this.flashFlag) {
                        g.setColor(0xFF2200);
                    }
                    if (System.currentTimeMillis() > this.flashTime + this.flashTimePeriod) {
                        this.flashTime = System.currentTimeMillis();
                        boolean bl = this.flashFlag = !this.flashFlag;
                    }
                }
                if (isButton) {
                    if (this.isHightlighted()) {
                        g.setColor(Color.BUTTON_HIGHTLIGHTED_FONT_COLOR);
                    } else {
                        g.setColor(Color.BUTTON_FONT_COLOR);
                    }
                }
                if (this.isWarning) {
                    g.setColor(0xFF0000);
                }
                String string = (String)this.stringList.elementAt(i);
                int itemContentWidthWithoutLogo = this.getItemContentWidthWithoutLogo();
                if (string != null && string.length() > 0) {
                    if (i == 0 && this.iconImage != null) {
                        x += itemFont.stringWidth("  ");
                    }
                    int tmpX = x;
                    if (i == 0 && this.canvasItemStyle.isBulleted()) {
                        Font bulletFont = itemFont;
                        try {
                            bulletFont = Font.getFont((int)this.canvasItemStyle.getItemFontFace(), (int)CanvasItemStyle.ITEM_FONT_STYLE_PLAIN, (int)this.canvasItemStyle.getItemFontSize());
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(e.getMessage());
                            bulletFont = Font.getDefaultFont();
                        }
                        g.setFont(bulletFont);
                        g.drawString(this.bulletString, tmpX, stringPosY, 20);
                        tmpX += itemFont.stringWidth(this.bulletString);
                        g.setFont(itemFont);
                    }
                    if (string != null && string.length() > 0) {
                        if (this.canvasItemStyle.getItemContentAlign() == CanvasItemStyle.ITEM_CONTENT_ALIGN_CENTER) {
                            int stringWidth = itemFont.stringWidth(string);
                            tmpX += (itemContentWidthWithoutLogo - stringWidth) / 2;
                        }
                        g.drawString(string, tmpX, stringPosY, 20);
                    }
                }
                ++i;
            }
        }
        return initY + this.getItemHeight();
    }

    public int getItemContentWidth() {
        int result = 0;
        if (this.iconImage != null) {
            result += this.iconImage.getWidth();
        }
        int stringWidth = 0;
        int i = 0;
        while (i < this.stringList.size()) {
            Font itemFont = null;
            try {
                itemFont = Font.getFont((int)this.canvasItemStyle.getItemFontFace(), (int)this.canvasItemStyle.getItemFontStyle(), (int)this.canvasItemStyle.getItemFontSize());
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
                itemFont = Font.getDefaultFont();
            }
            String string = (String)this.stringList.elementAt(i);
            if (string != null && string.length() > 0) {
                if (this.iconImage != null) {
                    string = "  " + string;
                }
                if (itemFont.stringWidth(string) > stringWidth) {
                    stringWidth = itemFont.stringWidth(string);
                }
            }
            ++i;
        }
        return result += stringWidth;
    }

    public int getItemContentWidthWithoutLogo() {
        int result = 0;
        int stringWidth = 0;
        int i = 0;
        while (i < this.stringList.size()) {
            Font itemFont = null;
            try {
                itemFont = Font.getFont((int)this.canvasItemStyle.getItemFontFace(), (int)this.canvasItemStyle.getItemFontStyle(), (int)this.canvasItemStyle.getItemFontSize());
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
                itemFont = Font.getDefaultFont();
            }
            String string = (String)this.stringList.elementAt(i);
            if (string != null && string.length() > 0 && itemFont.stringWidth(string) > stringWidth) {
                stringWidth = itemFont.stringWidth(string);
            }
            ++i;
        }
        return result += stringWidth;
    }

    public String toString() {
        String result = "";
        if (this.stringList != null && this.stringList.size() > 0) {
            int i = 0;
            while (i < this.stringList.size()) {
                result = String.valueOf(result) + this.stringList.elementAt(i);
                if (i != this.stringList.size() - 1) {
                    result = String.valueOf(result) + ",";
                }
                ++i;
            }
        }
        return result;
    }

    public void unload() {
        if (this.stringList != null) {
            this.stringList.removeAllElements();
            this.stringList = null;
        }
        this.font = null;
        this.iconImage = null;
        if (this.lineEnumeration != null) {
            this.lineEnumeration.unload();
            this.lineEnumeration = null;
        }
        System.gc();
        super.unload();
    }
}

