/*
 * Decompiled with CFR 0.152.
 */
import com.sonyericsson.ams.Application;
import com.sonyericsson.ams.ApplicationFilter;
import com.sonyericsson.ams.ApplicationManager;
import com.sonyericsson.ams.NoSuchApplicationException;
import java.util.Vector;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Invocation;

public class Handler {
    private Application[] apps = null;
    private ApplicationFilter filter = new ApplicationFilter(){

        public boolean matches(Application application) {
            String property = application.getProperty("SEMC-HomeScreenMidlet");
            boolean returnValue = false;
            if (property != null) {
                returnValue = property.equals("Y");
            }
            return returnValue;
        }
    };

    public static Handler getInstance() {
        return Holder.instance;
    }

    private Handler() {
        ApplicationManager manager = ApplicationManager.getApplicationManager();
        this.apps = manager.getApplications(this.filter);
    }

    private void acknowledgeInvocation(ContentHandlerServer server, Invocation invocation, int status) {
        if (invocation != null && (invocation.getResponseRequired() || status != 5)) {
            server.finish(invocation, status);
        }
    }

    private Application getApplication(ApplicationName applicationName) throws NoSuchApplicationException {
        ApplicationManager manager = ApplicationManager.getApplicationManager();
        Application app = manager.getApplication(applicationName.name, applicationName.vendor);
        if (app == null) {
            throw new NoSuchApplicationException();
        }
        return app;
    }

    private synchronized void HandleHomescreenMidlet(Application app) {
        boolean stopped = this.stopRunningHomescreen(app);
        if (stopped) {
            System.out.println("Starting requested homescreen application " + app.getSuiteName());
            this.startApplication(app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean stopRunningHomescreen(Application app) {
        System.out.println("Number of homescreen midlets installed on device: " + this.apps.length);
        Application running = this.getRunningApp();
        if (running == null) {
            return true;
        }
        if (app.getSuiteName().equals(running.getSuiteName())) {
            return false;
        }
        running.stop();
        int count = 100;
        while (running.isStarted() && count > 0) {
            Handler handler = this;
            synchronized (handler) {
                try {
                    --count;
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (count <= 0 || running.isStarted()) {
            System.out.println("Tried to stop the currently running homescreen for 10 seconds, not possible. Giving up");
        } else {
            System.out.println("Stopped currently running homescreen homescreen application " + running.getSuiteName());
        }
        return !running.isStarted();
    }

    private synchronized Application getRunningApp() {
        if (this.apps == null) {
            return null;
        }
        int i = 0;
        while (i < this.apps.length) {
            if (this.apps[i].isStarted()) {
                return this.apps[i];
            }
            ++i;
        }
        return null;
    }

    synchronized void handleInvocation(Invocation invoc, ContentHandlerServer server) {
        System.out.println("Invocation recieved");
        if (invoc == null || server == null) {
            return;
        }
        String[] parts = this.splitString(new String(invoc.getData()));
        if (parts.length >= 2) {
            ApplicationName targetApplication = new ApplicationName(parts[0], parts[1]);
            int status = 5;
            try {
                this.HandleHomescreenMidlet(this.getApplication(targetApplication));
            }
            catch (NoSuchApplicationException e) {
                status = 6;
            }
            this.acknowledgeInvocation(server, invoc, status);
        }
    }

    private String[] splitString(String data) {
        Vector<String> v = new Vector<String>();
        int startPos = 0;
        int endPos = data.indexOf(58, startPos);
        while (endPos > 0) {
            v.addElement(data.substring(startPos, endPos));
            startPos = endPos + 1;
            endPos = data.indexOf(58, startPos);
        }
        if (startPos > 0) {
            v.addElement(data.substring(startPos));
        }
        Object[] fields = new String[v.size()];
        v.copyInto(fields);
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startApplication(Application application) {
        int count = 100;
        try {
            application.start();
            while (!application.isStarted() && count > 0) {
                Handler handler = this;
                synchronized (handler) {
                    try {
                        --count;
                        this.wait(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (count <= 0 || !application.isStarted()) {
                System.out.println("Tried to start the new homescreen for 10 seconds, not possible. Giving up");
            } else {
                System.out.println("Started requested homescreen application " + application.getSuiteName());
            }
        }
        catch (NoSuchApplicationException e) {
            System.out.println("NoSuchApplicationException ");
        }
    }

    /* synthetic */ Handler(Handler handler) {
        this();
    }

    private static final class Holder {
        private static final Handler instance = new Handler(null);

        private Holder() {
        }
    }
}

