/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher.model;

import com.beeweeb.globallauncher.model.Item;
import com.beeweeb.globallauncher.model.Shortcut;

public class Strip
extends Item {
    public static final int TYPE_TEASER_IMAGE = 0;
    public static final int TYPE_TEASER_IMAGE_TEXT = 1;
    public static final int TYPE_TEASER_TEXT = 2;
    public static final int HREF_TYPE_WEB = 0;
    public static final int HREF_TYPE_APPLICATION = 1;
    public static final int HREF_TYPE_NATIVE = 2;
    private int type;
    private String href;
    private int hrefType;
    private Shortcut shortcut;

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Shortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(Shortcut shortcut) {
        this.shortcut = shortcut;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String string) {
        this.href = string;
    }

    public int getHrefType() {
        return this.hrefType;
    }

    public void setHrefType(int n) {
        this.hrefType = n;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<strip ");
        switch (this.type) {
            case 0: {
                stringBuffer.append("type=\"teaser_image\" ");
                break;
            }
            case 1: {
                stringBuffer.append("type=\"teaser_image_text\" ");
                break;
            }
            case 2: {
                stringBuffer.append("type=\"teaser_text\" ");
            }
        }
        stringBuffer.append("href=\"" + this.href + "\" ");
        switch (this.hrefType) {
            case 1: {
                stringBuffer.append(" href_type=\"application\" ");
                break;
            }
            case 2: {
                stringBuffer.append(" href_type=\"native\" ");
                break;
            }
            case 0: {
                stringBuffer.append(" href_type=\"web\" ");
            }
        }
        stringBuffer.append(">");
        if (this.imgSrc != null) {
            stringBuffer.append("<img src=\"" + this.imgSrc + "\" ");
            if (this.imgSrcDwl != null) {
                stringBuffer.append("srcdwl=\"" + this.imgSrcDwl + "\" ");
            }
            switch (this.align) {
                case 1: {
                    stringBuffer.append("align=\"right\" ");
                    break;
                }
                case 0: {
                    stringBuffer.append("align=\"left\" ");
                }
            }
            stringBuffer.append("/>");
        }
        if (this.title != null) {
            stringBuffer.append("<title text=\"" + this.title + "\"");
            if (this.titleColor != -1) {
                stringBuffer.append(" color=\"" + Integer.toHexString(this.titleColor) + "\"");
            }
            stringBuffer.append("/>");
        }
        if (this.body != null) {
            stringBuffer.append("<body text=\"" + this.body + "\"");
            if (this.titleColor != -1) {
                stringBuffer.append(" color=\"" + Integer.toHexString(this.bodyColor) + "\"");
            }
            stringBuffer.append("/>");
        }
        if (this.roamingText != null) {
            stringBuffer.append("<roamingnotification disable=\"" + this.roamingNotificationDisable + "\">");
            stringBuffer.append("<roamingtext>" + this.roamingText + "</" + "roamingtext" + ">");
            stringBuffer.append("</roamingnotification>");
        }
        if (this.shortcut != null) {
            stringBuffer.append(this.shortcut.toXML());
        }
        stringBuffer.append("</strip>");
        return stringBuffer.toString();
    }
}

