/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher.net;

import com.beeweeb.globallauncher.Launcher;
import com.beeweeb.globallauncher.model.Commons;
import com.beeweeb.globallauncher.model.InstantLauncherData;
import com.beeweeb.globallauncher.model.LauncherDataDocumentHandler;
import com.beeweeb.globallauncher.net.LauncherService;
import com.beeweeb.globallauncher.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.xml.parsers.SAXParser;
import org.xml.sax.helpers.DefaultHandler;

public class TaskGetNewConfiguration
implements Runnable {
    private LauncherService service;
    private String configurationURL;
    private HttpConnection connection;
    private InputStream input;
    private InstantLauncherData instantLauncherData;
    private int attempt;

    public TaskGetNewConfiguration(LauncherService launcherService, String string, InstantLauncherData instantLauncherData) {
        this.service = launcherService;
        this.configurationURL = string;
        this.instantLauncherData = instantLauncherData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            Log.log("Getting new configuration");
            if (!this.configurationURL.endsWith("/")) {
                this.configurationURL = this.configurationURL + "/";
            }
            this.configurationURL = this.configurationURL + this.instantLauncherData.getConfiguration().getHandsetType() + "/" + Launcher.VERSION;
            this.connection = (HttpConnection)Connector.open((String)this.configurationURL);
            this.connection.setRequestProperty("User-Agent", "bwb/IL/" + this.instantLauncherData.getConfiguration().getHandsetType() + "/" + Launcher.VERSION);
            int n = this.connection.getResponseCode();
            if (n == 200) {
                int n2;
                this.input = this.connection.openInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[4096];
                while ((n2 = this.input.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                this.closeAll();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                SAXParser sAXParser = Commons.getParser();
                LauncherDataDocumentHandler launcherDataDocumentHandler = new LauncherDataDocumentHandler();
                sAXParser.parse((InputStream)byteArrayInputStream, (DefaultHandler)launcherDataDocumentHandler);
                this.service.fireGotNewConfiguration(launcherDataDocumentHandler.getData());
                return;
            } else if (n == 301 || n == 302 || n == 303 || n == 307) {
                String string = this.connection.getHeaderField("Location");
                if (string == null) throw new Exception("Error in redirect");
                TaskGetNewConfiguration taskGetNewConfiguration = new TaskGetNewConfiguration(this.service, string, this.instantLauncherData);
                this.service.enqueueTask(taskGetNewConfiguration);
                return;
            } else if (n == 404) {
                return;
            } else {
                if (this.retry()) return;
                this.service.fireGetNewConfigurationFailedForServiceError();
            }
            return;
        }
        catch (Exception exception) {
            Log.log("TaskGetNewConfiguration", exception);
            if (this.retry()) return;
            this.service.fireGetNewConfigurationFailed(exception);
            return;
        }
        finally {
            this.closeAll();
        }
    }

    public int getAttempt() {
        return this.attempt;
    }

    public void setAttempt(int n) {
        this.attempt = n;
    }

    private void closeAll() {
        if (this.input != null) {
            try {
                this.input.close();
                this.input = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Runtime.getRuntime().gc();
    }

    private boolean retry() {
        if (this.instantLauncherData.getConfiguration() != null && this.attempt <= this.instantLauncherData.getConfiguration().getNumRetries()) {
            TaskGetNewConfiguration taskGetNewConfiguration = new TaskGetNewConfiguration(this.service, this.configurationURL, this.instantLauncherData);
            taskGetNewConfiguration.attempt = this.attempt + 1;
            this.service.enqueueTaskAfter(taskGetNewConfiguration, this.instantLauncherData.getConfiguration().getRetryInterval() * 1000);
            return true;
        }
        return false;
    }
}

