/*
 * Decompiled with CFR 0.152.
 */
package app.canvas;

import app.MainMidlet;
import app.util.Configuration;
import app.util.RegistrationMgr;
import app.util.SmsSender;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class RegisterCanvas
extends GameCanvas {
    private static RegisterCanvas instance = null;
    private Display parentDisplay = null;
    private MainMidlet app = null;
    private Configuration config = Configuration.getInstance();
    private Image errorImage = null;
    private Image waitImage = null;
    private Image thankyouImage = null;
    private int smsStatus = 0;

    private RegisterCanvas(Display display, MainMidlet mainMidlet) {
        super(false);
        this.setFullScreenMode(true);
        this.parentDisplay = display;
        this.app = mainMidlet;
        this.init();
        RegistrationMgr registrationMgr = RegistrationMgr.getInstance();
        if (!registrationMgr.isPhoneRegistered()) {
            this.registerPhone();
        } else {
            this.smsStatus = 1;
        }
    }

    public static RegisterCanvas getInstance(Display display, MainMidlet mainMidlet) {
        if (instance == null) {
            instance = new RegisterCanvas(display, mainMidlet);
        }
        return instance;
    }

    public void paint(Graphics graphics) {
        if (this.smsStatus == 0) {
            graphics.drawImage(this.waitImage, 0, 0, 20);
        } else if (this.smsStatus == 2) {
            graphics.drawImage(this.errorImage, 0, 0, 20);
        } else if (this.smsStatus == 1) {
            graphics.drawImage(this.thankyouImage, 0, 0, 20);
        }
    }

    protected void keyPressed(int n) {
        if (this.smsStatus == 2 && n == -6) {
            this.registerPhone();
        } else if (n == -7) {
            this.app.stopApp();
        }
    }

    public void setSmsStatus(int n) {
        this.smsStatus = n;
        if (this.smsStatus == 1) {
            RegistrationMgr registrationMgr = RegistrationMgr.getInstance();
            registrationMgr.addRegistration();
        }
        this.paint(this.getGraphics());
        this.flushGraphics();
    }

    private void registerPhone() {
        String string = this.getImei(System.getProperty("com.sonyericsson.imei"));
        String string2 = System.getProperty("microedition.platform");
        int n = this.getCheckSum(string);
        String string3 = "SERIP " + string + "," + n + "," + string2;
        SmsSender smsSender = SmsSender.getInstance(this);
        smsSender.sendMessage(string3);
    }

    private int getCheckSum(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(string.length() - i - 1);
            if (!Character.isDigit(c)) continue;
            int n2 = c - 48;
            int n3 = i % 2 == 0 ? 2 * n2 - n2 / 5 * 9 : n2;
            System.out.println(n2 + "," + n3);
            n += n3;
        }
        n = Math.abs(n) + 10;
        return (10 - n % 10) % 10;
    }

    private String getImei(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) continue;
            string2 = string2 + String.valueOf(c);
        }
        return string2;
    }

    private void init() {
        try {
            Configuration configuration = Configuration.getInstance();
            String string = configuration.getProperty("app.image.path") + this.getWidth() + "x" + this.getHeight() + "/";
            this.errorImage = Image.createImage((String)(string + configuration.getProperty("image.error")));
            this.waitImage = Image.createImage((String)(string + configuration.getProperty("image.wait")));
            this.thankyouImage = Image.createImage((String)(string + configuration.getProperty("image.thankyou")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

