/*
 * Decompiled with CFR 0.152.
 */
package accuweather;

import accuweather.AccuController;
import accuweather.DataUtility;
import com.emb.handler.DataParser;
import com.emb.handler.StoreManager;
import java.util.Vector;
import javax.microedition.rms.RecordStoreFullException;

public class AccuRMS {
    public static final int ADD_OK = 0;
    public static final int ADD_MAX_NO = 1;
    public static final int ADD_EXISTS = 2;
    public static final int ADD_ERROR = 3;
    public static final int MAX_LOC = 5;
    public static final int DUPLICATE_MESSAGE = 0;
    public static final int MEMORY_MESSAGE = 1;
    public static final int SUCCESS_MESSAGE = 2;
    public static final int UNKNOWN_MESSAGE = 3;

    static void saveAllPreferences(Vector vector) {
        try {
            if (StoreManager.isRSExists("preferences")) {
                StoreManager.deleteStore("preferences");
            }
            StoreManager.saveAllRecords("preferences", vector);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static int[] getAllPreferences() {
        Vector vector = null;
        int[] nArray = null;
        try {
            if (StoreManager.isRSExists("preferences")) {
                vector = StoreManager.getAllRecords("preferences");
            }
            if (vector != null && vector.size() > 0) {
                nArray = new int[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    nArray[i] = Integer.parseInt(vector.elementAt(i).toString());
                }
                return nArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setLanguage(int n) {
        AccuRMS.updatePreference(5, n);
        AccuController.preferences.langPref = n;
        DataUtility.loadMenuFromRes(n);
    }

    static boolean updatePreference(int n, int n2) {
        try {
            if (StoreManager.isRSExists("preferences")) {
                StoreManager.updateRecord(StoreManager.findRecordId(StoreManager.openStore("preferences"), n), "preferences", String.valueOf(n2).getBytes());
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static int getPreference(int n) {
        try {
            if (StoreManager.isRSExists("preferences")) {
                return Integer.parseInt(new String(StoreManager.getRecord(StoreManager.findRecordId(StoreManager.openStore("preferences"), n), "preferences")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static boolean checkDuplicateLocation(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        boolean bl = false;
        try {
            if (string == null || string.equals("")) {
                bl = false;
            }
            Vector vector = AccuRMS.getAllLocations();
            for (int i = 0; i < vector.size(); ++i) {
                if (!((String)vector.elementAt(i)).toUpperCase().equals((string + "|" + string2 + "|" + string3 + "|" + string4 + "|" + string5 + "|" + string6 + "|" + string7 + "|" + string8 + "|" + string9 + "|" + string10 + "|" + string11).toUpperCase())) continue;
                bl = true;
            }
            vector = null;
        }
        catch (Exception exception) {
            return bl;
        }
        return bl;
    }

    public static int addLocation(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        int n = 0;
        int n2 = 0;
        if (!AccuRMS.checkDuplicateLocation(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11)) {
            n2 = AccuRMS.addLocation(string + "|" + string2 + "|" + string3 + "|" + string4 + "|" + string5 + "|" + string6 + "|" + string7 + "|" + string8 + "|" + string9 + "|" + string10 + "|" + string11);
            if (n2 == 0) {
                AccuController.locations.region_code = string;
                AccuController.locations.city = string3;
                AccuController.locations.country = string2;
                AccuController.locations.city_sp = string5;
                AccuController.locations.country_sp = string4;
                AccuController.locations.city_de = string7;
                AccuController.locations.country_de = string6;
                AccuController.locations.city_fr = string9;
                AccuController.locations.country_fr = string8;
                AccuController.locations.city_it = string11;
                AccuController.locations.country_it = string10;
                n = 2;
                return 2;
            }
            if (n2 == 1) {
                n = 1;
                return 1;
            }
            n = 3;
            return 3;
        }
        n = 0;
        return 0;
    }

    public static int addLocation(String string) {
        int n = 0;
        try {
            if (!StoreManager.isRSExists("locations")) {
                StoreManager.saveRecord("locations", "1".getBytes());
            } else {
                String string2 = "" + StoreManager.getNumRecords("locations");
                StoreManager.updateRecord(1, "locations", string2.getBytes());
            }
            StoreManager.saveRecord("locations", string.getBytes());
            string = null;
            n = 0;
        }
        catch (RecordStoreFullException recordStoreFullException) {
            n = 1;
        }
        catch (Exception exception) {
            n = 2;
            return 2;
        }
        return n;
    }

    public static void editLocation(int n, String string, String string2, String string3) {
        try {
            if (StoreManager.isRSExists("locations")) {
                StoreManager.updateRecord(StoreManager.findRecordId(StoreManager.openStore("locations"), n), "locations", (string + "|" + string2 + "|" + string3).getBytes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = null;
        string2 = null;
        string3 = null;
    }

    public static void deleteLocation(int n) {
        try {
            if (StoreManager.isRSExists("locations")) {
                if (n < AccuRMS.getDefaultLocation()) {
                    AccuRMS.setDefaultLocation(AccuRMS.getDefaultLocation() - 1);
                }
                StoreManager.deleteRecord(StoreManager.findRecordId(StoreManager.openStore("locations"), n + 1), "locations");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String[] getLocationInfo(int n) {
        String string = null;
        String[] stringArray = null;
        try {
            if (StoreManager.isRSExists("locations")) {
                string = new String(StoreManager.getRecord(StoreManager.findRecordId(StoreManager.openStore("locations"), n), "locations"));
                stringArray = DataParser.tokenizer(string, "|");
                string = null;
                return stringArray;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Vector getAllLocations() {
        try {
            if (StoreManager.isRSExists("locations")) {
                return StoreManager.getAllRecords("locations");
            }
        }
        catch (Exception exception) {
            System.out.println("exception in getAllLocations  ");
            exception.printStackTrace();
            return null;
        }
        return null;
    }

    public static int getLocPos(String string, String string2, String string3) {
        int n = -1;
        try {
            Object var4_4 = null;
            boolean bl = true;
            if (string == null || string.equals("")) {
                bl = false;
            }
            if (var4_4 != null) {
                for (int i = 0; i < (var4_4).length; ++i) {
                    String[] stringArray = DataParser.tokenizer((String)var4_4[i + 1], "|");
                    if (stringArray != null) {
                        if (string != null && string.equals(var4_4[i]) && bl) {
                            n = Integer.parseInt(stringArray[0]);
                        }
                        if (string2 != null && string2.equals(var4_4[i]) && !bl) {
                            n = Integer.parseInt(stringArray[0]);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = null;
        string2 = null;
        string3 = null;
        return n;
    }

    public static void setDefaultLocation(int n) {
        try {
            if (StoreManager.isRSExists("locations")) {
                StoreManager.updateRecord(StoreManager.findRecordId(StoreManager.openStore("locations"), 1), "locations", String.valueOf(n).getBytes());
            } else {
                StoreManager.saveRecord("locations", String.valueOf(n).getBytes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getDefaultLocation() {
        int n = -1;
        try {
            if (!StoreManager.isRSExists("locations")) {
                return -1;
            }
            n = Integer.parseInt(new String(StoreManager.getRecord(StoreManager.findRecordId(StoreManager.openStore("locations"), 1), "locations")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    static void storeAccuXID(String string) {
        try {
            if (StoreManager.isRSExists("accuxid")) {
                StoreManager.deleteStore("accuxid");
            }
            StoreManager.saveRecord("accuxid", string.getBytes());
            string = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static String getAccuXID() {
        String string = null;
        try {
            if (StoreManager.isRSExists("accuxid")) {
                string = new String(StoreManager.getRecord(StoreManager.findRecordId(StoreManager.openStore("accuxid"), 1), "accuxid"));
            }
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    public static String getTickerTxt() {
        String string = null;
        try {
            if (StoreManager.isRSExists("tickertxt")) {
                string = new String(StoreManager.getRecord(StoreManager.findRecordId(StoreManager.openStore("tickertxt"), 1), "tickertxt"));
            }
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    public static void expireTicker() {
        try {
            if (StoreManager.isRSExists("tickertxt")) {
                StoreManager.deleteStore("tickertxt");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void storeTicker(String string, String string2) {
        AccuRMS.storeTickerId(string);
        AccuRMS.storeTickerTxt(string2);
        string = null;
        string2 = null;
    }

    private static void storeTickerTxt(String string) {
        if (string == null || string.trim().length() < 1) {
            return;
        }
        try {
            if (StoreManager.isRSExists("tickertxt")) {
                StoreManager.updateRecord(StoreManager.findRecordId(StoreManager.openStore("tickertxt"), 1), "tickertxt", String.valueOf(string).getBytes());
            } else {
                StoreManager.saveRecord("tickertxt", String.valueOf(string).getBytes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = null;
    }

    private static void storeTickerId(String string) {
        if (string == null || string.trim().length() < 1) {
            return;
        }
        try {
            if (StoreManager.isRSExists("tickerid")) {
                StoreManager.updateRecord(StoreManager.findRecordId(StoreManager.openStore("tickerid"), 1), "tickerid", String.valueOf(string).getBytes());
            } else {
                StoreManager.saveRecord("tickerid", String.valueOf(string).getBytes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = null;
    }

    public static String getTickerId() {
        String string = null;
        try {
            if (StoreManager.isRSExists("tickerid")) {
                if (StoreManager.isRSExists("tickertxt")) {
                    return "-1";
                }
            } else {
                return "0";
            }
            string = new String(StoreManager.getRecord(StoreManager.findRecordId(StoreManager.openStore("tickerid"), 1), "tickerid"));
        }
        catch (Exception exception) {
            return "0";
        }
        return string;
    }
}

