/*
 * Decompiled with CFR 0.152.
 */
package com.emb.form;

import accuweather.DataUtility;
import com.emb.holder.BaseHolder;
import com.emb.widget.Cell;
import com.emb.widget.Menu;
import com.emb.widget.Widget;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class WidgetForm
extends Canvas {
    protected Font titleFnt = DataUtility.TFONT;
    protected int fgClr = 0;
    public int focWdgIndex = 0;
    protected Image header;
    protected int bg_color = 0xFFFFFF;
    protected Image bg_image;
    protected int screenID;
    protected String title;
    protected String sub_title;
    public Vector widgetArray = new Vector(5, 5);
    protected Menu popupMenu;
    protected static Cell ticker = null;

    public abstract void getData();

    public void setDefaultFocusWidget(int n) {
        if (this.widgetArray != null && this.widgetArray.elementAt(n) != null) {
            this.focWdgIndex = n;
        }
    }

    public abstract void prepareScreen(BaseHolder var1);

    public final void setTitle(String string) {
        this.title = string != null ? string : "";
    }

    public void setSubTitle(String string) {
        this.sub_title = string;
    }

    public final void setBGColor(int n) {
        this.bg_color = n;
    }

    public final void setTitleColor(int n) {
        this.fgClr = n;
    }

    public final void setHeaderImage(Image image) {
        this.header = image;
    }

    public final void setBGImage(Image image) {
        this.bg_image = image;
    }

    public int getYPos() {
        int n = 0;
        if (this.header != null) {
            n += this.header.getHeight();
        }
        if (this.title != null && this.title.trim().length() > 0) {
            n += this.titleFnt.getHeight();
        }
        if (this.sub_title != null) {
            n += this.titleFnt.getHeight();
        }
        return n;
    }

    public int getHeight() {
        int n = 0;
        if (ticker != null) {
            n = ticker.getHeight();
        }
        return super.getHeight() - n;
    }

    public void addWidget(Widget widget) {
        if (widget.can == null) {
            widget.can = this;
        }
        this.widgetArray.addElement(widget);
    }

    public void addTicker(String string, int n) {
        this.removeTicker();
        ticker = Cell.getTickerCellInstance(string, 0, 0, 15094868, 0xFFFFFF, DataUtility.FONT, this);
        ticker.setYPosition(this.getHeight());
        ticker.setTickerCell(n);
    }

    public void removeTicker() {
        if (ticker != null) {
            ticker.stopTicker();
            WidgetForm.ticker.ticker_state = 0;
        }
        ticker = null;
    }

    private void showTicker(Graphics graphics) {
        if (ticker != null) {
            ticker.show(graphics);
        }
    }

    public void removeAllWidgets() {
        this.focWdgIndex = 0;
        this.widgetArray.removeAllElements();
        this.removeTicker();
    }

    public boolean removeWidget(int n) {
        if (n < 0 || n > this.widgetArray.size()) {
            return false;
        }
        this.widgetArray.removeElementAt(n);
        return true;
    }

    public final void showScreen(Graphics graphics) {
        String string;
        this.fillBGColor(graphics);
        if (this.bg_image != null) {
            graphics.drawImage(this.bg_image, 0, 0, 0);
        }
        int n = 0;
        if (this.header != null) {
            graphics.drawImage(this.header, (this.getWidth() - this.header.getWidth()) / 2, 0, 0);
            n = this.header.getHeight();
        }
        if (this.title != null && this.title.trim().length() > 0) {
            string = this.getStripTitle(this.title);
            graphics.setFont(this.titleFnt);
            graphics.setColor(this.fgClr);
            graphics.drawString(string, (this.getWidth() - this.titleFnt.stringWidth(string)) / 2, n, 0);
            n += this.titleFnt.getHeight() + 1;
        }
        if (this.sub_title != null) {
            string = this.getStripTitle(this.sub_title);
            graphics.setFont(this.titleFnt);
            graphics.setColor(this.fgClr);
            graphics.drawString(string, (this.getWidth() - this.titleFnt.stringWidth(string)) / 2, n, 0);
            n = this.titleFnt.getHeight() + 1;
        }
        for (int i = 0; i < this.widgetArray.size(); ++i) {
            if (i == this.focWdgIndex && ((Widget)this.widgetArray.elementAt(this.focWdgIndex)).isFocusable()) {
                ((Widget)this.widgetArray.elementAt(this.focWdgIndex)).setFocus(true);
            }
            ((Widget)this.widgetArray.elementAt(i)).show(graphics);
        }
        this.showTicker(graphics);
    }

    public final void showScreen(Graphics graphics, int n) {
        String string;
        this.fillBGColor(graphics);
        if (this.bg_image != null) {
            graphics.drawImage(this.bg_image, 0, 0, 0);
        }
        int n2 = 0;
        if (this.header != null) {
            graphics.drawImage(this.header, (this.getWidth() - this.header.getWidth()) / 2, 0, 0);
            n2 = this.header.getHeight() + 2;
        }
        if (this.title != null && this.title.trim().length() > 0) {
            string = this.getStripTitle(this.title);
            graphics.setFont(this.titleFnt);
            graphics.setColor(this.fgClr);
            graphics.drawString(string, (this.getWidth() - this.titleFnt.stringWidth(string)) / 2, n2, 0);
            if (string != null && string.trim().length() > 0) {
                n2 += this.titleFnt.getHeight() + 2;
            }
        }
        if (this.sub_title != null) {
            string = this.getStripTitle(this.sub_title);
            graphics.setFont(this.titleFnt);
            graphics.setColor(this.fgClr);
            graphics.drawString(string, (this.getWidth() - this.titleFnt.stringWidth(string)) / 2, n2, 0);
            if (string != null && string.trim().length() > 0) {
                n2 += this.titleFnt.getHeight() + 2;
            }
        }
        graphics.setClip(0, n2, this.getWidth(), super.getHeight());
        for (int i = 0; i < this.widgetArray.size(); ++i) {
            if (i == this.focWdgIndex && ((Widget)this.widgetArray.elementAt(this.focWdgIndex)).isFocusable()) {
                ((Widget)this.widgetArray.elementAt(this.focWdgIndex)).setFocus(true);
            }
            ((Widget)this.widgetArray.elementAt(i)).show(graphics, n);
        }
        this.showTicker(graphics);
    }

    public void fillBGColor(Graphics graphics) {
        graphics.setColor(this.bg_color);
        graphics.fillRect(0, 0, this.getWidth(), super.getHeight());
    }

    private String getStripTitle(String string) {
        if (string == null || string.trim().length() < 1) {
            return string;
        }
        if (this.titleFnt.stringWidth(string) > this.getWidth()) {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (this.titleFnt.stringWidth(stringBuffer.toString()) + this.titleFnt.stringWidth("..") > this.getWidth()) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            return stringBuffer.toString() + "..";
        }
        return string;
    }
}

