/*
 * Decompiled with CFR 0.152.
 */
package com.emb.widget;

import accuweather.DataUtility;
import com.emb.widget.Widget;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class StatusWidget
extends Widget {
    int statusBoxClr = 0;
    int statusClr = 255;
    int labelClr = 255;
    Font labelFont = DataUtility.FONT;
    public int curStatus = 0;
    String statusMsg = "";
    Font statusMsgFnt = DataUtility.FONT;
    int statusMsgClr = 0xFFFFFF;
    private static StatusWidget instance = null;

    private StatusWidget(Canvas canvas, int n) {
        this.can = canvas;
        this.height = n;
        this.calculateXYPos();
        this.curStatus = 0;
        instance = this;
    }

    public static StatusWidget getInstance(Canvas canvas, int n) {
        if (instance == null) {
            new StatusWidget(canvas, n);
        } else {
            StatusWidget.instance.can = canvas;
            StatusWidget.instance.height = n;
            StatusWidget.instance.curStatus = 0;
        }
        return instance;
    }

    public void show(Graphics graphics) {
        if (graphics != null) {
            int n = this.curStatus * 100 / this.width;
            graphics.setFont(this.statusMsgFnt);
            graphics.setColor(13411);
            graphics.fillRect(0, this.y_origin - this.statusMsgFnt.getHeight() - 2, this.can.getWidth(), this.can.getHeight());
            graphics.setColor(this.statusMsgClr);
            if (this.statusMsg != null) {
                graphics.drawString(this.statusMsg, (this.can.getWidth() - this.statusMsgFnt.stringWidth(this.statusMsg)) / 2, this.y_origin - this.statusMsgFnt.getHeight() - 2, 0);
            }
            graphics.setColor(this.statusBoxClr);
            graphics.drawRect(this.x_origin, this.y_origin - 1, this.width + 1, this.height + 2);
            graphics.setColor(this.bg_color);
            graphics.fillRect(this.x_origin + 1, this.y_origin, this.width, this.height + 1);
            graphics.setColor(this.statusClr);
            graphics.fillRect(this.x_origin + 1, this.y_origin, this.curStatus - 1, this.height + 1);
            if (this.getStatus() > 45) {
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.setColor(this.labelClr);
            }
            graphics.setFont(this.labelFont);
            graphics.drawString(n + "%", (this.x_origin + this.width + this.x_origin - this.labelFont.stringWidth(n + "%")) / 2, this.y_origin - 1, 0);
        }
    }

    private void calculateXYPos() {
        if (this.can != null) {
            this.width = this.can.getWidth() - this.can.getWidth() / 4;
            this.x_origin = (this.can.getWidth() - this.width) / 2;
            this.y_origin = this.can.getHeight() - this.height - 5;
        }
    }

    public void keyReleased(int n) {
    }

    public void incStatus(int n) {
        this.curStatus = this.curStatus < this.width - n ? (this.curStatus += n) : this.width;
        this.can.serviceRepaints();
    }

    public boolean isKeyEvtRequired(int n) {
        return false;
    }

    public int getStatus() {
        if (this.width < 1) {
            this.width = 1;
        }
        return this.curStatus * 100 / this.width;
    }

    public void setStatusMsg(String string) {
        if (string != null) {
            this.statusMsg = string;
        }
        this.can.repaint();
    }
}

