/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class DeluxeWorker
extends Thread {
    private DeluxeMIDlet mMIDlet;
    private WaitCanvas mWaitCanvas;
    private String mURL;
    private HttpConnection mHttpConnection;
    private boolean mTrucking;
    private boolean mCancel;

    public DeluxeWorker(DeluxeMIDlet deluxeMIDlet, WaitCanvas waitCanvas, String string) {
        this.mMIDlet = deluxeMIDlet;
        this.mWaitCanvas = waitCanvas;
        this.mURL = string;
        this.mTrucking = true;
        this.mCancel = false;
    }

    public synchronized void run() {
        while (this.mTrucking) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.mTrucking) continue;
            this.connect();
        }
    }

    public synchronized void go() {
        this.notify();
    }

    public void cancel() {
        try {
            this.mCancel = true;
            if (this.mHttpConnection != null) {
                this.mHttpConnection.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void stop() {
        this.mTrucking = false;
        this.notify();
    }

    private void connect() {
        InputStream inputStream = null;
        try {
            this.mWaitCanvas.setMessage("Sending...");
            this.mHttpConnection = (HttpConnection)Connector.open((String)this.mURL);
            this.mHttpConnection.setRequestProperty("Connection", "close");
            inputStream = this.mHttpConnection.openInputStream();
            this.mWaitCanvas.setMessage("Receiving...");
            int n = (int)this.mHttpConnection.getLength();
            if (n == -1) {
                n = 255;
            }
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            inputStream.close();
            this.mHttpConnection.close();
            String string = new String(byArray, 0, n2);
            this.mMIDlet.networkResponse(string);
        }
        catch (IOException iOException) {
            if (!this.mCancel) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (this.mHttpConnection != null) {
                        this.mHttpConnection.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.mMIDlet.networkException(iOException);
            }
            this.mCancel = false;
        }
    }
}

