/*
 * Decompiled with CFR 0.152.
 */
package com.loboltd.javamap.map.MapLV2;

import com.loboltd.javamap.bean.Building;
import com.loboltd.javamap.map.MapCanvas;
import com.loboltd.javamap.map.MapLV1Canvas;
import com.loboltd.javamap.map.MapLV2.MapBlock;
import com.loboltd.javamap.map.MapLV2.MapBlockMgr;
import com.loboltd.javamap.map.NullAreaException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MapLV2Canvas
extends MapCanvas {
    private MapBlockMgr mapBlockMgr;
    private int maxBlockX;
    private int maxBlockY;
    private int mapBlockWidth;
    private int mapBlockHeight;

    public MapLV2Canvas(String uniqueID) {
        super(uniqueID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapBlockMgr getMapBlockMgr() {
        MapLV2Canvas mapLV2Canvas = this;
        synchronized (mapLV2Canvas) {
            if (this.mapBlockMgr == null) {
                if (this.area == null) {
                    throw new RuntimeException(this.getClass() + "\tThe type is not setted!");
                }
                this.mapBlockMgr = new MapBlockMgr(this.area, this.LV);
                this.mapBlockMgr.setMaxBlockX(this.maxBlockX);
                this.mapBlockMgr.setMaxBlockY(this.maxBlockY);
                this.mapBlockMgr.setMapBlockWidth(this.mapBlockWidth);
                this.mapBlockMgr.setMapBlockHeight(this.mapBlockHeight);
                this.mapBlockMgr.setScreenHeight(this.getHeight());
                this.mapBlockMgr.setScreenWidth(this.getWidth());
            }
        }
        return this.mapBlockMgr;
    }

    public void setMaxBlockX(int num) {
        this.maxBlockX = num;
    }

    public void setMaxBlockY(int num) {
        this.maxBlockY = num;
    }

    protected void drawMap(int x, int y) {
        Graphics g = this.graphics;
        g.translate(-1 * g.getTranslateX(), -1 * g.getTranslateY());
        g.translate(this.halfWidth - x, this.halfHeight - y);
        MapBlockMgr map = this.getMapBlockMgr();
        MapBlock[] mapBlocks = map.getMapBlocks(x, y);
        int i = 0;
        while (i < mapBlocks.length) {
            Image image = mapBlocks[i].getImage();
            int mapx = mapBlocks[i].getCoordinateX();
            int mapy = mapBlocks[i].getCoordinateY();
            g.drawImage(image, mapx, mapy, 20);
            image = null;
            ++i;
        }
        mapBlocks = null;
        Runtime.getRuntime().gc();
        g.setColor(-15658497);
        g.fillTriangle(x, y - 8, x - 5, y - 20, x + 5, y - 20);
        g.fillTriangle(x, y + 8, x - 5, y + 20, x + 5, y + 20);
        g.fillTriangle(x - 8, y, x - 20, y + 5, x - 20, y - 5);
        g.fillTriangle(x + 8, y, x + 20, y + 5, x + 20, y - 5);
        int oldx = this.graphics.getTranslateX();
        int oldy = this.graphics.getTranslateY();
        this.graphics.translate(-oldx, -oldy);
        this.graphics.setColor(-65536);
        int borderSize = 3;
        this.graphics.fillRect(0, 0, borderSize, this.getHeight());
        this.graphics.fillRect(0, 0, this.getWidth(), borderSize);
        this.graphics.fillRect(0, this.getHeight() - borderSize, this.getWidth(), borderSize);
        this.graphics.fillRect(this.getWidth() - borderSize, 0, borderSize, this.getHeight());
        int wordFrameSize = 30;
        this.graphics.fillTriangle(this.halfWidth - wordFrameSize, 0, this.halfWidth + wordFrameSize, 0, this.halfWidth, wordFrameSize);
        this.graphics.fillTriangle(this.halfWidth - wordFrameSize, this.getHeight(), this.halfWidth + wordFrameSize, this.getHeight(), this.halfWidth, this.getHeight() - wordFrameSize);
        this.graphics.setColor(-1);
        this.graphics.drawString("N", this.halfWidth, 3, 17);
        this.graphics.drawString("S", this.halfWidth, this.getHeight() - 3, 33);
        this.graphics.translate(oldx, oldy);
        this.flushGraphics();
    }

    public void showMap(int x, int y) throws NullAreaException {
        super.showMap(x, y);
        this.showBuildings();
        this.showPersionBy84();
    }

    public int getMaxMapHeight() {
        return this.getMapBlockMgr().getMaxMapHeight();
    }

    public int getMaxMapWidth() {
        return this.getMapBlockMgr().getMaxMapWidth();
    }

    public MapCanvas getNextMapCanvas() throws NullAreaException {
        this.mapBlockMgr.clearData();
        Building building = MapCanvas.getCurrentBuilding();
        if (this.nextMapCanvas == null) {
            return null;
        }
        if (this.nextMapCanvas instanceof MapLV1Canvas) {
            ((MapLV1Canvas)this.nextMapCanvas).setCusor(this.currentX, this.currentY);
        } else if (building != null) {
            this.nextMapCanvas.showPointBy84(building.getName(), building.getLn(), building.getLat());
        }
        this.nextMapCanvas.showMap(this.currentX, this.currentY);
        return this.nextMapCanvas;
    }

    public void showPoint(String buildingName, int x, int y) {
        super.showPoint(buildingName, x, y);
        x = (int)((double)x * this.getRateX());
        y = (int)((double)y * this.getRateY());
        Font font = Font.getFont((int)0, (int)2, (int)16);
        int nameLength = font.stringWidth(buildingName) + 6;
        this.graphics.setFont(font);
        this.graphics.setColor(-5048331);
        this.graphics.fillRoundRect(x - nameLength / 2, y - 30, nameLength, 20, 10, 10);
        this.graphics.setColor(-16777216);
        this.graphics.drawRoundRect(x - nameLength / 2, y - 30, nameLength, 20, 10, 10);
        this.graphics.setColor(-16777216);
        this.graphics.drawString(buildingName, x, y - 30, 17);
        this.flushGraphics();
    }

    public int getMapBlockWidth() {
        return this.mapBlockWidth;
    }

    public void setMapBlockWidth(int mapBlockWidth) {
        this.mapBlockWidth = mapBlockWidth;
    }

    public int getMapBlockHeight() {
        return this.mapBlockHeight;
    }

    public void setMapBlockHeight(int mapBlockHeight) {
        this.mapBlockHeight = mapBlockHeight;
    }
}

