/*
 * Decompiled with CFR 0.152.
 */
package com.loboltd.javamap.map;

import com.loboltd.javamap.bean.Building;
import com.loboltd.javamap.location.Point;
import com.loboltd.javamap.map.MapCanvas;
import com.loboltd.javamap.map.NullAreaException;
import com.loboltd.javamap.util.CoordinateTool;
import com.loboltd.javamap.util.DataLoader;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MapLV1Canvas
extends MapCanvas {
    private Image mapOverview;
    private int cusorX = -1;
    private int cusorY = -1;

    public MapLV1Canvas(String uniqueID) {
        super(uniqueID);
        this.LV = 1;
    }

    private Image getMapOverview() throws NullAreaException {
        if (this.mapOverview == null) {
            if (this.area == null) {
                throw new NullAreaException(this.getClass() + "-The type is not setted!");
            }
            this.mapOverview = ((DataLoader)DataLoader.getInstance()).loadImage("IMAGES/" + this.area + "/overview.map");
        }
        return this.mapOverview;
    }

    public void showMap(int x, int y) throws NullAreaException {
        super.showMap(x, y);
        this.showCursor();
    }

    protected void drawMap(int x, int y) throws NullAreaException {
        Image map = this.getMapOverview();
        Graphics g = this.graphics;
        g.translate(-1 * g.getTranslateX(), -1 * g.getTranslateY());
        int adjX = x - this.halfWidth;
        int adjY = y - this.halfHeight;
        g.translate(-1 * adjX, -1 * adjY);
        g.drawImage(map, 0, 0, 20);
        int oldx = this.graphics.getTranslateX();
        int oldy = this.graphics.getTranslateY();
        this.graphics.translate(-oldx, -oldy);
        int borderSize = 3;
        this.graphics.setColor(-65536);
        this.graphics.fillRect(0, 0, borderSize, this.getHeight());
        this.graphics.fillRect(0, 0, this.getWidth(), borderSize);
        this.graphics.fillRect(0, this.getHeight() - borderSize, this.getWidth(), borderSize);
        this.graphics.fillRect(this.getWidth() - borderSize, 0, borderSize, this.getHeight());
        int wordFrameSize = 30;
        this.graphics.fillTriangle(this.halfWidth - wordFrameSize, 0, this.halfWidth + wordFrameSize, 0, this.halfWidth, wordFrameSize);
        this.graphics.fillTriangle(this.halfWidth - wordFrameSize, this.getHeight(), this.halfWidth + wordFrameSize, this.getHeight(), this.halfWidth, this.getHeight() - wordFrameSize);
        this.graphics.setColor(-1);
        this.graphics.drawString("N", this.halfWidth, 3, 17);
        this.graphics.drawString("S", this.halfWidth, this.getHeight() - 3, 33);
        this.graphics.translate(oldx, oldy);
        this.flushGraphics();
        Runtime.getRuntime().gc();
    }

    protected void showCursor() {
        int x = this.cusorX;
        int y = this.cusorY;
        x = (int)((double)x * this.getRateX());
        y = (int)((double)y * this.getRateY());
        Graphics g = this.graphics;
        g.setColor(-15658497);
        g.fillTriangle(x, y - 8, x - 5, y - 20, x + 5, y - 20);
        g.fillTriangle(x, y + 8, x - 5, y + 20, x + 5, y + 20);
        g.fillTriangle(x - 8, y, x - 20, y + 5, x - 20, y - 5);
        g.fillTriangle(x + 8, y, x + 20, y + 5, x + 20, y - 5);
        this.flushGraphics();
    }

    public int getMaxMapHeight() throws NullAreaException {
        return this.getMapOverview().getHeight();
    }

    public int getMaxMapWidth() throws NullAreaException {
        return this.getMapOverview().getWidth();
    }

    public MapCanvas getNextMapCanvas() throws NullAreaException {
        this.mapOverview = null;
        this.nextMapCanvas.showMap(this.cusorX, this.cusorY);
        Building building = MapCanvas.getCurrentBuilding();
        if (building != null) {
            this.nextMapCanvas.showPointBy84(building.getName(), building.getLn(), building.getLat());
        }
        return this.nextMapCanvas;
    }

    public void setCusorBy84(double ln, double lat) {
        double ln1 = this.fixLn;
        double lat1 = this.fixLat;
        double ln2 = ln;
        double lat2 = lat;
        int x = (int)CoordinateTool.getDX(ln1, lat1, ln2, lat2);
        int y = (int)CoordinateTool.getDY(ln1, lat1, ln2, lat2);
        this.setCusor(x, y);
    }

    public void setCusorByPoint(Point p) {
        this.setCusorBy84(p.getLn(), p.getLat());
    }

    public void setCusor(int cusorX, int cusorY) {
        this.cusorX = cusorX;
        this.cusorY = cusorY;
    }

    public void setRate(double ratex, double ratey) {
        super.setRate(ratex, ratey);
        if (this.cusorX == -1) {
            this.cusorX = (int)((double)this.halfWidth / ratex);
        }
        if (this.cusorY == -1) {
            this.cusorY = (int)((double)this.halfHeight / ratey);
        }
    }

    public int getCusorX() {
        return this.cusorX;
    }

    public int getCusorY() {
        return this.cusorY;
    }

    public void setCusorX(int cusorX) {
        this.cusorX = cusorX;
    }

    public void setCusorY(int cusorY) {
        this.cusorY = cusorY;
    }
}

