/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.kbox.common.StringTool;

public class BranchList
extends Canvas {
    private String name;
    private String[] list;
    private Image logo;
    private Image phoneLogo;
    private Image addressLogo;
    private Image banner;
    private int selectedIndex;

    protected void paint(Graphics g) {
        g.setColor(-1);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.banner, 0, 0, 20);
        int startFixed = this.banner.getHeight();
        int colSize = 35;
        Font font = Font.getFont((int)0, (int)0, (int)8);
        g.setFont(font);
        g.setColor(-131892);
        g.fillRect(0, startFixed, this.getWidth(), colSize);
        g.setColor(-16777216);
        g.drawImage(this.logo, 0, startFixed, 20);
        String[] nameParts = StringTool.split(this.name, " ");
        int j = 0;
        while (j < nameParts.length) {
            g.drawString(nameParts[j], this.logo.getWidth(), startFixed, 20);
            ++j;
        }
        g.setClip(0, this.logo.getHeight(), this.getWidth(), this.getHeight() - this.logo.getHeight());
        int fixed = startFixed + colSize;
        int subColSize = 35;
        int spaceRow = 3;
        fixed += 25;
        int i = 0;
        while (i < this.list.length) {
            g.drawImage(this.phoneLogo, 0, fixed + i / 2 * subColSize + i * spaceRow, 20);
            g.drawString(this.list[i], this.phoneLogo.getWidth() + 3, fixed + i / 2 * subColSize + i * spaceRow, 20);
            g.drawImage(this.addressLogo, 0, fixed + i / 2 * subColSize + 20 + i * spaceRow, 20);
            g.drawString(this.list[i + 1], this.addressLogo.getWidth() + 3, fixed + i / 2 * subColSize + 20 + i * spaceRow, 20);
            i += 2;
        }
        g.setColor(-16777216);
        g.drawRect(0, fixed + this.selectedIndex * subColSize / 2 + spaceRow * (this.selectedIndex % 2 == 0 ? this.selectedIndex : this.selectedIndex - 1), this.getWidth(), 17);
    }

    public BranchList(String name, String[] list, Image logo, Image phoneLogo, Image addressLogo, Image banner) {
        this.name = name;
        this.list = list;
        this.banner = banner;
        this.phoneLogo = phoneLogo;
        this.addressLogo = addressLogo;
        this.logo = logo;
    }

    protected void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        int listLength = this.list.length;
        switch (gameAction) {
            case 1: {
                this.selectedIndex = (this.selectedIndex - 1 + listLength) % listLength;
                break;
            }
            case 6: {
                this.selectedIndex = (this.selectedIndex + 1) % listLength;
            }
        }
        this.repaint();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }
}

