/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.rms;

import com.pacmobile.yp.mypcard.utility.Locale;
import java.io.UnsupportedEncodingException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class LanguageRMS {
    public static boolean hasLanguageRMS() {
        boolean result = false;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"MYPLanguage", (boolean)true);
            if (rs != null) {
                result = rs.getNumRecords() >= 1;
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException e) {
            System.err.println(e.getMessage());
        }
        return result;
    }

    public static String getLanguage() {
        String result = "0";
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"MYPLanguage", (boolean)true);
            if (rs != null) {
                if (rs.getNumRecords() >= 1) {
                    String lang = new String(rs.getRecord(1), "UTF8");
                    if (lang.equals(Locale.localeEN.getLanguage())) {
                        result = "1";
                    } else if (lang.equals(Locale.localeZH.getLanguage())) {
                        result = "0";
                    }
                } else {
                    Locale.setDefaultLocale(Locale.localeZH);
                    byte[] data = "zh".getBytes();
                    rs.addRecord(data, 0, data.length);
                }
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException e) {
            System.err.println(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
        }
        return result;
    }

    public static void loadLanguage() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"MYPLanguage", (boolean)true);
            if (rs != null) {
                if (rs.getNumRecords() >= 1) {
                    String lang = new String(rs.getRecord(1), "UTF8");
                    if (lang.equals(Locale.localeEN.getLanguage())) {
                        Locale.setDefaultLocale(Locale.localeEN);
                    } else if (lang.equals(Locale.localeZH.getLanguage())) {
                        Locale.setDefaultLocale(Locale.localeZH);
                    }
                } else {
                    Locale.setDefaultLocale(Locale.localeZH);
                    byte[] data = "zh".getBytes();
                    rs.addRecord(data, 0, data.length);
                }
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException e) {
            System.err.println(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void saveLanguage() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"MYPLanguage", (boolean)true);
            String lang = new String(Locale.getDefaultLocale().getLanguage().getBytes(), "UTF8");
            byte[] data = lang.getBytes();
            if (rs != null) {
                if (rs.getNumRecords() >= 1) {
                    rs.setRecord(1, data, 0, data.length);
                } else {
                    rs.addRecord(data, 0, data.length);
                }
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException e) {
            System.err.println(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void deleteRecordStore() {
        if (!LanguageRMS.hasLanguageRMS()) {
            return;
        }
        try {
            RecordStore.deleteRecordStore((String)"MYPLanguage");
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }
}

