/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene.canvas;

import com.pacmobile.yp.mypcard.rms.RegistrationRMS;
import com.pacmobile.yp.mypcard.scene.canvas.BaseCanvas;
import com.pacmobile.yp.mypcard.scene.canvas.Color;
import com.pacmobile.yp.mypcard.utility.DateTime;
import com.pacmobile.yp.mypcard.utility.Locale;
import java.util.Date;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DisplayMypCardCanvas
extends BaseCanvas {
    private Image mypCardTitleImage = null;
    private Image mypCardTitleChiImage = null;
    private Image mypCardTitleEngImage = null;
    private Image mypCardImage = null;
    Font font = Font.getFont((int)0);
    int fontHeight = this.font.getHeight();
    Image stringImage = null;
    String mypCardNum = "";
    String regDate = "";

    public DisplayMypCardCanvas() {
        System.gc();
        try {
            this.mypCardImage = Image.createImage((String)"/images/mypcard.png");
            this.mypCardTitleChiImage = Image.createImage((String)"/images/mypcard_title_chi.png");
            this.mypCardTitleEngImage = Image.createImage((String)"/images/mypcard_title_eng.png");
        }
        catch (Exception e) {
            System.out.println("Cannot load image: " + e);
        }
        this.stringImage = Image.createImage((int)this.getHeight(), (int)this.getWidth());
        String mypCardNumTmp = RegistrationRMS.getMYPCardNum();
        if (mypCardNumTmp != null && mypCardNumTmp.length() > 0) {
            this.mypCardNum = mypCardNumTmp;
        }
        String regDateStringTmp = "";
        Date regDateTmp = RegistrationRMS.getDate();
        if (regDateTmp != null) {
            DateTime dateTime = new DateTime(regDateTmp, "GMT+8");
            regDateStringTmp = dateTime.toMonthString();
            dateTime = null;
        }
        if (regDateStringTmp != null && regDateStringTmp.length() > 0) {
            this.regDate = regDateStringTmp;
        }
    }

    public void draw() {
        Graphics g = this.getStaticGraphics();
        if (g != null) {
            this.drawBuffer(g);
            super.drawSoftKeyBar(g);
            BaseCanvas.drawDebugMsg(g);
            this.flushGraphics();
        }
    }

    public void drawBuffer(Graphics g) {
        if (g != null) {
            if (this.stringImage != null) {
                try {
                    Graphics stringImageGraphics = this.stringImage.getGraphics();
                    g.setColor(Color.MYP_CARD_BACKGROUND_COLOR);
                    stringImageGraphics.fillRect(0, 0, this.stringImage.getWidth(), this.stringImage.getHeight());
                    int cardOffsetX = 0;
                    this.mypCardTitleImage = Locale.getDefaultLocale().equals(Locale.localeEN) ? this.mypCardTitleEngImage : this.mypCardTitleChiImage;
                    if (this.mypCardTitleImage != null) {
                        stringImageGraphics.drawRegion(this.mypCardTitleImage, 0, 0, this.mypCardTitleImage.getWidth(), this.mypCardTitleImage.getHeight(), 6, 0, 0, 0);
                        cardOffsetX += this.mypCardTitleImage.getHeight();
                    }
                    if (this.mypCardImage != null) {
                        int cardOffsetY = (this.stringImage.getHeight() - this.mypCardImage.getWidth()) / 2;
                        stringImageGraphics.drawRegion(this.mypCardImage, 0, 0, this.mypCardImage.getWidth(), this.mypCardImage.getHeight(), 6, cardOffsetX, cardOffsetY, 0);
                    }
                    stringImageGraphics.setColor(Color.DEFAULT_ITEM_FONT_COLOR);
                    String cardNumberString = "Card No.";
                    int stringY = this.stringImage.getHeight() / 2;
                    int originalFontColor = stringImageGraphics.getColor();
                    int bgFontColor = 0xAAAAAA;
                    stringImageGraphics.setColor(bgFontColor);
                    stringImageGraphics.drawString(cardNumberString, 10 + cardOffsetX + 1, (stringY += 10) + 1 + this.fontHeight, 20);
                    stringImageGraphics.setColor(originalFontColor);
                    stringImageGraphics.drawString(cardNumberString, 10 + cardOffsetX, stringY + this.fontHeight, 20);
                    int stringWidth = this.font.stringWidth(cardNumberString);
                    int cardOffsetLength = 0;
                    if (this.mypCardNum != null && this.mypCardNum.length() > 0) {
                        stringWidth = this.font.stringWidth(this.mypCardNum);
                        stringImageGraphics.setColor(bgFontColor);
                        stringImageGraphics.drawString(this.mypCardNum, 10 + cardOffsetX + 1, stringY + 2 * this.fontHeight + 1 + 1, 20);
                        stringImageGraphics.setColor(originalFontColor);
                        stringImageGraphics.drawString(this.mypCardNum, 10 + cardOffsetX, stringY + 2 * this.fontHeight + 1, 20);
                        cardOffsetLength = 10 + cardOffsetX + 1 + stringWidth;
                    }
                    if (this.mypCardNum != null && this.mypCardNum.length() > 0) {
                        int stringX;
                        stringWidth = this.font.stringWidth(this.regDate);
                        if (stringWidth < this.font.stringWidth("Since")) {
                            stringWidth = this.font.stringWidth("Since");
                        }
                        if (cardOffsetLength > (stringX = this.stringImage.getWidth() - stringWidth - 25)) {
                            stringY -= 2 * this.font.getHeight();
                        }
                        stringImageGraphics.setColor(bgFontColor);
                        stringImageGraphics.drawString("Since", stringX + 1, stringY + this.fontHeight + 1, 20);
                        stringImageGraphics.drawString(this.regDate, stringX + 1, stringY + 2 * this.fontHeight + 1 + 1, 20);
                        stringImageGraphics.setColor(originalFontColor);
                        stringImageGraphics.drawString("Since", stringX, stringY + this.fontHeight, 20);
                        stringImageGraphics.drawString(this.regDate, stringX, stringY + 2 * this.fontHeight + 1, 20);
                    }
                }
                catch (IllegalStateException e) {
                    System.err.println(e.getMessage());
                }
            }
            if (this.stringImage != null) {
                g.drawRegion(this.stringImage, 0, 0, this.stringImage.getWidth(), this.stringImage.getHeight(), 5, 0, 0, 0);
            }
        }
    }

    public synchronized void unload() {
        this.mypCardTitleImage = null;
        this.mypCardTitleChiImage = null;
        this.mypCardTitleEngImage = null;
        this.mypCardImage = null;
        this.font = null;
        this.stringImage = null;
        System.gc();
        super.unload();
    }
}

