/*
 * Decompiled with CFR 0.152.
 */
package gps;

import com.loboltd.javamap.bean.Building;
import com.loboltd.javamap.location.Point;
import com.loboltd.javamap.map.MapCanvas;
import com.loboltd.javamap.map.MapLV2.MapLV2Canvas;
import com.loboltd.javamap.map.NullAreaException;
import com.loboltd.javamap.util.DataPool;
import gps.GPS;
import gps.GpsLoadingPage;
import gps.NoSignlException;
import gps.OutOfServiceException;
import java.util.Timer;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import net.kbox.ActionController;
import net.kbox.ActionForward;
import net.kbox.common.MsgResource;
import net.kbox.component.KCommand;
import search.Address;
import search.HSBCSearcher;
import util.Area;

public class GPSThread
extends Thread {
    protected static GPSThread gps;
    protected ActionForward forward;
    protected Command cmd;
    protected boolean isStop = false;
    static /* synthetic */ Class class$0;

    protected GPSThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GPSThread getInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gps.GPSThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (gps == null) {
                gps = new GPSThread();
            } else {
                GPSThread.gps.isStop = true;
                gps = null;
                gps = new GPSThread();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return gps;
        }
    }

    public void setForward(ActionForward forward) {
        this.forward = forward;
    }

    public void stop() {
        this.isStop = true;
    }

    public void run() {
        GpsLoadingPage dis;
        MsgResource msgRes = MsgResource.getInstance();
        int count = 1;
        GPS gpsLoc = new GPS();
        int threadCount = 0;
        Object threadCountObj = DataPool.getAttribute("threadCount");
        if (threadCountObj != null) {
            threadCount = (Integer)threadCountObj;
            ++threadCount;
        }
        if (threadCount == 3) {
            gps.stop();
            if (gps.isAlive()) {
                gps.interrupt();
            }
            threadCount = 0;
            DataPool.removeAttribute("gps");
        }
        Point p = null;
        while (p == null && !this.isStop) {
            dis = new GpsLoadingPage(msgRes.getMsg("DETECTING"));
            dis.addCommand(new KCommand(msgRes.getMsg("RELOCATION"), 8, 10, "GPS", null));
            dis.addCommand(new KCommand(msgRes.getMsg("MAINMENU"), 8, 20, "BackToIndexPage", null));
            dis.addCommand(new KCommand(msgRes.getMsg("BACK"), 2, 10, "BackToIndexPage", null));
            dis.setCommandListener(ActionController.getInstance());
            if (dis == null) {
                return;
            }
            try {
                p = gpsLoc.getPoint(1);
            }
            catch (OutOfServiceException e) {
                dis.drawString("Out of service");
                return;
            }
            catch (InterruptedException e) {
                dis.drawString("Locate is Interrupted");
                return;
            }
            catch (NoSignlException e) {
                dis.drawString("Connecting GPS..." + count++ + "/300");
                if (count == 300) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    dis.drawString("Waiting is Interrupted");
                }
            }
        }
        if (p == null) {
            return;
        }
        if (count == 50) {
            dis = (GpsLoadingPage)this.checkCurrentDisplay();
            dis.drawString("Signal is too weak!");
            return;
        }
        String area = Area.getArea(p.getLn());
        MapCanvas mc = (MapCanvas)DataPool.getAttribute(String.valueOf(area) + "mapL3");
        if (mc == null) {
            return;
        }
        if (mc.getPersons() == null) {
            mc.setPersons(new Vector());
        }
        if (mc.getPersons().size() == 0) {
            mc.getPersons().addElement(new Building());
        }
        Building person = (Building)mc.getPersons().firstElement();
        person.setLat(p.getLat());
        person.setLn(p.getLn());
        Timer timer = (Timer)DataPool.getAttribute("timer");
        if (timer != null) {
            timer.cancel();
            DataPool.removeAttribute("timer");
        }
        final MapLV2Canvas mcl2 = (MapLV2Canvas)mc;
        try {
            if (mcl2.getLV() == 3) {
                Thread t = new Thread(){

                    public void run() {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e1) {
                            throw new RuntimeException(e1.toString());
                        }
                        Address[] as = new HSBCSearcher().searchAddressByCoordinate(mcl2.getCurrentLn(), mcl2.getCurrentLat(), 0.0036);
                        Vector<Address> showOnMap = new Vector<Address>();
                        if (as != null) {
                            int i = 0;
                            while (i < as.length) {
                                Address building = new Address();
                                building.setName(as[i].getName());
                                building.setAddress(as[i].getAddress());
                                building.setLat(as[i].getLat());
                                building.setLn(as[i].getLn());
                                building.setAddressId(as[i].getAddressId());
                                showOnMap.addElement(building);
                                ++i;
                            }
                        }
                        mcl2.setShowOnMap(showOnMap);
                        double currentLn = mcl2.getCurrentLn();
                        double currentLat = mcl2.getCurrentLat();
                        Vector buildings = mcl2.getShowOnMap();
                        if (buildings != null) {
                            Vector<Integer> selectedBuildingIndexs = new Vector<Integer>();
                            int i = 0;
                            while (i < buildings.size()) {
                                Building building = (Building)buildings.elementAt(i);
                                double addLn = Math.abs(building.getLn() - currentLn);
                                double addLat = Math.abs(building.getLat() - currentLat);
                                if (addLn < 4.5E-5 && addLat < 4.5E-5) {
                                    selectedBuildingIndexs.addElement(new Integer(i));
                                }
                                ++i;
                            }
                            mcl2.setSelectedBuildingIndex(selectedBuildingIndexs);
                        }
                        try {
                            mcl2.reflash();
                        }
                        catch (NullAreaException e) {
                            throw new RuntimeException(e.toString());
                        }
                    }
                };
                DataPool.setAttribute("LoadingBuildingThread", t);
                t.setPriority(1);
                t.start();
            }
            mcl2.showMapBy84(p.getLn(), p.getLat());
        }
        catch (NullAreaException e1) {
            mcl2.drawString("[ERROR]Map Error!", 0, 0);
            this.forward.forward((Displayable)mcl2);
            return;
        }
        this.forward.forward((Displayable)mcl2);
    }

    protected Displayable checkCurrentDisplay() {
        Displayable mcObj = this.forward.getCurrentDisplay();
        return mcObj;
    }

    public Command getCmd() {
        return this.cmd;
    }

    public void setCmd(Command cmd) {
        this.cmd = cmd;
    }
}

