/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.painter;

import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Painter;
import com.sun.lwuit.geom.Rectangle;
import java.util.Vector;

public class PainterChain
implements Painter {
    private Painter[] a;

    public PainterChain(Painter[] painterArray) {
        this.a = painterArray;
    }

    public PainterChain addPainter(Painter painter) {
        if (this.a.length != 0) {
            Painter[] painterArray = new Painter[this.a.length + 1];
            System.arraycopy(this.a, 0, painterArray, 0, this.a.length);
            painterArray[this.a.length] = painter;
            return new PainterChain(painterArray);
        }
        return new PainterChain(new Painter[]{painter});
    }

    public PainterChain prependPainter(Painter painter) {
        Painter[] painterArray = new Painter[this.a.length + 1];
        System.arraycopy(this.a, 1, painterArray, 0, this.a.length);
        painterArray[0] = painter;
        return new PainterChain(painterArray);
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2].paint(graphics, rectangle);
        }
    }

    public static void installGlassPane(Form form, Painter painter) {
        Painter painter2 = form.getGlassPane();
        if (painter2 == null) {
            form.setGlassPane(painter);
            return;
        }
        if (painter2 instanceof PainterChain) {
            ((PainterChain)painter2).addPainter(painter);
            return;
        }
        painter = new PainterChain(new Painter[]{painter2, painter});
        form.setGlassPane(painter);
    }

    public Painter[] getChain() {
        return this.a;
    }

    public static void removeGlassPane(Form form, Painter painter) {
        Painter painter2 = form.getGlassPane();
        if (painter2 == null) {
            return;
        }
        if (painter2 == painter) {
            form.setGlassPane(null);
            return;
        }
        if (painter2 instanceof PainterChain) {
            painter2 = (PainterChain)painter2;
            if (((PainterChain)painter2).a.length == 1) {
                form.setGlassPane(null);
                return;
            }
            Vector<Painter> vector = new Vector<Painter>();
            for (int i2 = 0; i2 < ((PainterChain)painter2).a.length; ++i2) {
                if (((PainterChain)painter2).a[i2] == painter) continue;
                vector.addElement(((PainterChain)painter2).a[i2]);
            }
            if (vector.size() == 0) {
                form.setGlassPane(null);
                return;
            }
            Painter[] painterArray = new Painter[vector.size()];
            for (int i3 = 0; i3 < painterArray.length; ++i3) {
                painterArray[i3] = (Painter)vector.elementAt(i3);
            }
            ((PainterChain)painter2).a = painterArray;
        }
    }
}

